/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.RoleCommand;
import id.onyx.obdp.server.actionmanager.ActionManager;
import id.onyx.obdp.server.actionmanager.HostRoleCommand;
import id.onyx.obdp.server.actionmanager.Request;
import id.onyx.obdp.server.actionmanager.RequestFactory;
import id.onyx.obdp.server.actionmanager.Stage;
import id.onyx.obdp.server.controller.ExecuteActionRequest;
import id.onyx.obdp.server.controller.RequestStatusResponse;
import id.onyx.obdp.server.controller.ShortTaskStatus;
import id.onyx.obdp.server.security.authorization.AuthorizationHelper;
import id.onyx.obdp.server.state.State;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestStageContainer {
    private Long id;
    private List<Stage> stages;
    private RequestFactory requestFactory;
    private ActionManager actionManager;
    private String requestContext = null;
    private ExecuteActionRequest actionRequest = null;
    private String clusterHostInfo = null;
    private static final Logger LOG = LoggerFactory.getLogger(RequestStageContainer.class);

    public RequestStageContainer(Long id, List<Stage> stages, RequestFactory factory, ActionManager manager) {
        this(id, stages, factory, manager, null);
    }

    public RequestStageContainer(Long id, List<Stage> stages, RequestFactory factory, ActionManager manager, ExecuteActionRequest actionRequest) {
        this.id = id;
        this.stages = stages == null ? new ArrayList() : stages;
        this.requestFactory = factory;
        this.actionManager = manager;
        this.actionRequest = actionRequest;
        this.clusterHostInfo = "{}";
    }

    public Long getId() {
        return this.id;
    }

    public void setClusterHostInfo(String clusterHostInfo) {
        this.clusterHostInfo = clusterHostInfo;
    }

    public void addStages(List<Stage> stages) {
        if (stages != null) {
            this.stages.addAll(stages);
        }
    }

    public List<Stage> getStages() {
        return this.stages;
    }

    public long getLastStageId() {
        return this.stages.isEmpty() ? -1L : this.stages.get(this.stages.size() - 1).getStageId();
    }

    public void setRequestContext(String context) {
        this.requestContext = context;
    }

    public State getProjectedState(String host, String component) {
        Enum lastCommand = null;
        ListIterator<Stage> iterator = this.stages.listIterator(this.stages.size());
        while (lastCommand == null && iterator.hasPrevious()) {
            HostRoleCommand roleCommand;
            Map<String, HostRoleCommand> hostCommands;
            Stage stage = iterator.previous();
            Map<String, Map<String, HostRoleCommand>> stageCommands = stage.getHostRoleCommands();
            if (stageCommands == null || (hostCommands = stageCommands.get(host)) == null || (roleCommand = hostCommands.get(component)) == null || roleCommand.getRoleCommand() == RoleCommand.SERVICE_CHECK) continue;
            lastCommand = roleCommand.getRoleCommand();
        }
        State resultingState = null;
        if (lastCommand != null) {
            switch (1.$SwitchMap$id$onyx$obdp$server$RoleCommand[lastCommand.ordinal()]) {
                case 1: 
                case 2: {
                    resultingState = State.INSTALLED;
                    break;
                }
                case 3: {
                    resultingState = State.STARTED;
                    break;
                }
                case 4: {
                    resultingState = State.INIT;
                    break;
                }
                default: {
                    resultingState = State.UNKNOWN;
                }
            }
        }
        return resultingState;
    }

    public void persist() throws OBDPException {
        if (!this.stages.isEmpty()) {
            Request request;
            Request request2 = request = null == this.actionRequest ? this.requestFactory.createNewFromStages(this.stages, this.clusterHostInfo) : this.requestFactory.createNewFromStages(this.stages, this.clusterHostInfo, this.actionRequest);
            if (null != this.requestContext) {
                request.setRequestContext(this.requestContext);
            }
            if (request != null) {
                request.setUserName(AuthorizationHelper.getAuthenticatedName());
            }
            if (request != null && request.getStages() != null && !request.getStages().isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Triggering Action Manager, request={}", (Object)request);
                }
                this.actionManager.sendActions(request, this.actionRequest);
            }
        }
    }

    public RequestStatusResponse getRequestStatusResponse() {
        RequestStatusResponse response = null;
        if (!this.stages.isEmpty()) {
            response = new RequestStatusResponse(this.id);
            List<HostRoleCommand> hostRoleCommands = this.actionManager.getRequestTasks(this.id);
            response.setRequestContext(this.actionManager.getRequestContext(this.id));
            ArrayList<ShortTaskStatus> tasks = new ArrayList<ShortTaskStatus>();
            for (HostRoleCommand hostRoleCommand : hostRoleCommands) {
                tasks.add(new ShortTaskStatus(hostRoleCommand));
            }
            response.setTasks(tasks);
        }
        return response;
    }
}

