/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import id.onyx.obdp.server.ClusterNotFoundException;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.ParentObjectNotFoundException;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.RequestScheduleRequest;
import id.onyx.obdp.server.controller.RequestScheduleResponse;
import id.onyx.obdp.server.controller.internal.AbstractControllerResourceProvider;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.scheduler.Batch;
import id.onyx.obdp.server.state.scheduler.BatchRequest;
import id.onyx.obdp.server.state.scheduler.BatchSettings;
import id.onyx.obdp.server.state.scheduler.RequestExecution;
import id.onyx.obdp.server.state.scheduler.RequestExecutionFactory;
import id.onyx.obdp.server.state.scheduler.Schedule;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestScheduleResourceProvider
extends AbstractControllerResourceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(RequestScheduleResourceProvider.class);
    public static final String REQUEST_SCHEDULE = "RequestSchedule";
    public static final String BATCH_SETTINGS = "batch_settings";
    public static final String BATCH_REQUESTS = "batch_requests";
    public static final String ID_PROPERTY_ID = "id";
    public static final String CLUSTER_NAME_PROPERTY_ID = "cluster_name";
    public static final String DESCRIPTION_PROPERTY_ID = "description";
    public static final String STATUS_PROPERTY_ID = "status";
    public static final String LAST_EXECUTION_STATUS_PROPERTY_ID = "last_execution_status";
    public static final String BATCH_PROPERTY_ID = "batch";
    public static final String SCHEDULE_PROPERTY_ID = "schedule";
    public static final String CREATE_USER_PROPERTY_ID = "create_user";
    public static final String AUTHENTICATED_USER_PROPERTY_ID = "authenticated_user";
    public static final String UPDATE_USER_PROPERTY_ID = "update_user";
    public static final String CREATE_TIME_PROPERTY_ID = "create_time";
    public static final String UPDATE_TIME_PROPERTY_ID = "update_time";
    public static final String BATCH_SEPARATION_IN_SECONDS_PROPERTY_ID = "batch_separation_in_seconds";
    public static final String TASK_FAILURE_TOLERANCE_PROPERTY_ID = "task_failure_tolerance";
    public static final String TASK_FAILURE_TOLERANCE_PER_BATCH_PROPERTY_ID = "task_failure_tolerance_per_batch";
    public static final String TASK_FAILURE_TOLERANCE_LIMIT_PROPERTY_ID = "task_failure_tolerance_limit";
    public static final String REQUESTS_PROPERTY_ID = "requests";
    public static final String PAUSE_AFTER_FIRST_BATCH_PROPERTY_ID = "pause_after_first_batch";
    public static final String TYPE_PROPERTY_ID = "type";
    public static final String URI_PROPERTY_ID = "uri";
    public static final String ORDER_ID_PROPERTY_ID = "order_id";
    public static final String REQUEST_TYPE_PROPERTY_ID = "request_type";
    public static final String REQUEST_URI_PROPERTY_ID = "request_uri";
    public static final String REQUEST_BODY_PROPERTY_ID = "request_body";
    public static final String REQUEST_STATUS_PROPERTY_ID = "request_status";
    public static final String RETURN_CODE_PROPERTY_ID = "return_code";
    public static final String RESPONSE_MESSAGE_PROPERTY_ID = "response_message";
    public static final String DAYS_OF_MONTH_PROPERTY_ID = "days_of_month";
    public static final String MINUTES_PROPERTY_ID = "minutes";
    public static final String HOURS_PROPERTY_ID = "hours";
    public static final String YEAR_PROPERTY_ID = "year";
    public static final String DAY_OF_WEEK_PROPERTY_ID = "day_of_week";
    public static final String MONTH_PROPERTY_ID = "month";
    public static final String START_TIME_PROPERTY_ID = "startTime";
    public static final String START_TIME_SNAKE_CASE_PROPERTY_ID = "start_time";
    public static final String END_TIME_PROPERTY_ID = "endTime";
    public static final String END_TIME_SNAKE_CASE_PROPERTY_ID = "end_time";
    public static final String ID = PropertyHelper.getPropertyId("RequestSchedule", "id");
    public static final String CLUSTER_NAME = PropertyHelper.getPropertyId("RequestSchedule", "cluster_name");
    public static final String DESCRIPTION = PropertyHelper.getPropertyId("RequestSchedule", "description");
    public static final String STATUS = PropertyHelper.getPropertyId("RequestSchedule", "status");
    public static final String LAST_EXECUTION_STATUS = PropertyHelper.getPropertyId("RequestSchedule", "last_execution_status");
    public static final String BATCH = PropertyHelper.getPropertyId("RequestSchedule", "batch");
    public static final String SCHEDULE = PropertyHelper.getPropertyId("RequestSchedule", "schedule");
    public static final String CREATE_USER = PropertyHelper.getPropertyId("RequestSchedule", "create_user");
    public static final String AUTHENTICATED_USER = PropertyHelper.getPropertyId("RequestSchedule", "authenticated_user");
    public static final String UPDATE_USER = PropertyHelper.getPropertyId("RequestSchedule", "update_user");
    public static final String CREATE_TIME = PropertyHelper.getPropertyId("RequestSchedule", "create_time");
    public static final String UPDATE_TIME = PropertyHelper.getPropertyId("RequestSchedule", "update_time");
    public static final String BATCH_SEPARATION_IN_SECONDS = PropertyHelper.getPropertyId("batch_settings", "batch_separation_in_seconds");
    public static final String TASK_FAILURE_TOLERANCE = PropertyHelper.getPropertyId("batch_settings", "task_failure_tolerance");
    public static final String TASK_FAILURE_TOLERANCE_PER_BATCH = PropertyHelper.getPropertyId("batch_settings", "task_failure_tolerance_per_batch");
    public static final String REQUESTS = PropertyHelper.getPropertyId(null, "requests");
    public static final String PAUSE_AFTER_FIRST_BATCH = PropertyHelper.getPropertyId("batch_settings", "pause_after_first_batch");
    public static final String TYPE = PropertyHelper.getPropertyId(null, "type");
    public static final String URI = PropertyHelper.getPropertyId(null, "uri");
    public static final String ORDER_ID = PropertyHelper.getPropertyId(null, "order_id");
    public static final String BODY = PropertyHelper.getPropertyId(null, "RequestBodyInfo");
    public static final String DAYS_OF_MONTH = PropertyHelper.getPropertyId(SCHEDULE, "days_of_month");
    public static final String MINUTES = PropertyHelper.getPropertyId(SCHEDULE, "minutes");
    public static final String HOURS = PropertyHelper.getPropertyId(SCHEDULE, "hours");
    public static final String YEAR = PropertyHelper.getPropertyId(SCHEDULE, "year");
    public static final String DAY_OF_WEEK = PropertyHelper.getPropertyId(SCHEDULE, "day_of_week");
    public static final String MONTH = PropertyHelper.getPropertyId(SCHEDULE, "month");
    public static final String START_TIME = PropertyHelper.getPropertyId(SCHEDULE, "startTime");
    public static final String END_TIME = PropertyHelper.getPropertyId(SCHEDULE, "endTime");
    private static final Map<Resource.Type, String> keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.Cluster, (Object)CLUSTER_NAME).put((Object)Resource.Type.RequestSchedule, (Object)ID).build();
    private static final Set<String> propertyIds = Sets.newHashSet((Object[])new String[]{ID, CLUSTER_NAME, DESCRIPTION, STATUS, LAST_EXECUTION_STATUS, BATCH, SCHEDULE, CREATE_USER, AUTHENTICATED_USER, UPDATE_USER, CREATE_TIME, UPDATE_TIME, BATCH_SEPARATION_IN_SECONDS, TASK_FAILURE_TOLERANCE, TASK_FAILURE_TOLERANCE_PER_BATCH, PAUSE_AFTER_FIRST_BATCH, REQUESTS, TYPE, URI, ORDER_ID, BODY, DAYS_OF_MONTH, MINUTES, HOURS, YEAR, DAY_OF_WEEK, MONTH, START_TIME, END_TIME});

    protected RequestScheduleResourceProvider(OBDPManagementController managementController) {
        super(Resource.Type.RequestSchedule, propertyIds, keyPropertyIds, managementController);
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return new HashSet<String>(keyPropertyIds.values());
    }

    @Override
    public RequestStatus createResources(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        final HashSet<RequestScheduleRequest> requests = new HashSet<RequestScheduleRequest>();
        for (Map<String, Object> propertyMap : request.getProperties()) {
            requests.add(this.getRequestScheduleRequest(propertyMap));
        }
        Set<RequestScheduleResponse> responses = this.createResources(new AbstractResourceProvider.Command<Set<RequestScheduleResponse>>(){

            @Override
            public Set<RequestScheduleResponse> invoke() throws OBDPException {
                return RequestScheduleResourceProvider.this.createRequestSchedules(requests);
            }
        });
        this.notifyCreate(Resource.Type.RequestSchedule, request);
        HashSet<Resource> associatedResources = new HashSet<Resource>();
        for (RequestScheduleResponse response : responses) {
            ResourceImpl resource = new ResourceImpl(Resource.Type.RequestSchedule);
            resource.setProperty(ID, response.getId());
            associatedResources.add(resource);
        }
        return this.getRequestStatus(null, associatedResources);
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        final HashSet<RequestScheduleRequest> requests = new HashSet<RequestScheduleRequest>();
        for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
            requests.add(this.getRequestScheduleRequest(propertyMap));
        }
        Set<RequestScheduleResponse> responses = this.getResources(new AbstractResourceProvider.Command<Set<RequestScheduleResponse>>(){

            @Override
            public Set<RequestScheduleResponse> invoke() throws OBDPException {
                return RequestScheduleResourceProvider.this.getRequestSchedules(requests);
            }
        });
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        HashSet<Resource> resources = new HashSet<Resource>();
        for (RequestScheduleResponse response : responses) {
            ResourceImpl resource = new ResourceImpl(Resource.Type.RequestSchedule);
            RequestScheduleResourceProvider.setResourceProperty(resource, ID, response.getId(), requestedIds);
            RequestScheduleResourceProvider.setResourceProperty(resource, CLUSTER_NAME, response.getClusterName(), requestedIds);
            RequestScheduleResourceProvider.setResourceProperty(resource, DESCRIPTION, response.getDescription(), requestedIds);
            RequestScheduleResourceProvider.setResourceProperty(resource, STATUS, response.getStatus(), requestedIds);
            RequestScheduleResourceProvider.setResourceProperty(resource, LAST_EXECUTION_STATUS, response.getLastExecutionStatus(), requestedIds);
            RequestScheduleResourceProvider.setResourceProperty(resource, BATCH, response.getBatch(), requestedIds);
            RequestScheduleResourceProvider.setResourceProperty(resource, SCHEDULE, response.getSchedule(), requestedIds);
            RequestScheduleResourceProvider.setResourceProperty(resource, CREATE_USER, response.getCreateUser(), requestedIds);
            RequestScheduleResourceProvider.setResourceProperty(resource, AUTHENTICATED_USER, response.getAuthenticatedUserId(), requestedIds);
            RequestScheduleResourceProvider.setResourceProperty(resource, CREATE_TIME, response.getCreateTime(), requestedIds);
            RequestScheduleResourceProvider.setResourceProperty(resource, UPDATE_USER, response.getUpdateUser(), requestedIds);
            RequestScheduleResourceProvider.setResourceProperty(resource, UPDATE_TIME, response.getUpdateTime(), requestedIds);
            resources.add(resource);
        }
        return resources;
    }

    @Override
    public RequestStatus updateResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        final HashSet<RequestScheduleRequest> requests = new HashSet<RequestScheduleRequest>();
        Iterator<Map<String, Object>> iterator = request.getProperties().iterator();
        if (iterator.hasNext()) {
            for (Map<String, Object> propertyMap : this.getPropertyMaps(iterator.next(), predicate)) {
                requests.add(this.getRequestScheduleRequest(propertyMap));
            }
            this.modifyResources(new AbstractResourceProvider.Command<Void>(){

                @Override
                public Void invoke() throws OBDPException {
                    RequestScheduleResourceProvider.this.updateRequestSchedule(requests);
                    return null;
                }
            });
        }
        this.notifyUpdate(Resource.Type.RequestSchedule, request, predicate);
        return this.getRequestStatus(null);
    }

    @Override
    public RequestStatus deleteResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
            final RequestScheduleRequest requestScheduleRequest = this.getRequestScheduleRequest(propertyMap);
            this.modifyResources(new AbstractResourceProvider.Command<Void>(){

                @Override
                public Void invoke() throws OBDPException {
                    RequestScheduleResourceProvider.this.deleteRequestSchedule(requestScheduleRequest);
                    return null;
                }
            });
        }
        this.notifyDelete(Resource.Type.RequestSchedule, predicate);
        return this.getRequestStatus(null);
    }

    private synchronized void deleteRequestSchedule(RequestScheduleRequest request) throws OBDPException {
        Cluster cluster;
        if (request.getId() == null) {
            throw new OBDPException("Id is a required field.");
        }
        Clusters clusters = this.getManagementController().getClusters();
        try {
            cluster = clusters.getCluster(request.getClusterName());
        }
        catch (ClusterNotFoundException e) {
            throw new ParentObjectNotFoundException("Attempted to delete a request schedule from a cluster which doesn't exist", e);
        }
        RequestExecution requestExecution = cluster.getAllRequestExecutions().get(request.getId());
        if (requestExecution == null) {
            throw new OBDPException("Request Schedule not found , clusterName = " + request.getClusterName() + ", description = " + request.getDescription() + ", id = " + request.getId());
        }
        String username = this.getManagementController().getAuthName();
        LOG.info("Disabling Request Schedule , clusterName = " + request.getClusterName() + ", id = " + request.getId() + ", user = " + username);
        this.getManagementController().getExecutionScheduleManager().deleteAllJobs(requestExecution);
        requestExecution.updateStatus(RequestExecution.Status.DISABLED);
    }

    private synchronized void updateRequestSchedule(Set<RequestScheduleRequest> requests) throws OBDPException {
        if (requests.isEmpty()) {
            LOG.warn("Received an empty requests set");
            return;
        }
        Clusters clusters = this.getManagementController().getClusters();
        for (RequestScheduleRequest request : requests) {
            Cluster cluster;
            this.validateRequest(request);
            try {
                cluster = clusters.getCluster(request.getClusterName());
            }
            catch (ClusterNotFoundException e) {
                throw new ParentObjectNotFoundException("Attempted to add a request schedule to a cluster which doesn't exist", e);
            }
            if (request.getId() == null) {
                throw new OBDPException("Id is a required parameter.");
            }
            RequestExecution requestExecution = cluster.getAllRequestExecutions().get(request.getId());
            if (requestExecution == null) {
                throw new OBDPException("Request Schedule not found , clusterName = " + request.getClusterName() + ", description = " + request.getDescription() + ", id = " + request.getId());
            }
            String username = this.getManagementController().getAuthName();
            Integer userId = this.getManagementController().getAuthId();
            if (request.getDescription() != null) {
                requestExecution.setDescription(request.getDescription());
            }
            if (request.getSchedule() != null) {
                requestExecution.setSchedule(request.getSchedule());
            }
            if (request.getStatus() != null) {
                if (!this.isValidRequestScheduleStatus(request.getStatus())) {
                    throw new OBDPException("Request Schedule status not valid, clusterName = " + request.getClusterName() + ", description = " + request.getDescription() + ", id = " + request.getId());
                }
                requestExecution.setStatus(RequestExecution.Status.valueOf(request.getStatus()));
            }
            requestExecution.setUpdateUser(username);
            requestExecution.setAuthenticatedUserId(userId);
            LOG.info("Persisting updated Request Schedule , clusterName = " + request.getClusterName() + ", description = " + request.getDescription() + ", status = " + request.getStatus() + ", user = " + username);
            requestExecution.persist();
            this.getManagementController().getExecutionScheduleManager().updateBatchSchedule(requestExecution);
        }
    }

    private synchronized Set<RequestScheduleResponse> createRequestSchedules(Set<RequestScheduleRequest> requests) throws OBDPException {
        if (requests.isEmpty()) {
            LOG.warn("Received an empty requests set");
            return null;
        }
        HashSet<RequestScheduleResponse> responses = new HashSet<RequestScheduleResponse>();
        Clusters clusters = this.getManagementController().getClusters();
        RequestExecutionFactory requestExecutionFactory = this.getManagementController().getRequestExecutionFactory();
        for (RequestScheduleRequest request : requests) {
            Cluster cluster;
            this.validateRequest(request);
            try {
                cluster = clusters.getCluster(request.getClusterName());
            }
            catch (ClusterNotFoundException e) {
                throw new ParentObjectNotFoundException("Attempted to add a request schedule to a cluster which doesn't exist", e);
            }
            String username = this.getManagementController().getAuthName();
            Integer userId = this.getManagementController().getAuthId();
            RequestExecution requestExecution = requestExecutionFactory.createNew(cluster, request.getBatch(), request.getSchedule());
            requestExecution.setCreateUser(username);
            requestExecution.setUpdateUser(username);
            requestExecution.setAuthenticatedUserId(userId);
            requestExecution.setStatus(RequestExecution.Status.SCHEDULED);
            LOG.info("Persisting new Request Schedule , clusterName = " + request.getClusterName() + ", description = " + request.getDescription() + ", user = " + username);
            requestExecution.persist();
            cluster.addRequestExecution(requestExecution);
            this.getManagementController().getExecutionScheduleManager().scheduleAllBatches(requestExecution);
            RequestScheduleResponse response = new RequestScheduleResponse(requestExecution.getId(), requestExecution.getClusterName(), requestExecution.getDescription(), requestExecution.getStatus(), requestExecution.getLastExecutionStatus(), requestExecution.getBatch(), request.getSchedule(), requestExecution.getCreateUser(), requestExecution.getCreateTime(), requestExecution.getUpdateUser(), requestExecution.getUpdateTime(), requestExecution.getAuthenticatedUserId());
            responses.add(response);
        }
        return responses;
    }

    private void validateRequest(RequestScheduleRequest request) throws OBDPException {
        Batch batch;
        if (request.getClusterName() == null) {
            throw new IllegalArgumentException("Cluster name is required.");
        }
        Schedule schedule = request.getSchedule();
        if (schedule != null) {
            this.getManagementController().getExecutionScheduleManager().validateSchedule(schedule);
        }
        if ((batch = request.getBatch()) != null && !batch.getBatchRequests().isEmpty()) {
            HashSet<Long> orderIdSet = new HashSet<Long>();
            for (BatchRequest batchRequest : batch.getBatchRequests()) {
                if (batchRequest.getOrderId() == null) {
                    throw new OBDPException("No order id provided for batch request. " + batchRequest);
                }
                if (orderIdSet.contains(batchRequest.getOrderId())) {
                    throw new OBDPException("Duplicate order id provided for batch request. " + batchRequest);
                }
                orderIdSet.add(batchRequest.getOrderId());
            }
        }
    }

    private synchronized Set<RequestScheduleResponse> getRequestSchedules(Set<RequestScheduleRequest> requests) throws OBDPException {
        HashSet<RequestScheduleResponse> responses = new HashSet<RequestScheduleResponse>();
        if (requests != null) {
            for (RequestScheduleRequest request : requests) {
                if (request.getClusterName() == null) {
                    LOG.warn("Cluster name is a required field.");
                    continue;
                }
                Cluster cluster = this.getManagementController().getClusters().getCluster(request.getClusterName());
                Map<Long, RequestExecution> allRequestExecutions = cluster.getAllRequestExecutions();
                if (request.getId() != null) {
                    RequestExecution requestExecution = allRequestExecutions.get(request.getId());
                    if (requestExecution == null) continue;
                    responses.add(requestExecution.convertToResponseWithBody());
                    continue;
                }
                if (request.getStatus() != null) {
                    for (RequestExecution requestExecution : allRequestExecutions.values()) {
                        if (!requestExecution.getStatus().equals(request.getStatus())) continue;
                        responses.add(requestExecution.convertToResponse());
                    }
                    continue;
                }
                for (RequestExecution requestExecution : allRequestExecutions.values()) {
                    responses.add(requestExecution.convertToResponse());
                }
            }
        }
        return responses;
    }

    private boolean isValidRequestScheduleStatus(String giveStatus) {
        for (RequestExecution.Status status : RequestExecution.Status.values()) {
            if (!status.name().equalsIgnoreCase(giveStatus)) continue;
            return true;
        }
        return false;
    }

    private RequestScheduleRequest getRequestScheduleRequest(Map<String, Object> properties) {
        Object idObj = properties.get(ID);
        Long id = null;
        if (idObj != null) {
            id = idObj instanceof Long ? (Long)idObj : Long.parseLong((String)idObj);
        }
        RequestScheduleRequest requestScheduleRequest = new RequestScheduleRequest(id, (String)properties.get(CLUSTER_NAME), (String)properties.get(DESCRIPTION), (String)properties.get(STATUS), null, null);
        Batch batch = new Batch();
        BatchSettings batchSettings = new BatchSettings();
        ArrayList<BatchRequest> batchRequests = new ArrayList<BatchRequest>();
        Object batchObject = properties.get(BATCH);
        if (batchObject != null && batchObject instanceof HashSet) {
            try {
                HashSet batchMap = (HashSet)batchObject;
                for (Map map : batchMap) {
                    if (map == null) continue;
                    for (Map.Entry batchMapEntry : map.entrySet()) {
                        if (((String)batchMapEntry.getKey()).equals(TASK_FAILURE_TOLERANCE)) {
                            batchSettings.setTaskFailureToleranceLimit(Integer.valueOf((String)batchMapEntry.getValue()));
                            continue;
                        }
                        if (((String)batchMapEntry.getKey()).equals(TASK_FAILURE_TOLERANCE_PER_BATCH)) {
                            batchSettings.setTaskFailureToleranceLimitPerBatch(Integer.valueOf((String)batchMapEntry.getValue()));
                            continue;
                        }
                        if (((String)batchMapEntry.getKey()).equals(BATCH_SEPARATION_IN_SECONDS)) {
                            batchSettings.setBatchSeparationInSeconds(Integer.valueOf((String)batchMapEntry.getValue()));
                            continue;
                        }
                        if (((String)batchMapEntry.getKey()).equals(PAUSE_AFTER_FIRST_BATCH)) {
                            batchSettings.setPauseAfterFirstBatch(Boolean.valueOf((String)batchMapEntry.getValue()));
                            continue;
                        }
                        if (!((String)batchMapEntry.getKey()).equals(REQUESTS)) continue;
                        HashSet requestSet = (HashSet)batchMapEntry.getValue();
                        for (Map requestEntry : requestSet) {
                            if (requestEntry == null) continue;
                            BatchRequest batchRequest = new BatchRequest();
                            for (Map.Entry requestMapEntry : requestEntry.entrySet()) {
                                if (((String)requestMapEntry.getKey()).equals(TYPE)) {
                                    batchRequest.setType(BatchRequest.Type.valueOf((String)requestMapEntry.getValue()));
                                    continue;
                                }
                                if (((String)requestMapEntry.getKey()).equals(URI)) {
                                    batchRequest.setUri((String)requestMapEntry.getValue());
                                    continue;
                                }
                                if (((String)requestMapEntry.getKey()).equals(ORDER_ID)) {
                                    batchRequest.setOrderId(Long.parseLong((String)requestMapEntry.getValue()));
                                    continue;
                                }
                                if (!((String)requestMapEntry.getKey()).equals(BODY)) continue;
                                batchRequest.setBody((String)requestMapEntry.getValue());
                            }
                            batchRequests.add(batchRequest);
                        }
                    }
                }
                batch.getBatchRequests().addAll(batchRequests);
                batch.setBatchSettings(batchSettings);
            }
            catch (Exception e) {
                LOG.warn("Request Schedule batch json is unparseable. " + batchObject, (Throwable)e);
            }
        }
        requestScheduleRequest.setBatch(batch);
        Schedule schedule = new Schedule();
        for (Map.Entry entry : properties.entrySet()) {
            if (((String)entry.getKey()).equals(DAY_OF_WEEK)) {
                schedule.setDayOfWeek((String)entry.getValue());
                continue;
            }
            if (((String)entry.getKey()).equals(DAYS_OF_MONTH)) {
                schedule.setDaysOfMonth((String)entry.getValue());
                continue;
            }
            if (((String)entry.getKey()).equals(END_TIME)) {
                schedule.setEndTime((String)entry.getValue());
                continue;
            }
            if (((String)entry.getKey()).equals(HOURS)) {
                schedule.setHours((String)entry.getValue());
                continue;
            }
            if (((String)entry.getKey()).equals(MINUTES)) {
                schedule.setMinutes((String)entry.getValue());
                continue;
            }
            if (((String)entry.getKey()).equals(MONTH)) {
                schedule.setMonth((String)entry.getValue());
                continue;
            }
            if (((String)entry.getKey()).equals(START_TIME)) {
                schedule.setStartTime((String)entry.getValue());
                continue;
            }
            if (!((String)entry.getKey()).equals(YEAR)) continue;
            schedule.setYear((String)entry.getValue());
        }
        if (!schedule.isEmpty()) {
            requestScheduleRequest.setSchedule(schedule);
        }
        return requestScheduleRequest;
    }
}

