/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.StaticallyInject;
import id.onyx.obdp.server.actionmanager.ActionManager;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.actionmanager.RequestStatus;
import id.onyx.obdp.server.api.predicate.InvalidQueryException;
import id.onyx.obdp.server.api.predicate.PredicateCompiler;
import id.onyx.obdp.server.controller.ExecuteActionRequest;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.RequestRequest;
import id.onyx.obdp.server.controller.RequestStatusResponse;
import id.onyx.obdp.server.controller.internal.AbstractControllerResourceProvider;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.CalculatedStatus;
import id.onyx.obdp.server.controller.internal.HostComponentResourceProvider;
import id.onyx.obdp.server.controller.internal.RequestOperationLevel;
import id.onyx.obdp.server.controller.internal.RequestResourceFilter;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.ClusterController;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.QueryResponse;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.ClusterControllerHelper;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.customactions.ActionDefinition;
import id.onyx.obdp.server.orm.dao.HostRoleCommandDAO;
import id.onyx.obdp.server.orm.dao.HostRoleCommandStatusSummaryDTO;
import id.onyx.obdp.server.orm.dao.RequestDAO;
import id.onyx.obdp.server.orm.entities.RequestEntity;
import id.onyx.obdp.server.security.authorization.AuthorizationException;
import id.onyx.obdp.server.security.authorization.AuthorizationHelper;
import id.onyx.obdp.server.security.authorization.ResourceType;
import id.onyx.obdp.server.security.authorization.RoleAuthorization;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.topology.LogicalRequest;
import id.onyx.obdp.server.topology.TopologyManager;
import id.onyx.obdp.server.utils.SecretReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StaticallyInject
public class RequestResourceProvider
extends AbstractControllerResourceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(RequestResourceProvider.class);
    @Inject
    private static RequestDAO s_requestDAO = null;
    @Inject
    private static HostRoleCommandDAO s_hostRoleCommandDAO = null;
    @Inject
    private static TopologyManager topologyManager;
    public static final String REQUESTS = "Requests";
    public static final String REQUEST_INFO = "RequestInfo";
    public static final String REQUEST_CLUSTER_NAME_PROPERTY_ID = "Requests/cluster_name";
    public static final String REQUEST_CLUSTER_ID_PROPERTY_ID = "Requests/cluster_id";
    public static final String REQUEST_ID_PROPERTY_ID = "Requests/id";
    public static final String REQUEST_STATUS_PROPERTY_ID = "Requests/request_status";
    public static final String REQUEST_ABORT_REASON_PROPERTY_ID = "Requests/abort_reason";
    public static final String REQUEST_CONTEXT_ID = "Requests/request_context";
    public static final String REQUEST_SOURCE_SCHEDULE = "Requests/request_schedule";
    public static final String REQUEST_SOURCE_SCHEDULE_ID = "Requests/request_schedule/schedule_id";
    public static final String REQUEST_SOURCE_SCHEDULE_HREF = "Requests/request_schedule/href";
    public static final String REQUEST_TYPE_ID = "Requests/type";
    public static final String REQUEST_INPUTS_ID = "Requests/inputs";
    public static final String REQUEST_CLUSTER_HOST_INFO_ID = "Requests/cluster_host_info";
    public static final String REQUEST_RESOURCE_FILTER_ID = "Requests/resource_filters";
    public static final String REQUEST_OPERATION_LEVEL_ID = "Requests/operation_level";
    public static final String REQUEST_CREATE_TIME_ID = "Requests/create_time";
    public static final String REQUEST_START_TIME_ID = "Requests/start_time";
    public static final String REQUEST_END_TIME_ID = "Requests/end_time";
    public static final String REQUEST_EXCLUSIVE_ID = "Requests/exclusive";
    public static final String REQUEST_TASK_CNT_ID = "Requests/task_count";
    public static final String REQUEST_FAILED_TASK_CNT_ID = "Requests/failed_task_count";
    public static final String REQUEST_ABORTED_TASK_CNT_ID = "Requests/aborted_task_count";
    public static final String REQUEST_TIMED_OUT_TASK_CNT_ID = "Requests/timed_out_task_count";
    public static final String REQUEST_COMPLETED_TASK_CNT_ID = "Requests/completed_task_count";
    public static final String REQUEST_QUEUED_TASK_CNT_ID = "Requests/queued_task_count";
    public static final String REQUEST_PROGRESS_PERCENT_ID = "Requests/progress_percent";
    public static final String REQUEST_REMOVE_PENDING_HOST_REQUESTS_ID = "Requests/remove_pending_host_requests";
    public static final String REQUEST_PENDING_HOST_REQUEST_COUNT_ID = "Requests/pending_host_request_count";
    public static final String REQUEST_USER_NAME = "Requests/user_name";
    public static final String COMMAND_ID = "command";
    public static final String SERVICE_ID = "service_name";
    public static final String COMPONENT_ID = "component_name";
    public static final String HOSTS_ID = "hosts";
    public static final String HOSTS_PREDICATE = "hosts_predicate";
    public static final String ACTION_ID = "action";
    public static final String INPUTS_ID = "parameters";
    public static final String EXCLUSIVE_ID = "exclusive";
    public static final String HAS_RESOURCE_FILTERS = "HAS_RESOURCE_FILTERS";
    public static final String CONTEXT = "context";
    private static final Set<String> PK_PROPERTY_IDS;
    private PredicateCompiler predicateCompiler = new PredicateCompiler();
    private static final Map<Resource.Type, String> keyPropertyIds;
    static Set<String> PROPERTY_IDS;

    RequestResourceProvider(OBDPManagementController managementController) {
        super(Resource.Type.Request, PROPERTY_IDS, keyPropertyIds, managementController);
    }

    @Override
    public id.onyx.obdp.server.controller.spi.RequestStatus createResources(Request request) throws SystemException, UnsupportedPropertyException, NoSuchParentResourceException, ResourceAlreadyExistsException {
        if (request.getProperties().size() > 1) {
            throw new UnsupportedOperationException("Multiple actions/commands cannot be executed at the same time.");
        }
        final ExecuteActionRequest actionRequest = this.getActionRequest(request);
        final Map<String, String> requestInfoProperties = request.getRequestInfoProperties();
        return this.getRequestStatus(this.createResources(new AbstractResourceProvider.Command<RequestStatusResponse>(){

            @Override
            public RequestStatusResponse invoke() throws OBDPException, AuthorizationException {
                Long resourceId;
                ResourceType resourceType;
                String clusterName = actionRequest.getClusterName();
                if (StringUtils.isEmpty((String)clusterName)) {
                    resourceType = ResourceType.OBDP;
                    resourceId = null;
                } else {
                    resourceType = ResourceType.CLUSTER;
                    resourceId = RequestResourceProvider.this.getClusterResourceId(clusterName);
                }
                if (actionRequest.isCommand().booleanValue()) {
                    String commandName = actionRequest.getCommandName();
                    if (StringUtils.isEmpty((String)commandName)) {
                        commandName = "_unknown_command_";
                    }
                    if (commandName.endsWith("_SERVICE_CHECK")) {
                        if (!AuthorizationHelper.isAuthorized(resourceType, resourceId, RoleAuthorization.SERVICE_RUN_SERVICE_CHECK)) {
                            throw new AuthorizationException("The authenticated user is not authorized to execute service checks.");
                        }
                    } else if (commandName.equals("DECOMMISSION")) {
                        if (!AuthorizationHelper.isAuthorized(resourceType, resourceId, RoleAuthorization.SERVICE_DECOMMISSION_RECOMMISSION)) {
                            throw new AuthorizationException("The authenticated user is not authorized to decommission services.");
                        }
                    } else if (!AuthorizationHelper.isAuthorized(resourceType, resourceId, RoleAuthorization.SERVICE_RUN_CUSTOM_COMMAND)) {
                        throw new AuthorizationException(String.format("The authenticated user is not authorized to execute the command, %s.", commandName));
                    }
                } else {
                    String actionName = actionRequest.getActionName();
                    if (StringUtils.isEmpty((String)actionName)) {
                        actionName = "_unknown_action_";
                    }
                    if (actionName.contains("SERVICE_CHECK")) {
                        if (!AuthorizationHelper.isAuthorized(resourceType, resourceId, RoleAuthorization.SERVICE_RUN_SERVICE_CHECK)) {
                            throw new AuthorizationException("The authenticated user is not authorized to execute service checks.");
                        }
                    } else {
                        ActionDefinition actionDefinition = RequestResourceProvider.this.getManagementController().getAmbariMetaInfo().getActionDefinition(actionName);
                        Set<RoleAuthorization> permissions = actionDefinition == null ? null : actionDefinition.getPermissions();
                        ResourceType customActionResourceType = resourceType;
                        if (actionName.contains("check_host")) {
                            customActionResourceType = ResourceType.CLUSTER;
                        }
                        if (!AuthorizationHelper.isAuthorized(customActionResourceType, resourceId, permissions)) {
                            throw new AuthorizationException(String.format("The authenticated user is not authorized to execute the action %s.", actionName));
                        }
                    }
                }
                return RequestResourceProvider.this.getManagementController().createAction(actionRequest, requestInfoProperties);
            }
        }));
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        Boolean ascOrder;
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        HashSet<Resource> resources = new HashSet<Resource>();
        String maxResultsRaw = request.getRequestInfoProperties().get("Request_Info/max_results");
        String ascOrderRaw = request.getRequestInfoProperties().get("Request_Info/asc_order");
        Integer maxResults = maxResultsRaw == null ? null : Integer.valueOf(Integer.parseInt(maxResultsRaw));
        Boolean bl = ascOrder = ascOrderRaw == null ? null : Boolean.valueOf(Boolean.parseBoolean(ascOrderRaw));
        if (null == predicate) {
            this.authorizeGetResources(null);
            resources.addAll(this.getRequestResources(null, null, null, maxResults, ascOrder, requestedIds));
        } else {
            for (Map<String, Object> properties : this.getPropertyMaps(predicate)) {
                String clusterName = (String)properties.get(REQUEST_CLUSTER_NAME_PROPERTY_ID);
                Long requestId = null;
                if (properties.get(REQUEST_ID_PROPERTY_ID) != null) {
                    requestId = Long.valueOf((String)properties.get(REQUEST_ID_PROPERTY_ID));
                }
                String requestStatus = null;
                if (properties.get(REQUEST_STATUS_PROPERTY_ID) != null) {
                    requestStatus = (String)properties.get(REQUEST_STATUS_PROPERTY_ID);
                }
                this.authorizeGetResources(clusterName);
                resources.addAll(this.getRequestResources(clusterName, requestId, requestStatus, maxResults, ascOrder, requestedIds));
            }
        }
        return resources;
    }

    private void authorizeGetResources(String clusterName) throws NoSuchParentResourceException, AuthorizationException {
        HashSet requiredAuthorizations;
        Long resourceId;
        boolean ambariLevelRequest = StringUtils.isBlank((String)clusterName);
        ResourceType resourceType = ambariLevelRequest ? ResourceType.OBDP : ResourceType.CLUSTER;
        try {
            resourceId = ambariLevelRequest ? null : this.getClusterResourceId(clusterName);
        }
        catch (OBDPException e) {
            throw new NoSuchParentResourceException("Error while fetching cluster resource ID", e);
        }
        HashSet hashSet = requiredAuthorizations = ambariLevelRequest ? Sets.newHashSet((Object[])new RoleAuthorization[]{RoleAuthorization.OBDP_VIEW_STATUS_INFO}) : Sets.newHashSet((Object[])new RoleAuthorization[]{RoleAuthorization.CLUSTER_VIEW_STATUS_INFO, RoleAuthorization.HOST_VIEW_STATUS_INFO, RoleAuthorization.SERVICE_VIEW_STATUS_INFO});
        if (!AuthorizationHelper.isAuthorized(resourceType, resourceId, requiredAuthorizations)) {
            throw new AuthorizationException(String.format("The authenticated user is not authorized to fetch request related information.", new Object[0]));
        }
    }

    @Override
    public id.onyx.obdp.server.controller.spi.RequestStatus updateResources(Request requestInfo, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        OBDPManagementController amc = this.getManagementController();
        HashSet<RequestRequest> requests = new HashSet<RequestRequest>();
        Iterator<Map<String, Object>> iterator = requestInfo.getProperties().iterator();
        if (iterator.hasNext()) {
            for (Map<String, Object> map : this.getPropertyMaps(iterator.next(), predicate)) {
                requests.add(this.getRequest(map));
            }
        }
        ArrayList<id.onyx.obdp.server.actionmanager.Request> targets = new ArrayList<id.onyx.obdp.server.actionmanager.Request>();
        for (RequestRequest updateRequest : requests) {
            ActionManager actionManager = amc.getActionManager();
            List<id.onyx.obdp.server.actionmanager.Request> internalRequests = actionManager.getRequests(Collections.singletonList(updateRequest.getRequestId()));
            if (internalRequests.size() == 0) {
                throw new IllegalArgumentException(String.format("Request %s does not exist", updateRequest.getRequestId()));
            }
            id.onyx.obdp.server.actionmanager.Request internalRequest = internalRequests.get(0);
            if (updateRequest.isRemovePendingHostRequests()) {
                if (internalRequest instanceof LogicalRequest) {
                    targets.add(internalRequest);
                    continue;
                }
                throw new IllegalArgumentException("Request with id: " + internalRequest.getRequestId() + "is not a Logical Request.");
            }
            if (updateRequest.getAbortReason() == null || updateRequest.getAbortReason().isEmpty()) {
                throw new IllegalArgumentException("Abort reason can not be empty.");
            }
            if (updateRequest.getStatus() != HostRoleStatus.ABORTED) {
                throw new IllegalArgumentException(String.format("%s is wrong value. The only allowed value for updating request status is ABORTED", new Object[]{updateRequest.getStatus()}));
            }
            HostRoleStatus internalRequestStatus = CalculatedStatus.statusFromStages(internalRequest.getStages()).getStatus();
            if (internalRequestStatus.isCompletedState()) continue;
            targets.add(internalRequest);
        }
        Iterator iterator2 = requests.iterator();
        for (id.onyx.obdp.server.actionmanager.Request target : targets) {
            if (target instanceof LogicalRequest) {
                topologyManager.removePendingHostRequests(target.getClusterName(), target.getRequestId());
                continue;
            }
            String reason = ((RequestRequest)iterator2.next()).getAbortReason();
            amc.getActionManager().cancelRequest(target.getRequestId(), reason);
        }
        return this.getRequestStatus(null);
    }

    private RequestRequest getRequest(Map<String, Object> propertyMap) {
        String clusterNameStr = (String)propertyMap.get(REQUEST_CLUSTER_NAME_PROPERTY_ID);
        String requestIdStr = (String)propertyMap.get(REQUEST_ID_PROPERTY_ID);
        long requestId = Integer.parseInt(requestIdStr);
        String requestStatusStr = (String)propertyMap.get(REQUEST_STATUS_PROPERTY_ID);
        HostRoleStatus requestStatus = null;
        if (requestStatusStr != null) {
            requestStatus = HostRoleStatus.valueOf(requestStatusStr);
        }
        String abortReason = StringEscapeUtils.escapeHtml4((String)((String)propertyMap.get(REQUEST_ABORT_REASON_PROPERTY_ID)));
        String removePendingHostRequests = (String)propertyMap.get(REQUEST_REMOVE_PENDING_HOST_REQUESTS_ID);
        RequestRequest requestRequest = new RequestRequest(clusterNameStr, requestId);
        requestRequest.setStatus(requestStatus);
        requestRequest.setAbortReason(abortReason);
        if (removePendingHostRequests != null) {
            requestRequest.setRemovePendingHostRequests(Boolean.valueOf(removePendingHostRequests));
        }
        return requestRequest;
    }

    @Override
    public id.onyx.obdp.server.controller.spi.RequestStatus deleteResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new UnsupportedOperationException("Not currently supported.");
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return PK_PROPERTY_IDS;
    }

    private ExecuteActionRequest getActionRequest(Request request) throws UnsupportedOperationException, SystemException {
        Map<String, String> requestInfoProperties = request.getRequestInfoProperties();
        Map<String, Object> propertyMap = request.getProperties().iterator().next();
        Boolean isCommand = requestInfoProperties.containsKey(COMMAND_ID);
        String commandName = null;
        String actionName = null;
        if (isCommand.booleanValue()) {
            if (requestInfoProperties.containsKey(ACTION_ID)) {
                throw new UnsupportedOperationException("Both command and action cannot be specified.");
            }
            commandName = requestInfoProperties.get(COMMAND_ID);
        } else {
            if (!requestInfoProperties.containsKey(ACTION_ID)) {
                throw new UnsupportedOperationException("Either command or action must be specified.");
            }
            actionName = requestInfoProperties.get(ACTION_ID);
        }
        ArrayList<RequestResourceFilter> resourceFilterList = null;
        HashMap<String, String> params = new HashMap<String, String>();
        Object resourceFilterObj = propertyMap.get(REQUEST_RESOURCE_FILTER_ID);
        if (resourceFilterObj != null && resourceFilterObj instanceof HashSet) {
            HashSet resourceFilters = (HashSet)resourceFilterObj;
            resourceFilterList = new ArrayList<RequestResourceFilter>();
            for (Map resourceMap : resourceFilters) {
                params.put(HAS_RESOURCE_FILTERS, "true");
                resourceFilterList.addAll(this.parseRequestResourceFilter(resourceMap, (String)propertyMap.get(REQUEST_CLUSTER_NAME_PROPERTY_ID)));
            }
            LOG.debug("RequestResourceFilters : {}", (Object)resourceFilters);
        }
        RequestOperationLevel operationLevel = null;
        if (requestInfoProperties.containsKey("operation_level/level")) {
            operationLevel = new RequestOperationLevel(requestInfoProperties);
        }
        String keyPrefix = "parameters/";
        for (String key : requestInfoProperties.keySet()) {
            if (!key.startsWith(keyPrefix)) continue;
            params.put(key.substring(keyPrefix.length()), requestInfoProperties.get(key));
        }
        boolean exclusive = false;
        if (requestInfoProperties.containsKey(EXCLUSIVE_ID)) {
            exclusive = Boolean.valueOf(requestInfoProperties.get(EXCLUSIVE_ID).trim());
        }
        return new ExecuteActionRequest((String)propertyMap.get(REQUEST_CLUSTER_NAME_PROPERTY_ID), commandName, actionName, resourceFilterList, operationLevel, params, exclusive);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<RequestResourceFilter> parseRequestResourceFilter(Map<String, Object> resourceMap, String clusterName) throws SystemException {
        ArrayList<RequestResourceFilter> resourceFilterList = new ArrayList<RequestResourceFilter>();
        String serviceName = (String)resourceMap.get(SERVICE_ID);
        String componentName = (String)resourceMap.get(COMPONENT_ID);
        String hostsPredicate = (String)resourceMap.get(HOSTS_PREDICATE);
        Object hostListStr = resourceMap.get(HOSTS_ID);
        List<String> hostList = Collections.emptyList();
        if (hostListStr != null) {
            hostList = new ArrayList();
            for (String hostName : ((String)hostListStr).split(",")) {
                hostList.add(hostName.trim());
            }
            resourceFilterList.add(new RequestResourceFilter(serviceName, componentName, hostList));
            return resourceFilterList;
        }
        if (hostsPredicate != null) {
            Predicate filterPredicate;
            try {
                filterPredicate = this.predicateCompiler.compile(hostsPredicate);
            }
            catch (InvalidQueryException e) {
                String msg = "Invalid predicate expression provided: " + hostsPredicate;
                LOG.warn(msg, (Throwable)e);
                throw new SystemException(msg, e);
            }
            HashSet<String> propertyIds = new HashSet<String>();
            propertyIds.add(HostComponentResourceProvider.CLUSTER_NAME);
            propertyIds.add(HostComponentResourceProvider.SERVICE_NAME);
            propertyIds.add(HostComponentResourceProvider.COMPONENT_NAME);
            Request request = PropertyHelper.getReadRequest(propertyIds);
            try {
                ClusterController clusterController = ClusterControllerHelper.getClusterController();
                QueryResponse queryResponse = clusterController.getResources(Resource.Type.HostComponent, request, filterPredicate);
                Iterable<Resource> resourceIterable = clusterController.getIterable(Resource.Type.HostComponent, queryResponse, request, filterPredicate, null, null);
                HashMap<ServiceComponentTuple, List<String>> tupleListMap = new HashMap<ServiceComponentTuple, List<String>>();
                for (Resource resource : resourceIterable) {
                    String computedComponentName;
                    String hostnameStr = (String)resource.getPropertyValue(HostComponentResourceProvider.HOST_NAME);
                    if (hostnameStr == null) continue;
                    String computedServiceName = (String)resource.getPropertyValue(HostComponentResourceProvider.SERVICE_NAME);
                    ServiceComponentTuple tuple = new ServiceComponentTuple(computedServiceName, computedComponentName = (String)resource.getPropertyValue(HostComponentResourceProvider.COMPONENT_NAME));
                    if (!tupleListMap.containsKey(tuple)) {
                        hostList = new ArrayList<String>();
                        hostList.add(hostnameStr);
                        tupleListMap.put(tuple, hostList);
                        continue;
                    }
                    ((List)tupleListMap.get(tuple)).add(hostnameStr);
                }
                if (tupleListMap.isEmpty()) return resourceFilterList;
                for (Map.Entry entry : tupleListMap.entrySet()) {
                    resourceFilterList.add(new RequestResourceFilter(((ServiceComponentTuple)entry.getKey()).getServiceName(), ((ServiceComponentTuple)entry.getKey()).getComponentName(), (List)entry.getValue()));
                }
                return resourceFilterList;
            }
            catch (Exception e) {
                LOG.warn("Exception finding requested resources with serviceName = " + serviceName + ", componentName = " + componentName + ", hostPredicate = " + hostsPredicate, (Throwable)e);
                return resourceFilterList;
            }
        }
        resourceFilterList.add(new RequestResourceFilter(serviceName, componentName, hostList));
        return resourceFilterList;
    }

    private Set<Resource> getRequestResources(String clusterName, Long requestId, String requestStatus, Integer maxResults, Boolean ascOrder, Set<String> requestedPropertyIds) throws NoSuchResourceException, NoSuchParentResourceException {
        HashSet<Resource> response = new HashSet<Resource>();
        ActionManager actionManager = this.getManagementController().getActionManager();
        Long clusterId = null;
        if (clusterName != null) {
            Clusters clusters = this.getManagementController().getClusters();
            try {
                Cluster cluster = clusters.getCluster(clusterName);
                clusterId = cluster.getClusterId();
            }
            catch (OBDPException e) {
                throw new NoSuchParentResourceException(e.getMessage(), e);
            }
        }
        List<Object> requestIds = Collections.emptyList();
        if (requestId == null) {
            RequestStatus status = null;
            if (requestStatus != null) {
                status = RequestStatus.valueOf(requestStatus);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Received a Get Request Status request, requestId=null, requestStatus={}", (Object)status);
            }
            maxResults = maxResults != null ? maxResults : 20;
            ascOrder = ascOrder != null ? ascOrder : false;
            requestIds = null == status ? (null != clusterId ? s_requestDAO.findAllRequestIds(maxResults, ascOrder, clusterId) : s_requestDAO.findAllRequestIds(maxResults, ascOrder, null)) : actionManager.getRequestsByStatus(status, maxResults, ascOrder);
            LOG.debug("List<Long> requestIds = actionManager.getRequestsByStatus = {}", (Object)requestIds.size());
            response.addAll(this.getRequestResources(clusterId, clusterName, requestIds, requestedPropertyIds));
        } else {
            Collection<Resource> responses = this.getRequestResources(clusterId, clusterName, Collections.singletonList(requestId), requestedPropertyIds);
            if (responses.isEmpty()) {
                throw new NoSuchResourceException("Request resource doesn't exist.");
            }
            response.addAll(responses);
        }
        return response;
    }

    private Collection<Resource> getRequestResources(Long clusterId, String clusterName, List<Long> requestIds, Set<String> requestedPropertyIds) {
        HashMap<Long, Resource> resourceMap = new HashMap<Long, Resource>();
        List<RequestEntity> requests = s_requestDAO.findByPks(requestIds, true);
        ArrayList<RequestEntity> topologyRequestEntities = new ArrayList<RequestEntity>();
        Collection<LogicalRequest> topologyRequests = topologyManager.getRequests(requestIds);
        for (id.onyx.obdp.server.actionmanager.Request request : topologyRequests) {
            topologyRequestEntities.add(request.constructNewPersistenceEntity());
        }
        if (requests.isEmpty()) {
            requests = new ArrayList<RequestEntity>();
        }
        requests.addAll(topologyRequestEntities);
        for (RequestEntity requestEntity : requests) {
            if ((null != clusterId || null != requestEntity.getClusterId() && -1L != requestEntity.getClusterId()) && (null == clusterId || null == requestEntity.getRequestId() || !requestEntity.getClusterId().equals(clusterId))) continue;
            Resource r = this.getRequestResource(requestEntity, clusterName, requestedPropertyIds);
            resourceMap.put(requestEntity.getRequestId(), r);
        }
        return resourceMap.values();
    }

    private Resource getRequestResource(RequestEntity entity, String clusterName, Set<String> requestedPropertyIds) {
        CalculatedStatus status;
        ResourceImpl resource = new ResourceImpl(Resource.Type.Request);
        if (null != clusterName) {
            RequestResourceProvider.setResourceProperty(resource, REQUEST_CLUSTER_NAME_PROPERTY_ID, clusterName, requestedPropertyIds);
        } else if (null != entity.getClusterId() && -1L != entity.getClusterId()) {
            RequestResourceProvider.setResourceProperty(resource, REQUEST_CLUSTER_ID_PROPERTY_ID, entity.getClusterId(), requestedPropertyIds);
        }
        RequestResourceProvider.setResourceProperty(resource, REQUEST_ID_PROPERTY_ID, entity.getRequestId(), requestedPropertyIds);
        Object requestContext = entity.getRequestContext();
        RequestResourceProvider.setResourceProperty(resource, REQUEST_CONTEXT_ID, requestContext, requestedPropertyIds);
        RequestResourceProvider.setResourceProperty(resource, REQUEST_TYPE_ID, (Object)entity.getRequestType(), requestedPropertyIds);
        if (RequestResourceProvider.isPropertyRequested(REQUEST_INPUTS_ID, requestedPropertyIds)) {
            String value = entity.getInputs();
            if (!StringUtils.isBlank((String)value)) {
                value = SecretReference.maskPasswordInPropertyMap(value);
            }
            resource.setProperty(REQUEST_INPUTS_ID, value);
        }
        if (RequestResourceProvider.isPropertyRequested(REQUEST_CLUSTER_HOST_INFO_ID, requestedPropertyIds)) {
            resource.setProperty(REQUEST_CLUSTER_HOST_INFO_ID, entity.getClusterHostInfo());
        }
        RequestResourceProvider.setResourceProperty(resource, REQUEST_RESOURCE_FILTER_ID, id.onyx.obdp.server.actionmanager.Request.filtersFromEntity(entity), requestedPropertyIds);
        RequestOperationLevel operationLevel = id.onyx.obdp.server.actionmanager.Request.operationLevelFromEntity(entity);
        String opLevelStr = null;
        if (operationLevel != null) {
            opLevelStr = RequestOperationLevel.getExternalLevelName(operationLevel.getLevel().toString());
        }
        RequestResourceProvider.setResourceProperty(resource, REQUEST_OPERATION_LEVEL_ID, opLevelStr, requestedPropertyIds);
        RequestResourceProvider.setResourceProperty(resource, REQUEST_CREATE_TIME_ID, entity.getCreateTime(), requestedPropertyIds);
        RequestResourceProvider.setResourceProperty(resource, REQUEST_START_TIME_ID, entity.getStartTime(), requestedPropertyIds);
        RequestResourceProvider.setResourceProperty(resource, REQUEST_END_TIME_ID, entity.getEndTime(), requestedPropertyIds);
        RequestResourceProvider.setResourceProperty(resource, REQUEST_EXCLUSIVE_ID, entity.isExclusive(), requestedPropertyIds);
        if (entity.getRequestScheduleId() != null) {
            RequestResourceProvider.setResourceProperty(resource, REQUEST_SOURCE_SCHEDULE_ID, entity.getRequestScheduleId(), requestedPropertyIds);
        } else {
            RequestResourceProvider.setResourceProperty(resource, REQUEST_SOURCE_SCHEDULE, null, requestedPropertyIds);
        }
        Map<Long, HostRoleCommandStatusSummaryDTO> summary = s_hostRoleCommandDAO.findAggregateCounts(entity.getRequestId());
        summary.putAll(topologyManager.getStageSummaries(entity.getRequestId()));
        LogicalRequest logicalRequest = topologyManager.getRequest(entity.getRequestId());
        if (summary.isEmpty() && null != logicalRequest) {
            Optional<String> failureReason;
            status = logicalRequest.calculateStatus();
            if (status == CalculatedStatus.ABORTED && (failureReason = logicalRequest.getFailureReason()).isPresent()) {
                requestContext = (String)requestContext + "\nFAILED: " + (String)failureReason.get();
                RequestResourceProvider.setResourceProperty(resource, REQUEST_CONTEXT_ID, requestContext, requestedPropertyIds);
            }
        } else {
            status = CalculatedStatus.statusFromStageSummary(summary, summary.keySet());
        }
        if (null != logicalRequest) {
            RequestResourceProvider.setResourceProperty(resource, REQUEST_PENDING_HOST_REQUEST_COUNT_ID, logicalRequest.getPendingHostRequestCount(), requestedPropertyIds);
        }
        RequestResourceProvider.setResourceProperty(resource, REQUEST_STATUS_PROPERTY_ID, status.getStatus().toString(), requestedPropertyIds);
        RequestResourceProvider.setResourceProperty(resource, REQUEST_PROGRESS_PERCENT_ID, status.getPercent(), requestedPropertyIds);
        int taskCount = 0;
        for (HostRoleCommandStatusSummaryDTO dto : summary.values()) {
            taskCount += dto.getTaskTotal();
        }
        Map<HostRoleStatus, Integer> hostRoleStatusCounters = CalculatedStatus.calculateTaskStatusCounts(summary, summary.keySet());
        RequestResourceProvider.setResourceProperty(resource, REQUEST_TASK_CNT_ID, taskCount, requestedPropertyIds);
        RequestResourceProvider.setResourceProperty(resource, REQUEST_FAILED_TASK_CNT_ID, hostRoleStatusCounters.get((Object)HostRoleStatus.FAILED), requestedPropertyIds);
        RequestResourceProvider.setResourceProperty(resource, REQUEST_ABORTED_TASK_CNT_ID, hostRoleStatusCounters.get((Object)HostRoleStatus.ABORTED), requestedPropertyIds);
        RequestResourceProvider.setResourceProperty(resource, REQUEST_TIMED_OUT_TASK_CNT_ID, hostRoleStatusCounters.get((Object)HostRoleStatus.TIMEDOUT), requestedPropertyIds);
        RequestResourceProvider.setResourceProperty(resource, REQUEST_QUEUED_TASK_CNT_ID, hostRoleStatusCounters.get((Object)HostRoleStatus.QUEUED), requestedPropertyIds);
        RequestResourceProvider.setResourceProperty(resource, REQUEST_COMPLETED_TASK_CNT_ID, hostRoleStatusCounters.get((Object)HostRoleStatus.COMPLETED), requestedPropertyIds);
        RequestResourceProvider.setResourceProperty(resource, REQUEST_USER_NAME, entity.getUserName(), requestedPropertyIds);
        return resource;
    }

    static {
        PK_PROPERTY_IDS = ImmutableSet.of((Object)REQUEST_ID_PROPERTY_ID);
        keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.Request, (Object)REQUEST_ID_PROPERTY_ID).put((Object)Resource.Type.Cluster, (Object)REQUEST_CLUSTER_NAME_PROPERTY_ID).build();
        PROPERTY_IDS = Sets.newHashSet((Object[])new String[]{REQUEST_ID_PROPERTY_ID, REQUEST_CLUSTER_NAME_PROPERTY_ID, REQUEST_CLUSTER_ID_PROPERTY_ID, REQUEST_STATUS_PROPERTY_ID, REQUEST_ABORT_REASON_PROPERTY_ID, REQUEST_CONTEXT_ID, REQUEST_SOURCE_SCHEDULE, REQUEST_SOURCE_SCHEDULE_ID, REQUEST_SOURCE_SCHEDULE_HREF, REQUEST_TYPE_ID, REQUEST_INPUTS_ID, REQUEST_RESOURCE_FILTER_ID, REQUEST_OPERATION_LEVEL_ID, REQUEST_CREATE_TIME_ID, REQUEST_START_TIME_ID, REQUEST_END_TIME_ID, REQUEST_EXCLUSIVE_ID, REQUEST_TASK_CNT_ID, REQUEST_FAILED_TASK_CNT_ID, REQUEST_ABORTED_TASK_CNT_ID, REQUEST_TIMED_OUT_TASK_CNT_ID, REQUEST_COMPLETED_TASK_CNT_ID, REQUEST_QUEUED_TASK_CNT_ID, REQUEST_PROGRESS_PERCENT_ID, REQUEST_REMOVE_PENDING_HOST_REQUESTS_ID, REQUEST_PENDING_HOST_REQUEST_COUNT_ID, REQUEST_CLUSTER_HOST_INFO_ID, REQUEST_USER_NAME});
    }

    class ServiceComponentTuple {
        final String serviceName;
        final String componentName;

        ServiceComponentTuple(String serviceName, String componentName) {
            this.serviceName = serviceName;
            this.componentName = componentName;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public String getComponentName() {
            return this.componentName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ServiceComponentTuple that = (ServiceComponentTuple)o;
            if (this.serviceName != null ? !this.serviceName.equals(that.serviceName) : that.serviceName != null) {
                return false;
            }
            return !(this.componentName == null ? that.componentName != null : !this.componentName.equals(that.componentName));
        }

        public int hashCode() {
            int result = this.serviceName != null ? this.serviceName.hashCode() : 0;
            result = 31 * result + (this.componentName != null ? this.componentName.hashCode() : 0);
            return result;
        }
    }
}

