/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import id.onyx.obdp.server.controller.spi.Resource;
import java.util.Map;

public class RequestOperationLevel {
    private static final String[][] LEVEL_ALIASES = new String[][]{{"CLUSTER", "Cluster"}, {"SERVICE", "Service"}, {"HOST", "Host"}, {"HOST_COMPONENT", "HostComponent"}};
    private static final int ALIAS_COLUMN = 0;
    private static final int INTERNAL_NAME_COLUMN = 1;
    public static final String OPERATION_LEVEL_ID = "operation_level/level";
    public static final String OPERATION_CLUSTER_ID = "operation_level/cluster_name";
    public static final String OPERATION_SERVICE_ID = "operation_level/service_name";
    public static final String OPERATION_HOSTCOMPONENT_ID = "operation_level/hostcomponent_name";
    public static final String OPERATION_HOST_NAME = "operation_level/host_name";
    private Resource.Type level;
    private String clusterName;
    private String serviceName;
    private String hostComponentName;
    private String hostName;

    public static String getInternalLevelName(String external) throws IllegalArgumentException {
        String refinedAlias = external.trim().toUpperCase();
        for (String[] pair : LEVEL_ALIASES) {
            if (!pair[0].equals(refinedAlias)) continue;
            return pair[1];
        }
        String message = String.format("Unknown operation level %s", external);
        throw new IllegalArgumentException(message);
    }

    public static String getExternalLevelName(String internal) {
        for (String[] pair : LEVEL_ALIASES) {
            if (!pair[1].equals(internal)) continue;
            return pair[0];
        }
        String message = String.format("Unknown internal operation level name %s", internal);
        throw new IllegalArgumentException(message);
    }

    public RequestOperationLevel(Resource.Type level, String clusterName, String serviceName, String hostComponentName, String hostName) {
        this.level = level;
        this.clusterName = clusterName;
        this.serviceName = serviceName;
        this.hostComponentName = hostComponentName;
        this.hostName = hostName;
    }

    public RequestOperationLevel(Map<String, String> requestInfoProperties) throws IllegalArgumentException {
        String operationLevelStr = requestInfoProperties.get(OPERATION_LEVEL_ID);
        try {
            String internalOpLevelNameStr = RequestOperationLevel.getInternalLevelName(operationLevelStr);
            this.level = Resource.Type.valueOf(internalOpLevelNameStr);
        }
        catch (IllegalArgumentException e) {
            String message = String.format("Wrong operation level value: %s", operationLevelStr);
            throw new IllegalArgumentException(message, e);
        }
        if (!requestInfoProperties.containsKey(OPERATION_CLUSTER_ID)) {
            String message = String.format("Mandatory key %s for operation level is not specified", OPERATION_CLUSTER_ID);
            throw new IllegalArgumentException(message);
        }
        this.clusterName = requestInfoProperties.get(OPERATION_CLUSTER_ID);
        this.serviceName = requestInfoProperties.get(OPERATION_SERVICE_ID);
        this.hostComponentName = requestInfoProperties.get(OPERATION_HOSTCOMPONENT_ID);
        this.hostName = requestInfoProperties.get(OPERATION_HOST_NAME);
    }

    public Resource.Type getLevel() {
        return this.level;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getHostComponentName() {
        return this.hostComponentName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String toString() {
        return "RequestOperationLevel{level=" + this.level + ", clusterName='" + this.clusterName + "', serviceName='" + this.serviceName + "', hostComponentName='" + this.hostComponentName + "', hostName='" + this.hostName + "'}";
    }

    public static Map<String, String> propertiesFor(Resource.Type type, String clusterName) {
        return ImmutableMap.of((Object)OPERATION_LEVEL_ID, (Object)RequestOperationLevel.getExternalLevelName(type.name()), (Object)OPERATION_CLUSTER_ID, (Object)clusterName);
    }
}

