/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import id.onyx.obdp.server.controller.spi.PageRequest;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.SortRequest;
import id.onyx.obdp.server.controller.spi.TemporalInfo;
import java.util.Map;
import java.util.Set;

public class RequestImpl
implements Request {
    private final Set<String> propertyIds;
    private final Set<Map<String, Object>> properties;
    private final Map<String, String> requestInfoProperties;
    private final Map<String, TemporalInfo> m_mapTemporalInfo;
    private final PageRequest m_pageRequest;
    private final SortRequest m_sortRequest;
    private final boolean dryRun;

    public RequestImpl(Set<String> propertyIds, Set<Map<String, Object>> properties, Map<String, String> requestInfoProperties, Map<String, TemporalInfo> mapTemporalInfo) {
        this(propertyIds, properties, requestInfoProperties, mapTemporalInfo, null, null);
    }

    public RequestImpl(Set<String> propertyIds, Set<Map<String, Object>> properties, Map<String, String> requestInfoProperties, Map<String, TemporalInfo> mapTemporalInfo, SortRequest sortRequest, PageRequest pageRequest) {
        this.propertyIds = propertyIds == null ? ImmutableSet.of() : ImmutableSet.copyOf(propertyIds);
        this.properties = properties == null ? ImmutableSet.of() : ImmutableSet.copyOf(properties);
        this.requestInfoProperties = requestInfoProperties == null ? ImmutableMap.of() : ImmutableMap.copyOf(requestInfoProperties);
        this.m_mapTemporalInfo = mapTemporalInfo;
        this.m_sortRequest = sortRequest;
        this.m_pageRequest = pageRequest;
        this.dryRun = this.requestInfoProperties.containsKey("dry_run") && Boolean.parseBoolean(this.requestInfoProperties.get("dry_run"));
    }

    @Override
    public Set<String> getPropertyIds() {
        return this.propertyIds;
    }

    @Override
    public Set<Map<String, Object>> getProperties() {
        return this.properties;
    }

    @Override
    public Map<String, String> getRequestInfoProperties() {
        return this.requestInfoProperties;
    }

    @Override
    public TemporalInfo getTemporalInfo(String id) {
        return this.m_mapTemporalInfo == null ? null : this.m_mapTemporalInfo.get(id);
    }

    @Override
    public PageRequest getPageRequest() {
        return this.m_pageRequest;
    }

    @Override
    public SortRequest getSortRequest() {
        return this.m_sortRequest;
    }

    @Override
    public boolean isDryRunRequest() {
        return this.dryRun;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestImpl request = (RequestImpl)o;
        return !(this.properties != null ? !this.properties.equals(request.properties) : request.properties != null) && !(this.propertyIds != null ? !this.propertyIds.equals(request.propertyIds) : request.propertyIds != null);
    }

    public int hashCode() {
        int result = this.propertyIds != null ? this.propertyIds.hashCode() : 0;
        result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Request:, propertyIds=[");
        for (String string : this.propertyIds) {
            sb.append(" { propertyName=").append(string).append(" }, ");
        }
        sb.append(" ], properties=[ ");
        for (Map map : this.properties) {
            for (Map.Entry entry : map.entrySet()) {
                sb.append(" { propertyName=").append((String)entry.getKey()).append(", propertyValue=").append(entry.getValue() == null ? "NULL" : entry.getValue().toString()).append(" }, ");
            }
        }
        sb.append(" ], temporalInfo=[");
        if (this.m_mapTemporalInfo == null) {
            sb.append("null");
        } else {
            for (Map.Entry entry : this.m_mapTemporalInfo.entrySet()) {
                sb.append(" { propertyName=").append((String)entry.getKey()).append(", temporalInfo=").append(entry.getValue() == null ? "NULL" : ((TemporalInfo)entry.getValue()).toString());
            }
        }
        sb.append(" ]");
        return sb.toString();
    }
}

