/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.DuplicateResourceException;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.ObjectNotFoundException;
import id.onyx.obdp.server.api.resources.OperatingSystemResourceDefinition;
import id.onyx.obdp.server.api.resources.RepositoryResourceDefinition;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.controller.internal.AbstractAuthorizedResourceProvider;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.orm.dao.HostVersionDAO;
import id.onyx.obdp.server.orm.dao.RepositoryVersionDAO;
import id.onyx.obdp.server.orm.dao.StackDAO;
import id.onyx.obdp.server.orm.entities.HostVersionEntity;
import id.onyx.obdp.server.orm.entities.RepoDefinitionEntity;
import id.onyx.obdp.server.orm.entities.RepoOsEntity;
import id.onyx.obdp.server.orm.entities.RepositoryVersionEntity;
import id.onyx.obdp.server.orm.entities.StackEntity;
import id.onyx.obdp.server.security.authorization.AuthorizationException;
import id.onyx.obdp.server.security.authorization.AuthorizationHelper;
import id.onyx.obdp.server.security.authorization.ResourceType;
import id.onyx.obdp.server.security.authorization.RoleAuthorization;
import id.onyx.obdp.server.stack.upgrade.RepositoryVersionHelper;
import id.onyx.obdp.server.state.OperatingSystemInfo;
import id.onyx.obdp.server.state.RepositoryVersionState;
import id.onyx.obdp.server.state.ServiceInfo;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.StackInfo;
import id.onyx.obdp.server.state.repository.ManifestServiceInfo;
import id.onyx.obdp.server.state.repository.VersionDefinitionXml;
import id.onyx.obdp.server.utils.URLCredentialsHider;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;

public class RepositoryVersionResourceProvider
extends AbstractAuthorizedResourceProvider {
    public static final String REPOSITORY_VERSION = "RepositoryVersions";
    public static final String REPOSITORY_VERSION_ID_PROPERTY_ID = PropertyHelper.getPropertyId("RepositoryVersions", "id");
    public static final String REPOSITORY_VERSION_STACK_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("RepositoryVersions", "stack_name");
    public static final String REPOSITORY_VERSION_STACK_VERSION_PROPERTY_ID = PropertyHelper.getPropertyId("RepositoryVersions", "stack_version");
    public static final String REPOSITORY_VERSION_REPOSITORY_VERSION_PROPERTY_ID = PropertyHelper.getPropertyId("RepositoryVersions", "repository_version");
    public static final String REPOSITORY_VERSION_DISPLAY_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("RepositoryVersions", "display_name");
    public static final String REPOSITORY_VERSION_HIDDEN_PROPERTY_ID = PropertyHelper.getPropertyId("RepositoryVersions", "hidden");
    public static final String REPOSITORY_VERSION_RESOLVED_PROPERTY_ID = PropertyHelper.getPropertyId("RepositoryVersions", "resolved");
    public static final String SUBRESOURCE_OPERATING_SYSTEMS_PROPERTY_ID = new OperatingSystemResourceDefinition().getPluralName();
    public static final String SUBRESOURCE_REPOSITORIES_PROPERTY_ID = new RepositoryResourceDefinition().getPluralName();
    public static final String REPOSITORY_VERSION_TYPE_PROPERTY_ID = "RepositoryVersions/type";
    public static final String REPOSITORY_VERSION_RELEASE_VERSION = "RepositoryVersions/release/version";
    public static final String REPOSITORY_VERSION_RELEASE_BUILD = "RepositoryVersions/release/build";
    public static final String REPOSITORY_VERSION_RELEASE_NOTES = "RepositoryVersions/release/notes";
    public static final String REPOSITORY_VERSION_RELEASE_COMPATIBLE_WITH = "RepositoryVersions/release/compatible_with";
    public static final String REPOSITORY_VERSION_AVAILABLE_SERVICES = "RepositoryVersions/services";
    public static final String REPOSITORY_VERSION_STACK_SERVICES = "RepositoryVersions/stack_services";
    public static final String REPOSITORY_VERSION_PARENT_ID = "RepositoryVersions/parent_id";
    public static final String REPOSITORY_VERSION_HAS_CHILDREN = "RepositoryVersions/has_children";
    private static final Set<String> pkPropertyIds = ImmutableSet.of((Object)REPOSITORY_VERSION_ID_PROPERTY_ID);
    public static final Set<String> propertyIds = ImmutableSet.of((Object)REPOSITORY_VERSION_ID_PROPERTY_ID, (Object)REPOSITORY_VERSION_REPOSITORY_VERSION_PROPERTY_ID, (Object)REPOSITORY_VERSION_DISPLAY_NAME_PROPERTY_ID, (Object)REPOSITORY_VERSION_HIDDEN_PROPERTY_ID, (Object)REPOSITORY_VERSION_STACK_NAME_PROPERTY_ID, (Object)REPOSITORY_VERSION_STACK_VERSION_PROPERTY_ID, (Object[])new String[]{SUBRESOURCE_OPERATING_SYSTEMS_PROPERTY_ID, "RepositoryVersions/type", "RepositoryVersions/release/build", "RepositoryVersions/release/compatible_with", "RepositoryVersions/release/notes", "RepositoryVersions/release/version", "RepositoryVersions/parent_id", "RepositoryVersions/has_children", "RepositoryVersions/services", "RepositoryVersions/stack_services", REPOSITORY_VERSION_RESOLVED_PROPERTY_ID});
    public static final Map<Resource.Type, String> keyPropertyIds = new ImmutableMap.Builder().put((Object)Resource.Type.Stack, (Object)REPOSITORY_VERSION_STACK_NAME_PROPERTY_ID).put((Object)Resource.Type.StackVersion, (Object)REPOSITORY_VERSION_STACK_VERSION_PROPERTY_ID).put((Object)Resource.Type.RepositoryVersion, (Object)REPOSITORY_VERSION_ID_PROPERTY_ID).build();
    @Inject
    private Gson gson;
    @Inject
    private RepositoryVersionDAO repositoryVersionDAO;
    @Inject
    private OBDPMetaInfo obdpMetaInfo;
    @Inject
    private RepositoryVersionHelper repositoryVersionHelper;
    @Inject
    private StackDAO stackDAO;
    @Inject
    HostVersionDAO hostVersionDAO;

    public RepositoryVersionResourceProvider() {
        super(Resource.Type.RepositoryVersion, propertyIds, keyPropertyIds);
        this.setRequiredCreateAuthorizations(EnumSet.of(RoleAuthorization.OBDP_MANAGE_STACK_VERSIONS));
        this.setRequiredDeleteAuthorizations(EnumSet.of(RoleAuthorization.OBDP_MANAGE_STACK_VERSIONS));
        this.setRequiredUpdateAuthorizations(EnumSet.of(RoleAuthorization.OBDP_MANAGE_STACK_VERSIONS, RoleAuthorization.OBDP_EDIT_STACK_REPOS));
        this.setRequiredGetAuthorizations(EnumSet.of(RoleAuthorization.OBDP_MANAGE_STACK_VERSIONS, RoleAuthorization.OBDP_EDIT_STACK_REPOS, RoleAuthorization.CLUSTER_VIEW_STACK_DETAILS, RoleAuthorization.CLUSTER_UPGRADE_DOWNGRADE_STACK));
    }

    @Override
    protected RequestStatus createResourcesAuthorized(final Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        for (final Map<String, Object> properties : request.getProperties()) {
            this.createResources(new AbstractResourceProvider.Command<Void>(){

                @Override
                public Void invoke() throws OBDPException {
                    String[] requiredProperties;
                    for (String propertyName : requiredProperties = new String[]{REPOSITORY_VERSION_DISPLAY_NAME_PROPERTY_ID, SUBRESOURCE_OPERATING_SYSTEMS_PROPERTY_ID, REPOSITORY_VERSION_STACK_NAME_PROPERTY_ID, REPOSITORY_VERSION_STACK_VERSION_PROPERTY_ID, REPOSITORY_VERSION_REPOSITORY_VERSION_PROPERTY_ID}) {
                        if (properties.get(propertyName) != null) continue;
                        throw new OBDPException("Property " + propertyName + " should be provided");
                    }
                    RepositoryVersionEntity entity = RepositoryVersionResourceProvider.this.toRepositoryVersionEntity(properties);
                    if (RepositoryVersionResourceProvider.this.repositoryVersionDAO.findByDisplayName(entity.getDisplayName()) != null) {
                        throw new DuplicateResourceException("Repository version with name " + entity.getDisplayName() + " already exists");
                    }
                    if (RepositoryVersionResourceProvider.this.repositoryVersionDAO.findByStackAndVersion(entity.getStack(), entity.getVersion()) != null) {
                        throw new DuplicateResourceException("Repository version for stack " + entity.getStack() + " and version " + entity.getVersion() + " already exists");
                    }
                    RepositoryVersionResourceProvider.validateRepositoryVersion(RepositoryVersionResourceProvider.this.repositoryVersionDAO, RepositoryVersionResourceProvider.this.obdpMetaInfo, entity);
                    RepositoryVersionResourceProvider.this.repositoryVersionDAO.create(entity);
                    RepositoryVersionResourceProvider.this.notifyCreate(Resource.Type.RepositoryVersion, request);
                    return null;
                }
            });
        }
        return this.getRequestStatus(null);
    }

    @Override
    protected Set<Resource> getResourcesAuthorized(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        HashSet<Resource> resources = new HashSet<Resource>();
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        Set<Map<String, Object>> propertyMaps = this.getPropertyMaps(predicate);
        ArrayList<RepositoryVersionEntity> requestedEntities = new ArrayList<RepositoryVersionEntity>();
        for (Map<String, Object> propertyMap : propertyMaps) {
            Long id;
            StackId stackId = this.getStackInformationFromUrl(propertyMap);
            if (stackId != null && propertyMaps.size() == 1 && propertyMap.get(REPOSITORY_VERSION_ID_PROPERTY_ID) == null) {
                requestedEntities.addAll(this.repositoryVersionDAO.findByStack(stackId));
                continue;
            }
            try {
                id = Long.parseLong(propertyMap.get(REPOSITORY_VERSION_ID_PROPERTY_ID).toString());
            }
            catch (Exception ex) {
                throw new SystemException("Repository version should have numerical id");
            }
            RepositoryVersionEntity entity = (RepositoryVersionEntity)this.repositoryVersionDAO.findByPK(id);
            if (entity == null) {
                throw new NoSuchResourceException("There is no repository version with id " + id);
            }
            requestedEntities.add(entity);
        }
        for (RepositoryVersionEntity entity : requestedEntities) {
            List<ManifestServiceInfo> stackServices;
            StackInfo stack;
            VersionDefinitionXml xml;
            ResourceImpl resource = new ResourceImpl(Resource.Type.RepositoryVersion);
            RepositoryVersionResourceProvider.setResourceProperty(resource, REPOSITORY_VERSION_ID_PROPERTY_ID, entity.getId(), requestedIds);
            RepositoryVersionResourceProvider.setResourceProperty(resource, REPOSITORY_VERSION_STACK_NAME_PROPERTY_ID, entity.getStackName(), requestedIds);
            RepositoryVersionResourceProvider.setResourceProperty(resource, REPOSITORY_VERSION_STACK_VERSION_PROPERTY_ID, entity.getStackVersion(), requestedIds);
            RepositoryVersionResourceProvider.setResourceProperty(resource, REPOSITORY_VERSION_DISPLAY_NAME_PROPERTY_ID, entity.getDisplayName(), requestedIds);
            RepositoryVersionResourceProvider.setResourceProperty(resource, REPOSITORY_VERSION_HIDDEN_PROPERTY_ID, entity.isHidden(), requestedIds);
            RepositoryVersionResourceProvider.setResourceProperty(resource, REPOSITORY_VERSION_REPOSITORY_VERSION_PROPERTY_ID, entity.getVersion(), requestedIds);
            RepositoryVersionResourceProvider.setResourceProperty(resource, REPOSITORY_VERSION_TYPE_PROPERTY_ID, entity.getType(), requestedIds);
            RepositoryVersionResourceProvider.setResourceProperty(resource, REPOSITORY_VERSION_RESOLVED_PROPERTY_ID, entity.isResolved(), requestedIds);
            RepositoryVersionResourceProvider.setResourceProperty(resource, REPOSITORY_VERSION_PARENT_ID, entity.getParentId(), requestedIds);
            List<RepositoryVersionEntity> children = entity.getChildren();
            RepositoryVersionResourceProvider.setResourceProperty(resource, REPOSITORY_VERSION_HAS_CHILDREN, null != children && !children.isEmpty(), requestedIds);
            try {
                xml = entity.getRepositoryXml();
            }
            catch (Exception e) {
                throw new SystemException(String.format("Could not load xml for Repository %s", entity.getId()), e);
            }
            try {
                stack = this.obdpMetaInfo.getStack(entity.getStackName(), entity.getStackVersion());
            }
            catch (OBDPException e) {
                throw new SystemException(String.format("Could not load stack %s for Repository %s", entity.getStackId().toString(), entity.getId()));
            }
            if (null != xml) {
                RepositoryVersionResourceProvider.setResourceProperty(resource, REPOSITORY_VERSION_RELEASE_VERSION, xml.release.version, requestedIds);
                RepositoryVersionResourceProvider.setResourceProperty(resource, REPOSITORY_VERSION_RELEASE_BUILD, xml.release.build, requestedIds);
                RepositoryVersionResourceProvider.setResourceProperty(resource, REPOSITORY_VERSION_RELEASE_COMPATIBLE_WITH, xml.release.compatibleWith, requestedIds);
                RepositoryVersionResourceProvider.setResourceProperty(resource, REPOSITORY_VERSION_RELEASE_NOTES, xml.release.releaseNotes, requestedIds);
                RepositoryVersionResourceProvider.setResourceProperty(resource, REPOSITORY_VERSION_AVAILABLE_SERVICES, xml.getAvailableServices(stack), requestedIds);
                stackServices = xml.getStackServices(stack);
            } else {
                stackServices = new ArrayList<ManifestServiceInfo>();
                for (ServiceInfo si : stack.getServices()) {
                    stackServices.add(new ManifestServiceInfo(si.getName(), si.getDisplayName(), si.getComment(), Collections.singleton(si.getVersion())));
                }
            }
            RepositoryVersionResourceProvider.setResourceProperty(resource, REPOSITORY_VERSION_STACK_SERVICES, stackServices, requestedIds);
            resources.add(resource);
        }
        return resources;
    }

    @Override
    @Transactional
    protected RequestStatus updateResourcesAuthorized(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        final Set<Map<String, Object>> propertyMaps = request.getProperties();
        this.modifyResources(new AbstractResourceProvider.Command<Void>(){

            @Override
            public Void invoke() throws OBDPException, AuthorizationException {
                for (Map propertyMap : propertyMaps) {
                    Long id;
                    try {
                        id = Long.parseLong(propertyMap.get(REPOSITORY_VERSION_ID_PROPERTY_ID).toString());
                    }
                    catch (Exception ex) {
                        throw new OBDPException("Repository version should have numerical id");
                    }
                    RepositoryVersionEntity entity = (RepositoryVersionEntity)RepositoryVersionResourceProvider.this.repositoryVersionDAO.findByPK(id);
                    if (entity == null) {
                        throw new ObjectNotFoundException("There is no repository version with id " + id);
                    }
                    if (StringUtils.isNotBlank((String)ObjectUtils.toString(propertyMap.get(SUBRESOURCE_OPERATING_SYSTEMS_PROPERTY_ID)))) {
                        if (!AuthorizationHelper.isAuthorized(ResourceType.OBDP, null, RoleAuthorization.OBDP_EDIT_STACK_REPOS)) {
                            throw new AuthorizationException("The authenticated user does not have authorization to modify stack repositories");
                        }
                        Object operatingSystems = propertyMap.get(SUBRESOURCE_OPERATING_SYSTEMS_PROPERTY_ID);
                        String operatingSystemsJson = RepositoryVersionResourceProvider.this.gson.toJson(operatingSystems);
                        try {
                            entity.addRepoOsEntities(RepositoryVersionResourceProvider.this.repositoryVersionHelper.parseOperatingSystems(operatingSystemsJson));
                        }
                        catch (Exception ex) {
                            throw new OBDPException("Json structure for operating systems is incorrect", (Throwable)ex);
                        }
                    }
                    if (StringUtils.isNotBlank((String)ObjectUtils.toString(propertyMap.get(REPOSITORY_VERSION_DISPLAY_NAME_PROPERTY_ID)))) {
                        entity.setDisplayName(propertyMap.get(REPOSITORY_VERSION_DISPLAY_NAME_PROPERTY_ID).toString());
                    }
                    if (StringUtils.isNotBlank((String)ObjectUtils.toString(propertyMap.get(REPOSITORY_VERSION_HIDDEN_PROPERTY_ID)))) {
                        boolean isHidden = Boolean.valueOf(ObjectUtils.toString(propertyMap.get(REPOSITORY_VERSION_HIDDEN_PROPERTY_ID)));
                        entity.setHidden(isHidden);
                    }
                    RepositoryVersionResourceProvider.validateRepositoryVersion(RepositoryVersionResourceProvider.this.repositoryVersionDAO, RepositoryVersionResourceProvider.this.obdpMetaInfo, entity);
                    RepositoryVersionResourceProvider.this.repositoryVersionDAO.merge(entity);
                }
                return null;
            }
        });
        return this.getRequestStatus(null);
    }

    @Override
    protected RequestStatus deleteResourcesAuthorized(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        Set<Map<String, Object>> propertyMaps = this.getPropertyMaps(predicate);
        ArrayList<RepositoryVersionEntity> entitiesToBeRemoved = new ArrayList<RepositoryVersionEntity>();
        for (Map<String, Object> propertyMap : propertyMaps) {
            Long id;
            try {
                id = Long.parseLong(propertyMap.get(REPOSITORY_VERSION_ID_PROPERTY_ID).toString());
            }
            catch (Exception ex) {
                throw new SystemException("Repository version should have numerical id");
            }
            RepositoryVersionEntity entity = (RepositoryVersionEntity)this.repositoryVersionDAO.findByPK(id);
            if (entity == null) {
                throw new NoSuchResourceException("There is no repository version with id " + id);
            }
            HashSet forbiddenToDeleteStates = Sets.newHashSet((Object[])new RepositoryVersionState[]{RepositoryVersionState.CURRENT, RepositoryVersionState.INSTALLED, RepositoryVersionState.INSTALLING});
            List<HostVersionEntity> hostVersions = this.hostVersionDAO.findByRepositoryAndStates(entity, forbiddenToDeleteStates);
            if (CollectionUtils.isNotEmpty(hostVersions)) {
                HashMap hostsInUse = new HashMap();
                for (HostVersionEntity hostVersion : hostVersions) {
                    if (!hostsInUse.containsKey((Object)hostVersion.getState())) {
                        hostsInUse.put(hostVersion.getState(), new HashSet());
                    }
                    ((Set)hostsInUse.get((Object)hostVersion.getState())).add(hostVersion.getHostName());
                }
                HashSet<String> errors = new HashSet<String>();
                for (Map.Entry entry : hostsInUse.entrySet()) {
                    errors.add(String.format("%s on %s", entry.getKey(), StringUtils.join((Collection)((Collection)entry.getValue()), (String)", ")));
                }
                throw new SystemException(String.format("Repository version can't be deleted as it is used by the following hosts: %s", StringUtils.join(errors, (char)';')));
            }
            entitiesToBeRemoved.add(entity);
        }
        for (RepositoryVersionEntity entity : entitiesToBeRemoved) {
            this.repositoryVersionDAO.remove(entity);
        }
        return this.getRequestStatus(null);
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return pkPropertyIds;
    }

    protected static void validateRepositoryVersion(RepositoryVersionDAO dao, OBDPMetaInfo metaInfo, RepositoryVersionEntity repositoryVersion) throws OBDPException {
        RepositoryVersionResourceProvider.validateRepositoryVersion(dao, metaInfo, repositoryVersion, false);
    }

    protected static void validateRepositoryVersion(RepositoryVersionDAO dao, OBDPMetaInfo metaInfo, RepositoryVersionEntity repositoryVersion, boolean skipUrlCheck) throws OBDPException {
        StackId requiredStack = new StackId(repositoryVersion.getStack());
        String requiredStackName = requiredStack.getStackName();
        String requiredStackVersion = requiredStack.getStackVersion();
        String requiredStackId = requiredStack.getStackId();
        HashSet<String> existingRepoUrls = new HashSet<String>();
        List<RepositoryVersionEntity> existingRepoVersions = dao.findByStack(requiredStack);
        for (RepositoryVersionEntity repositoryVersionEntity : existingRepoVersions) {
            for (RepoOsEntity repoOsEntity : repositoryVersionEntity.getRepoOsEntities()) {
                for (RepoDefinitionEntity repositoryEntity : repoOsEntity.getRepoDefinitionEntities()) {
                    if (!repositoryEntity.isUnique() || repositoryVersionEntity.getId().equals(repositoryVersion.getId())) continue;
                    existingRepoUrls.add(repositoryEntity.getBaseUrl());
                }
            }
        }
        HashSet<String> osSupported = new HashSet<String>();
        for (OperatingSystemInfo osInfo : metaInfo.getOperatingSystems(requiredStackName, requiredStackVersion)) {
            osSupported.add(osInfo.getOsType());
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (RepoOsEntity repoOsEntity : repositoryVersion.getRepoOsEntities()) {
            hashSet.add(repoOsEntity.getFamily());
            for (RepoDefinitionEntity repositoryEntity : repoOsEntity.getRepoDefinitionEntities()) {
                String baseUrl = repositoryEntity.getBaseUrl();
                if (skipUrlCheck || !repoOsEntity.isAmbariManaged() || !existingRepoUrls.contains(baseUrl)) continue;
                throw new DuplicateResourceException("Base url " + URLCredentialsHider.hideCredentials(baseUrl) + " is already defined for another repository version. Setting up base urls that contain the same versions of components will cause stack upgrade to fail.");
            }
        }
        if (hashSet.isEmpty()) {
            throw new OBDPException("At least one set of repositories for OS should be provided");
        }
        for (String string : hashSet) {
            if (osSupported.contains(string)) continue;
            throw new OBDPException("Operating system type " + string + " is not supported by stack " + requiredStackId);
        }
        if (!RepositoryVersionEntity.isVersionInStack(repositoryVersion.getStackId(), repositoryVersion.getVersion())) {
            throw new OBDPException(MessageFormat.format("Version {0} needs to belong to stack {1}", repositoryVersion.getVersion(), repositoryVersion.getStackName() + "-" + repositoryVersion.getStackVersion()));
        }
    }

    protected RepositoryVersionEntity toRepositoryVersionEntity(Map<String, Object> properties) throws OBDPException {
        RepositoryVersionEntity entity = new RepositoryVersionEntity();
        String stackName = properties.get(REPOSITORY_VERSION_STACK_NAME_PROPERTY_ID).toString();
        String stackVersion = properties.get(REPOSITORY_VERSION_STACK_VERSION_PROPERTY_ID).toString();
        StackEntity stackEntity = this.stackDAO.find(stackName, stackVersion);
        entity.setDisplayName(properties.get(REPOSITORY_VERSION_DISPLAY_NAME_PROPERTY_ID).toString());
        entity.setStack(stackEntity);
        entity.setVersion(properties.get(REPOSITORY_VERSION_REPOSITORY_VERSION_PROPERTY_ID).toString());
        Object operatingSystems = properties.get(SUBRESOURCE_OPERATING_SYSTEMS_PROPERTY_ID);
        String operatingSystemsJson = this.gson.toJson(operatingSystems);
        try {
            entity.addRepoOsEntities(this.repositoryVersionHelper.parseOperatingSystems(operatingSystemsJson));
        }
        catch (Exception ex) {
            throw new OBDPException("Json structure for operating systems is incorrect", (Throwable)ex);
        }
        return entity;
    }

    protected StackId getStackInformationFromUrl(Map<String, Object> propertyMap) {
        if (propertyMap.containsKey(REPOSITORY_VERSION_STACK_NAME_PROPERTY_ID) && propertyMap.containsKey(REPOSITORY_VERSION_STACK_VERSION_PROPERTY_ID)) {
            return new StackId(propertyMap.get(REPOSITORY_VERSION_STACK_NAME_PROPERTY_ID).toString(), propertyMap.get(REPOSITORY_VERSION_STACK_VERSION_PROPERTY_ID).toString());
        }
        return null;
    }

    @Override
    protected ResourceType getResourceType(Request request, Predicate predicate) {
        return null;
    }
}

