/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.RepositoryRequest;
import id.onyx.obdp.server.controller.RepositoryResponse;
import id.onyx.obdp.server.controller.internal.AbstractControllerResourceProvider;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.utils.URLCredentialsHider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.BooleanUtils;

public class RepositoryResourceProvider
extends AbstractControllerResourceProvider {
    public static final String REPOSITORY_REPO_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("Repositories", "repo_name");
    public static final String REPOSITORY_STACK_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("Repositories", "stack_name");
    public static final String REPOSITORY_STACK_VERSION_PROPERTY_ID = PropertyHelper.getPropertyId("Repositories", "stack_version");
    public static final String REPOSITORY_CLUSTER_STACK_VERSION_PROPERTY_ID = PropertyHelper.getPropertyId("Repositories", "cluster_version_id");
    public static final String REPOSITORY_OS_TYPE_PROPERTY_ID = PropertyHelper.getPropertyId("Repositories", "os_type");
    public static final String REPOSITORY_BASE_URL_PROPERTY_ID = PropertyHelper.getPropertyId("Repositories", "base_url");
    public static final String REPOSITORY_DISTRIBUTION_PROPERTY_ID = PropertyHelper.getPropertyId("Repositories", "distribution");
    public static final String REPOSITORY_COMPONENTS_PROPERTY_ID = PropertyHelper.getPropertyId("Repositories", "components");
    public static final String REPOSITORY_REPO_ID_PROPERTY_ID = PropertyHelper.getPropertyId("Repositories", "repo_id");
    public static final String REPOSITORY_MIRRORS_LIST_PROPERTY_ID = PropertyHelper.getPropertyId("Repositories", "mirrors_list");
    public static final String REPOSITORY_DEFAULT_BASE_URL_PROPERTY_ID = PropertyHelper.getPropertyId("Repositories", "default_base_url");
    public static final String REPOSITORY_VERIFY_BASE_URL_PROPERTY_ID = PropertyHelper.getPropertyId("Repositories", "verify_base_url");
    public static final String REPOSITORY_REPOSITORY_VERSION_ID_PROPERTY_ID = PropertyHelper.getPropertyId("Repositories", "repository_version_id");
    public static final String REPOSITORY_VERSION_DEFINITION_ID_PROPERTY_ID = PropertyHelper.getPropertyId("Repositories", "version_definition_id");
    public static final String REPOSITORY_UNIQUE_PROPERTY_ID = PropertyHelper.getPropertyId("Repositories", "unique");
    public static final String REPOSITORY_TAGS_PROPERTY_ID = PropertyHelper.getPropertyId("Repositories", "tags");
    public static final String REPOSITORY_APPLICABLE_SERVICES_PROPERTY_ID = PropertyHelper.getPropertyId("Repositories", "applicable_services");
    private static final Set<String> pkPropertyIds = ImmutableSet.builder().add((Object)REPOSITORY_STACK_NAME_PROPERTY_ID).add((Object)REPOSITORY_STACK_VERSION_PROPERTY_ID).add((Object)REPOSITORY_OS_TYPE_PROPERTY_ID).add((Object)REPOSITORY_REPO_ID_PROPERTY_ID).build();
    public static final Set<String> propertyIds = ImmutableSet.builder().add((Object)REPOSITORY_REPO_NAME_PROPERTY_ID).add((Object)REPOSITORY_DISTRIBUTION_PROPERTY_ID).add((Object)REPOSITORY_COMPONENTS_PROPERTY_ID).add((Object)REPOSITORY_STACK_NAME_PROPERTY_ID).add((Object)REPOSITORY_STACK_VERSION_PROPERTY_ID).add((Object)REPOSITORY_OS_TYPE_PROPERTY_ID).add((Object)REPOSITORY_BASE_URL_PROPERTY_ID).add((Object)REPOSITORY_REPO_ID_PROPERTY_ID).add((Object)REPOSITORY_MIRRORS_LIST_PROPERTY_ID).add((Object)REPOSITORY_DEFAULT_BASE_URL_PROPERTY_ID).add((Object)REPOSITORY_VERIFY_BASE_URL_PROPERTY_ID).add((Object)REPOSITORY_REPOSITORY_VERSION_ID_PROPERTY_ID).add((Object)REPOSITORY_VERSION_DEFINITION_ID_PROPERTY_ID).add((Object)REPOSITORY_CLUSTER_STACK_VERSION_PROPERTY_ID).add((Object)REPOSITORY_UNIQUE_PROPERTY_ID).add((Object)REPOSITORY_TAGS_PROPERTY_ID).add((Object)REPOSITORY_APPLICABLE_SERVICES_PROPERTY_ID).build();
    public static final Map<Resource.Type, String> keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.Stack, (Object)REPOSITORY_STACK_NAME_PROPERTY_ID).put((Object)Resource.Type.StackVersion, (Object)REPOSITORY_STACK_VERSION_PROPERTY_ID).put((Object)Resource.Type.ClusterStackVersion, (Object)REPOSITORY_CLUSTER_STACK_VERSION_PROPERTY_ID).put((Object)Resource.Type.OperatingSystem, (Object)REPOSITORY_OS_TYPE_PROPERTY_ID).put((Object)Resource.Type.Repository, (Object)REPOSITORY_REPO_ID_PROPERTY_ID).put((Object)Resource.Type.RepositoryVersion, (Object)REPOSITORY_REPOSITORY_VERSION_ID_PROPERTY_ID).put((Object)Resource.Type.VersionDefinition, (Object)REPOSITORY_VERSION_DEFINITION_ID_PROPERTY_ID).build();

    public RepositoryResourceProvider(OBDPManagementController managementController) {
        super(Resource.Type.Repository, propertyIds, keyPropertyIds, managementController);
    }

    @Override
    public RequestStatus updateResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        HashSet<RepositoryRequest> requestsToVerifyBaseURLs = new HashSet<RepositoryRequest>();
        Iterator<Map<String, Object>> iterator = request.getProperties().iterator();
        if (iterator.hasNext()) {
            for (Map<String, Object> propertyMap : this.getPropertyMaps(iterator.next(), predicate)) {
                RepositoryRequest rr = this.getRequest(propertyMap);
                if (!rr.isVerifyBaseUrl()) continue;
                requestsToVerifyBaseURLs.add(rr);
            }
        }
        try {
            this.getManagementController().verifyRepositories(requestsToVerifyBaseURLs);
        }
        catch (OBDPException e) {
            throw new SystemException("", e);
        }
        return this.getRequestStatus(null);
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        final HashSet<RepositoryRequest> requests = new HashSet<RepositoryRequest>();
        if (predicate == null) {
            requests.add(this.getRequest(Collections.emptyMap()));
        } else {
            for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
                requests.add(this.getRequest(propertyMap));
            }
        }
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        Set<RepositoryResponse> responses = this.getResources(new AbstractResourceProvider.Command<Set<RepositoryResponse>>(){

            @Override
            public Set<RepositoryResponse> invoke() throws OBDPException {
                return RepositoryResourceProvider.this.getManagementController().getRepositories(requests);
            }
        });
        HashSet<Resource> resources = new HashSet<Resource>();
        for (RepositoryResponse response : responses) {
            ResourceImpl resource = new ResourceImpl(Resource.Type.Repository);
            RepositoryResourceProvider.setResourceProperty(resource, REPOSITORY_STACK_NAME_PROPERTY_ID, response.getStackName(), requestedIds);
            RepositoryResourceProvider.setResourceProperty(resource, REPOSITORY_STACK_VERSION_PROPERTY_ID, response.getStackVersion(), requestedIds);
            RepositoryResourceProvider.setResourceProperty(resource, REPOSITORY_REPO_NAME_PROPERTY_ID, response.getRepoName(), requestedIds);
            RepositoryResourceProvider.setResourceProperty(resource, REPOSITORY_DISTRIBUTION_PROPERTY_ID, response.getDistribution(), requestedIds);
            RepositoryResourceProvider.setResourceProperty(resource, REPOSITORY_COMPONENTS_PROPERTY_ID, response.getComponents(), requestedIds);
            RepositoryResourceProvider.setResourceProperty(resource, REPOSITORY_BASE_URL_PROPERTY_ID, URLCredentialsHider.hideCredentials(response.getBaseUrl()), requestedIds);
            RepositoryResourceProvider.setResourceProperty(resource, REPOSITORY_OS_TYPE_PROPERTY_ID, response.getOsType(), requestedIds);
            RepositoryResourceProvider.setResourceProperty(resource, REPOSITORY_REPO_ID_PROPERTY_ID, response.getRepoId(), requestedIds);
            RepositoryResourceProvider.setResourceProperty(resource, REPOSITORY_MIRRORS_LIST_PROPERTY_ID, response.getMirrorsList(), requestedIds);
            RepositoryResourceProvider.setResourceProperty(resource, REPOSITORY_DEFAULT_BASE_URL_PROPERTY_ID, URLCredentialsHider.hideCredentials(response.getDefaultBaseUrl()), requestedIds);
            RepositoryResourceProvider.setResourceProperty(resource, REPOSITORY_UNIQUE_PROPERTY_ID, response.isUnique(), requestedIds);
            RepositoryResourceProvider.setResourceProperty(resource, REPOSITORY_TAGS_PROPERTY_ID, response.getTags(), requestedIds);
            RepositoryResourceProvider.setResourceProperty(resource, REPOSITORY_APPLICABLE_SERVICES_PROPERTY_ID, response.getApplicableServices(), requestedIds);
            if (null != response.getClusterVersionId()) {
                RepositoryResourceProvider.setResourceProperty(resource, REPOSITORY_CLUSTER_STACK_VERSION_PROPERTY_ID, response.getClusterVersionId(), requestedIds);
            }
            if (null != response.getRepositoryVersionId()) {
                RepositoryResourceProvider.setResourceProperty(resource, REPOSITORY_REPOSITORY_VERSION_ID_PROPERTY_ID, response.getRepositoryVersionId(), requestedIds);
            }
            if (null != response.getVersionDefinitionId()) {
                RepositoryResourceProvider.setResourceProperty(resource, REPOSITORY_VERSION_DEFINITION_ID_PROPERTY_ID, response.getVersionDefinitionId(), requestedIds);
            }
            resources.add(resource);
        }
        return resources;
    }

    @Override
    public RequestStatus createResources(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        String validateOnlyProperty = request.getRequestInfoProperties().get("validate_only");
        if (BooleanUtils.toBoolean((String)validateOnlyProperty)) {
            final HashSet<RepositoryRequest> requests = new HashSet<RepositoryRequest>();
            Iterator<Map<String, Object>> iterator = request.getProperties().iterator();
            if (iterator.hasNext()) {
                for (Map<String, Object> propertyMap : request.getProperties()) {
                    requests.add(this.getRequest(propertyMap));
                }
            }
            this.createResources(new AbstractResourceProvider.Command<Void>(){

                @Override
                public Void invoke() throws OBDPException {
                    RepositoryResourceProvider.this.getManagementController().verifyRepositories(requests);
                    return null;
                }
            });
            return this.getRequestStatus(null);
        }
        throw new SystemException("Cannot create repositories.", null);
    }

    @Override
    public RequestStatus deleteResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new SystemException("Cannot delete repositories.", null);
    }

    private RepositoryRequest getRequest(Map<String, Object> properties) {
        RepositoryRequest request = new RepositoryRequest((String)properties.get(REPOSITORY_STACK_NAME_PROPERTY_ID), (String)properties.get(REPOSITORY_STACK_VERSION_PROPERTY_ID), (String)properties.get(REPOSITORY_OS_TYPE_PROPERTY_ID), (String)properties.get(REPOSITORY_REPO_ID_PROPERTY_ID), (String)properties.get(REPOSITORY_REPO_NAME_PROPERTY_ID));
        if (properties.containsKey(REPOSITORY_REPOSITORY_VERSION_ID_PROPERTY_ID)) {
            request.setRepositoryVersionId(Long.parseLong(properties.get(REPOSITORY_REPOSITORY_VERSION_ID_PROPERTY_ID).toString()));
        }
        if (properties.containsKey(REPOSITORY_VERSION_DEFINITION_ID_PROPERTY_ID)) {
            request.setVersionDefinitionId(properties.get(REPOSITORY_VERSION_DEFINITION_ID_PROPERTY_ID).toString());
        }
        if (properties.containsKey(REPOSITORY_CLUSTER_STACK_VERSION_PROPERTY_ID)) {
            request.setClusterVersionId(Long.parseLong(properties.get(REPOSITORY_CLUSTER_STACK_VERSION_PROPERTY_ID).toString()));
        }
        if (properties.containsKey(REPOSITORY_BASE_URL_PROPERTY_ID)) {
            request.setBaseUrl((String)properties.get(REPOSITORY_BASE_URL_PROPERTY_ID));
            if (properties.containsKey(REPOSITORY_VERIFY_BASE_URL_PROPERTY_ID)) {
                request.setVerifyBaseUrl("true".equalsIgnoreCase(properties.get(REPOSITORY_VERIFY_BASE_URL_PROPERTY_ID).toString()));
            }
        }
        if (properties.containsKey(REPOSITORY_MIRRORS_LIST_PROPERTY_ID)) {
            request.setMirrorsList((String)properties.get(REPOSITORY_MIRRORS_LIST_PROPERTY_ID));
        }
        return request;
    }

    @Override
    public Set<String> getPKPropertyIds() {
        return pkPropertyIds;
    }
}

