/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import id.onyx.obdp.server.DuplicateResourceException;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.StaticallyInject;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.controller.internal.AbstractAuthorizedResourceProvider;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.predicate.EqualsPredicate;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.orm.dao.RemoteOBDPClusterDAO;
import id.onyx.obdp.server.orm.entities.RemoteOBDPClusterEntity;
import id.onyx.obdp.server.orm.entities.RemoteOBDPClusterServiceEntity;
import id.onyx.obdp.server.security.authorization.RoleAuthorization;
import id.onyx.obdp.server.view.RemoteOBDPClusterRegistry;
import id.onyx.obdp.view.MaskException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StaticallyInject
public class RemoteClusterResourceProvider
extends AbstractAuthorizedResourceProvider {
    public static final String CLUSTER_NAME_PROPERTY_ID = "ClusterInfo/name";
    public static final String CLUSTER_ID_PROPERTY_ID = "ClusterInfo/cluster_id";
    public static final String CLUSTER_URL_PROPERTY_ID = "ClusterInfo/url";
    public static final String USERNAME_PROPERTY_ID = "ClusterInfo/username";
    public static final String PASSWORD_PROPERTY_ID = "ClusterInfo/password";
    public static final String SERVICES_PROPERTY_ID = "ClusterInfo/services";
    private static final Logger LOG = LoggerFactory.getLogger(RemoteClusterResourceProvider.class);
    private static final Map<Resource.Type, String> keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.RemoteCluster, (Object)"ClusterInfo/name").build();
    private static final Set<String> propertyIds = Sets.newHashSet((Object[])new String[]{"ClusterInfo/name", "ClusterInfo/cluster_id", "ClusterInfo/url", "ClusterInfo/username", "ClusterInfo/password", "ClusterInfo/services"});
    @Inject
    private static RemoteOBDPClusterDAO remoteOBDPClusterDAO;
    @Inject
    private static Configuration configuration;
    @Inject
    private static RemoteOBDPClusterRegistry remoteOBDPClusterRegistry;

    protected RemoteClusterResourceProvider() {
        super(Resource.Type.RemoteCluster, propertyIds, keyPropertyIds);
        EnumSet<RoleAuthorization> requiredAuthorizations = EnumSet.of(RoleAuthorization.OBDP_ADD_DELETE_CLUSTERS);
        this.setRequiredCreateAuthorizations(requiredAuthorizations);
        this.setRequiredDeleteAuthorizations(requiredAuthorizations);
        this.setRequiredUpdateAuthorizations(requiredAuthorizations);
    }

    @Override
    public Map<Resource.Type, String> getKeyPropertyIds() {
        return keyPropertyIds;
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return new HashSet<String>(keyPropertyIds.values());
    }

    @Override
    public RequestStatus createResourcesAuthorized(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        for (Map<String, Object> properties : request.getProperties()) {
            this.createResources(this.getCreateCommand(properties));
        }
        this.notifyCreate(Resource.Type.RemoteCluster, request);
        return this.getRequestStatus(null);
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        HashSet<Resource> resources = new HashSet<Resource>();
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        Set<Map<String, Object>> propertyMaps = this.getPropertyMaps(predicate);
        if (propertyMaps.isEmpty()) {
            propertyMaps.add(Collections.emptyMap());
        }
        for (Map<String, Object> propertyMap : propertyMaps) {
            String clusterName = (String)propertyMap.get(CLUSTER_NAME_PROPERTY_ID);
            if (!Strings.isNullOrEmpty((String)clusterName)) {
                RemoteOBDPClusterEntity cluster = remoteOBDPClusterDAO.findByName(clusterName);
                if (cluster == null) {
                    throw new NoSuchResourceException(String.format("Cluster with name %s cannot be found", clusterName));
                }
                resources.add(this.toResource(requestedIds, cluster));
                continue;
            }
            for (RemoteOBDPClusterEntity cluster : remoteOBDPClusterDAO.findAll()) {
                Resource resource = this.toResource(requestedIds, cluster);
                resources.add(resource);
            }
        }
        return resources;
    }

    protected Resource toResource(Set<String> requestedIds, RemoteOBDPClusterEntity cluster) {
        ResourceImpl resource = new ResourceImpl(Resource.Type.RemoteCluster);
        RemoteClusterResourceProvider.setResourceProperty(resource, CLUSTER_NAME_PROPERTY_ID, cluster.getName(), requestedIds);
        RemoteClusterResourceProvider.setResourceProperty(resource, CLUSTER_ID_PROPERTY_ID, cluster.getId(), requestedIds);
        RemoteClusterResourceProvider.setResourceProperty(resource, CLUSTER_URL_PROPERTY_ID, cluster.getUrl(), requestedIds);
        RemoteClusterResourceProvider.setResourceProperty(resource, USERNAME_PROPERTY_ID, cluster.getUsername(), requestedIds);
        ArrayList<String> services = new ArrayList<String>();
        for (RemoteOBDPClusterServiceEntity remoteClusterServiceEntity : cluster.getServices()) {
            services.add(remoteClusterServiceEntity.getServiceName());
        }
        RemoteClusterResourceProvider.setResourceProperty(resource, SERVICES_PROPERTY_ID, services, requestedIds);
        return resource;
    }

    @Override
    public RequestStatus updateResourcesAuthorized(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        Iterator<Map<String, Object>> iterator = request.getProperties().iterator();
        if (iterator.hasNext()) {
            for (Map<String, Object> propertyMap : this.getPropertyMaps(iterator.next(), predicate)) {
                this.modifyResources(this.getUpdateCommand(propertyMap));
            }
        }
        this.notifyUpdate(Resource.Type.RemoteCluster, request, predicate);
        return this.getRequestStatus(null);
    }

    @Override
    protected RequestStatus deleteResourcesAuthorized(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        this.modifyResources(this.getDeleteCommand(predicate));
        this.notifyDelete(Resource.Type.ViewInstance, predicate);
        return this.getRequestStatus(null);
    }

    private AbstractResourceProvider.Command<Void> getCreateCommand(final Map<String, Object> properties) {
        return new AbstractResourceProvider.Command<Void>(){

            @Override
            public Void invoke() throws OBDPException {
                String name = (String)properties.get(RemoteClusterResourceProvider.CLUSTER_NAME_PROPERTY_ID);
                if (StringUtils.isEmpty((String)name)) {
                    throw new IllegalArgumentException("Cluster Name cannot ne null or Empty");
                }
                if (remoteOBDPClusterDAO.findByName(name) != null) {
                    throw new DuplicateResourceException(String.format("Remote cluster with name %s already exists", name));
                }
                RemoteClusterResourceProvider.this.saveOrUpdateRemoteAmbariClusterEntity(properties, false);
                return null;
            }
        };
    }

    private AbstractResourceProvider.Command<Void> getUpdateCommand(final Map<String, Object> properties) {
        return new AbstractResourceProvider.Command<Void>(){

            @Override
            public Void invoke() throws OBDPException {
                String name = (String)properties.get(RemoteClusterResourceProvider.CLUSTER_NAME_PROPERTY_ID);
                if (StringUtils.isEmpty((String)name)) {
                    throw new IllegalArgumentException("Cluster Name cannot be null or Empty");
                }
                String id = (String)properties.get(RemoteClusterResourceProvider.CLUSTER_ID_PROPERTY_ID);
                if (StringUtils.isEmpty((String)id)) {
                    throw new IllegalArgumentException("Cluster Id cannot be null or Empty");
                }
                RemoteClusterResourceProvider.this.saveOrUpdateRemoteAmbariClusterEntity(properties, true);
                return null;
            }
        };
    }

    private void saveOrUpdateRemoteAmbariClusterEntity(Map<String, Object> properties, boolean update) throws OBDPException {
        RemoteOBDPClusterEntity entity;
        String name = (String)properties.get(CLUSTER_NAME_PROPERTY_ID);
        String url = (String)properties.get(CLUSTER_URL_PROPERTY_ID);
        String username = (String)properties.get(USERNAME_PROPERTY_ID);
        String password = (String)properties.get(PASSWORD_PROPERTY_ID);
        if (StringUtils.isEmpty((String)url) && StringUtils.isEmpty((String)username)) {
            throw new IllegalArgumentException("Url or username cannot be null");
        }
        if (update) {
            Long id = Long.valueOf((String)properties.get(CLUSTER_ID_PROPERTY_ID));
            entity = remoteOBDPClusterDAO.findById(id);
            if (entity == null) {
                throw new IllegalArgumentException(String.format("Cannot find cluster with Id : \"%s\"", id));
            }
        } else {
            entity = remoteOBDPClusterDAO.findByName(name);
            if (entity != null) {
                throw new DuplicateResourceException(String.format("Cluster with name : \"%s\" already exists", name));
            }
        }
        if (StringUtils.isBlank((String)password) && !update) {
            throw new IllegalArgumentException("Password cannot be null");
        }
        if (StringUtils.isBlank((String)password) && update && !username.equals(entity.getUsername())) {
            throw new IllegalArgumentException("Failed to update. Username does not match.");
        }
        if (entity == null) {
            entity = new RemoteOBDPClusterEntity();
        }
        entity.setName(name);
        entity.setUrl(url);
        try {
            if (password != null) {
                entity.setUsername(username);
                entity.setPassword(password);
            }
        }
        catch (MaskException e) {
            throw new IllegalArgumentException("Failed to create new Remote Cluster " + name + ". Illegal Password");
        }
        try {
            remoteOBDPClusterRegistry.saveOrUpdate(entity, update);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to create new Remote Cluster " + name + ". " + e.getMessage(), e);
        }
    }

    private AbstractResourceProvider.Command<Void> getDeleteCommand(final Predicate predicate) {
        return new AbstractResourceProvider.Command<Void>(){

            @Override
            public Void invoke() throws OBDPException {
                Comparable deletedCluster = ((EqualsPredicate)predicate).getValue();
                String toDelete = deletedCluster.toString();
                RemoteOBDPClusterEntity clusterEntity = remoteOBDPClusterDAO.findByName(toDelete);
                if (clusterEntity == null) {
                    throw new IllegalArgumentException("The Cluster " + toDelete + " does not exist");
                }
                remoteOBDPClusterRegistry.delete(clusterEntity);
                return null;
            }
        };
    }
}

