/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.api.services.stackadvisor.StackAdvisorException;
import id.onyx.obdp.server.api.services.stackadvisor.StackAdvisorRequest;
import id.onyx.obdp.server.api.services.stackadvisor.StackAdvisorRequestException;
import id.onyx.obdp.server.api.services.stackadvisor.recommendations.RecommendationResponse;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.BaseProvider;
import id.onyx.obdp.server.controller.internal.RequestStatusImpl;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.internal.StackAdvisorResourceProvider;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecommendationResourceProvider
extends StackAdvisorResourceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(RecommendationResourceProvider.class);
    protected static final String RECOMMENDATION_ID_PROPERTY_ID = PropertyHelper.getPropertyId("Recommendation", "id");
    protected static final String CLUSTER_ID_PROPERTY_ID = "clusterId";
    protected static final String SERVICE_NAME_PROPERTY_ID = "serviceName";
    protected static final String AUTO_COMPLETE_PROPERTY_ID = "autoComplete";
    protected static final String CONFIGS_RESPONSE_PROPERTY_ID = "configsResponse";
    protected static final String HOSTS_PROPERTY_ID = "hosts";
    protected static final String SERVICES_PROPERTY_ID = "services";
    protected static final String RECOMMEND_PROPERTY_ID = "recommend";
    protected static final String RECOMMENDATIONS_PROPERTY_ID = "recommendations";
    protected static final String CONFIG_GROUPS_PROPERTY_ID = PropertyHelper.getPropertyId("recommendations", "config-groups");
    protected static final String BLUEPRINT_PROPERTY_ID = PropertyHelper.getPropertyId("recommendations", "blueprint");
    protected static final String BLUEPRINT_CONFIGURATIONS_PROPERTY_ID = PropertyHelper.getPropertyId("recommendations/blueprint", "configurations");
    protected static final String BLUEPRINT_HOST_GROUPS_PROPERTY_ID = PropertyHelper.getPropertyId("recommendations/blueprint", "host_groups");
    protected static final String BLUEPRINT_HOST_GROUPS_NAME_PROPERTY_ID = "name";
    protected static final String BLUEPRINT_HOST_GROUPS_COMPONENTS_PROPERTY_ID = "components";
    protected static final String BINDING_HOST_GROUPS_PROPERTY_ID = PropertyHelper.getPropertyId("recommendations/blueprint_cluster_binding", "host_groups");
    protected static final String BINDING_HOST_GROUPS_NAME_PROPERTY_ID = "name";
    protected static final String BINDING_HOST_GROUPS_HOSTS_PROPERTY_ID = "hosts";
    protected static final String CHANGED_CONFIGURATIONS_PROPERTY_ID = "changed_configurations";
    protected static final String BINDING_PROPERTY_ID = PropertyHelper.getPropertyId("recommendations", "blueprint_cluster_binding");
    protected static final String USER_CONTEXT_PROPERTY_ID = "user_context";
    protected static final String USER_CONTEXT_OPERATION_PROPERTY_ID = PropertyHelper.getPropertyId("user_context", "operation");
    protected static final String USER_CONTEXT_OPERATION_DETAILS_PROPERTY_ID = PropertyHelper.getPropertyId("user_context", "operation_details");
    private static final Map<Resource.Type, String> keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.Recommendation, (Object)RECOMMENDATION_ID_PROPERTY_ID).put((Object)Resource.Type.Stack, (Object)STACK_NAME_PROPERTY_ID).put((Object)Resource.Type.StackVersion, (Object)STACK_VERSION_PROPERTY_ID).build();
    private static final Set<String> propertyIds = Sets.newHashSet((Object[])new String[]{RECOMMENDATION_ID_PROPERTY_ID, STACK_NAME_PROPERTY_ID, STACK_VERSION_PROPERTY_ID, "recommend", "clusterId", "serviceName", "autoComplete", "configsResponse", "hosts", "services", CONFIG_GROUPS_PROPERTY_ID, "changed_configurations", "user_context", USER_CONTEXT_OPERATION_PROPERTY_ID, USER_CONTEXT_OPERATION_DETAILS_PROPERTY_ID, "recommendations", BLUEPRINT_PROPERTY_ID, BLUEPRINT_CONFIGURATIONS_PROPERTY_ID, BLUEPRINT_HOST_GROUPS_PROPERTY_ID, PropertyHelper.getPropertyId(BLUEPRINT_HOST_GROUPS_PROPERTY_ID, "name"), PropertyHelper.getPropertyId(BLUEPRINT_HOST_GROUPS_PROPERTY_ID, "components"), BINDING_PROPERTY_ID, BINDING_HOST_GROUPS_PROPERTY_ID, PropertyHelper.getPropertyId(BINDING_HOST_GROUPS_PROPERTY_ID, "name"), PropertyHelper.getPropertyId(BINDING_HOST_GROUPS_PROPERTY_ID, "hosts"), "name", "hosts"});

    protected RecommendationResourceProvider(OBDPManagementController managementController) {
        super(Resource.Type.Recommendation, propertyIds, keyPropertyIds, managementController);
    }

    @Override
    protected String getRequestTypePropertyId() {
        return RECOMMEND_PROPERTY_ID;
    }

    @Override
    public RequestStatus createResources(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        RecommendationResponse response;
        final StackAdvisorRequest recommendationRequest = this.prepareStackAdvisorRequest(request);
        try {
            response = saHelper.recommend(recommendationRequest);
        }
        catch (StackAdvisorRequestException e) {
            LOG.warn("Error occured during recommendation", (Throwable)e);
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (OBDPException | StackAdvisorException e) {
            LOG.warn("Error occured during recommendation", e);
            throw new SystemException(e.getMessage(), e);
        }
        Resource recommendation = this.createResources(new AbstractResourceProvider.Command<Resource>(){

            @Override
            public Resource invoke() throws OBDPException {
                ResourceImpl resource = new ResourceImpl(Resource.Type.Recommendation);
                if (!recommendationRequest.getConfigsResponse().booleanValue()) {
                    BaseProvider.setResourceProperty(resource, RECOMMENDATION_ID_PROPERTY_ID, response.getId(), RecommendationResourceProvider.this.getPropertyIds());
                    BaseProvider.setResourceProperty(resource, StackAdvisorResourceProvider.STACK_NAME_PROPERTY_ID, response.getVersion().getStackName(), RecommendationResourceProvider.this.getPropertyIds());
                    BaseProvider.setResourceProperty(resource, StackAdvisorResourceProvider.STACK_VERSION_PROPERTY_ID, response.getVersion().getStackVersion(), RecommendationResourceProvider.this.getPropertyIds());
                    BaseProvider.setResourceProperty(resource, "hosts", response.getHosts(), RecommendationResourceProvider.this.getPropertyIds());
                    BaseProvider.setResourceProperty(resource, RecommendationResourceProvider.SERVICES_PROPERTY_ID, response.getServices(), RecommendationResourceProvider.this.getPropertyIds());
                }
                BaseProvider.setResourceProperty(resource, CONFIG_GROUPS_PROPERTY_ID, response.getRecommendations().getConfigGroups(), RecommendationResourceProvider.this.getPropertyIds());
                BaseProvider.setResourceProperty(resource, BLUEPRINT_CONFIGURATIONS_PROPERTY_ID, response.getRecommendations().getBlueprint().getConfigurations(), RecommendationResourceProvider.this.getPropertyIds());
                if (!recommendationRequest.getConfigsResponse().booleanValue()) {
                    Set<RecommendationResponse.HostGroup> hostGroups = response.getRecommendations().getBlueprint().getHostGroups();
                    ArrayList listGroupProps = new ArrayList();
                    for (RecommendationResponse.HostGroup hostGroup : hostGroups) {
                        HashMap<String, Object> mapGroupProps = new HashMap<String, Object>();
                        mapGroupProps.put("name", hostGroup.getName());
                        mapGroupProps.put(RecommendationResourceProvider.BLUEPRINT_HOST_GROUPS_COMPONENTS_PROPERTY_ID, hostGroup.getComponents());
                        listGroupProps.add(mapGroupProps);
                    }
                    BaseProvider.setResourceProperty(resource, BLUEPRINT_HOST_GROUPS_PROPERTY_ID, listGroupProps, RecommendationResourceProvider.this.getPropertyIds());
                    Set<RecommendationResponse.BindingHostGroup> bindingHostGroups = response.getRecommendations().getBlueprintClusterBinding().getHostGroups();
                    ArrayList listBindingGroupProps = new ArrayList();
                    for (RecommendationResponse.BindingHostGroup hostGroup : bindingHostGroups) {
                        HashMap<String, Object> mapGroupProps = new HashMap<String, Object>();
                        mapGroupProps.put("name", hostGroup.getName());
                        mapGroupProps.put("hosts", hostGroup.getHosts());
                        listBindingGroupProps.add(mapGroupProps);
                    }
                    BaseProvider.setResourceProperty(resource, BINDING_HOST_GROUPS_PROPERTY_ID, listBindingGroupProps, RecommendationResourceProvider.this.getPropertyIds());
                }
                return resource;
            }
        });
        this.notifyCreate(Resource.Type.Recommendation, request);
        HashSet<Resource> resources = new HashSet<Resource>(Arrays.asList(recommendation));
        return new RequestStatusImpl(null, resources);
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return new HashSet<String>(keyPropertyIds.values());
    }
}

