/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.internal.AbstractControllerResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.state.QuickLinksConfigurationInfo;
import id.onyx.obdp.server.state.ServiceInfo;
import id.onyx.obdp.server.state.StackInfo;
import id.onyx.obdp.server.state.quicklinks.Link;
import id.onyx.obdp.server.state.quicklinks.QuickLinks;
import id.onyx.obdp.server.state.quicklinksprofile.QuickLinkVisibilityController;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuickLinkArtifactResourceProvider
extends AbstractControllerResourceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(QuickLinkArtifactResourceProvider.class);
    public static final String STACK_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("QuickLinkInfo", "stack_name");
    public static final String STACK_VERSION_PROPERTY_ID = PropertyHelper.getPropertyId("QuickLinkInfo", "stack_version");
    public static final String STACK_SERVICE_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("QuickLinkInfo", "service_name");
    public static final String QUICKLINK_DEFAULT_PROPERTY_ID = PropertyHelper.getPropertyId("QuickLinkInfo", "default");
    public static final String QUICKLINK_FILE_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("QuickLinkInfo", "file_name");
    public static final String QUICKLINK_DATA_PROPERTY_ID = PropertyHelper.getPropertyId("QuickLinkInfo", "quicklink_data");
    public static final Set<String> pkPropertyIds = ImmutableSet.builder().add((Object)QUICKLINK_FILE_NAME_PROPERTY_ID).build();
    public static final Map<Resource.Type, String> keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.QuickLink, (Object)QUICKLINK_FILE_NAME_PROPERTY_ID).put((Object)Resource.Type.Stack, (Object)STACK_NAME_PROPERTY_ID).put((Object)Resource.Type.StackVersion, (Object)STACK_VERSION_PROPERTY_ID).put((Object)Resource.Type.StackService, (Object)STACK_SERVICE_NAME_PROPERTY_ID).build();
    public static final Set<String> propertyIds = ImmutableSet.builder().add((Object)STACK_NAME_PROPERTY_ID).add((Object)STACK_VERSION_PROPERTY_ID).add((Object)STACK_SERVICE_NAME_PROPERTY_ID).add((Object)QUICKLINK_FILE_NAME_PROPERTY_ID).add((Object)QUICKLINK_DATA_PROPERTY_ID).add((Object)QUICKLINK_DEFAULT_PROPERTY_ID).build();

    protected QuickLinkArtifactResourceProvider(OBDPManagementController managementController) {
        super(Resource.Type.QuickLink, propertyIds, keyPropertyIds, managementController);
    }

    @Override
    public RequestStatus createResources(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        throw new UnsupportedOperationException("Creating of quick links is not supported");
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        LinkedHashSet<Resource> resources = new LinkedHashSet<Resource>();
        resources.addAll(this.getQuickLinks(request, predicate));
        if (resources.isEmpty()) {
            throw new NoSuchResourceException("The requested resource doesn't exist: QuickLink not found, " + predicate);
        }
        return resources;
    }

    @Override
    public RequestStatus updateResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new UnsupportedOperationException("Updating of quick links is not supported");
    }

    @Override
    public RequestStatus deleteResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new UnsupportedOperationException("Deleting of quick links is not supported");
    }

    private Set<Resource> getQuickLinks(Request request, Predicate predicate) throws NoSuchParentResourceException, NoSuchResourceException, UnsupportedPropertyException, SystemException {
        LinkedHashSet<Resource> resources = new LinkedHashSet<Resource>();
        for (Map<String, Object> properties : this.getPropertyMaps(predicate)) {
            StackInfo stackInfo;
            String quickLinksFileName = (String)properties.get(QUICKLINK_FILE_NAME_PROPERTY_ID);
            String stackName = (String)properties.get(STACK_NAME_PROPERTY_ID);
            String stackVersion = (String)properties.get(STACK_VERSION_PROPERTY_ID);
            String stackService = (String)properties.get(STACK_SERVICE_NAME_PROPERTY_ID);
            try {
                stackInfo = this.getManagementController().getAmbariMetaInfo().getStack(stackName, stackVersion);
            }
            catch (OBDPException e) {
                throw new NoSuchParentResourceException(String.format("Parent stack resource doesn't exist: stackName='%s', stackVersion='%s'", stackName, stackVersion));
            }
            ArrayList<ServiceInfo> serviceInfoList = new ArrayList<ServiceInfo>();
            if (stackService == null) {
                serviceInfoList.addAll(stackInfo.getServices());
            } else {
                ServiceInfo service = stackInfo.getService(stackService);
                if (service == null) {
                    throw new NoSuchParentResourceException(String.format("Parent stack/service resource doesn't exist: stackName='%s', stackVersion='%s', serviceName='%s'", stackName, stackVersion, stackService));
                }
                serviceInfoList.add(service);
            }
            for (ServiceInfo serviceInfo : serviceInfoList) {
                ArrayList<QuickLinksConfigurationInfo> serviceQuickLinks = new ArrayList<QuickLinksConfigurationInfo>();
                if (quickLinksFileName != null) {
                    LOG.debug("Getting quick links from service {}, quick links = {}", (Object)serviceInfo.getName(), serviceInfo.getQuickLinksConfigurationsMap());
                    serviceQuickLinks.add(serviceInfo.getQuickLinksConfigurationsMap().get(quickLinksFileName));
                } else {
                    for (QuickLinksConfigurationInfo quickLinksConfigurationInfo : serviceInfo.getQuickLinksConfigurationsMap().values()) {
                        if (quickLinksConfigurationInfo.getIsDefault().booleanValue()) {
                            serviceQuickLinks.add(0, quickLinksConfigurationInfo);
                            continue;
                        }
                        serviceQuickLinks.add(quickLinksConfigurationInfo);
                    }
                }
                this.setVisibilityAndOverrides(serviceInfo.getName(), serviceQuickLinks);
                ArrayList<ResourceImpl> serviceResources = new ArrayList<ResourceImpl>();
                for (QuickLinksConfigurationInfo quickLinksConfigurationInfo : serviceQuickLinks) {
                    ResourceImpl resource = new ResourceImpl(Resource.Type.QuickLink);
                    Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
                    QuickLinkArtifactResourceProvider.setResourceProperty(resource, QUICKLINK_FILE_NAME_PROPERTY_ID, quickLinksConfigurationInfo.getFileName(), requestedIds);
                    QuickLinkArtifactResourceProvider.setResourceProperty(resource, QUICKLINK_DATA_PROPERTY_ID, quickLinksConfigurationInfo.getQuickLinksConfigurationMap(), requestedIds);
                    QuickLinkArtifactResourceProvider.setResourceProperty(resource, QUICKLINK_DEFAULT_PROPERTY_ID, quickLinksConfigurationInfo.getIsDefault(), requestedIds);
                    QuickLinkArtifactResourceProvider.setResourceProperty(resource, STACK_NAME_PROPERTY_ID, stackName, requestedIds);
                    QuickLinkArtifactResourceProvider.setResourceProperty(resource, STACK_VERSION_PROPERTY_ID, stackVersion, requestedIds);
                    QuickLinkArtifactResourceProvider.setResourceProperty(resource, STACK_SERVICE_NAME_PROPERTY_ID, serviceInfo.getName(), requestedIds);
                    serviceResources.add(resource);
                }
                resources.addAll(serviceResources);
            }
        }
        return resources;
    }

    private void setVisibilityAndOverrides(String serviceName, List<QuickLinksConfigurationInfo> serviceQuickLinks) {
        QuickLinkVisibilityController visibilityController = this.getManagementController().getQuicklinkVisibilityController();
        for (QuickLinksConfigurationInfo configurationInfo : serviceQuickLinks) {
            for (QuickLinks links : configurationInfo.getQuickLinksConfigurationMap().values()) {
                for (Link link : links.getQuickLinksConfiguration().getLinks()) {
                    link.setVisible(visibilityController.isVisible(serviceName, link));
                    visibilityController.getUrlOverride(serviceName, link).ifPresent(link::setUrl);
                }
            }
        }
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return null;
    }
}

