/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.base.Enums;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import id.onyx.obdp.server.api.predicate.InvalidQueryException;
import id.onyx.obdp.server.controller.internal.BaseClusterRequest;
import id.onyx.obdp.server.controller.internal.ProvisionAction;
import id.onyx.obdp.server.security.encryption.CredentialStoreType;
import id.onyx.obdp.server.stack.NoSuchStackException;
import id.onyx.obdp.server.state.quicklinksprofile.QuickLinksProfileBuilder;
import id.onyx.obdp.server.state.quicklinksprofile.QuickLinksProfileEvaluationException;
import id.onyx.obdp.server.topology.ConfigRecommendationStrategy;
import id.onyx.obdp.server.topology.Configuration;
import id.onyx.obdp.server.topology.ConfigurationFactory;
import id.onyx.obdp.server.topology.Credential;
import id.onyx.obdp.server.topology.HostGroupInfo;
import id.onyx.obdp.server.topology.InvalidTopologyTemplateException;
import id.onyx.obdp.server.topology.NoSuchBlueprintException;
import id.onyx.obdp.server.topology.SecurityConfiguration;
import id.onyx.obdp.server.topology.TopologyRequest;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProvisionClusterRequest
extends BaseClusterRequest {
    public static final String HOSTGROUPS_PROPERTY = "host_groups";
    public static final String HOSTGROUP_NAME_PROPERTY = "name";
    public static final String HOSTGROUP_HOST_COUNT_PROPERTY = "host_count";
    public static final String HOSTGROUP_HOST_PREDICATE_PROPERTY = "host_predicate";
    public static final String HOSTGROUP_HOST_FQDN_PROPERTY = "fqdn";
    public static final String HOSTGROUP_HOST_RACK_INFO_PROPERTY = "rack_info";
    public static final String HOSTGROUP_HOSTS_PROPERTY = "hosts";
    public static final String CONFIGURATIONS_PROPERTY = "configurations";
    public static final String DEFAULT_PASSWORD_PROPERTY = "default_password";
    public static final String CONFIG_RECOMMENDATION_STRATEGY = "config_recommendation_strategy";
    public static final String REPO_VERSION_PROPERTY = "repository_version";
    public static final String REPO_VERSION_ID_PROPERTY = "repository_version_id";
    public static final String QUICKLINKS_PROFILE_FILTERS_PROPERTY = "quicklinks_profile/filters";
    public static final String QUICKLINKS_PROFILE_SERVICES_PROPERTY = "quicklinks_profile/services";
    public static final String ALIAS = "alias";
    public static final String PRINCIPAL = "principal";
    public static final String KEY = "key";
    public static final String TYPE = "type";
    private static ConfigurationFactory configurationFactory = new ConfigurationFactory();
    private String clusterName;
    private String defaultPassword;
    private Map<String, Credential> credentialsMap;
    private final ConfigRecommendationStrategy configRecommendationStrategy;
    private String repoVersion;
    private Long repoVersionId;
    private final String quickLinksProfileJson;
    private static final Logger LOG = LoggerFactory.getLogger(ProvisionClusterRequest.class);

    public ProvisionClusterRequest(Map<String, Object> properties, SecurityConfiguration securityConfiguration) throws InvalidTopologyTemplateException {
        this.setClusterName(String.valueOf(properties.get("Clusters/cluster_name")));
        if (properties.containsKey(REPO_VERSION_PROPERTY)) {
            this.repoVersion = properties.get(REPO_VERSION_PROPERTY).toString();
        }
        if (properties.containsKey(REPO_VERSION_ID_PROPERTY)) {
            this.repoVersionId = Long.parseLong(properties.get(REPO_VERSION_ID_PROPERTY).toString());
        }
        if (properties.containsKey(DEFAULT_PASSWORD_PROPERTY)) {
            this.defaultPassword = String.valueOf(properties.get(DEFAULT_PASSWORD_PROPERTY));
        }
        try {
            this.parseBlueprint(properties);
        }
        catch (NoSuchStackException e) {
            throw new InvalidTopologyTemplateException("The specified stack doesn't exist: " + e, e);
        }
        catch (NoSuchBlueprintException e) {
            throw new InvalidTopologyTemplateException("The specified blueprint doesn't exist: " + e, e);
        }
        this.securityConfiguration = securityConfiguration;
        Configuration configuration = configurationFactory.getConfiguration((Collection)properties.get(CONFIGURATIONS_PROPERTY));
        configuration.setParentConfiguration(this.blueprint.getConfiguration());
        this.setConfiguration(configuration);
        this.parseHostGroupInfo(properties);
        this.credentialsMap = this.parseCredentials(properties);
        this.configRecommendationStrategy = this.parseConfigRecommendationStrategy(properties);
        this.setProvisionAction(this.parseProvisionAction(properties));
        try {
            this.quickLinksProfileJson = this.processQuickLinksProfile(properties);
        }
        catch (QuickLinksProfileEvaluationException ex) {
            throw new InvalidTopologyTemplateException("Invalid quick links profile", ex);
        }
    }

    private String processQuickLinksProfile(Map<String, Object> properties) throws QuickLinksProfileEvaluationException {
        Object globalFilters = properties.get(QUICKLINKS_PROFILE_FILTERS_PROPERTY);
        Object serviceFilters = properties.get(QUICKLINKS_PROFILE_SERVICES_PROPERTY);
        return null != globalFilters || null != serviceFilters ? new QuickLinksProfileBuilder().buildQuickLinksProfile(globalFilters, serviceFilters) : null;
    }

    private Map<String, Credential> parseCredentials(Map<String, Object> properties) throws InvalidTopologyTemplateException {
        HashMap<String, Credential> credentialHashMap = new HashMap<String, Credential>();
        Set credentialsSet = (Set)properties.get("credentials");
        if (credentialsSet != null) {
            for (Map credentialMap : credentialsSet) {
                String alias = Strings.emptyToNull((String)((String)credentialMap.get(ALIAS)));
                if (alias == null) {
                    throw new InvalidTopologyTemplateException("credential.alias property is missing.");
                }
                String principal = Strings.emptyToNull((String)((String)credentialMap.get(PRINCIPAL)));
                if (principal == null) {
                    throw new InvalidTopologyTemplateException("credential.principal property is missing.");
                }
                String key = Strings.emptyToNull((String)((String)credentialMap.get(KEY)));
                if (key == null) {
                    throw new InvalidTopologyTemplateException("credential.key is missing.");
                }
                String typeString = Strings.emptyToNull((String)((String)credentialMap.get(TYPE)));
                if (typeString == null) {
                    throw new InvalidTopologyTemplateException("credential.type is missing.");
                }
                CredentialStoreType type = (CredentialStoreType)((Object)Enums.getIfPresent(CredentialStoreType.class, (String)typeString.toUpperCase()).orNull());
                if (type == null) {
                    throw new InvalidTopologyTemplateException(String.format("credential.type [%s] is invalid. acceptable values: %s", typeString.toUpperCase(), Arrays.toString((Object[])CredentialStoreType.values())));
                }
                credentialHashMap.put(alias, new Credential(alias, principal, key, type));
            }
        }
        return credentialHashMap;
    }

    public Map<String, Credential> getCredentialsMap() {
        return this.credentialsMap;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public ConfigRecommendationStrategy getConfigRecommendationStrategy() {
        return this.configRecommendationStrategy;
    }

    @Override
    public Long getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(Long clusterId) {
        this.clusterId = clusterId;
    }

    @Override
    public TopologyRequest.Type getType() {
        return TopologyRequest.Type.PROVISION;
    }

    @Override
    public String getDescription() {
        return String.format("Provision Cluster '%s'", this.clusterName);
    }

    private void parseBlueprint(Map<String, Object> properties) throws NoSuchStackException, NoSuchBlueprintException {
        String blueprintName = String.valueOf(properties.get("blueprint"));
        this.setBlueprint(this.getBlueprintFactory().getBlueprint(blueprintName));
        if (this.blueprint == null) {
            throw new NoSuchBlueprintException(blueprintName);
        }
    }

    private void parseHostGroupInfo(Map<String, Object> properties) throws InvalidTopologyTemplateException {
        Collection hostGroups = (Collection)properties.get(HOSTGROUPS_PROPERTY);
        if (hostGroups == null || hostGroups.isEmpty()) {
            throw new InvalidTopologyTemplateException("'host_groups' element must be included in cluster create body");
        }
        for (Map hostGroupProperties : hostGroups) {
            this.processHostGroup(hostGroupProperties);
        }
    }

    private void processHostGroup(Map<String, Object> hostGroupProperties) throws InvalidTopologyTemplateException {
        String name = String.valueOf(hostGroupProperties.get(HOSTGROUP_NAME_PROPERTY));
        if (name == null || name.equals("null") || name.isEmpty()) {
            throw new InvalidTopologyTemplateException("All host groups must contain a 'name' element");
        }
        HostGroupInfo hostGroupInfo = new HostGroupInfo(name);
        this.getHostGroupInfo().put(name, hostGroupInfo);
        this.processHostCountAndPredicate(hostGroupProperties, hostGroupInfo);
        this.processGroupHosts(name, (Collection)hostGroupProperties.get(HOSTGROUP_HOSTS_PROPERTY), hostGroupInfo);
        hostGroupInfo.setConfiguration(configurationFactory.getConfiguration((Collection)hostGroupProperties.get(CONFIGURATIONS_PROPERTY)));
    }

    private void processHostCountAndPredicate(Map<String, Object> hostGroupProperties, HostGroupInfo hostGroupInfo) throws InvalidTopologyTemplateException {
        if (hostGroupProperties.containsKey(HOSTGROUP_HOST_COUNT_PROPERTY)) {
            hostGroupInfo.setRequestedCount(Integer.parseInt(String.valueOf(hostGroupProperties.get(HOSTGROUP_HOST_COUNT_PROPERTY))));
            LOG.info("Stored expected hosts count {} for group {}", (Object)hostGroupInfo.getRequestedHostCount(), (Object)hostGroupInfo.getHostGroupName());
        }
        if (hostGroupProperties.containsKey(HOSTGROUP_HOST_PREDICATE_PROPERTY)) {
            if (hostGroupInfo.getRequestedHostCount() == 0) {
                throw new InvalidTopologyTemplateException(String.format("Host group '%s' must not specify 'host_predicate' without 'host_count'", hostGroupInfo.getHostGroupName()));
            }
            String hostPredicate = String.valueOf(hostGroupProperties.get(HOSTGROUP_HOST_PREDICATE_PROPERTY));
            this.validateHostPredicateProperties(hostPredicate);
            try {
                hostGroupInfo.setPredicate(hostPredicate);
                LOG.info("Compiled host predicate {} for group {}", (Object)hostPredicate, (Object)hostGroupInfo.getHostGroupName());
            }
            catch (InvalidQueryException e) {
                throw new InvalidTopologyTemplateException(String.format("Unable to compile host predicate '%s': %s", hostPredicate, e), e);
            }
        }
    }

    private void processGroupHosts(String name, Collection<Map<String, String>> hosts, HostGroupInfo hostGroupInfo) throws InvalidTopologyTemplateException {
        if (hosts != null) {
            if (hostGroupInfo.getRequestedHostCount() != 0) {
                throw new InvalidTopologyTemplateException(String.format("Host group '%s' must not contain both a 'hosts' element and a 'host_count' value", name));
            }
            if (hostGroupInfo.getPredicate() != null) {
                throw new InvalidTopologyTemplateException(String.format("Host group '%s' must not contain both a 'hosts' element and a 'host_predicate' value", name));
            }
            for (Map<String, String> hostProperties : hosts) {
                if (hostProperties.containsKey(HOSTGROUP_HOST_FQDN_PROPERTY)) {
                    hostGroupInfo.addHost(hostProperties.get(HOSTGROUP_HOST_FQDN_PROPERTY));
                }
                if (!hostProperties.containsKey(HOSTGROUP_HOST_RACK_INFO_PROPERTY)) continue;
                hostGroupInfo.addHostRackInfo(hostProperties.get(HOSTGROUP_HOST_FQDN_PROPERTY), hostProperties.get(HOSTGROUP_HOST_RACK_INFO_PROPERTY));
            }
        }
        if (hostGroupInfo.getRequestedHostCount() == 0) {
            throw new InvalidTopologyTemplateException(String.format("Host group '%s' must contain at least one 'hosts/fqdn' or a 'host_count' value", name));
        }
    }

    private ConfigRecommendationStrategy parseConfigRecommendationStrategy(Map<String, Object> properties) throws InvalidTopologyTemplateException {
        if (properties.containsKey(CONFIG_RECOMMENDATION_STRATEGY)) {
            String configRecommendationStrategy = String.valueOf(properties.get(CONFIG_RECOMMENDATION_STRATEGY));
            Optional configRecommendationStrategyOpt = Enums.getIfPresent(ConfigRecommendationStrategy.class, (String)configRecommendationStrategy);
            if (!configRecommendationStrategyOpt.isPresent()) {
                throw new InvalidTopologyTemplateException(String.format("Config recommendation strategy is not supported: %s", configRecommendationStrategy));
            }
            return (ConfigRecommendationStrategy)((Object)configRecommendationStrategyOpt.get());
        }
        return ConfigRecommendationStrategy.NEVER_APPLY;
    }

    private ProvisionAction parseProvisionAction(Map<String, Object> properties) throws InvalidTopologyTemplateException {
        if (properties.containsKey("provision_action")) {
            String provisionActionStr = String.valueOf(properties.get("provision_action"));
            Optional provisionActionOptional = Enums.getIfPresent(ProvisionAction.class, (String)provisionActionStr);
            if (!provisionActionOptional.isPresent()) {
                throw new InvalidTopologyTemplateException(String.format("Invalid provision_action specified in the template: %s", provisionActionStr));
            }
            return (ProvisionAction)((Object)provisionActionOptional.get());
        }
        return ProvisionAction.INSTALL_AND_START;
    }

    public String getRepositoryVersion() {
        return this.repoVersion;
    }

    public Long getRepositoryVersionId() {
        return this.repoVersionId;
    }

    public String getQuickLinksProfileJson() {
        return this.quickLinksProfileJson;
    }

    public String getDefaultPassword() {
        return this.defaultPassword;
    }
}

