/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableSet;
import id.onyx.obdp.server.controller.internal.Stack;
import id.onyx.obdp.server.controller.internal.TrimmingStrategy;
import id.onyx.obdp.server.state.PropertyInfo;
import id.onyx.obdp.server.state.ValueAttributesInfo;
import java.util.Map;
import java.util.Set;

public class PropertyValueTrimmingStrategyDefiner {
    private static final Set<String> SET_OF_URL_PROPERTIES = ImmutableSet.of((Object)"javax.jdo.option.ConnectionURL", (Object)"oozie.service.JPAService.jdbc.url");

    private static TrimmingStrategy getTrimmingStrategyForConfigProperty(Stack.ConfigProperty configProperty) {
        if (configProperty != null) {
            ValueAttributesInfo valueAttributesInfo = configProperty.getPropertyValueAttributes();
            if (valueAttributesInfo != null) {
                String type = valueAttributesInfo.getType();
                if ("directory".equals(type) || "directories".equals(type)) {
                    return TrimmingStrategy.DIRECTORIES;
                }
                if ("host".equals(type)) {
                    return TrimmingStrategy.DEFAULT;
                }
            }
            if (configProperty.getPropertyTypes() != null && configProperty.getPropertyTypes().contains((Object)PropertyInfo.PropertyType.PASSWORD)) {
                return TrimmingStrategy.PASSWORD;
            }
        }
        return null;
    }

    private static TrimmingStrategy getTrimmingStrategyByPropertyName(String propertyName) {
        if (SET_OF_URL_PROPERTIES.contains(propertyName)) {
            return TrimmingStrategy.DEFAULT;
        }
        return TrimmingStrategy.DELETE_SPACES_AT_END;
    }

    public static TrimmingStrategy defineTrimmingStrategy(Stack stack, String propertyName, String configType) {
        Stack.ConfigProperty configProperty;
        Map<String, Stack.ConfigProperty> map;
        TrimmingStrategy result = null;
        String service = stack.getServiceForConfigType(configType);
        if (service != null && (map = stack.getConfigurationPropertiesWithMetadata(service, configType)) != null && (configProperty = map.get(propertyName)) != null) {
            result = PropertyValueTrimmingStrategyDefiner.getTrimmingStrategyForConfigProperty(configProperty);
        }
        if (result == null) {
            result = PropertyValueTrimmingStrategyDefiner.getTrimmingStrategyByPropertyName(propertyName);
        }
        return result;
    }
}

