/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import id.onyx.obdp.server.DuplicateResourceException;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.internal.AbstractAuthorizedResourceProvider;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.orm.dao.GroupDAO;
import id.onyx.obdp.server.orm.dao.PermissionDAO;
import id.onyx.obdp.server.orm.dao.PrincipalDAO;
import id.onyx.obdp.server.orm.dao.PrivilegeDAO;
import id.onyx.obdp.server.orm.dao.ResourceDAO;
import id.onyx.obdp.server.orm.dao.UserDAO;
import id.onyx.obdp.server.orm.entities.GroupEntity;
import id.onyx.obdp.server.orm.entities.PermissionEntity;
import id.onyx.obdp.server.orm.entities.PrincipalEntity;
import id.onyx.obdp.server.orm.entities.PrincipalTypeEntity;
import id.onyx.obdp.server.orm.entities.PrivilegeEntity;
import id.onyx.obdp.server.orm.entities.ResourceEntity;
import id.onyx.obdp.server.orm.entities.UserEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public abstract class PrivilegeResourceProvider<T>
extends AbstractAuthorizedResourceProvider {
    private static PrivilegeDAO privilegeDAO;
    private static UserDAO userDAO;
    private static GroupDAO groupDAO;
    private static PrincipalDAO principalDAO;
    protected static PermissionDAO permissionDAO;
    private static ResourceDAO resourceDAO;
    public static final String PRIVILEGE_INFO = "PrivilegeInfo";
    public static final String PRIVILEGE_ID_PROPERTY_ID = "privilege_id";
    public static final String PERMISSION_NAME_PROPERTY_ID = "permission_name";
    public static final String PERMISSION_LABEL_PROPERTY_ID = "permission_label";
    public static final String PRINCIPAL_NAME_PROPERTY_ID = "principal_name";
    public static final String PRINCIPAL_TYPE_PROPERTY_ID = "principal_type";
    public static final String VERSION_PROPERTY_ID = "version";
    public static final String TYPE_PROPERTY_ID = "type";
    public static final String PRIVILEGE_ID = "PrivilegeInfo/privilege_id";
    public static final String PERMISSION_NAME = "PrivilegeInfo/permission_name";
    public static final String PERMISSION_LABEL = "PrivilegeInfo/permission_label";
    public static final String PRINCIPAL_NAME = "PrivilegeInfo/principal_name";
    public static final String PRINCIPAL_TYPE = "PrivilegeInfo/principal_type";
    private final Resource.Type resourceType;

    public PrivilegeResourceProvider(Set<String> propertyIds, Map<Resource.Type, String> keyPropertyIds, Resource.Type resourceType) {
        super(resourceType, propertyIds, keyPropertyIds);
        this.resourceType = resourceType;
    }

    public static void init(PrivilegeDAO privDAO, UserDAO usrDAO, GroupDAO grpDAO, PrincipalDAO prinDAO, PermissionDAO permDAO, ResourceDAO resDAO) {
        privilegeDAO = privDAO;
        userDAO = usrDAO;
        groupDAO = grpDAO;
        principalDAO = prinDAO;
        permissionDAO = permDAO;
        resourceDAO = resDAO;
    }

    public abstract Map<Long, T> getResourceEntities(Map<String, Object> var1) throws OBDPException;

    public abstract Long getResourceEntityId(Predicate var1);

    @Override
    public RequestStatus createResourcesAuthorized(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        for (Map<String, Object> properties : request.getProperties()) {
            this.createResources(this.getCreateCommand(properties));
        }
        this.notifyCreate(this.resourceType, request);
        return this.getRequestStatus(null);
    }

    @Override
    public Set<Resource> getResourcesAuthorized(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        HashSet<Resource> resources = new HashSet<Resource>();
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        HashSet<Long> resourceIds = new HashSet<Long>();
        Set<Map<String, Object>> propertyMaps = this.getPropertyMaps(predicate);
        if (propertyMaps.isEmpty()) {
            propertyMaps.add(Collections.emptyMap());
        }
        for (Map<String, Object> properties : propertyMaps) {
            Map<Long, T> resourceEntities;
            try {
                resourceEntities = this.getResourceEntities(properties);
            }
            catch (OBDPException e) {
                throw new SystemException("Could not get resource list from request", e);
            }
            resourceIds.addAll(resourceEntities.keySet());
            HashSet<PrivilegeEntity> entitySet = new HashSet<PrivilegeEntity>();
            LinkedList<PrincipalEntity> userPrincipals = new LinkedList<PrincipalEntity>();
            LinkedList<PrincipalEntity> groupPrincipals = new LinkedList<PrincipalEntity>();
            LinkedList<PrincipalEntity> rolePrincipals = new LinkedList<PrincipalEntity>();
            List<PrivilegeEntity> entities = privilegeDAO.findAll();
            for (PrivilegeEntity privilegeEntity : entities) {
                if (!resourceIds.contains(privilegeEntity.getResource().getId())) continue;
                PrincipalEntity principal = privilegeEntity.getPrincipal();
                String string = principal.getPrincipalType().getName();
                entitySet.add(privilegeEntity);
                if (PrincipalTypeEntity.USER_PRINCIPAL_TYPE_NAME.equals(string)) {
                    userPrincipals.add(principal);
                    continue;
                }
                if (PrincipalTypeEntity.GROUP_PRINCIPAL_TYPE_NAME.equals(string)) {
                    groupPrincipals.add(principal);
                    continue;
                }
                if (!PrincipalTypeEntity.ROLE_PRINCIPAL_TYPE_NAME.equals(string)) continue;
                rolePrincipals.add(principal);
            }
            HashMap<Long, UserEntity> userEntities = new HashMap<Long, UserEntity>();
            if (!userPrincipals.isEmpty()) {
                List<UserEntity> userList = userDAO.findUsersByPrincipal(userPrincipals);
                for (UserEntity userEntity : userList) {
                    userEntities.put(userEntity.getPrincipal().getId(), userEntity);
                }
            }
            HashMap<Long, GroupEntity> groupEntities = new HashMap<Long, GroupEntity>();
            if (!groupPrincipals.isEmpty()) {
                List<GroupEntity> groupList = groupDAO.findGroupsByPrincipal(groupPrincipals);
                for (Object groupEntity : groupList) {
                    groupEntities.put(((GroupEntity)groupEntity).getPrincipal().getId(), (GroupEntity)groupEntity);
                }
            }
            HashMap<Long, PermissionEntity> roleEntities = new HashMap<Long, PermissionEntity>();
            if (!rolePrincipals.isEmpty()) {
                Object groupEntity;
                List<PermissionEntity> list = permissionDAO.findPermissionsByPrincipal(rolePrincipals);
                groupEntity = list.iterator();
                while (groupEntity.hasNext()) {
                    PermissionEntity roleEntity = (PermissionEntity)groupEntity.next();
                    roleEntities.put(roleEntity.getPrincipal().getId(), roleEntity);
                }
            }
            for (PrivilegeEntity privilegeEntity : entitySet) {
                Resource resource = this.toResource(privilegeEntity, userEntities, groupEntities, roleEntities, resourceEntities, requestedIds);
                if (resource == null || predicate != null && !predicate.evaluate(resource)) continue;
                resources.add(resource);
            }
        }
        return resources;
    }

    @Override
    public RequestStatus updateResourcesAuthorized(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        this.modifyResources(this.getUpdateCommand(request, predicate));
        this.notifyUpdate(this.resourceType, request, predicate);
        return this.getRequestStatus(null);
    }

    @Override
    public RequestStatus deleteResourcesAuthorized(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        this.modifyResources(this.getDeleteCommand(predicate));
        this.notifyDelete(this.resourceType, predicate);
        return this.getRequestStatus(null);
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return new HashSet<String>(this.getKeyPropertyIds().values());
    }

    protected boolean checkResourceTypes(PrivilegeEntity entity) throws OBDPException {
        Integer resourceType = entity.getResource().getResourceType().getId();
        Integer permissionResourceType = entity.getPermission().getResourceType().getId();
        return resourceType.equals(permissionResourceType);
    }

    protected Resource toResource(PrivilegeEntity privilegeEntity, Map<Long, UserEntity> userEntities, Map<Long, GroupEntity> groupEntities, Map<Long, PermissionEntity> roleEntities, Map<Long, T> resourceEntities, Set<String> requestedIds) {
        PrincipalTypeEntity principalType;
        ResourceImpl resource = new ResourceImpl(this.resourceType);
        PrincipalEntity principal = privilegeEntity.getPrincipal();
        String principalTypeName = null;
        String resourcePropertyName = null;
        if (principal != null && (principalType = principal.getPrincipalType()) != null) {
            UserEntity userEntity;
            Long principalId = principal.getId();
            principalTypeName = principalType.getName();
            if (StringUtils.equalsIgnoreCase((String)PrincipalTypeEntity.GROUP_PRINCIPAL_TYPE_NAME, (String)principalTypeName)) {
                GroupEntity groupEntity = groupEntities.get(principalId);
                if (groupEntity != null) {
                    resourcePropertyName = groupEntity.getGroupName();
                }
            } else if (StringUtils.equalsIgnoreCase((String)PrincipalTypeEntity.ROLE_PRINCIPAL_TYPE_NAME, (String)principalTypeName)) {
                PermissionEntity roleEntity = roleEntities.get(principalId);
                if (roleEntity != null) {
                    resourcePropertyName = roleEntity.getPermissionName();
                }
            } else if (StringUtils.equalsIgnoreCase((String)PrincipalTypeEntity.USER_PRINCIPAL_TYPE_NAME, (String)principalTypeName) && (userEntity = userEntities.get(principalId)) != null) {
                resourcePropertyName = userEntity.getUserName();
            }
        }
        PrivilegeResourceProvider.setResourceProperty(resource, PRIVILEGE_ID, privilegeEntity.getId(), requestedIds);
        PrivilegeResourceProvider.setResourceProperty(resource, PERMISSION_NAME, privilegeEntity.getPermission().getPermissionName(), requestedIds);
        PrivilegeResourceProvider.setResourceProperty(resource, PERMISSION_LABEL, privilegeEntity.getPermission().getPermissionLabel(), requestedIds);
        PrivilegeResourceProvider.setResourceProperty(resource, PRINCIPAL_NAME, resourcePropertyName, requestedIds);
        PrivilegeResourceProvider.setResourceProperty(resource, PRINCIPAL_TYPE, principalTypeName, requestedIds);
        return resource;
    }

    protected PrivilegeEntity toEntity(Map<String, Object> properties, Long resourceId) throws OBDPException {
        ResourceEntity resourceEntity;
        PrivilegeEntity entity = new PrivilegeEntity();
        String permissionName = (String)properties.get(PERMISSION_NAME);
        PermissionEntity permission = this.getPermission(permissionName, resourceEntity = resourceDAO.findById(resourceId));
        if (permission == null) {
            throw new OBDPException("Can't find a permission named " + permissionName + " for the resource.");
        }
        entity.setPermission(permission);
        entity.setResource(resourceEntity);
        String principalName = (String)properties.get(PRINCIPAL_NAME);
        String principalType = (String)properties.get(PRINCIPAL_TYPE);
        if (StringUtils.equalsIgnoreCase((String)PrincipalTypeEntity.GROUP_PRINCIPAL_TYPE_NAME, (String)principalType)) {
            GroupEntity groupEntity = groupDAO.findGroupByName(principalName);
            if (groupEntity != null) {
                entity.setPrincipal(principalDAO.findById(groupEntity.getPrincipal().getId()));
            }
        } else if (StringUtils.equalsIgnoreCase((String)PrincipalTypeEntity.ROLE_PRINCIPAL_TYPE_NAME, (String)principalType)) {
            PermissionEntity permissionEntity = permissionDAO.findByName(principalName);
            if (permissionEntity != null) {
                entity.setPrincipal(principalDAO.findById(permissionEntity.getPrincipal().getId()));
            }
        } else if (StringUtils.equalsIgnoreCase((String)PrincipalTypeEntity.USER_PRINCIPAL_TYPE_NAME, (String)principalType)) {
            UserEntity userEntity = userDAO.findUserByName(principalName);
            if (userEntity != null) {
                entity.setPrincipal(principalDAO.findById(userEntity.getPrincipal().getId()));
            }
        } else {
            throw new OBDPException("Unknown principal type " + principalType);
        }
        if (entity.getPrincipal() == null) {
            throw new OBDPException("Could not find " + principalType + " named " + principalName);
        }
        return entity;
    }

    protected PermissionEntity getPermission(String permissionName, ResourceEntity resourceEntity) throws OBDPException {
        return permissionDAO.findPermissionByNameAndType(permissionName, resourceEntity.getResourceType());
    }

    private AbstractResourceProvider.Command<Void> getCreateCommand(final Map<String, Object> properties) {
        return new AbstractResourceProvider.Command<Void>(){

            @Override
            public Void invoke() throws OBDPException {
                Set<Long> resourceIds = PrivilegeResourceProvider.this.getResourceEntities(properties).keySet();
                Long resourceId = resourceIds.iterator().next();
                PrivilegeEntity entity = PrivilegeResourceProvider.this.toEntity(properties, resourceId);
                if (entity.getPrincipal() == null) {
                    throw new OBDPException("Can't find principal " + properties.get(PrivilegeResourceProvider.PRINCIPAL_TYPE) + " " + properties.get(PrivilegeResourceProvider.PRINCIPAL_NAME) + " for privilege.");
                }
                if (privilegeDAO.exists(entity)) {
                    throw new DuplicateResourceException("The privilege already exists.");
                }
                if (!PrivilegeResourceProvider.this.checkResourceTypes(entity)) {
                    throw new OBDPException("Can't grant " + entity.getPermission().getResourceType().getName() + " permission on a " + entity.getResource().getResourceType().getName() + " resource.");
                }
                privilegeDAO.create(entity);
                entity.getPrincipal().getPrivileges().add(entity);
                principalDAO.merge(entity.getPrincipal());
                return null;
            }
        };
    }

    private AbstractResourceProvider.Command<Void> getDeleteCommand(final Predicate predicate) {
        return new AbstractResourceProvider.Command<Void>(){

            @Override
            public Void invoke() throws OBDPException {
                try {
                    for (Map<String, Object> resource : PrivilegeResourceProvider.this.getPropertyMaps(predicate)) {
                        if (resource.get(PrivilegeResourceProvider.PRIVILEGE_ID) == null) {
                            throw new OBDPException("Privilege ID should be provided for this request");
                        }
                        PrivilegeEntity entity = privilegeDAO.findById(Integer.valueOf(resource.get(PrivilegeResourceProvider.PRIVILEGE_ID).toString()));
                        if (entity == null) continue;
                        if (!PrivilegeResourceProvider.this.checkResourceTypes(entity)) {
                            throw new OBDPException("Can't remove " + entity.getPermission().getResourceType().getName() + " permission from a " + entity.getResource().getResourceType().getName() + " resource.");
                        }
                        entity.getPrincipal().getPrivileges().remove(entity);
                        principalDAO.merge(entity.getPrincipal());
                        privilegeDAO.remove(entity);
                    }
                }
                catch (Exception e) {
                    throw new OBDPException("Caught exception deleting privilege.", (Throwable)e);
                }
                return null;
            }
        };
    }

    private AbstractResourceProvider.Command<Void> getUpdateCommand(final Request request, final Predicate predicate) {
        return new AbstractResourceProvider.Command<Void>(){

            @Override
            public Void invoke() throws OBDPException {
                Long resource = null;
                ArrayList<PrivilegeEntity> requiredEntities = new ArrayList<PrivilegeEntity>();
                for (Map<String, Object> properties : request.getProperties()) {
                    Set<Long> resourceIds = PrivilegeResourceProvider.this.getResourceEntities(properties).keySet();
                    Long resourceId = resourceIds.iterator().next();
                    if (resource != null && !resourceId.equals(resource)) {
                        throw new OBDPException("Can't update privileges of multiple resources in one request");
                    }
                    resource = resourceId;
                    PrivilegeEntity entity = PrivilegeResourceProvider.this.toEntity(properties, resourceId);
                    requiredEntities.add(entity);
                }
                if (resource == null && (resource = PrivilegeResourceProvider.this.getResourceEntityId(predicate)) == null) {
                    return null;
                }
                List<PrivilegeEntity> currentPrivileges = privilegeDAO.findByResourceId(resource);
                for (PrivilegeEntity requiredPrivilege : requiredEntities) {
                    boolean isInBothLists = false;
                    for (PrivilegeEntity currentPrivilege : currentPrivileges) {
                        if (!requiredPrivilege.getPermission().getPermissionName().equals(currentPrivilege.getPermission().getPermissionName()) || !requiredPrivilege.getPrincipal().getId().equals(currentPrivilege.getPrincipal().getId())) continue;
                        isInBothLists = true;
                        break;
                    }
                    if (isInBothLists) continue;
                    if (!PrivilegeResourceProvider.this.checkResourceTypes(requiredPrivilege)) {
                        throw new OBDPException("Can't grant " + requiredPrivilege.getPermission().getResourceType().getName() + " permission on a " + requiredPrivilege.getResource().getResourceType().getName() + " resource.");
                    }
                    privilegeDAO.create(requiredPrivilege);
                    requiredPrivilege.getPrincipal().getPrivileges().add(requiredPrivilege);
                    principalDAO.merge(requiredPrivilege.getPrincipal());
                }
                for (PrivilegeEntity currentPrivilege : currentPrivileges) {
                    boolean isInBothLists = false;
                    for (PrivilegeEntity requiredPrivilege : requiredEntities) {
                        if (!requiredPrivilege.getPermission().getPermissionName().equals(currentPrivilege.getPermission().getPermissionName()) || !requiredPrivilege.getPrincipal().getId().equals(currentPrivilege.getPrincipal().getId())) continue;
                        isInBothLists = true;
                        break;
                    }
                    if (isInBothLists) continue;
                    if (!PrivilegeResourceProvider.this.checkResourceTypes(currentPrivilege)) {
                        throw new OBDPException("Can't remove " + currentPrivilege.getPermission().getResourceType().getName() + " permission from a " + currentPrivilege.getResource().getResourceType().getName() + " resource.");
                    }
                    currentPrivilege.getPrincipal().getPrivileges().remove(currentPrivilege);
                    principalDAO.merge(currentPrivilege.getPrincipal());
                    privilegeDAO.remove(currentPrivilege);
                }
                return null;
            }
        };
    }
}

