/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Provider;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.StaticallyInject;
import id.onyx.obdp.server.checks.UpgradeCheckRegistry;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.internal.ReadOnlyResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.internal.URLStreamProvider;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.orm.dao.RepositoryVersionDAO;
import id.onyx.obdp.server.orm.entities.RepositoryVersionEntity;
import id.onyx.obdp.server.stack.upgrade.Direction;
import id.onyx.obdp.server.stack.upgrade.UpgradePack;
import id.onyx.obdp.server.stack.upgrade.orchestrate.UpgradeHelper;
import id.onyx.obdp.server.state.CheckHelper;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.spi.ClusterInformation;
import id.onyx.obdp.spi.RepositoryVersion;
import id.onyx.obdp.spi.net.HttpURLConnectionProvider;
import id.onyx.obdp.spi.upgrade.UpgradeCheck;
import id.onyx.obdp.spi.upgrade.UpgradeCheckRequest;
import id.onyx.obdp.spi.upgrade.UpgradeCheckResult;
import id.onyx.obdp.spi.upgrade.UpgradeType;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StaticallyInject
public class PreUpgradeCheckResourceProvider
extends ReadOnlyResourceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(PreUpgradeCheckResourceProvider.class);
    public static final String UPGRADE_CHECK_ID_PROPERTY_ID = PropertyHelper.getPropertyId("UpgradeChecks", "id");
    public static final String UPGRADE_CHECK_CHECK_PROPERTY_ID = PropertyHelper.getPropertyId("UpgradeChecks", "check");
    public static final String UPGRADE_CHECK_STATUS_PROPERTY_ID = PropertyHelper.getPropertyId("UpgradeChecks", "status");
    public static final String UPGRADE_CHECK_REASON_PROPERTY_ID = PropertyHelper.getPropertyId("UpgradeChecks", "reason");
    public static final String UPGRADE_CHECK_FAILED_ON_PROPERTY_ID = PropertyHelper.getPropertyId("UpgradeChecks", "failed_on");
    public static final String UPGRADE_CHECK_FAILED_DETAIL_PROPERTY_ID = PropertyHelper.getPropertyId("UpgradeChecks", "failed_detail");
    public static final String UPGRADE_CHECK_CHECK_TYPE_PROPERTY_ID = PropertyHelper.getPropertyId("UpgradeChecks", "check_type");
    public static final String UPGRADE_CHECK_CLUSTER_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("UpgradeChecks", "cluster_name");
    public static final String UPGRADE_CHECK_UPGRADE_TYPE_PROPERTY_ID = PropertyHelper.getPropertyId("UpgradeChecks", "upgrade_type");
    public static final String UPGRADE_CHECK_TARGET_REPOSITORY_VERSION_ID_ID = PropertyHelper.getPropertyId("UpgradeChecks", "repository_version_id");
    public static final String UPGRADE_CHECK_TARGET_REPOSITORY_VERSION = PropertyHelper.getPropertyId("UpgradeChecks", "repository_version");
    public static final String UPGRADE_CHECK_UPGRADE_PACK_PROPERTY_ID = PropertyHelper.getPropertyId("UpgradeChecks", "upgrade_pack");
    public static final String UPGRADE_CHECK_REPOSITORY_VERSION_PROPERTY_ID = PropertyHelper.getPropertyId("UpgradeChecks", "repository_version");
    public static final String UPGRADE_CHECK_FOR_REVERT_PROPERTY_ID = PropertyHelper.getPropertyId("UpgradeChecks", "for_revert");
    @Inject
    private static Provider<Clusters> clustersProvider;
    @Inject
    private static RepositoryVersionDAO repositoryVersionDAO;
    @Inject
    private static Provider<UpgradeCheckRegistry> upgradeCheckRegistryProvider;
    @Inject
    private static Provider<UpgradeHelper> upgradeHelper;
    @Inject
    private static Provider<Configuration> config;
    @Inject
    private static CheckHelper checkHelper;
    private static final Set<String> pkPropertyIds;
    public static final Set<String> propertyIds;
    public static final Map<Resource.Type, String> keyPropertyIds;

    public PreUpgradeCheckResourceProvider(OBDPManagementController managementController) {
        super(Resource.Type.PreUpgradeCheck, propertyIds, keyPropertyIds, managementController);
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        HashSet<Resource> resources = new HashSet<Resource>();
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        Set<Map<String, Object>> propertyMaps = this.getPropertyMaps(predicate);
        for (Map<String, Object> propertyMap : propertyMaps) {
            List<UpgradeCheck> upgradeChecksToRun;
            Cluster cluster;
            String clusterName = propertyMap.get(UPGRADE_CHECK_CLUSTER_NAME_PROPERTY_ID).toString();
            UpgradeType upgradeType = UpgradeType.ROLLING;
            if (propertyMap.containsKey(UPGRADE_CHECK_UPGRADE_TYPE_PROPERTY_ID)) {
                try {
                    upgradeType = UpgradeType.valueOf((String)propertyMap.get(UPGRADE_CHECK_UPGRADE_TYPE_PROPERTY_ID).toString());
                }
                catch (Exception e) {
                    throw new SystemException(String.format("Property %s has an incorrect value of %s.", UPGRADE_CHECK_UPGRADE_TYPE_PROPERTY_ID, propertyMap.get(UPGRADE_CHECK_UPGRADE_TYPE_PROPERTY_ID)));
                }
            }
            try {
                cluster = ((Clusters)clustersProvider.get()).getCluster(clusterName);
            }
            catch (OBDPException ambariException) {
                throw new NoSuchResourceException(ambariException.getMessage());
            }
            StackId sourceStackId = cluster.getCurrentStackVersion();
            String repositoryVersionId = (String)propertyMap.get(UPGRADE_CHECK_TARGET_REPOSITORY_VERSION_ID_ID);
            if (StringUtils.isBlank((String)repositoryVersionId)) {
                throw new SystemException(String.format("%s is a required property when executing upgrade checks", UPGRADE_CHECK_TARGET_REPOSITORY_VERSION_ID_ID));
            }
            RepositoryVersionEntity repositoryVersion = (RepositoryVersionEntity)repositoryVersionDAO.findByPK(Long.valueOf(repositoryVersionId));
            UpgradePack upgradePack = null;
            String preferredUpgradePackName = propertyMap.containsKey(UPGRADE_CHECK_UPGRADE_PACK_PROPERTY_ID) ? (String)propertyMap.get(UPGRADE_CHECK_UPGRADE_PACK_PROPERTY_ID) : null;
            try {
                upgradePack = ((UpgradeHelper)upgradeHelper.get()).suggestUpgradePack(clusterName, sourceStackId, repositoryVersion.getStackId(), Direction.UPGRADE, upgradeType, preferredUpgradePackName);
            }
            catch (OBDPException e) {
                throw new SystemException(e.getMessage(), e);
            }
            if (upgradePack == null) {
                throw new SystemException(String.format("Upgrade pack not found for the target repository version %s", repositoryVersion));
            }
            ClusterInformation clusterInformation = cluster.buildClusterInformation();
            StackId stackId = repositoryVersion.getStackId();
            RepositoryVersion targetRepositoryVersion = new RepositoryVersion(repositoryVersion.getId().longValue(), stackId.getStackName(), stackId.getStackVersion(), stackId.getStackId(), repositoryVersion.getVersion(), repositoryVersion.getType());
            UpgradeCheckRequest upgradeCheckRequest = new UpgradeCheckRequest(clusterInformation, upgradeType, targetRepositoryVersion, upgradePack.getPrerequisiteCheckConfig().getAllProperties(), (HttpURLConnectionProvider)new URLStreamProvider.AmbariHttpUrlConnectionProvider());
            if (propertyMap.containsKey(UPGRADE_CHECK_FOR_REVERT_PROPERTY_ID)) {
                Boolean forRevert = BooleanUtils.toBooleanObject((String)propertyMap.get(UPGRADE_CHECK_FOR_REVERT_PROPERTY_ID).toString());
                upgradeCheckRequest.setRevert(forRevert.booleanValue());
            }
            UpgradeCheckRegistry upgradeCheckRegistry = (UpgradeCheckRegistry)upgradeCheckRegistryProvider.get();
            try {
                upgradeChecksToRun = upgradeCheckRegistry.getFilteredUpgradeChecks(upgradePack);
            }
            catch (OBDPException ambariException) {
                throw new SystemException("Unable to load upgrade checks", ambariException);
            }
            List<UpgradeCheckResult> results = checkHelper.performChecks(upgradeCheckRequest, upgradeChecksToRun, (Configuration)config.get());
            for (UpgradeCheckResult prerequisiteCheck : results) {
                ResourceImpl resource = new ResourceImpl(Resource.Type.PreUpgradeCheck);
                PreUpgradeCheckResourceProvider.setResourceProperty(resource, UPGRADE_CHECK_ID_PROPERTY_ID, prerequisiteCheck.getId(), requestedIds);
                PreUpgradeCheckResourceProvider.setResourceProperty(resource, UPGRADE_CHECK_CHECK_PROPERTY_ID, prerequisiteCheck.getDescription(), requestedIds);
                PreUpgradeCheckResourceProvider.setResourceProperty(resource, UPGRADE_CHECK_STATUS_PROPERTY_ID, prerequisiteCheck.getStatus(), requestedIds);
                PreUpgradeCheckResourceProvider.setResourceProperty(resource, UPGRADE_CHECK_REASON_PROPERTY_ID, prerequisiteCheck.getFailReason(), requestedIds);
                PreUpgradeCheckResourceProvider.setResourceProperty(resource, UPGRADE_CHECK_FAILED_ON_PROPERTY_ID, prerequisiteCheck.getFailedOn(), requestedIds);
                PreUpgradeCheckResourceProvider.setResourceProperty(resource, UPGRADE_CHECK_FAILED_DETAIL_PROPERTY_ID, prerequisiteCheck.getFailedDetail(), requestedIds);
                PreUpgradeCheckResourceProvider.setResourceProperty(resource, UPGRADE_CHECK_CHECK_TYPE_PROPERTY_ID, prerequisiteCheck.getType(), requestedIds);
                PreUpgradeCheckResourceProvider.setResourceProperty(resource, UPGRADE_CHECK_CLUSTER_NAME_PROPERTY_ID, cluster.getClusterName(), requestedIds);
                PreUpgradeCheckResourceProvider.setResourceProperty(resource, UPGRADE_CHECK_UPGRADE_TYPE_PROPERTY_ID, upgradeType, requestedIds);
                PreUpgradeCheckResourceProvider.setResourceProperty(resource, UPGRADE_CHECK_TARGET_REPOSITORY_VERSION_ID_ID, repositoryVersion.getId(), requestedIds);
                PreUpgradeCheckResourceProvider.setResourceProperty(resource, UPGRADE_CHECK_TARGET_REPOSITORY_VERSION, repositoryVersion.getVersion(), requestedIds);
                resources.add(resource);
            }
        }
        return resources;
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return pkPropertyIds;
    }

    static {
        pkPropertyIds = Collections.singleton(UPGRADE_CHECK_ID_PROPERTY_ID);
        propertyIds = ImmutableSet.of((Object)UPGRADE_CHECK_ID_PROPERTY_ID, (Object)UPGRADE_CHECK_CHECK_PROPERTY_ID, (Object)UPGRADE_CHECK_STATUS_PROPERTY_ID, (Object)UPGRADE_CHECK_REASON_PROPERTY_ID, (Object)UPGRADE_CHECK_FAILED_ON_PROPERTY_ID, (Object)UPGRADE_CHECK_FAILED_DETAIL_PROPERTY_ID, (Object[])new String[]{UPGRADE_CHECK_CHECK_TYPE_PROPERTY_ID, UPGRADE_CHECK_CLUSTER_NAME_PROPERTY_ID, UPGRADE_CHECK_UPGRADE_TYPE_PROPERTY_ID, UPGRADE_CHECK_FOR_REVERT_PROPERTY_ID, UPGRADE_CHECK_TARGET_REPOSITORY_VERSION_ID_ID, UPGRADE_CHECK_UPGRADE_PACK_PROPERTY_ID});
        keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.PreUpgradeCheck, (Object)UPGRADE_CHECK_ID_PROPERTY_ID).put((Object)Resource.Type.Cluster, (Object)UPGRADE_CHECK_CLUSTER_NAME_PROPERTY_ID).build();
    }
}

