/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.orm.dao.PermissionDAO;
import id.onyx.obdp.server.orm.entities.PermissionEntity;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PermissionResourceProvider
extends AbstractResourceProvider {
    private static PermissionDAO permissionDAO;
    public static final String PERMISSION_ID_PROPERTY_ID = "PermissionInfo/permission_id";
    public static final String PERMISSION_NAME_PROPERTY_ID = "PermissionInfo/permission_name";
    public static final String PERMISSION_LABEL_PROPERTY_ID = "PermissionInfo/permission_label";
    public static final String RESOURCE_NAME_PROPERTY_ID = "PermissionInfo/resource_name";
    public static final String SORT_ORDER_PROPERTY_ID = "PermissionInfo/sort_order";
    private static final Map<Resource.Type, String> keyPropertyIds;
    private static final Set<String> propertyIds;

    public PermissionResourceProvider() {
        super(propertyIds, keyPropertyIds);
    }

    public static void init(PermissionDAO dao) {
        permissionDAO = dao;
    }

    @Override
    public RequestStatus createResources(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        HashSet<Resource> resources = new HashSet<Resource>();
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        for (PermissionEntity permissionEntity : permissionDAO.findAll()) {
            resources.add(this.toResource(permissionEntity, requestedIds));
        }
        return resources;
    }

    @Override
    public RequestStatus updateResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public RequestStatus deleteResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public Map<Resource.Type, String> getKeyPropertyIds() {
        return keyPropertyIds;
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return new HashSet<String>(keyPropertyIds.values());
    }

    private Resource toResource(PermissionEntity entity, Set<String> requestedIds) {
        ResourceImpl resource = new ResourceImpl(Resource.Type.Permission);
        PermissionResourceProvider.setResourceProperty(resource, PERMISSION_ID_PROPERTY_ID, entity.getId(), requestedIds);
        PermissionResourceProvider.setResourceProperty(resource, PERMISSION_NAME_PROPERTY_ID, entity.getPermissionName(), requestedIds);
        PermissionResourceProvider.setResourceProperty(resource, PERMISSION_LABEL_PROPERTY_ID, entity.getPermissionLabel(), requestedIds);
        PermissionResourceProvider.setResourceProperty(resource, RESOURCE_NAME_PROPERTY_ID, entity.getResourceType().getName(), requestedIds);
        PermissionResourceProvider.setResourceProperty(resource, SORT_ORDER_PROPERTY_ID, entity.getSortOrder(), requestedIds);
        return resource;
    }

    static {
        keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.Permission, (Object)PERMISSION_ID_PROPERTY_ID).build();
        propertyIds = Sets.newHashSet((Object[])new String[]{PERMISSION_ID_PROPERTY_ID, PERMISSION_NAME_PROPERTY_ID, PERMISSION_LABEL_PROPERTY_ID, RESOURCE_NAME_PROPERTY_ID, SORT_ORDER_PROPERTY_ID});
    }
}

