/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.metrics.MetricHostProvider;
import id.onyx.obdp.server.controller.metrics.MetricsServiceProvider;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.state.ConfigHelper;
import id.onyx.obdp.server.state.kerberos.VariableReplacementHelper;
import java.net.URI;
import java.util.Map;
import java.util.Optional;

public class OverriddenMetricsHostProvider
implements MetricHostProvider {
    private final Map<String, String> overriddenHosts;
    private final MetricHostProvider metricHostProvider;
    private final ConfigHelper configHelper;
    private final VariableReplacementHelper variableReplacer = new VariableReplacementHelper();

    public OverriddenMetricsHostProvider(Map<String, String> overriddenHosts, MetricHostProvider metricHostProvider, ConfigHelper configHelper) {
        this.overriddenHosts = overriddenHosts;
        this.metricHostProvider = metricHostProvider;
        this.configHelper = configHelper;
    }

    @Override
    public Optional<String> getExternalHostName(String clusterName, String componentName) {
        return this.getOverriddenHost(componentName).map(host -> this.replaceVariables(clusterName, (String)host));
    }

    @Override
    public boolean isCollectorHostExternal(String clusterName) {
        return this.metricHostProvider.isCollectorHostExternal(clusterName);
    }

    private Optional<String> getOverriddenHost(String componentName) {
        return Optional.ofNullable(this.overriddenHosts.get(componentName));
    }

    private String replaceVariables(String clusterName, String hostName) {
        try {
            return this.hostName(this.variableReplacer.replaceVariables(hostName, this.config(clusterName)));
        }
        catch (OBDPException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, Map<String, String>> config(String clusterName) throws OBDPException {
        return this.configHelper.getEffectiveConfigProperties(clusterName, null);
    }

    private String hostName(String resolvedHost) throws OBDPException {
        return this.hasScheme(resolvedHost) ? URI.create(resolvedHost).getHost() : URI.create("any://" + resolvedHost).getHost();
    }

    private boolean hasScheme(String host) {
        return host.contains("://");
    }

    @Override
    public String getHostName(String clusterName, String componentName) throws SystemException {
        return this.metricHostProvider.getHostName(clusterName, componentName);
    }

    @Override
    public String getCollectorHostName(String clusterName, MetricsServiceProvider.MetricsService service) throws SystemException {
        return this.metricHostProvider.getCollectorHostName(clusterName, service);
    }

    @Override
    public String getCollectorPort(String clusterName, MetricsServiceProvider.MetricsService service) throws SystemException {
        return this.metricHostProvider.getCollectorPort(clusterName, service);
    }

    @Override
    public boolean isCollectorHostLive(String clusterName, MetricsServiceProvider.MetricsService service) throws SystemException {
        return this.metricHostProvider.isCollectorHostLive(clusterName, service);
    }

    @Override
    public boolean isCollectorComponentLive(String clusterName, MetricsServiceProvider.MetricsService service) throws SystemException {
        return this.metricHostProvider.isCollectorComponentLive(clusterName, service);
    }
}

