/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.OperatingSystemRequest;
import id.onyx.obdp.server.controller.OperatingSystemResponse;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.ReadOnlyResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class OperatingSystemResourceProvider
extends ReadOnlyResourceProvider {
    public static final String OPERATING_SYSTEM_STACK_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("OperatingSystems", "stack_name");
    public static final String OPERATING_SYSTEM_STACK_VERSION_PROPERTY_ID = PropertyHelper.getPropertyId("OperatingSystems", "stack_version");
    public static final String OPERATING_SYSTEM_OS_TYPE_PROPERTY_ID = PropertyHelper.getPropertyId("OperatingSystems", "os_type");
    public static final String OPERATING_SYSTEM_REPOSITORY_VERSION_ID_PROPERTY_ID = PropertyHelper.getPropertyId("OperatingSystems", "repository_version_id");
    public static final String OPERATING_SYSTEM_VERSION_DEFINITION_ID_PROPERTY_ID = PropertyHelper.getPropertyId("OperatingSystems", "version_definition_id");
    public static final String OPERATING_SYSTEM_OBDP_MANAGED_REPOS = "OperatingSystems/ambari_managed_repositories";
    private static final Set<String> pkPropertyIds = ImmutableSet.of((Object)OPERATING_SYSTEM_OS_TYPE_PROPERTY_ID, (Object)OPERATING_SYSTEM_STACK_NAME_PROPERTY_ID, (Object)OPERATING_SYSTEM_STACK_VERSION_PROPERTY_ID);
    public static final Set<String> propertyIds = ImmutableSet.of((Object)OPERATING_SYSTEM_OS_TYPE_PROPERTY_ID, (Object)OPERATING_SYSTEM_STACK_NAME_PROPERTY_ID, (Object)OPERATING_SYSTEM_STACK_VERSION_PROPERTY_ID, (Object)OPERATING_SYSTEM_REPOSITORY_VERSION_ID_PROPERTY_ID, (Object)OPERATING_SYSTEM_VERSION_DEFINITION_ID_PROPERTY_ID, (Object)"OperatingSystems/ambari_managed_repositories", (Object[])new String[0]);
    public static final Map<Resource.Type, String> keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.OperatingSystem, (Object)OPERATING_SYSTEM_OS_TYPE_PROPERTY_ID).put((Object)Resource.Type.Stack, (Object)OPERATING_SYSTEM_STACK_NAME_PROPERTY_ID).put((Object)Resource.Type.StackVersion, (Object)OPERATING_SYSTEM_STACK_VERSION_PROPERTY_ID).put((Object)Resource.Type.RepositoryVersion, (Object)OPERATING_SYSTEM_REPOSITORY_VERSION_ID_PROPERTY_ID).put((Object)Resource.Type.CompatibleRepositoryVersion, (Object)OPERATING_SYSTEM_REPOSITORY_VERSION_ID_PROPERTY_ID).put((Object)Resource.Type.VersionDefinition, (Object)OPERATING_SYSTEM_VERSION_DEFINITION_ID_PROPERTY_ID).build();

    protected OperatingSystemResourceProvider(OBDPManagementController managementController) {
        super(Resource.Type.OperatingSystem, propertyIds, keyPropertyIds, managementController);
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        final HashSet<OperatingSystemRequest> requests = new HashSet<OperatingSystemRequest>();
        if (predicate == null) {
            requests.add(this.getRequest(Collections.emptyMap()));
        } else {
            for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
                requests.add(this.getRequest(propertyMap));
            }
        }
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        Set<OperatingSystemResponse> responses = this.getResources(new AbstractResourceProvider.Command<Set<OperatingSystemResponse>>(){

            @Override
            public Set<OperatingSystemResponse> invoke() throws OBDPException {
                return OperatingSystemResourceProvider.this.getManagementController().getOperatingSystems(requests);
            }
        });
        HashSet<Resource> resources = new HashSet<Resource>();
        for (OperatingSystemResponse response : responses) {
            ResourceImpl resource = new ResourceImpl(Resource.Type.OperatingSystem);
            OperatingSystemResourceProvider.setResourceProperty(resource, OPERATING_SYSTEM_STACK_NAME_PROPERTY_ID, response.getStackName(), requestedIds);
            OperatingSystemResourceProvider.setResourceProperty(resource, OPERATING_SYSTEM_STACK_VERSION_PROPERTY_ID, response.getStackVersion(), requestedIds);
            OperatingSystemResourceProvider.setResourceProperty(resource, OPERATING_SYSTEM_OS_TYPE_PROPERTY_ID, response.getOsType(), requestedIds);
            OperatingSystemResourceProvider.setResourceProperty(resource, OPERATING_SYSTEM_OBDP_MANAGED_REPOS, response.isAmbariManagedRepos(), requestedIds);
            if (response.getRepositoryVersionId() != null) {
                OperatingSystemResourceProvider.setResourceProperty(resource, OPERATING_SYSTEM_REPOSITORY_VERSION_ID_PROPERTY_ID, response.getRepositoryVersionId(), requestedIds);
            }
            if (response.getVersionDefinitionId() != null) {
                OperatingSystemResourceProvider.setResourceProperty(resource, OPERATING_SYSTEM_VERSION_DEFINITION_ID_PROPERTY_ID, response.getVersionDefinitionId(), requestedIds);
            }
            resources.add(resource);
        }
        return resources;
    }

    private OperatingSystemRequest getRequest(Map<String, Object> properties) {
        OperatingSystemRequest request = new OperatingSystemRequest((String)properties.get(OPERATING_SYSTEM_STACK_NAME_PROPERTY_ID), (String)properties.get(OPERATING_SYSTEM_STACK_VERSION_PROPERTY_ID), (String)properties.get(OPERATING_SYSTEM_OS_TYPE_PROPERTY_ID));
        if (properties.containsKey(OPERATING_SYSTEM_REPOSITORY_VERSION_ID_PROPERTY_ID)) {
            request.setRepositoryVersionId(Long.parseLong(properties.get(OPERATING_SYSTEM_REPOSITORY_VERSION_ID_PROPERTY_ID).toString()));
        }
        if (properties.containsKey(OPERATING_SYSTEM_VERSION_DEFINITION_ID_PROPERTY_ID)) {
            request.setVersionDefinitionId(properties.get(OPERATING_SYSTEM_VERSION_DEFINITION_ID_PROPERTY_ID).toString());
        }
        return request;
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return pkPropertyIds;
    }
}

