/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.api.services.stackadvisor.StackAdvisorException;
import id.onyx.obdp.server.api.services.stackadvisor.StackAdvisorHelper;
import id.onyx.obdp.server.api.services.stackadvisor.StackAdvisorRequest;
import id.onyx.obdp.server.api.services.stackadvisor.recommendations.RecommendationResponse;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.internal.OBDPServerConfigurationHandler;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import id.onyx.obdp.server.orm.dao.OBDPConfigurationDAO;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.ConfigHelper;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.ValueAttributesInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OBDPServerStackAdvisorAwareConfigurationHandler
extends OBDPServerConfigurationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(OBDPServerStackAdvisorAwareConfigurationHandler.class);
    private final Clusters clusters;
    private final ConfigHelper configHelper;
    private final OBDPManagementController managementController;
    private final StackAdvisorHelper stackAdvisorHelper;

    OBDPServerStackAdvisorAwareConfigurationHandler(OBDPConfigurationDAO ambariConfigurationDAO, OBDPEventPublisher publisher, Clusters clusters, ConfigHelper configHelper, OBDPManagementController managementController, StackAdvisorHelper stackAdvisorHelper) {
        super(ambariConfigurationDAO, publisher);
        this.clusters = clusters;
        this.configHelper = configHelper;
        this.managementController = managementController;
        this.stackAdvisorHelper = stackAdvisorHelper;
    }

    protected void processClusters(StackAdvisorRequest.StackAdvisorRequestType stackAdvisorRequestType) {
        Map<String, Cluster> clusterMap = this.clusters.getClusters();
        if (clusterMap != null) {
            for (Cluster cluster : clusterMap.values()) {
                try {
                    LOGGER.info("Managing the {} configuration for the cluster named '{}'", (Object)stackAdvisorRequestType.toString(), (Object)cluster.getClusterName());
                    this.processCluster(cluster, stackAdvisorRequestType);
                }
                catch (OBDPException | StackAdvisorException e) {
                    LOGGER.warn("Failed to update the {} for the cluster named '{}': ", new Object[]{stackAdvisorRequestType.toString(), cluster.getClusterName(), e});
                }
            }
        }
    }

    protected void processCluster(Cluster cluster, StackAdvisorRequest.StackAdvisorRequestType stackAdvisorRequestType) throws OBDPException, StackAdvisorException {
        Map<String, RecommendationResponse.BlueprintConfigurations> configurations;
        StackId stackVersion = cluster.getCurrentStackVersion();
        List<String> hosts = cluster.getHosts().stream().map(Host::getHostName).collect(Collectors.toList());
        Set<String> serviceNames = cluster.getServices().values().stream().map(Service::getName).collect(Collectors.toSet());
        StackAdvisorRequest request = StackAdvisorRequest.StackAdvisorRequestBuilder.forStack(stackVersion.getStackName(), stackVersion.getStackVersion()).ofType(stackAdvisorRequestType).forHosts(hosts).forServices(serviceNames).withComponentHostsMap(cluster.getServiceComponentHostMap(null, null)).withConfigurations(this.calculateExistingConfigurations(cluster)).build();
        RecommendationResponse response = this.stackAdvisorHelper.recommend(request);
        RecommendationResponse.Recommendation recommendation = response == null ? null : response.getRecommendations();
        RecommendationResponse.Blueprint blueprint = recommendation == null ? null : recommendation.getBlueprint();
        Map<String, RecommendationResponse.BlueprintConfigurations> map = configurations = blueprint == null ? null : blueprint.getConfigurations();
        if (configurations != null) {
            for (Map.Entry<String, RecommendationResponse.BlueprintConfigurations> configuration : configurations.entrySet()) {
                this.processConfigurationType(cluster, configuration.getKey(), configuration.getValue());
            }
        }
    }

    private void processConfigurationType(Cluster cluster, String configType, RecommendationResponse.BlueprintConfigurations configurations) throws OBDPException {
        Map<String, ValueAttributesInfo> recommendedConfigPropertyAttributes;
        HashMap<String, String> updates = new HashMap<String, String>();
        HashSet<String> removals = new HashSet<String>();
        Map<String, String> recommendedConfigProperties = configurations.getProperties();
        if (recommendedConfigProperties != null) {
            updates.putAll(recommendedConfigProperties);
        }
        if ((recommendedConfigPropertyAttributes = configurations.getPropertyAttributes()) != null) {
            for (Map.Entry<String, ValueAttributesInfo> entry : recommendedConfigPropertyAttributes.entrySet()) {
                ValueAttributesInfo info = entry.getValue();
                if (info == null || !"true".equalsIgnoreCase(info.getDelete())) continue;
                updates.remove(entry.getKey());
                removals.add(entry.getKey());
            }
        }
        this.configHelper.updateConfigType(cluster, cluster.getCurrentStackVersion(), this.managementController, configType, updates, removals, "internal", this.getServiceVersionNote());
    }

    protected String getServiceVersionNote() {
        return "Ambari-managed configuration change";
    }

    private Map<String, Map<String, Map<String, String>>> calculateExistingConfigurations(Cluster cluster) throws OBDPException {
        Map<String, Map<String, String>> configurationTags = this.configHelper.getEffectiveDesiredTags(cluster, null);
        Map<String, Map<String, String>> effectiveConfigs = this.configHelper.getEffectiveConfigProperties(cluster, configurationTags);
        HashMap<String, Map<String, Map<String, String>>> requestConfigurations = new HashMap<String, Map<String, Map<String, String>>>();
        if (effectiveConfigs != null) {
            for (Map.Entry<String, Map<String, String>> configuration : effectiveConfigs.entrySet()) {
                HashMap<String, HashMap<String, String>> properties = new HashMap<String, HashMap<String, String>>();
                String configType = configuration.getKey();
                HashMap<String, String> configurationProperties = new HashMap<String, String>(configuration.getValue());
                properties.put("properties", configurationProperties);
                requestConfigurations.put(configType, properties);
            }
        }
        return requestConfigurations;
    }
}

