/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.api.services.stackadvisor.StackAdvisorHelper;
import id.onyx.obdp.server.api.services.stackadvisor.StackAdvisorRequest;
import id.onyx.obdp.server.configuration.OBDPServerConfigurationCategory;
import id.onyx.obdp.server.configuration.OBDPServerConfigurationKey;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.internal.OBDPServerStackAdvisorAwareConfigurationHandler;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import id.onyx.obdp.server.orm.dao.OBDPConfigurationDAO;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.ConfigHelper;
import java.util.Map;
import java.util.Set;

@Singleton
public class OBDPServerSSOConfigurationHandler
extends OBDPServerStackAdvisorAwareConfigurationHandler {
    @Inject
    public OBDPServerSSOConfigurationHandler(Clusters clusters, ConfigHelper configHelper, OBDPManagementController managementController, StackAdvisorHelper stackAdvisorHelper, OBDPConfigurationDAO ambariConfigurationDAO, OBDPEventPublisher publisher) {
        super(ambariConfigurationDAO, publisher, clusters, configHelper, managementController, stackAdvisorHelper);
    }

    @Override
    public void updateComponentCategory(String categoryName, Map<String, String> properties, boolean removePropertiesIfNotSpecified) throws OBDPException {
        boolean manageSSOConfigurations;
        super.updateComponentCategory(categoryName, properties, removePropertiesIfNotSpecified);
        Map<String, String> ssoProperties = this.getConfigurationProperties(OBDPServerConfigurationCategory.SSO_CONFIGURATION.getCategoryName());
        boolean bl = manageSSOConfigurations = ssoProperties != null && "true".equalsIgnoreCase(ssoProperties.get(OBDPServerConfigurationKey.SSO_MANAGE_SERVICES.key()));
        if (manageSSOConfigurations) {
            this.processClusters(StackAdvisorRequest.StackAdvisorRequestType.SSO_CONFIGURATIONS);
        }
    }

    public Set<String> getSSOEnabledServices() {
        return this.getEnabledServices(OBDPServerConfigurationCategory.SSO_CONFIGURATION.getCategoryName(), OBDPServerConfigurationKey.SSO_MANAGE_SERVICES.key(), OBDPServerConfigurationKey.SSO_ENABLED_SERVICES.key());
    }

    @Override
    protected String getServiceVersionNote() {
        return "Ambari-managed single sign-on configurations";
    }
}

