/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.api.services.stackadvisor.StackAdvisorHelper;
import id.onyx.obdp.server.api.services.stackadvisor.StackAdvisorRequest;
import id.onyx.obdp.server.configuration.OBDPServerConfiguration;
import id.onyx.obdp.server.configuration.OBDPServerConfigurationCategory;
import id.onyx.obdp.server.configuration.OBDPServerConfigurationKey;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.internal.OBDPServerStackAdvisorAwareConfigurationHandler;
import id.onyx.obdp.server.controller.internal.RootServiceComponentConfigurationHandler;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import id.onyx.obdp.server.ldap.domain.OBDPLdapConfiguration;
import id.onyx.obdp.server.ldap.service.AmbariLdapException;
import id.onyx.obdp.server.ldap.service.LdapFacade;
import id.onyx.obdp.server.orm.dao.OBDPConfigurationDAO;
import id.onyx.obdp.server.security.encryption.Encryptor;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.ConfigHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class OBDPServerLDAPConfigurationHandler
extends OBDPServerStackAdvisorAwareConfigurationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(OBDPServerLDAPConfigurationHandler.class);
    private final LdapFacade ldapFacade;
    private final Encryptor<OBDPServerConfiguration> encryptor;

    @Inject
    OBDPServerLDAPConfigurationHandler(Clusters clusters, ConfigHelper configHelper, OBDPManagementController managementController, StackAdvisorHelper stackAdvisorHelper, OBDPConfigurationDAO ambariConfigurationDAO, OBDPEventPublisher publisher, LdapFacade ldapFacade, @Named(value="OBDPServerConfigurationEncryptor") Encryptor<OBDPServerConfiguration> encryptor) {
        super(ambariConfigurationDAO, publisher, clusters, configHelper, managementController, stackAdvisorHelper);
        this.ldapFacade = ldapFacade;
        this.encryptor = encryptor;
    }

    @Override
    public void updateComponentCategory(String categoryName, Map<String, String> properties, boolean removePropertiesIfNotSpecified) throws OBDPException {
        OBDPLdapConfiguration ldapConfiguration = new OBDPLdapConfiguration(properties);
        this.encryptor.encryptSensitiveData(ldapConfiguration);
        super.updateComponentCategory(categoryName, ldapConfiguration.toMap(), removePropertiesIfNotSpecified);
        if (ldapConfiguration.isAmbariManagesLdapConfiguration()) {
            this.processClusters(StackAdvisorRequest.StackAdvisorRequestType.LDAP_CONFIGURATIONS);
        }
    }

    public Set<String> getLDAPEnabledServices() {
        return this.getEnabledServices(OBDPServerConfigurationCategory.LDAP_CONFIGURATION.getCategoryName(), OBDPServerConfigurationKey.AMBARI_MANAGES_LDAP_CONFIGURATION.key(), OBDPServerConfigurationKey.LDAP_ENABLED_SERVICES.key());
    }

    @Override
    public RootServiceComponentConfigurationHandler.OperationResult performOperation(String categoryName, Map<String, String> properties, boolean mergeExistingProperties, String operation, Map<String, Object> operationParameters) throws SystemException {
        Map<String, String> _ldapProperties;
        OperationType operationType;
        if (!OBDPServerConfigurationCategory.LDAP_CONFIGURATION.getCategoryName().equals(categoryName)) {
            throw new SystemException(String.format("Unexpected category name for Ambari server LDAP properties: %s", categoryName));
        }
        try {
            operationType = OperationType.translate(operation);
        }
        catch (IllegalArgumentException e) {
            throw new SystemException(String.format("The requested operation is not supported for this category: %s", categoryName), e);
        }
        HashMap<String, String> ldapConfigurationProperties = new HashMap<String, String>();
        if (mergeExistingProperties && (_ldapProperties = this.getConfigurationProperties(categoryName)) != null) {
            ldapConfigurationProperties.putAll(_ldapProperties);
        }
        if (properties != null) {
            ldapConfigurationProperties.putAll(properties);
        }
        OBDPLdapConfiguration ambariLdapConfiguration = new OBDPLdapConfiguration(ldapConfigurationProperties);
        boolean success = true;
        String message = null;
        Map<String, Object> resultData = null;
        try {
            switch (operationType) {
                case TEST_CONNECTION: {
                    LOGGER.debug("Testing connection to the LDAP server ...");
                    this.ldapFacade.checkConnection(ambariLdapConfiguration);
                    break;
                }
                case TEST_ATTRIBUTES: {
                    LOGGER.debug("Testing LDAP attributes ....");
                    Set<String> groups = this.ldapFacade.checkLdapAttributes(operationParameters, ambariLdapConfiguration);
                    resultData = Collections.singletonMap("groups", groups);
                    break;
                }
                case DETECT_ATTRIBUTES: {
                    LOGGER.info("Detecting LDAP attributes ...");
                    ambariLdapConfiguration = this.ldapFacade.detectAttributes(ambariLdapConfiguration);
                    resultData = Collections.singletonMap("attributes", ambariLdapConfiguration.toMap());
                    break;
                }
                default: {
                    LOGGER.warn("No action provided ...");
                    throw new IllegalArgumentException("No request action provided");
                }
            }
        }
        catch (AmbariLdapException e) {
            success = false;
            message = this.determineCause(e);
            if (StringUtils.isEmpty((String)message)) {
                message = "An unexpected error has occurred.";
            }
            LOGGER.warn(String.format("Failed to perform %s: %s", operationType.name(), message), (Throwable)e);
        }
        return new RootServiceComponentConfigurationHandler.OperationResult(this, operationType.getOperation(), success, message, resultData);
    }

    private String determineCause(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        Throwable cause = throwable.getCause();
        if (cause == null || cause == throwable) {
            return throwable.getMessage();
        }
        String message = this.determineCause(cause);
        return message == null ? throwable.getMessage() : message;
    }

    @Override
    protected String getServiceVersionNote() {
        return "Ambari managed LDAP configurations";
    }

    static enum OperationType {
        TEST_CONNECTION("test-connection"),
        TEST_ATTRIBUTES("test-attributes"),
        DETECT_ATTRIBUTES("detect-attributes");

        private final String operation;

        private OperationType(String operation) {
            this.operation = operation;
        }

        public String getOperation() {
            return this.operation;
        }

        public static OperationType translate(String operation) {
            if (!StringUtils.isEmpty((String)operation)) {
                operation = operation.trim();
                for (OperationType category : OperationType.values()) {
                    if (!category.getOperation().equals(operation)) continue;
                    return category;
                }
            }
            throw new IllegalArgumentException(String.format("Invalid operation for %s: %s", OBDPServerConfigurationCategory.LDAP_CONFIGURATION.getCategoryName(), operation));
        }

        public static String translate(OperationType operation) {
            return operation == null ? null : operation.getOperation();
        }
    }
}

