/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import id.onyx.obdp.server.configuration.ConfigurationPropertyType;
import id.onyx.obdp.server.configuration.OBDPServerConfigurationCategory;
import id.onyx.obdp.server.configuration.OBDPServerConfigurationKey;

public class OBDPServerConfigurationUtils {
    public static OBDPServerConfigurationKey getConfigurationKey(String category, String propertyName) {
        return OBDPServerConfigurationUtils.getConfigurationKey(OBDPServerConfigurationCategory.translate(category), propertyName);
    }

    public static OBDPServerConfigurationKey getConfigurationKey(OBDPServerConfigurationCategory category, String propertyName) {
        return OBDPServerConfigurationKey.translate(category, propertyName);
    }

    public static ConfigurationPropertyType getConfigurationPropertyType(String category, String propertyName) {
        return OBDPServerConfigurationUtils.getConfigurationPropertyType(OBDPServerConfigurationUtils.getConfigurationKey(category, propertyName));
    }

    public static ConfigurationPropertyType getConfigurationPropertyType(OBDPServerConfigurationCategory category, String propertyName) {
        return OBDPServerConfigurationUtils.getConfigurationPropertyType(OBDPServerConfigurationUtils.getConfigurationKey(category, propertyName));
    }

    private static ConfigurationPropertyType getConfigurationPropertyType(OBDPServerConfigurationKey configurationKey) {
        return configurationKey == null ? ConfigurationPropertyType.UNKNOWN : configurationKey.getConfigurationPropertyType();
    }

    public static String getConfigurationPropertyTypeName(OBDPServerConfigurationCategory category, String propertyName) {
        ConfigurationPropertyType configurationPropertyType = OBDPServerConfigurationUtils.getConfigurationPropertyType(category, propertyName);
        return configurationPropertyType == null ? null : configurationPropertyType.name();
    }

    public static String getConfigurationPropertyTypeName(String category, String propertyName) {
        ConfigurationPropertyType configurationPropertyType = OBDPServerConfigurationUtils.getConfigurationPropertyType(category, propertyName);
        return configurationPropertyType == null ? null : configurationPropertyType.name();
    }

    public static boolean isPassword(String category, String propertyName) {
        return OBDPServerConfigurationUtils.isPassword(OBDPServerConfigurationUtils.getConfigurationKey(category, propertyName));
    }

    public static boolean isPassword(OBDPServerConfigurationCategory category, String propertyName) {
        return OBDPServerConfigurationUtils.isPassword(OBDPServerConfigurationUtils.getConfigurationKey(category, propertyName));
    }

    public static boolean isPassword(OBDPServerConfigurationKey configurationKey) {
        return ConfigurationPropertyType.PASSWORD.equals((Object)OBDPServerConfigurationUtils.getConfigurationPropertyType(configurationKey));
    }
}

