/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.api.services.RootServiceComponentConfiguration;
import id.onyx.obdp.server.controller.internal.OBDPServerConfigurationUtils;
import id.onyx.obdp.server.controller.internal.RootServiceComponentConfigurationHandler;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.events.OBDPConfigurationChangedEvent;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import id.onyx.obdp.server.orm.dao.OBDPConfigurationDAO;
import id.onyx.obdp.server.orm.entities.OBDPConfigurationEntity;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class OBDPServerConfigurationHandler
extends RootServiceComponentConfigurationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(OBDPServerConfigurationHandler.class);
    private final OBDPConfigurationDAO ambariConfigurationDAO;
    private final OBDPEventPublisher publisher;

    @Inject
    OBDPServerConfigurationHandler(OBDPConfigurationDAO ambariConfigurationDAO, OBDPEventPublisher publisher) {
        this.ambariConfigurationDAO = ambariConfigurationDAO;
        this.publisher = publisher;
    }

    @Override
    public Map<String, RootServiceComponentConfiguration> getComponentConfigurations(String categoryName) {
        List<Object> entities;
        HashMap<String, RootServiceComponentConfiguration> configurations = null;
        List<Object> list = entities = categoryName == null ? this.ambariConfigurationDAO.findAll() : this.ambariConfigurationDAO.findByCategory(categoryName);
        if (entities != null) {
            configurations = new HashMap<String, RootServiceComponentConfiguration>();
            for (OBDPConfigurationEntity oBDPConfigurationEntity : entities) {
                String category = oBDPConfigurationEntity.getCategoryName();
                RootServiceComponentConfiguration configuration = (RootServiceComponentConfiguration)configurations.get(category);
                if (configuration == null) {
                    configuration = new RootServiceComponentConfiguration();
                    configurations.put(category, configuration);
                }
                configuration.addProperty(oBDPConfigurationEntity.getPropertyName(), oBDPConfigurationEntity.getPropertyValue());
                if (categoryName == null) continue;
                configuration.addPropertyType(oBDPConfigurationEntity.getPropertyName(), OBDPServerConfigurationUtils.getConfigurationPropertyTypeName(categoryName, oBDPConfigurationEntity.getPropertyName()));
            }
        }
        return configurations;
    }

    @Override
    public void removeComponentConfiguration(String categoryName) {
        if (null == categoryName) {
            LOGGER.debug("No resource id provided in the request");
        } else {
            LOGGER.debug("Deleting Ambari configuration with id: {}", (Object)categoryName);
            if (this.ambariConfigurationDAO.removeByCategory(categoryName) > 0) {
                this.publisher.publish(new OBDPConfigurationChangedEvent(categoryName));
            }
        }
    }

    @Override
    public void updateComponentCategory(String categoryName, Map<String, String> properties, boolean removePropertiesIfNotSpecified) throws OBDPException {
        boolean toBePublished;
        this.validateProperties(categoryName, properties);
        boolean bl = toBePublished = properties.isEmpty() ? false : this.ambariConfigurationDAO.reconcileCategory(categoryName, properties, removePropertiesIfNotSpecified);
        if (toBePublished) {
            this.publisher.publish(new OBDPConfigurationChangedEvent(categoryName));
        }
    }

    private void validateProperties(String categoryName, Map<String, String> properties) {
        for (String key : properties.keySet()) {
            if (OBDPServerConfigurationUtils.getConfigurationKey(categoryName, key) != null) continue;
            throw new IllegalArgumentException(String.format("Invalid Ambari server configuration key: %s:%s", categoryName, key));
        }
    }

    @Override
    public RootServiceComponentConfigurationHandler.OperationResult performOperation(String categoryName, Map<String, String> properties, boolean mergeExistingProperties, String operation, Map<String, Object> operationParameters) throws SystemException {
        throw new SystemException(String.format("The requested operation is not supported for this category: %s", categoryName));
    }

    public Map<String, Map<String, String>> getConfigurations() {
        HashMap<String, Map<String, String>> configurations = new HashMap<String, Map<String, String>>();
        List entities = this.ambariConfigurationDAO.findAll();
        if (entities != null) {
            for (OBDPConfigurationEntity entity : entities) {
                String category = entity.getCategoryName();
                Map configuration = configurations.computeIfAbsent(category, k -> new HashMap());
                configuration.put(entity.getPropertyName(), entity.getPropertyValue());
            }
        }
        return configurations;
    }

    public Map<String, String> getConfigurationProperties(String categoryName) {
        HashMap<String, String> properties = null;
        List<OBDPConfigurationEntity> entities = this.ambariConfigurationDAO.findByCategory(categoryName);
        if (entities != null) {
            properties = new HashMap<String, String>();
            for (OBDPConfigurationEntity entity : entities) {
                properties.put(entity.getPropertyName(), entity.getPropertyValue());
            }
        }
        return properties;
    }

    protected Set<String> getEnabledServices(String categoryName, String manageServicesConfigurationPropertyName, String enabledServicesPropertyName) {
        String enabledServices;
        Map<String, String> configurationProperties = this.getConfigurationProperties(categoryName);
        boolean manageConfigurations = StringUtils.isNotBlank((CharSequence)manageServicesConfigurationPropertyName) && "true".equalsIgnoreCase(configurationProperties.get(manageServicesConfigurationPropertyName));
        String string = enabledServices = manageConfigurations ? configurationProperties.get(enabledServicesPropertyName) : null;
        if (StringUtils.isEmpty((CharSequence)enabledServices)) {
            return Collections.emptySet();
        }
        return Arrays.stream(enabledServices.split(",")).map(String::trim).map(String::toUpperCase).collect(Collectors.toSet());
    }
}

