/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import id.onyx.obdp.server.controller.internal.PrivilegeResourceProvider;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.orm.dao.ClusterDAO;
import id.onyx.obdp.server.orm.entities.ClusterEntity;
import id.onyx.obdp.server.orm.entities.GroupEntity;
import id.onyx.obdp.server.orm.entities.PermissionEntity;
import id.onyx.obdp.server.orm.entities.PrivilegeEntity;
import id.onyx.obdp.server.orm.entities.ResourceEntity;
import id.onyx.obdp.server.orm.entities.ResourceTypeEntity;
import id.onyx.obdp.server.orm.entities.UserEntity;
import id.onyx.obdp.server.orm.entities.ViewEntity;
import id.onyx.obdp.server.orm.entities.ViewInstanceEntity;
import id.onyx.obdp.server.security.authorization.ResourceType;
import id.onyx.obdp.server.security.authorization.RoleAuthorization;
import id.onyx.obdp.server.view.ViewRegistry;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OBDPPrivilegeResourceProvider
extends PrivilegeResourceProvider<Object> {
    public static final String TYPE = "PrivilegeInfo/type";
    protected static ClusterDAO clusterDAO;
    private static final Set<String> propertyIds;
    private static final Map<Resource.Type, String> keyPropertyIds;

    public OBDPPrivilegeResourceProvider() {
        super(propertyIds, keyPropertyIds, Resource.Type.AmbariPrivilege);
        EnumSet<RoleAuthorization> requiredAuthorizations = EnumSet.of(RoleAuthorization.OBDP_ASSIGN_ROLES);
        this.setRequiredCreateAuthorizations(requiredAuthorizations);
        this.setRequiredDeleteAuthorizations(requiredAuthorizations);
        this.setRequiredGetAuthorizations(requiredAuthorizations);
        this.setRequiredUpdateAuthorizations(requiredAuthorizations);
    }

    public static void init(ClusterDAO clusterDao) {
        clusterDAO = clusterDao;
    }

    @Override
    public Map<Resource.Type, String> getKeyPropertyIds() {
        return keyPropertyIds;
    }

    @Override
    public Map<Long, Object> getResourceEntities(Map<String, Object> properties) {
        LinkedHashMap<Long, Object> resourceEntities = new LinkedHashMap<Long, Object>();
        resourceEntities.put(1L, null);
        List<ClusterEntity> clusterEntities = clusterDAO.findAll();
        if (clusterEntities != null) {
            for (ClusterEntity clusterEntity : clusterEntities) {
                resourceEntities.put(clusterEntity.getResource().getId(), clusterEntity);
            }
        }
        ViewRegistry viewRegistry = ViewRegistry.getInstance();
        for (ViewEntity viewEntity : viewRegistry.getDefinitions()) {
            if (!viewEntity.isDeployed()) continue;
            for (ViewInstanceEntity viewInstanceEntity : viewEntity.getInstances()) {
                resourceEntities.put(viewInstanceEntity.getResource().getId(), viewInstanceEntity);
            }
        }
        return resourceEntities;
    }

    @Override
    protected Resource toResource(PrivilegeEntity privilegeEntity, Map<Long, UserEntity> userEntities, Map<Long, GroupEntity> groupEntities, Map<Long, PermissionEntity> roleEntities, Map<Long, Object> resourceEntities, Set<String> requestedIds) {
        ResourceEntity resourceEntity;
        ResourceTypeEntity type;
        String typeName;
        ResourceType resourceType;
        Resource resource = super.toResource(privilegeEntity, userEntities, groupEntities, roleEntities, resourceEntities, requestedIds);
        if (resource != null && (resourceType = ResourceType.translate(typeName = (type = (resourceEntity = privilegeEntity.getResource()).getResourceType()).getName())) != null) {
            switch (resourceType) {
                case OBDP: {
                    break;
                }
                case CLUSTER: {
                    ClusterEntity clusterEntity = (ClusterEntity)resourceEntities.get(resourceEntity.getId());
                    OBDPPrivilegeResourceProvider.setResourceProperty(resource, "PrivilegeInfo/cluster_name", clusterEntity.getClusterName(), requestedIds);
                    break;
                }
                case VIEW: {
                    ViewInstanceEntity viewInstanceEntity = (ViewInstanceEntity)resourceEntities.get(resourceEntity.getId());
                    ViewEntity viewEntity = viewInstanceEntity.getViewEntity();
                    OBDPPrivilegeResourceProvider.setResourceProperty(resource, "PrivilegeInfo/view_name", viewEntity.getCommonName(), requestedIds);
                    OBDPPrivilegeResourceProvider.setResourceProperty(resource, "PrivilegeInfo/version", viewEntity.getVersion(), requestedIds);
                    OBDPPrivilegeResourceProvider.setResourceProperty(resource, "PrivilegeInfo/instance_name", viewInstanceEntity.getName(), requestedIds);
                }
            }
            OBDPPrivilegeResourceProvider.setResourceProperty(resource, TYPE, resourceType.name(), requestedIds);
        }
        return resource;
    }

    @Override
    public Long getResourceEntityId(Predicate predicate) {
        return 1L;
    }

    static {
        propertyIds = Sets.newHashSet((Object[])new String[]{"PrivilegeInfo/privilege_id", "PrivilegeInfo/permission_name", "PrivilegeInfo/permission_label", "PrivilegeInfo/principal_name", "PrivilegeInfo/principal_type", "PrivilegeInfo/view_name", "PrivilegeInfo/version", "PrivilegeInfo/instance_name", "PrivilegeInfo/cluster_name", TYPE});
        keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.AmbariPrivilege, (Object)"PrivilegeInfo/privilege_id").build();
    }
}

