/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.inject.Inject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.StaticallyInject;
import id.onyx.obdp.server.api.services.parsers.BodyParseException;
import id.onyx.obdp.server.controller.MpackRequest;
import id.onyx.obdp.server.controller.MpackResponse;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.internal.AbstractControllerResourceProvider;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.DeleteStatusMetaData;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PredicateHelper;
import id.onyx.obdp.server.orm.dao.MpackDAO;
import id.onyx.obdp.server.orm.dao.RepositoryVersionDAO;
import id.onyx.obdp.server.orm.dao.StackDAO;
import id.onyx.obdp.server.orm.entities.MpackEntity;
import id.onyx.obdp.server.orm.entities.StackEntity;
import id.onyx.obdp.server.state.Module;
import id.onyx.obdp.server.state.StackId;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;

@StaticallyInject
public class MpackResourceProvider
extends AbstractControllerResourceProvider {
    public static final String RESPONSE_KEY = "MpackInfo";
    public static final String ALL_PROPERTIES = "MpackInfo/*";
    public static final String MPACK_RESOURCE_ID = "MpackInfo/id";
    public static final String REGISTRY_ID = "MpackInfo/registry_id";
    public static final String MPACK_ID = "MpackInfo/mpack_id";
    public static final String MPACK_NAME = "MpackInfo/mpack_name";
    public static final String MPACK_VERSION = "MpackInfo/mpack_version";
    public static final String MPACK_DESCRIPTION = "MpackInfo/mpack_description";
    public static final String MPACK_DISPLAY_NAME = "MpackInfo/mpack_display_name";
    public static final String MPACK_URI = "MpackInfo/mpack_uri";
    public static final String MODULES = "MpackInfo/modules";
    public static final String STACK_NAME_PROPERTY_ID = "MpackInfo/stack_name";
    public static final String STACK_VERSION_PROPERTY_ID = "MpackInfo/stack_version";
    private static Set<String> pkPropertyIds = new HashSet<String>(Arrays.asList("MpackInfo/id", "MpackInfo/stack_name", "MpackInfo/stack_version"));
    private static final Set<String> PROPERTY_IDS = new HashSet<String>();
    private static final Map<Resource.Type, String> KEY_PROPERTY_IDS = new HashMap<Resource.Type, String>();
    @Inject
    protected static MpackDAO mpackDAO;
    @Inject
    protected static StackDAO stackDAO;
    @Inject
    protected static RepositoryVersionDAO repositoryVersionDAO;

    MpackResourceProvider(OBDPManagementController controller) {
        super(Resource.Type.Mpack, PROPERTY_IDS, KEY_PROPERTY_IDS, controller);
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return pkPropertyIds;
    }

    @Override
    public RequestStatus createResources(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException, IllegalArgumentException {
        HashSet<Resource> associatedResources = new HashSet<Resource>();
        try {
            MpackRequest mpackRequest = this.getRequest(request);
            if (mpackRequest == null) {
                throw new BodyParseException("Please provide MpackInfo/mpack_name ,MpackInfo/mpack_version ,MpackInfo/mpack_uri");
            }
            this.validateCreateRequest(mpackRequest);
            MpackResponse response = this.getManagementController().registerMpack(mpackRequest);
            if (response != null) {
                this.notifyCreate(Resource.Type.Mpack, request);
                ResourceImpl resource = new ResourceImpl(Resource.Type.Mpack);
                resource.setProperty(MPACK_RESOURCE_ID, response.getId());
                resource.setProperty(MPACK_ID, response.getMpackId());
                resource.setProperty(MPACK_NAME, response.getMpackName());
                resource.setProperty(MPACK_VERSION, response.getMpackVersion());
                resource.setProperty(MPACK_URI, response.getMpackUri());
                resource.setProperty(MPACK_DESCRIPTION, response.getDescription());
                resource.setProperty(REGISTRY_ID, response.getRegistryId());
                resource.setProperty(MPACK_DISPLAY_NAME, response.getDisplayName());
                associatedResources.add(resource);
                return this.getRequestStatus(null, associatedResources);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (BodyParseException e1) {
            e1.printStackTrace();
        }
        return null;
    }

    private void validateCreateRequest(MpackRequest mpackRequest) {
        String mpackName = mpackRequest.getMpackName();
        String mpackUrl = mpackRequest.getMpackUri();
        Long registryId = mpackRequest.getRegistryId();
        String mpackVersion = mpackRequest.getMpackVersion();
        if (registryId == null) {
            Validate.isTrue((mpackUrl != null ? 1 : 0) != 0);
            LOG.info("Received a createMpack request, mpackUrl=" + mpackUrl);
        } else {
            Validate.notNull((Object)mpackName, (String)"MpackName should not be null");
            Validate.notNull((Object)mpackVersion, (String)"MpackVersion should not be null");
            LOG.info("Received a createMpack request, mpackName=" + mpackName + ", mpackVersion=" + mpackVersion + ", registryId=" + registryId);
        }
        try {
            URI uri = new URI(mpackUrl);
            URL uRL = uri.toURL();
        }
        catch (Exception e) {
            Validate.isTrue((e == null ? 1 : 0) != 0, (String)(e.getMessage() + " is an invalid mpack uri. Please check the download link for the mpack again."));
        }
    }

    public MpackRequest getRequest(Request request) throws OBDPException {
        MpackRequest mpackRequest = new MpackRequest();
        Set<Map<String, Object>> properties = request.getProperties();
        for (Map<String, Object> propertyMap : properties) {
            if (!propertyMap.containsKey(MPACK_URI) && !propertyMap.containsKey(REGISTRY_ID)) {
                return null;
            }
            if (!propertyMap.containsKey(MPACK_URI)) {
                mpackRequest.setRegistryId(Long.valueOf((String)propertyMap.get(REGISTRY_ID)));
                mpackRequest.setMpackName((String)propertyMap.get(MPACK_NAME));
                mpackRequest.setMpackVersion((String)propertyMap.get(MPACK_VERSION));
                continue;
            }
            mpackRequest.setMpackUri((String)propertyMap.get(MPACK_URI));
        }
        return mpackRequest;
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        LinkedHashSet<Resource> results = new LinkedHashSet<Resource>();
        Long mpackId = null;
        if (predicate == null) {
            Set<MpackResponse> responses = this.getManagementController().getMpacks();
            if (null == responses) {
                responses = Collections.emptySet();
            }
            for (MpackResponse response : responses) {
                Resource resource = this.setResources(response);
                Set<String> requestIds = this.getRequestPropertyIds(request, predicate);
                if (requestIds.contains(MODULES)) {
                    List<Module> modules = this.getManagementController().getModules(response.getId());
                    resource.setProperty(MODULES, modules);
                }
                results.add(resource);
            }
        } else {
            HashMap<String, Object> propertyMap = new HashMap<String, Object>(PredicateHelper.getProperties(predicate));
            if (propertyMap.containsKey(MPACK_RESOURCE_ID)) {
                MpackResponse response;
                Object objMpackId = propertyMap.get(MPACK_RESOURCE_ID);
                if (objMpackId != null) {
                    mpackId = Long.valueOf((String)objMpackId);
                }
                if (null != (response = this.getManagementController().getMpack(mpackId))) {
                    Resource resource = this.setResources(response);
                    List<Module> modules = this.getManagementController().getModules(response.getId());
                    resource.setProperty(MODULES, modules);
                    results.add(resource);
                }
            } else if (propertyMap.containsKey(STACK_NAME_PROPERTY_ID) && propertyMap.containsKey(STACK_VERSION_PROPERTY_ID)) {
                String stackName = (String)propertyMap.get(STACK_NAME_PROPERTY_ID);
                String stackVersion = (String)propertyMap.get(STACK_VERSION_PROPERTY_ID);
                StackEntity stackEntity = stackDAO.find(stackName, stackVersion);
                mpackId = stackEntity.getMpackId();
                MpackResponse response = this.getManagementController().getMpack(mpackId);
                if (null != response) {
                    Resource resource = this.setResources(response);
                    resource.setProperty(STACK_NAME_PROPERTY_ID, stackName);
                    resource.setProperty(STACK_VERSION_PROPERTY_ID, stackVersion);
                    results.add(resource);
                }
            }
            if (null == mpackId) {
                throw new IllegalArgumentException("Either the management pack ID or the stack name and version are required when searching");
            }
            if (results.isEmpty()) {
                throw new NoSuchResourceException("The requested resource doesn't exist: " + predicate);
            }
        }
        return results;
    }

    private Resource setResources(MpackResponse response) {
        ResourceImpl resource = new ResourceImpl(Resource.Type.Mpack);
        resource.setProperty(MPACK_RESOURCE_ID, response.getId());
        resource.setProperty(MPACK_ID, response.getMpackId());
        resource.setProperty(MPACK_NAME, response.getMpackName());
        resource.setProperty(MPACK_VERSION, response.getMpackVersion());
        resource.setProperty(MPACK_URI, response.getMpackUri());
        resource.setProperty(MPACK_DESCRIPTION, response.getDescription());
        resource.setProperty(REGISTRY_ID, response.getRegistryId());
        resource.setProperty(MPACK_DISPLAY_NAME, response.getDisplayName());
        return resource;
    }

    @Override
    protected RequestStatus deleteResourcesAuthorized(Request request, final Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        HashMap<String, Object> propertyMap = new HashMap<String, Object>(PredicateHelper.getProperties(predicate));
        DeleteStatusMetaData deleteStatusMetaData = null;
        if (this.getManagementController().getClusters().getClusters().size() > 0) {
            throw new SystemException("Delete request cannot be completed since there is a cluster deployed");
        }
        if (propertyMap.containsKey(MPACK_RESOURCE_ID)) {
            Object objMpackId = propertyMap.get(MPACK_RESOURCE_ID);
            if (objMpackId != null) {
                final Long mpackId = Long.valueOf((String)objMpackId);
                LOG.info("Deleting Mpack, id = " + mpackId.toString());
                MpackEntity mpackEntity = mpackDAO.findById(mpackId);
                final StackEntity stackEntity = stackDAO.findByMpack(mpackId);
                try {
                    this.getManagementController().removeMpack(mpackEntity, stackEntity);
                    if (mpackEntity == null) {
                        throw new NoSuchResourceException("The requested resource doesn't exist: " + predicate);
                    }
                    deleteStatusMetaData = this.modifyResources(new AbstractResourceProvider.Command<DeleteStatusMetaData>(){

                        @Override
                        public DeleteStatusMetaData invoke() throws OBDPException {
                            if (stackEntity != null) {
                                repositoryVersionDAO.removeByStack(new StackId(stackEntity.getStackName() + "-" + stackEntity.getStackVersion()));
                                stackDAO.removeByMpack(mpackId);
                                MpackResourceProvider.this.notifyDelete(Resource.Type.Stack, predicate);
                            }
                            mpackDAO.removeById(mpackId);
                            return new DeleteStatusMetaData();
                        }
                    });
                    this.notifyDelete(Resource.Type.Mpack, predicate);
                    deleteStatusMetaData.addDeletedKey(mpackId.toString());
                }
                catch (IOException e) {
                    throw new SystemException("There is an issue with the Files");
                }
            }
        } else {
            throw new UnsupportedPropertyException(Resource.Type.Mpack, null);
        }
        return this.getRequestStatus(null, null, deleteStatusMetaData);
    }

    static {
        PROPERTY_IDS.add(MPACK_RESOURCE_ID);
        PROPERTY_IDS.add(REGISTRY_ID);
        PROPERTY_IDS.add(MPACK_ID);
        PROPERTY_IDS.add(MPACK_NAME);
        PROPERTY_IDS.add(MPACK_VERSION);
        PROPERTY_IDS.add(MPACK_URI);
        PROPERTY_IDS.add(MPACK_DESCRIPTION);
        PROPERTY_IDS.add(MODULES);
        PROPERTY_IDS.add(STACK_NAME_PROPERTY_ID);
        PROPERTY_IDS.add(STACK_VERSION_PROPERTY_ID);
        PROPERTY_IDS.add(MPACK_DISPLAY_NAME);
        KEY_PROPERTY_IDS.put(Resource.Type.Mpack, MPACK_RESOURCE_ID);
        KEY_PROPERTY_IDS.put(Resource.Type.Stack, STACK_NAME_PROPERTY_ID);
        KEY_PROPERTY_IDS.put(Resource.Type.StackVersion, STACK_VERSION_PROPERTY_ID);
    }
}

