/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.MemberRequest;
import id.onyx.obdp.server.controller.MemberResponse;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.internal.AbstractControllerResourceProvider;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.security.authorization.RoleAuthorization;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemberResourceProvider
extends AbstractControllerResourceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(MemberResourceProvider.class);
    public static final String MEMBER_GROUP_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("MemberInfo", "group_name");
    public static final String MEMBER_USER_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("MemberInfo", "user_name");
    private static final Map<Resource.Type, String> keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.Group, (Object)MEMBER_GROUP_NAME_PROPERTY_ID).put((Object)Resource.Type.Member, (Object)MEMBER_USER_NAME_PROPERTY_ID).build();
    private static final Set<String> propertyIds = Sets.newHashSet((Object[])new String[]{MEMBER_GROUP_NAME_PROPERTY_ID, MEMBER_USER_NAME_PROPERTY_ID});

    @AssistedInject
    public MemberResourceProvider(@Assisted OBDPManagementController managementController) {
        super(Resource.Type.Member, propertyIds, keyPropertyIds, managementController);
        EnumSet<RoleAuthorization> manageUserAuthorizations = EnumSet.of(RoleAuthorization.OBDP_MANAGE_USERS);
        this.setRequiredCreateAuthorizations(manageUserAuthorizations);
        this.setRequiredGetAuthorizations(manageUserAuthorizations);
        this.setRequiredUpdateAuthorizations(manageUserAuthorizations);
        this.setRequiredDeleteAuthorizations(manageUserAuthorizations);
    }

    @Override
    protected RequestStatus createResourcesAuthorized(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        final HashSet<MemberRequest> requests = new HashSet<MemberRequest>();
        for (Map<String, Object> propertyMap : request.getProperties()) {
            requests.add(this.getRequest(propertyMap));
        }
        this.createResources(new AbstractResourceProvider.Command<Void>(){

            @Override
            public Void invoke() throws OBDPException {
                MemberResourceProvider.this.getManagementController().createMembers(requests);
                return null;
            }
        });
        return this.getRequestStatus(null);
    }

    @Override
    @Transactional
    protected Set<Resource> getResourcesAuthorized(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        final HashSet<MemberRequest> requests = new HashSet<MemberRequest>();
        for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
            requests.add(this.getRequest(propertyMap));
        }
        Set<MemberResponse> responses = this.getResources(new AbstractResourceProvider.Command<Set<MemberResponse>>(){

            @Override
            public Set<MemberResponse> invoke() throws OBDPException {
                return MemberResourceProvider.this.getManagementController().getMembers(requests);
            }
        });
        LOG.debug("Found member responses matching get members request, membersRequestSize={}, membersResponseSize={}", (Object)requests.size(), (Object)responses.size());
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        HashSet<Resource> resources = new HashSet<Resource>();
        for (MemberResponse memberResponse : responses) {
            ResourceImpl resource = new ResourceImpl(Resource.Type.Member);
            MemberResourceProvider.setResourceProperty(resource, MEMBER_GROUP_NAME_PROPERTY_ID, memberResponse.getGroupName(), requestedIds);
            MemberResourceProvider.setResourceProperty(resource, MEMBER_USER_NAME_PROPERTY_ID, memberResponse.getUserName(), requestedIds);
            resources.add(resource);
        }
        return resources;
    }

    @Override
    protected RequestStatus updateResourcesAuthorized(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        final HashSet<MemberRequest> requests = new HashSet<MemberRequest>();
        for (Map<String, Object> propertyMap : request.getProperties()) {
            requests.add(this.getRequest(propertyMap));
        }
        if (requests.isEmpty()) {
            HashMap<String, Object> propertyMap = new HashMap<String, Object>();
            propertyMap.put(MEMBER_GROUP_NAME_PROPERTY_ID, MemberResourceProvider.getQueryParameterValue(MEMBER_GROUP_NAME_PROPERTY_ID, predicate));
            requests.add(this.getRequest(propertyMap));
        }
        this.modifyResources(new AbstractResourceProvider.Command<Void>(){

            @Override
            public Void invoke() throws OBDPException {
                MemberResourceProvider.this.getManagementController().updateMembers(requests);
                return null;
            }
        });
        return this.getRequestStatus(null);
    }

    @Override
    protected RequestStatus deleteResourcesAuthorized(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        final HashSet<MemberRequest> requests = new HashSet<MemberRequest>();
        for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
            MemberRequest req = this.getRequest(propertyMap);
            requests.add(req);
        }
        this.modifyResources(new AbstractResourceProvider.Command<Void>(){

            @Override
            public Void invoke() throws OBDPException {
                MemberResourceProvider.this.getManagementController().deleteMembers(requests);
                return null;
            }
        });
        return this.getRequestStatus(null);
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return new HashSet<String>(keyPropertyIds.values());
    }

    private MemberRequest getRequest(Map<String, Object> properties) {
        if (properties == null) {
            return new MemberRequest(null, null);
        }
        MemberRequest request = new MemberRequest((String)properties.get(MEMBER_GROUP_NAME_PROPERTY_ID), (String)properties.get(MEMBER_USER_NAME_PROPERTY_ID));
        return request;
    }
}

