/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.OBDPServer;
import id.onyx.obdp.server.controller.internal.AbstractControllerResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.logging.LogQueryResponse;
import id.onyx.obdp.server.controller.logging.LoggingRequestHelper;
import id.onyx.obdp.server.controller.logging.LoggingRequestHelperFactoryImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LoggingResourceProvider
extends AbstractControllerResourceProvider {
    private static final String LOGGING_SEARCH_SERVICE_PROPERTY_ID = PropertyHelper.getPropertyId("Logging", "search_service_name");
    private static final String LOGGING_SEARCH_TERM_PROPERTY_ID = PropertyHelper.getPropertyId("Logging", "searchTerm");
    private static final String LOGGING_COMPONENT_PROPERTY_ID = PropertyHelper.getPropertyId("Logging", "component");
    private static final Set<String> PROPERTY_IDS;
    private static final Map<Resource.Type, String> KEY_PROPERTY_IDS;

    public LoggingResourceProvider(OBDPManagementController controller) {
        super(Resource.Type.LoggingQuery, PROPERTY_IDS, KEY_PROPERTY_IDS, controller);
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return Collections.emptySet();
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        ResourceImpl resource = new ResourceImpl(Resource.Type.LoggingQuery);
        LoggingResourceProvider.setResourceProperty(resource, LOGGING_SEARCH_SERVICE_PROPERTY_ID, "logging", this.getRequestPropertyIds(request, predicate));
        LoggingRequestHelper requestHelper = new LoggingRequestHelperFactoryImpl().getHelper(OBDPServer.getController(), "");
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        queryParameters.put("level", "ERROR");
        LogQueryResponse response = requestHelper.sendQueryRequest(queryParameters);
        resource.setProperty("startIndex", response.getStartIndex());
        resource.setProperty("pageSize", response.getPageSize());
        resource.setProperty("resultSize", response.getResultSize());
        resource.setProperty("queryTimeMMS", response.getQueryTimeMS());
        resource.setProperty("totalCount", response.getTotalCount());
        resource.setProperty("logList", response.getListOfResults());
        return Collections.singleton(resource);
    }

    @Override
    public Set<String> checkPropertyIds(Set<String> propertyIds) {
        Set<String> unSupportedProperties = super.checkPropertyIds(propertyIds);
        unSupportedProperties.remove("searchTerm");
        return unSupportedProperties;
    }

    static {
        HashSet<String> localSet = new HashSet<String>();
        localSet.add(LOGGING_SEARCH_SERVICE_PROPERTY_ID);
        localSet.add(LOGGING_SEARCH_TERM_PROPERTY_ID);
        localSet.add(LOGGING_COMPONENT_PROPERTY_ID);
        PROPERTY_IDS = Collections.unmodifiableSet(localSet);
        HashMap<Resource.Type, String> localMap = new HashMap<Resource.Type, String>();
        localMap.put(Resource.Type.LoggingQuery, LOGGING_SEARCH_SERVICE_PROPERTY_ID);
        KEY_PROPERTY_IDS = Collections.unmodifiableMap(localMap);
    }
}

