/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.LdapSyncRequest;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.internal.AbstractControllerResourceProvider;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.orm.entities.LdapSyncEventEntity;
import id.onyx.obdp.server.orm.entities.LdapSyncSpecEntity;
import id.onyx.obdp.server.security.authorization.AuthorizationException;
import id.onyx.obdp.server.security.authorization.AuthorizationHelper;
import id.onyx.obdp.server.security.authorization.ResourceType;
import id.onyx.obdp.server.security.authorization.RoleAuthorization;
import id.onyx.obdp.server.security.ldap.LdapBatchDto;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.naming.OperationNotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapSyncEventResourceProvider
extends AbstractControllerResourceProvider {
    private static ExecutorService executorService;
    private static final int THREAD_POOL_CORE_SIZE = 2;
    private static final int THREAD_POOL_MAX_SIZE = 5;
    private static final long THREAD_POOL_TIMEOUT = 1000L;
    public static final String EVENT_ID_PROPERTY_ID = "Event/id";
    public static final String EVENT_STATUS_PROPERTY_ID = "Event/status";
    public static final String EVENT_STATUS_DETAIL_PROPERTY_ID = "Event/status_detail";
    public static final String EVENT_START_TIME_PROPERTY_ID = "Event/sync_time/start";
    public static final String EVENT_END_TIME_PROPERTY_ID = "Event/sync_time/end";
    public static final String USERS_CREATED_PROPERTY_ID = "Event/summary/users/created";
    public static final String USERS_UPDATED_PROPERTY_ID = "Event/summary/users/updated";
    public static final String USERS_REMOVED_PROPERTY_ID = "Event/summary/users/removed";
    public static final String USERS_SKIPPED_PROPERTY_ID = "Event/summary/users/skipped";
    public static final String GROUPS_CREATED_PROPERTY_ID = "Event/summary/groups/created";
    public static final String GROUPS_UPDATED_PROPERTY_ID = "Event/summary/groups/updated";
    public static final String GROUPS_REMOVED_PROPERTY_ID = "Event/summary/groups/removed";
    public static final String MEMBERSHIPS_CREATED_PROPERTY_ID = "Event/summary/memberships/created";
    public static final String MEMBERSHIPS_REMOVED_PROPERTY_ID = "Event/summary/memberships/removed";
    public static final String EVENT_SPECS_PROPERTY_ID = "Event/specs";
    private static final Map<Resource.Type, String> keyPropertyIds;
    private static final Set<String> propertyIds;
    private static final String PRINCIPAL_TYPE_SPEC_KEY = "principal_type";
    private static final String SYNC_TYPE_SPEC_KEY = "sync_type";
    private static final String POST_PROCESS_EXISTING_USERS_SPEC_KEY = "post_process_existing_users";
    private static final String NAMES_SPEC_KEY = "names";
    private final Map<Long, LdapSyncEventEntity> events = new ConcurrentSkipListMap<Long, LdapSyncEventEntity>();
    private final Queue<LdapSyncEventEntity> eventQueue = new LinkedList<LdapSyncEventEntity>();
    private volatile boolean processingEvents = false;
    private AtomicLong nextEventId = new AtomicLong(1L);
    private static final Logger LOG;

    public LdapSyncEventResourceProvider(OBDPManagementController managementController) {
        super(Resource.Type.LdapSyncEvent, propertyIds, keyPropertyIds, managementController);
        EnumSet<RoleAuthorization> roleAuthorizations = EnumSet.of(RoleAuthorization.OBDP_MANAGE_GROUPS, RoleAuthorization.OBDP_MANAGE_USERS);
        this.setRequiredCreateAuthorizations(roleAuthorizations);
        this.setRequiredDeleteAuthorizations(roleAuthorizations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RequestStatus createResourcesAuthorized(Request event) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        HashSet<LdapSyncEventEntity> newEvents = new HashSet<LdapSyncEventEntity>();
        for (Map<String, Object> properties : event.getProperties()) {
            newEvents.add(this.createResources(this.getCreateCommand(properties)));
        }
        this.notifyCreate(Resource.Type.ViewInstance, event);
        HashSet<Resource> associatedResources = new HashSet<Resource>();
        for (LdapSyncEventEntity eventEntity : newEvents) {
            ResourceImpl resource = new ResourceImpl(Resource.Type.LdapSyncEvent);
            resource.setProperty(EVENT_ID_PROPERTY_ID, eventEntity.getId());
            associatedResources.add(resource);
            Queue<LdapSyncEventEntity> queue = this.eventQueue;
            synchronized (queue) {
                this.eventQueue.offer(eventEntity);
            }
        }
        this.ensureEventProcessor();
        return this.getRequestStatus(null, associatedResources);
    }

    @Override
    public Set<Resource> getResources(Request event, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        HashSet<Resource> resources = new HashSet<Resource>();
        Set<String> requestedIds = this.getRequestPropertyIds(event, predicate);
        for (LdapSyncEventEntity eventEntity : this.events.values()) {
            resources.add(this.toResource(eventEntity, requestedIds));
        }
        return resources;
    }

    @Override
    public RequestStatus updateResources(Request event, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public RequestStatus deleteResourcesAuthorized(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        this.modifyResources(this.getDeleteCommand(predicate));
        this.notifyDelete(Resource.Type.ViewInstance, predicate);
        return this.getRequestStatus(null);
    }

    @Override
    public Map<Resource.Type, String> getKeyPropertyIds() {
        return keyPropertyIds;
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return new HashSet<String>(keyPropertyIds.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureEventProcessor() {
        if (!this.processingEvents) {
            Queue<LdapSyncEventEntity> queue = this.eventQueue;
            synchronized (queue) {
                if (!this.processingEvents) {
                    this.processingEvents = true;
                    LdapSyncEventResourceProvider.getExecutorService().submit(new Runnable(){

                        @Override
                        public void run() {
                            LdapSyncEventResourceProvider.this.processSyncEvents();
                        }
                    });
                }
            }
        }
    }

    private Resource toResource(LdapSyncEventEntity eventEntity, Set<String> requestedIds) {
        ResourceImpl resource = new ResourceImpl(Resource.Type.LdapSyncEvent);
        LdapSyncEventResourceProvider.setResourceProperty(resource, EVENT_ID_PROPERTY_ID, eventEntity.getId(), requestedIds);
        LdapSyncEventResourceProvider.setResourceProperty(resource, EVENT_STATUS_PROPERTY_ID, eventEntity.getStatus().toString().toUpperCase(), requestedIds);
        LdapSyncEventResourceProvider.setResourceProperty(resource, EVENT_STATUS_DETAIL_PROPERTY_ID, eventEntity.getStatusDetail(), requestedIds);
        LdapSyncEventResourceProvider.setResourceProperty(resource, USERS_CREATED_PROPERTY_ID, eventEntity.getUsersCreated(), requestedIds);
        LdapSyncEventResourceProvider.setResourceProperty(resource, USERS_UPDATED_PROPERTY_ID, eventEntity.getUsersUpdated(), requestedIds);
        LdapSyncEventResourceProvider.setResourceProperty(resource, USERS_REMOVED_PROPERTY_ID, eventEntity.getUsersRemoved(), requestedIds);
        LdapSyncEventResourceProvider.setResourceProperty(resource, USERS_SKIPPED_PROPERTY_ID, eventEntity.getUsersSkipped(), requestedIds);
        LdapSyncEventResourceProvider.setResourceProperty(resource, GROUPS_CREATED_PROPERTY_ID, eventEntity.getGroupsCreated(), requestedIds);
        LdapSyncEventResourceProvider.setResourceProperty(resource, GROUPS_UPDATED_PROPERTY_ID, eventEntity.getGroupsUpdated(), requestedIds);
        LdapSyncEventResourceProvider.setResourceProperty(resource, GROUPS_REMOVED_PROPERTY_ID, eventEntity.getGroupsRemoved(), requestedIds);
        LdapSyncEventResourceProvider.setResourceProperty(resource, MEMBERSHIPS_CREATED_PROPERTY_ID, eventEntity.getMembershipsCreated(), requestedIds);
        LdapSyncEventResourceProvider.setResourceProperty(resource, MEMBERSHIPS_REMOVED_PROPERTY_ID, eventEntity.getMembershipsRemoved(), requestedIds);
        HashSet specs = new HashSet();
        List<LdapSyncSpecEntity> specList = eventEntity.getSpecs();
        for (LdapSyncSpecEntity spec : specList) {
            HashMap<String, String> specMap = new HashMap<String, String>();
            specMap.put(PRINCIPAL_TYPE_SPEC_KEY, spec.getPrincipalType().toString().toLowerCase());
            specMap.put(SYNC_TYPE_SPEC_KEY, spec.getSyncType().toString().toLowerCase());
            List<String> names = spec.getPrincipalNames();
            if (!names.isEmpty()) {
                specMap.put(NAMES_SPEC_KEY, names.toString().replace("[", "").replace("]", "").replace(", ", ","));
            }
            specs.add(specMap);
        }
        LdapSyncEventResourceProvider.setResourceProperty(resource, EVENT_SPECS_PROPERTY_ID, specs, requestedIds);
        LdapSyncEventResourceProvider.setResourceProperty(resource, EVENT_START_TIME_PROPERTY_ID, eventEntity.getStartTime(), requestedIds);
        LdapSyncEventResourceProvider.setResourceProperty(resource, EVENT_END_TIME_PROPERTY_ID, eventEntity.getEndTime(), requestedIds);
        return resource;
    }

    private LdapSyncEventEntity toEntity(Map<String, Object> properties) {
        LdapSyncEventEntity entity = new LdapSyncEventEntity(this.getNextEventId());
        LinkedList<LdapSyncSpecEntity> specList = new LinkedList<LdapSyncSpecEntity>();
        Set specs = (Set)properties.get(EVENT_SPECS_PROPERTY_ID);
        for (Map specMap : specs) {
            LdapSyncSpecEntity.SyncType syncType = null;
            LdapSyncSpecEntity.PrincipalType principalType = null;
            boolean postProcessExistingUsers = false;
            List<String> principalNames = Collections.emptyList();
            for (Map.Entry entry : specMap.entrySet()) {
                String key = (String)entry.getKey();
                if (key.equalsIgnoreCase(PRINCIPAL_TYPE_SPEC_KEY)) {
                    principalType = LdapSyncSpecEntity.PrincipalType.valueOfIgnoreCase((String)entry.getValue());
                    continue;
                }
                if (key.equalsIgnoreCase(SYNC_TYPE_SPEC_KEY)) {
                    syncType = LdapSyncSpecEntity.SyncType.valueOfIgnoreCase((String)entry.getValue());
                    continue;
                }
                if (key.equalsIgnoreCase(NAMES_SPEC_KEY)) {
                    String names = (String)entry.getValue();
                    principalNames = Arrays.asList(names.split("\\s*,\\s*"));
                    continue;
                }
                if (key.equalsIgnoreCase(POST_PROCESS_EXISTING_USERS_SPEC_KEY)) {
                    postProcessExistingUsers = "true".equalsIgnoreCase((String)entry.getValue());
                    continue;
                }
                throw new IllegalArgumentException("Unknown spec key " + key + ".");
            }
            if (syncType == null || principalType == null) {
                throw new IllegalArgumentException("LDAP event spec must include both sync-type and principal-type.");
            }
            LdapSyncSpecEntity spec = new LdapSyncSpecEntity(principalType, syncType, principalNames, postProcessExistingUsers);
            specList.add(spec);
        }
        entity.setSpecs(specList);
        return entity;
    }

    private long getNextEventId() {
        return this.nextEventId.getAndIncrement();
    }

    private AbstractResourceProvider.Command<LdapSyncEventEntity> getCreateCommand(final Map<String, Object> properties) {
        return new AbstractResourceProvider.Command<LdapSyncEventEntity>(){

            @Override
            public LdapSyncEventEntity invoke() throws OBDPException, AuthorizationException {
                LdapSyncEventEntity eventEntity = LdapSyncEventResourceProvider.this.toEntity(properties);
                for (LdapSyncSpecEntity ldapSyncSpecEntity : eventEntity.getSpecs()) {
                    if (ldapSyncSpecEntity.getPrincipalType() == LdapSyncSpecEntity.PrincipalType.USERS) {
                        if (AuthorizationHelper.isAuthorized(ResourceType.OBDP, null, RoleAuthorization.OBDP_MANAGE_USERS)) continue;
                        throw new AuthorizationException("The uthenticated user is not authorized to syng LDAP users");
                    }
                    if (AuthorizationHelper.isAuthorized(ResourceType.OBDP, null, RoleAuthorization.OBDP_MANAGE_GROUPS)) continue;
                    throw new AuthorizationException("The uthenticated user is not authorized to syng LDAP groups");
                }
                LdapSyncEventResourceProvider.this.events.put(eventEntity.getId(), eventEntity);
                return eventEntity;
            }
        };
    }

    private AbstractResourceProvider.Command<Void> getDeleteCommand(final Predicate predicate) {
        return new AbstractResourceProvider.Command<Void>(){

            @Override
            public Void invoke() throws OBDPException {
                Set<String> requestedIds = LdapSyncEventResourceProvider.this.getRequestPropertyIds(PropertyHelper.getReadRequest(new String[0]), predicate);
                HashSet<LdapSyncEventEntity> entities = new HashSet<LdapSyncEventEntity>();
                for (LdapSyncEventEntity entity : LdapSyncEventResourceProvider.this.events.values()) {
                    Resource resource = LdapSyncEventResourceProvider.this.toResource(entity, requestedIds);
                    if (predicate != null && !predicate.evaluate(resource)) continue;
                    entities.add(entity);
                }
                for (LdapSyncEventEntity entity : entities) {
                    LdapSyncEventResourceProvider.this.events.remove(entity.getId());
                }
                return null;
            }
        };
    }

    private static synchronized ExecutorService getExecutorService() {
        if (executorService == null) {
            LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(2, 5, 1000L, TimeUnit.MILLISECONDS, queue);
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        return executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSyncEvents() {
        while (this.processingEvents) {
            LdapSyncEventEntity event;
            Queue<LdapSyncEventEntity> queue = this.eventQueue;
            synchronized (queue) {
                if (!this.processingEvents) {
                    break;
                }
                event = this.eventQueue.poll();
                if (event == null) {
                    this.processingEvents = false;
                    return;
                }
            }
            event.setStatus(LdapSyncEventEntity.Status.RUNNING);
            event.setStatusDetail("Running LDAP sync.");
            event.setStartTime(System.currentTimeMillis());
            try {
                this.populateLdapSyncEvent(event, this.syncLdap(event));
                event.setStatus(LdapSyncEventEntity.Status.COMPLETE);
                event.setStatusDetail("Completed LDAP sync.");
            }
            catch (Exception e) {
                event.setStatus(LdapSyncEventEntity.Status.ERROR);
                Object msg = "Caught exception running LDAP sync. ";
                if (e.getCause() instanceof OperationNotSupportedException) {
                    msg = (String)msg + "LDAP server may not support search results pagination. Try to turn the pagination off.";
                }
                event.setStatusDetail((String)msg + e.getMessage());
                LOG.error((String)msg, (Throwable)e);
            }
            finally {
                event.setEndTime(System.currentTimeMillis());
            }
        }
    }

    private LdapBatchDto syncLdap(LdapSyncEventEntity event) throws OBDPException {
        LdapSyncRequest userRequest = null;
        LdapSyncRequest groupRequest = null;
        for (LdapSyncSpecEntity spec : event.getSpecs()) {
            switch (spec.getPrincipalType()) {
                case USERS: {
                    userRequest = this.getLdapRequest(userRequest, spec);
                    break;
                }
                case GROUPS: {
                    groupRequest = this.getLdapRequest(groupRequest, spec);
                }
            }
        }
        return this.getManagementController().synchronizeLdapUsersAndGroups(userRequest, groupRequest);
    }

    private LdapSyncRequest getLdapRequest(LdapSyncRequest request, LdapSyncSpecEntity spec) {
        switch (spec.getSyncType()) {
            case ALL: {
                return new LdapSyncRequest(LdapSyncSpecEntity.SyncType.ALL, spec.getPostProcessExistingUsers());
            }
            case EXISTING: {
                return new LdapSyncRequest(LdapSyncSpecEntity.SyncType.EXISTING, spec.getPostProcessExistingUsers());
            }
            case SPECIFIC: {
                HashSet<String> principalNames = new HashSet<String>(spec.getPrincipalNames());
                if (request == null) {
                    request = new LdapSyncRequest(LdapSyncSpecEntity.SyncType.SPECIFIC, principalNames, spec.getPostProcessExistingUsers());
                    break;
                }
                request.addPrincipalNames(principalNames);
            }
        }
        return request;
    }

    private void populateLdapSyncEvent(LdapSyncEventEntity event, LdapBatchDto syncInfo) {
        event.setUsersCreated(syncInfo.getUsersToBeCreated().size());
        event.setUsersUpdated(syncInfo.getUsersToBecomeLdap().size());
        event.setUsersRemoved(syncInfo.getUsersToBeRemoved().size());
        event.setUsersSkipped(syncInfo.getUsersSkipped().size());
        event.setGroupsCreated(syncInfo.getGroupsToBeCreated().size());
        event.setGroupsUpdated(syncInfo.getGroupsToBecomeLdap().size());
        event.setGroupsRemoved(syncInfo.getGroupsToBeRemoved().size());
        event.setMembershipsCreated(syncInfo.getMembershipToAdd().size());
        event.setMembershipsRemoved(syncInfo.getMembershipToRemove().size());
    }

    static {
        keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.LdapSyncEvent, (Object)EVENT_ID_PROPERTY_ID).build();
        propertyIds = Sets.newHashSet((Object[])new String[]{EVENT_ID_PROPERTY_ID, EVENT_STATUS_PROPERTY_ID, EVENT_STATUS_DETAIL_PROPERTY_ID, EVENT_START_TIME_PROPERTY_ID, EVENT_END_TIME_PROPERTY_ID, USERS_CREATED_PROPERTY_ID, USERS_UPDATED_PROPERTY_ID, USERS_REMOVED_PROPERTY_ID, USERS_SKIPPED_PROPERTY_ID, GROUPS_CREATED_PROPERTY_ID, GROUPS_UPDATED_PROPERTY_ID, GROUPS_REMOVED_PROPERTY_ID, MEMBERSHIPS_CREATED_PROPERTY_ID, MEMBERSHIPS_REMOVED_PROPERTY_ID, EVENT_SPECS_PROPERTY_ID});
        LOG = LoggerFactory.getLogger(LdapSyncEventResourceProvider.class);
    }
}

