/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.assistedinject.Assisted;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.internal.AbstractControllerResourceProvider;
import id.onyx.obdp.server.controller.internal.RequestImpl;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.orm.dao.KerberosDescriptorDAO;
import id.onyx.obdp.server.orm.entities.KerberosDescriptorEntity;
import id.onyx.obdp.server.topology.KerberosDescriptor;
import id.onyx.obdp.server.topology.KerberosDescriptorFactory;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosDescriptorResourceProvider
extends AbstractControllerResourceProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(KerberosDescriptorResourceProvider.class);
    static final String KERBEROS_DESCRIPTOR_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("KerberosDescriptors", "kerberos_descriptor_name");
    private static final String KERBEROS_DESCRIPTOR_TEXT_PROPERTY_ID = PropertyHelper.getPropertyId("KerberosDescriptors", "kerberos_descriptor_text");
    private static final Map<Resource.Type, String> KEY_PROPERTY_IDS = ImmutableMap.of((Object)Resource.Type.KerberosDescriptor, (Object)KERBEROS_DESCRIPTOR_NAME_PROPERTY_ID);
    private static final Set<String> PROPERTY_IDS = ImmutableSet.of((Object)KERBEROS_DESCRIPTOR_NAME_PROPERTY_ID, (Object)KERBEROS_DESCRIPTOR_TEXT_PROPERTY_ID);
    private KerberosDescriptorDAO kerberosDescriptorDAO;
    private KerberosDescriptorFactory kerberosDescriptorFactory;

    @Inject
    KerberosDescriptorResourceProvider(KerberosDescriptorDAO kerberosDescriptorDAO, KerberosDescriptorFactory kerberosDescriptorFactory, @Assisted OBDPManagementController managementController) {
        super(Resource.Type.KerberosDescriptor, PROPERTY_IDS, KEY_PROPERTY_IDS, managementController);
        this.kerberosDescriptorDAO = kerberosDescriptorDAO;
        this.kerberosDescriptorFactory = kerberosDescriptorFactory;
    }

    @Override
    public Set<String> checkPropertyIds(Set<String> propertyIds) {
        LOGGER.debug("Skipping property id validation for kerberos descriptor resources");
        return Collections.emptySet();
    }

    @Override
    public RequestStatus createResources(Request request) throws ResourceAlreadyExistsException {
        String name = KerberosDescriptorResourceProvider.getNameFromRequest(request);
        String descriptor = KerberosDescriptorResourceProvider.getRawKerberosDescriptorFromRequest(request);
        if (this.kerberosDescriptorDAO.findByName(name) != null) {
            String msg = String.format("Kerberos descriptor named %s already exists", name);
            LOGGER.info(msg);
            throw new ResourceAlreadyExistsException(msg);
        }
        KerberosDescriptor kerberosDescriptor = this.kerberosDescriptorFactory.createKerberosDescriptor(name, descriptor);
        this.kerberosDescriptorDAO.create(kerberosDescriptor.toEntity());
        return this.getRequestStatus(null);
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws NoSuchResourceException, NoSuchParentResourceException {
        String name;
        Set<Map<String, Object>> requestProps;
        List<KerberosDescriptorEntity> results = null;
        boolean applyPredicate = false;
        if (predicate != null && (requestProps = this.getPropertyMaps(predicate)).size() == 1 && (name = (String)requestProps.iterator().next().get(KERBEROS_DESCRIPTOR_NAME_PROPERTY_ID)) != null) {
            KerberosDescriptorEntity entity = this.kerberosDescriptorDAO.findByName(name);
            List<Object> list = results = entity == null ? Collections.emptyList() : Collections.singletonList(entity);
        }
        if (results == null) {
            applyPredicate = true;
            results = this.kerberosDescriptorDAO.findAll();
        }
        HashSet<Resource> resources = new HashSet<Resource>();
        Set<String> requestPropertyIds = this.getRequestPropertyIds(request, predicate);
        for (KerberosDescriptorEntity entity : results) {
            ResourceImpl resource = new ResourceImpl(Resource.Type.KerberosDescriptor);
            KerberosDescriptorResourceProvider.toResource(resource, entity, requestPropertyIds);
            if (predicate != null && applyPredicate && !predicate.evaluate(resource)) continue;
            resources.add(resource);
        }
        if (predicate != null && resources.isEmpty()) {
            throw new NoSuchResourceException("The requested resource doesn't exist: Kerberos Descriptor not found, " + predicate);
        }
        return resources;
    }

    private static void toResource(Resource resource, KerberosDescriptorEntity entity, Set<String> requestPropertyIds) {
        KerberosDescriptorResourceProvider.setResourceProperty(resource, KERBEROS_DESCRIPTOR_NAME_PROPERTY_ID, entity.getName(), requestPropertyIds);
        KerberosDescriptorResourceProvider.setResourceProperty(resource, KERBEROS_DESCRIPTOR_TEXT_PROPERTY_ID, entity.getKerberosDescriptorText(), requestPropertyIds);
    }

    @Override
    public RequestStatus updateResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    @Override
    public RequestStatus deleteResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        Set<Resource> setResources = this.getResources(new RequestImpl(null, null, null, null), predicate);
        for (Resource resource : setResources) {
            String kerberosDescriptorName = (String)resource.getPropertyValue(KERBEROS_DESCRIPTOR_NAME_PROPERTY_ID);
            LOGGER.debug("Deleting resource with name: {}", (Object)kerberosDescriptorName);
            this.kerberosDescriptorDAO.removeByName(kerberosDescriptorName);
        }
        return this.getRequestStatus(null);
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return ImmutableSet.copyOf(KEY_PROPERTY_IDS.values());
    }

    private static String getRawKerberosDescriptorFromRequest(Request request) {
        String descriptorText;
        Map<String, String> requestInfoProperties = request.getRequestInfoProperties();
        if (requestInfoProperties != null && !Strings.isNullOrEmpty((String)(descriptorText = requestInfoProperties.get("RAW_REQUEST_BODY")))) {
            return descriptorText;
        }
        String msg = "No Kerberos descriptor found in the request body";
        LOGGER.error(msg);
        throw new IllegalArgumentException(msg);
    }

    private static String getNameFromRequest(Request request) {
        Map<String, Object> properties;
        Object name;
        if (request.getProperties() != null && !request.getProperties().isEmpty() && (name = (properties = request.getProperties().iterator().next()).get(KERBEROS_DESCRIPTOR_NAME_PROPERTY_ID)) != null) {
            return String.valueOf(name);
        }
        String msg = "No name provided for the Kerberos descriptor";
        LOGGER.error(msg);
        throw new IllegalArgumentException(msg);
    }
}

