/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import id.onyx.obdp.server.controller.internal.HttpPropertyProvider;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.SystemException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JsonHttpPropertyRequest
extends HttpPropertyProvider.HttpPropertyRequest {
    private static final Logger LOG = LoggerFactory.getLogger(JsonHttpPropertyRequest.class);
    private static final Type MAP_TYPE = new TypeToken<Map<String, Object>>(){}.getType();
    private static final Gson GSON = new Gson();

    public JsonHttpPropertyRequest(Map<String, String> propertyMappings) {
        super(propertyMappings);
    }

    @Override
    public void populateResource(Resource resource, InputStream inputStream) throws SystemException {
        try {
            Map responseMap = (Map)GSON.fromJson(IOUtils.toString((InputStream)inputStream, (String)"UTF-8"), MAP_TYPE);
            if (responseMap == null) {
                LOG.error("Properties map from HTTP response is null");
            }
            for (Map.Entry<String, String> entry : this.getPropertyMappings().entrySet()) {
                Object propertyValueToSet = this.getPropertyValue(responseMap, entry.getKey());
                resource.setProperty(entry.getValue(), propertyValueToSet);
            }
        }
        catch (IOException e) {
            throw new SystemException("Error setting properties.", e);
        }
    }

    private Object getPropertyValue(Map<String, Object> responseMap, String property) throws SystemException {
        if (property == null || responseMap == null) {
            return null;
        }
        Object result = responseMap;
        try {
            for (String key : property.split("/")) {
                result = result.get(key);
            }
        }
        catch (ClassCastException e) {
            String msg = String.format("Error getting property value for %s.", property);
            LOG.error(msg, (Throwable)e);
            throw new SystemException(msg, e);
        }
        return result;
    }
}

