/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import id.onyx.obdp.server.controller.internal.AbstractJDBCResourceProvider;
import id.onyx.obdp.server.controller.internal.BaseProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.jdbc.ConnectionFactory;
import id.onyx.obdp.server.controller.jdbc.JobHistoryPostgresConnectionFactory;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobResourceProvider
extends AbstractJDBCResourceProvider<JobFields> {
    private static final Logger LOG = LoggerFactory.getLogger(JobResourceProvider.class);
    protected static final String JOB_CLUSTER_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("Job", "cluster_name");
    protected static final String JOB_WORKFLOW_ID_PROPERTY_ID = PropertyHelper.getPropertyId("Job", "workflow_id");
    protected static final String JOB_ID_PROPERTY_ID = PropertyHelper.getPropertyId("Job", "job_id");
    protected static final String JOB_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("Job", "name");
    protected static final String JOB_STATUS_PROPERTY_ID = PropertyHelper.getPropertyId("Job", "status");
    protected static final String JOB_USER_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("Job", "user_name");
    protected static final String JOB_SUBMIT_TIME_PROPERTY_ID = PropertyHelper.getPropertyId("Job", "submit_time");
    protected static final String JOB_ELAPSED_TIME_PROPERTY_ID = PropertyHelper.getPropertyId("Job", "elapsed_time");
    protected static final String JOB_MAPS_PROPERTY_ID = PropertyHelper.getPropertyId("Job", "maps");
    protected static final String JOB_REDUCES_PROPERTY_ID = PropertyHelper.getPropertyId("Job", "reduces");
    protected static final String JOB_INPUT_BYTES_PROPERTY_ID = PropertyHelper.getPropertyId("Job", "input_bytes");
    protected static final String JOB_OUTPUT_BYTES_PROPERTY_ID = PropertyHelper.getPropertyId("Job", "output_bytes");
    protected static final String JOB_CONF_PATH_PROPERTY_ID = PropertyHelper.getPropertyId("Job", "conf_path");
    protected static final String JOB_WORKFLOW_ENTITY_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("Job", "workflow_entity_name");
    protected JobFetcher jobFetcher;
    protected static final Map<Resource.Type, String> keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.Cluster, (Object)JOB_CLUSTER_NAME_PROPERTY_ID).put((Object)Resource.Type.Workflow, (Object)JOB_WORKFLOW_ID_PROPERTY_ID).put((Object)Resource.Type.Job, (Object)JOB_ID_PROPERTY_ID).build();
    protected static final Set<String> propertyIds = ImmutableSet.of((Object)JOB_CLUSTER_NAME_PROPERTY_ID, (Object)JOB_WORKFLOW_ID_PROPERTY_ID, (Object)JOB_ID_PROPERTY_ID, (Object)JOB_NAME_PROPERTY_ID, (Object)JOB_STATUS_PROPERTY_ID, (Object)JOB_USER_NAME_PROPERTY_ID, (Object[])new String[]{JOB_SUBMIT_TIME_PROPERTY_ID, JOB_ELAPSED_TIME_PROPERTY_ID, JOB_MAPS_PROPERTY_ID, JOB_REDUCES_PROPERTY_ID, JOB_INPUT_BYTES_PROPERTY_ID, JOB_OUTPUT_BYTES_PROPERTY_ID, JOB_CONF_PATH_PROPERTY_ID, JOB_WORKFLOW_ENTITY_NAME_PROPERTY_ID});

    protected JobResourceProvider() {
        super(propertyIds, keyPropertyIds);
        this.jobFetcher = new PostgresJobFetcher(new JobHistoryPostgresConnectionFactory());
    }

    protected JobResourceProvider(JobFetcher jobFetcher) {
        super(propertyIds, keyPropertyIds);
        this.jobFetcher = jobFetcher;
    }

    @Override
    public RequestStatus createResources(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        HashSet<Resource> resourceSet = new HashSet<Resource>();
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        Set<Map<String, Object>> predicatePropertieSet = this.getPropertyMaps(predicate);
        for (Map<String, Object> predicateProperties : predicatePropertieSet) {
            String clusterName = (String)predicateProperties.get(JOB_CLUSTER_NAME_PROPERTY_ID);
            String workflowId = (String)predicateProperties.get(JOB_WORKFLOW_ID_PROPERTY_ID);
            String jobId = (String)predicateProperties.get(JOB_ID_PROPERTY_ID);
            resourceSet.addAll(this.jobFetcher.fetchJobDetails(requestedIds, clusterName, workflowId, jobId));
        }
        return resourceSet;
    }

    @Override
    public RequestStatus updateResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new UnsupportedOperationException();
    }

    @Override
    public RequestStatus deleteResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return new HashSet<String>(keyPropertyIds.values());
    }

    @Override
    public Map<Resource.Type, String> getKeyPropertyIds() {
        return keyPropertyIds;
    }

    @Override
    protected Map<String, JobFields> getDBFieldMap() {
        HashMap<String, JobFields> dbFields = new HashMap<String, JobFields>();
        dbFields.put(JOB_WORKFLOW_ID_PROPERTY_ID, JobFields.WORKFLOWID);
        dbFields.put(JOB_ID_PROPERTY_ID, JobFields.JOBID);
        dbFields.put(JOB_NAME_PROPERTY_ID, JobFields.JOBNAME);
        dbFields.put(JOB_STATUS_PROPERTY_ID, JobFields.STATUS);
        dbFields.put(JOB_USER_NAME_PROPERTY_ID, JobFields.USERNAME);
        dbFields.put(JOB_SUBMIT_TIME_PROPERTY_ID, JobFields.SUBMITTIME);
        dbFields.put(JOB_ELAPSED_TIME_PROPERTY_ID, JobFields.FINISHTIME);
        dbFields.put(JOB_MAPS_PROPERTY_ID, JobFields.MAPS);
        dbFields.put(JOB_REDUCES_PROPERTY_ID, JobFields.REDUCES);
        dbFields.put(JOB_INPUT_BYTES_PROPERTY_ID, JobFields.INPUTBYTES);
        dbFields.put(JOB_OUTPUT_BYTES_PROPERTY_ID, JobFields.OUTPUTBYTES);
        dbFields.put(JOB_CONF_PATH_PROPERTY_ID, JobFields.CONFPATH);
        dbFields.put(JOB_WORKFLOW_ENTITY_NAME_PROPERTY_ID, JobFields.WORKFLOWENTITYNAME);
        return dbFields;
    }

    protected class PostgresJobFetcher
    implements JobFetcher {
        private static final String JOB_TABLE_NAME = "job";
        private ConnectionFactory connectionFactory;
        Connection db;
        PreparedStatement ps;

        public PostgresJobFetcher(ConnectionFactory connectionFactory) {
            this.connectionFactory = connectionFactory;
            this.db = null;
            this.ps = null;
        }

        protected ResultSet getResultSet(Set<String> requestedIds, String workflowId, String jobId) throws SQLException {
            this.db = null;
            this.ps = null;
            this.db = this.connectionFactory.getConnection();
            Object fields = JobResourceProvider.this.getDBFieldString(requestedIds);
            if (requestedIds.contains(JOB_ELAPSED_TIME_PROPERTY_ID) && !requestedIds.contains(JOB_SUBMIT_TIME_PROPERTY_ID)) {
                fields = (String)fields + "," + JobResourceProvider.this.getDBField(JOB_SUBMIT_TIME_PROPERTY_ID);
            }
            if (jobId == null) {
                this.ps = this.db.prepareStatement("SELECT " + (String)fields + " FROM job WHERE " + JobFields.WORKFLOWID + " = ?");
                this.ps.setString(1, workflowId);
            } else {
                this.ps = this.db.prepareStatement("SELECT " + (String)fields + " FROM job WHERE " + JobFields.JOBID + " = ?");
                this.ps.setString(1, jobId);
            }
            return this.ps.executeQuery();
        }

        protected void close() {
            if (this.ps != null) {
                try {
                    this.ps.close();
                }
                catch (SQLException e) {
                    LOG.error("Exception while closing statment", (Throwable)e);
                }
            }
            if (this.db != null) {
                try {
                    this.db.close();
                }
                catch (SQLException e) {
                    LOG.error("Exception while closing connection", (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Resource> fetchJobDetails(Set<String> requestedIds, String clusterName, String workflowId, String jobId) {
            HashSet<Resource> jobs = new HashSet<Resource>();
            ResultSet rs = null;
            try {
                rs = this.getResultSet(requestedIds, workflowId, jobId);
                while (rs.next()) {
                    ResourceImpl resource = new ResourceImpl(Resource.Type.Job);
                    BaseProvider.setResourceProperty(resource, JOB_CLUSTER_NAME_PROPERTY_ID, clusterName, requestedIds);
                    JobResourceProvider.this.setString(resource, JOB_ID_PROPERTY_ID, rs, requestedIds);
                    JobResourceProvider.this.setString(resource, JOB_NAME_PROPERTY_ID, rs, requestedIds);
                    JobResourceProvider.this.setString(resource, JOB_STATUS_PROPERTY_ID, rs, requestedIds);
                    JobResourceProvider.this.setString(resource, JOB_USER_NAME_PROPERTY_ID, rs, requestedIds);
                    if (requestedIds.contains(JOB_SUBMIT_TIME_PROPERTY_ID) || requestedIds.contains(JOB_ELAPSED_TIME_PROPERTY_ID)) {
                        long submitTime = rs.getLong(JobFields.SUBMITTIME.toString());
                        if (requestedIds.contains(JOB_SUBMIT_TIME_PROPERTY_ID)) {
                            BaseProvider.setResourceProperty(resource, JOB_SUBMIT_TIME_PROPERTY_ID, submitTime, requestedIds);
                        }
                        if (requestedIds.contains(JOB_ELAPSED_TIME_PROPERTY_ID)) {
                            long finishTime = rs.getLong(JobFields.FINISHTIME.toString());
                            if (finishTime > submitTime) {
                                BaseProvider.setResourceProperty(resource, JOB_ELAPSED_TIME_PROPERTY_ID, finishTime - submitTime, requestedIds);
                            } else {
                                BaseProvider.setResourceProperty(resource, JOB_ELAPSED_TIME_PROPERTY_ID, 0L, requestedIds);
                            }
                        }
                    }
                    JobResourceProvider.this.setInt(resource, JOB_MAPS_PROPERTY_ID, rs, requestedIds);
                    JobResourceProvider.this.setInt(resource, JOB_REDUCES_PROPERTY_ID, rs, requestedIds);
                    JobResourceProvider.this.setLong(resource, JOB_INPUT_BYTES_PROPERTY_ID, rs, requestedIds);
                    JobResourceProvider.this.setLong(resource, JOB_OUTPUT_BYTES_PROPERTY_ID, rs, requestedIds);
                    JobResourceProvider.this.setString(resource, JOB_CONF_PATH_PROPERTY_ID, rs, requestedIds);
                    JobResourceProvider.this.setString(resource, JOB_WORKFLOW_ID_PROPERTY_ID, rs, requestedIds);
                    JobResourceProvider.this.setString(resource, JOB_WORKFLOW_ENTITY_NAME_PROPERTY_ID, rs, requestedIds);
                    jobs.add(resource);
                }
            }
            catch (SQLException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Caught exception getting resource.", (Throwable)e);
                }
                Set<Resource> set = Collections.emptySet();
                return set;
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {
                        LOG.error("Exception while closing ResultSet", (Throwable)e);
                    }
                }
                this.close();
            }
            return jobs;
        }
    }

    public static interface JobFetcher {
        public Set<Resource> fetchJobDetails(Set<String> var1, String var2, String var3, String var4);
    }

    static enum JobFields {
        JOBID,
        JOBNAME,
        STATUS,
        USERNAME,
        SUBMITTIME,
        FINISHTIME,
        MAPS,
        REDUCES,
        INPUTBYTES,
        OUTPUTBYTES,
        CONFPATH,
        WORKFLOWID,
        WORKFLOWENTITYNAME;

    }
}

