/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import id.onyx.obdp.server.controller.internal.AbstractDRResourceProvider;
import id.onyx.obdp.server.controller.internal.RequestStatusImpl;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.ivory.Instance;
import id.onyx.obdp.server.controller.ivory.IvoryService;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InstanceResourceProvider
extends AbstractDRResourceProvider {
    protected static final String INSTANCE_FEED_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("Instance", "feedName");
    protected static final String INSTANCE_ID_PROPERTY_ID = PropertyHelper.getPropertyId("Instance", "id");
    protected static final String INSTANCE_STATUS_PROPERTY_ID = PropertyHelper.getPropertyId("Instance", "status");
    protected static final String INSTANCE_START_TIME_PROPERTY_ID = PropertyHelper.getPropertyId("Instance", "startTime");
    protected static final String INSTANCE_END_TIME_PROPERTY_ID = PropertyHelper.getPropertyId("Instance", "endTime");
    protected static final String INSTANCE_DETAILS_PROPERTY_ID = PropertyHelper.getPropertyId("Instance", "details");
    protected static final String INSTANCE_LOG_PROPERTY_ID = PropertyHelper.getPropertyId("Instance", "log");
    private static final Map<Resource.Type, String> keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.DRInstance, (Object)INSTANCE_FEED_NAME_PROPERTY_ID).put((Object)Resource.Type.Workflow, (Object)INSTANCE_ID_PROPERTY_ID).build();
    private static final Set<String> propertyIds = Sets.newHashSet((Object[])new String[]{INSTANCE_FEED_NAME_PROPERTY_ID, INSTANCE_ID_PROPERTY_ID, INSTANCE_STATUS_PROPERTY_ID, INSTANCE_START_TIME_PROPERTY_ID, INSTANCE_END_TIME_PROPERTY_ID, INSTANCE_DETAILS_PROPERTY_ID, INSTANCE_LOG_PROPERTY_ID});

    public InstanceResourceProvider(IvoryService ivoryService) {
        super(propertyIds, keyPropertyIds, ivoryService);
    }

    @Override
    public RequestStatus createResources(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        HashSet<Resource> resources = new HashSet<Resource>();
        List<Object> feedNames = new LinkedList();
        IvoryService service = this.getService();
        if (predicate == null) {
            feedNames = service.getFeedNames();
        } else {
            for (Map map : this.getPropertyMaps(predicate)) {
                String feedName = (String)map.get(INSTANCE_FEED_NAME_PROPERTY_ID);
                if (feedName == null) {
                    feedNames = service.getFeedNames();
                    break;
                }
                feedNames.add(feedName);
            }
        }
        for (String string : feedNames) {
            List<Instance> instances = service.getInstances(string);
            for (Instance instance : instances) {
                ResourceImpl resource = new ResourceImpl(Resource.Type.DRInstance);
                InstanceResourceProvider.setResourceProperty(resource, INSTANCE_FEED_NAME_PROPERTY_ID, instance.getFeedName(), requestedIds);
                InstanceResourceProvider.setResourceProperty(resource, INSTANCE_ID_PROPERTY_ID, instance.getId(), requestedIds);
                InstanceResourceProvider.setResourceProperty(resource, INSTANCE_STATUS_PROPERTY_ID, instance.getStatus(), requestedIds);
                InstanceResourceProvider.setResourceProperty(resource, INSTANCE_START_TIME_PROPERTY_ID, instance.getStartTime(), requestedIds);
                InstanceResourceProvider.setResourceProperty(resource, INSTANCE_END_TIME_PROPERTY_ID, instance.getEndTime(), requestedIds);
                InstanceResourceProvider.setResourceProperty(resource, INSTANCE_DETAILS_PROPERTY_ID, instance.getDetails(), requestedIds);
                InstanceResourceProvider.setResourceProperty(resource, INSTANCE_LOG_PROPERTY_ID, instance.getLog(), requestedIds);
                if (predicate != null && !predicate.evaluate(resource)) continue;
                resources.add(resource);
            }
        }
        return resources;
    }

    @Override
    public RequestStatus updateResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        Map<String, Object> propertyMap;
        String desiredStatus;
        IvoryService service = this.getService();
        Iterator<Map<String, Object>> iterator = request.getProperties().iterator();
        if (iterator.hasNext() && (desiredStatus = (String)(propertyMap = iterator.next()).get(INSTANCE_STATUS_PROPERTY_ID)) != null) {
            Set<Resource> resources = this.getResources(PropertyHelper.getReadRequest(new String[0]), predicate);
            for (Resource resource : resources) {
                String status = (String)resource.getPropertyValue(INSTANCE_STATUS_PROPERTY_ID);
                String feedName = (String)resource.getPropertyValue(INSTANCE_FEED_NAME_PROPERTY_ID);
                String id = (String)resource.getPropertyValue(INSTANCE_ID_PROPERTY_ID);
                if (desiredStatus.equals("SUSPENDED")) {
                    service.suspendInstance(feedName, id);
                    continue;
                }
                if (!status.equals("SUSPENDED") || !desiredStatus.equals("RUNNING")) continue;
                service.resumeInstance(feedName, id);
            }
        }
        return new RequestStatusImpl(null);
    }

    @Override
    public RequestStatus deleteResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        IvoryService service = this.getService();
        Set<Resource> resources = this.getResources(PropertyHelper.getReadRequest(new String[0]), predicate);
        for (Resource resource : resources) {
            service.killInstance((String)resource.getPropertyValue(INSTANCE_FEED_NAME_PROPERTY_ID), (String)resource.getPropertyValue(INSTANCE_ID_PROPERTY_ID));
        }
        return new RequestStatusImpl(null);
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return new HashSet<String>(keyPropertyIds.values());
    }

    protected static Instance getInstance(String feedName, String instanceId, Map<String, Object> propertyMap) {
        return new Instance(feedName, instanceId, (String)propertyMap.get(INSTANCE_STATUS_PROPERTY_ID), (String)propertyMap.get(INSTANCE_START_TIME_PROPERTY_ID), (String)propertyMap.get(INSTANCE_END_TIME_PROPERTY_ID), (String)propertyMap.get(INSTANCE_DETAILS_PROPERTY_ID), (String)propertyMap.get(INSTANCE_LOG_PROPERTY_ID));
    }
}

