/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.internal.BaseProvider;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.PropertyProvider;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.utilities.StreamProvider;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpPropertyProvider
extends BaseProvider
implements PropertyProvider {
    private static final Logger LOG = LoggerFactory.getLogger(HttpPropertyProvider.class);
    private final StreamProvider streamProvider;
    private final String clusterNamePropertyId;
    private final String hostNamePropertyId;
    private final String publicHostNamePropertyId;
    private final String componentNamePropertyId;
    private final Clusters clusters;
    private final Map<String, List<HttpPropertyRequest>> httpPropertyRequests;

    public HttpPropertyProvider(StreamProvider stream, Clusters clusters, String clusterNamePropertyId, String hostNamePropertyId, String publicHostNamePropertyId, String componentNamePropertyId, Map<String, List<HttpPropertyRequest>> httpPropertyRequests) {
        super(HttpPropertyProvider.getSupportedProperties(httpPropertyRequests));
        this.streamProvider = stream;
        this.clusterNamePropertyId = clusterNamePropertyId;
        this.hostNamePropertyId = hostNamePropertyId;
        this.publicHostNamePropertyId = publicHostNamePropertyId;
        this.componentNamePropertyId = componentNamePropertyId;
        this.clusters = clusters;
        this.httpPropertyRequests = httpPropertyRequests;
    }

    private static Set<String> getSupportedProperties(Map<String, List<HttpPropertyRequest>> httpPropertyRequests) {
        HashSet<String> supportedProperties = new HashSet<String>();
        for (List<HttpPropertyRequest> httpPropertyRequestList : httpPropertyRequests.values()) {
            for (HttpPropertyRequest httpPropertyRequest : httpPropertyRequestList) {
                supportedProperties.addAll(httpPropertyRequest.getSupportedProperties());
            }
        }
        return Collections.unmodifiableSet(supportedProperties);
    }

    @Override
    public Set<Resource> populateResources(Set<Resource> resources, Request request, Predicate predicate) throws SystemException {
        Set<String> ids = this.getRequestPropertyIds(request, predicate);
        if (ids.size() == 0) {
            return resources;
        }
        for (Resource resource : resources) {
            String clusterName = (String)resource.getPropertyValue(this.clusterNamePropertyId);
            String hostName = (String)resource.getPropertyValue(this.hostNamePropertyId);
            String publicHostName = (String)resource.getPropertyValue(this.publicHostNamePropertyId);
            String componentName = (String)resource.getPropertyValue(this.componentNamePropertyId);
            if (clusterName == null || hostName == null || componentName == null || !this.httpPropertyRequests.containsKey(componentName)) continue;
            try {
                Cluster cluster = this.clusters.getCluster(clusterName);
                List<HttpPropertyRequest> httpPropertyRequestList = this.httpPropertyRequests.get(componentName);
                for (HttpPropertyRequest httpPropertyRequest : httpPropertyRequestList) {
                    this.populateResource(httpPropertyRequest, resource, cluster, hostName, publicHostName);
                }
            }
            catch (OBDPException e) {
                String msg = String.format("Could not load cluster with name %s.", clusterName);
                LOG.debug(msg, (Throwable)e);
                throw new SystemException(msg, e);
            }
        }
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateResource(HttpPropertyRequest httpPropertyRequest, Resource resource, Cluster cluster, String hostName, String publicHostName) throws SystemException {
        block16: {
            String url = httpPropertyRequest.getUrl(cluster, hostName);
            try {
                InputStream inputStream = this.streamProvider.readFrom(url);
                try {
                    httpPropertyRequest.populateResource(resource, inputStream);
                }
                catch (Throwable throwable) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException ioe) {
                        LOG.error(String.format("Error closing HTTP response stream %s", url), (Throwable)ioe);
                    }
                    throw throwable;
                }
                try {
                    inputStream.close();
                }
                catch (IOException ioe) {
                    LOG.error(String.format("Error closing HTTP response stream %s", url), (Throwable)ioe);
                }
            }
            catch (Exception e) {
                LOG.debug(String.format("Error reading HTTP response from %s", url), (Throwable)e);
                if (publicHostName == null || publicHostName.equalsIgnoreCase(hostName)) break block16;
                String publicUrl = httpPropertyRequest.getUrl(cluster, publicHostName);
                LOG.debug(String.format("Retry using public host name url %s", publicUrl));
                try {
                    InputStream inputStream = this.streamProvider.readFrom(publicUrl);
                    try {
                        httpPropertyRequest.populateResource(resource, inputStream);
                    }
                    catch (Throwable throwable) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException ioe) {
                            LOG.error(String.format("Error closing HTTP response stream %s", url), (Throwable)ioe);
                        }
                        throw throwable;
                    }
                    try {
                        inputStream.close();
                    }
                    catch (IOException ioe) {
                        LOG.error(String.format("Error closing HTTP response stream %s", url), (Throwable)ioe);
                    }
                }
                catch (Exception ex) {
                    LOG.debug(String.format("Error reading HTTP response from public host name url %s", url), (Throwable)ex);
                }
            }
        }
    }

    public static abstract class HttpPropertyRequest {
        private final Map<String, String> propertyMappings;

        protected HttpPropertyRequest(Map<String, String> propertyMappings) {
            this.propertyMappings = propertyMappings;
        }

        public Collection<String> getSupportedProperties() {
            return this.propertyMappings.values();
        }

        protected Map<String, String> getPropertyMappings() {
            return this.propertyMappings;
        }

        public abstract String getUrl(Cluster var1, String var2) throws SystemException;

        public abstract void populateResource(Resource var1, InputStream var2) throws SystemException;
    }
}

