/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.HostRequest;
import id.onyx.obdp.server.controller.HostResponse;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.ServiceComponentHostRequest;
import id.onyx.obdp.server.controller.ServiceComponentHostResponse;
import id.onyx.obdp.server.controller.internal.HostResourceProvider;
import id.onyx.obdp.server.state.HostState;
import id.onyx.obdp.server.state.State;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostStatusHelper {
    private static final Logger LOG = LoggerFactory.getLogger(HostStatusHelper.class);

    public static boolean isHostComponentLive(OBDPManagementController managementController, String clusterName, String hostName, String serviceName, String componentName) {
        ServiceComponentHostResponse componentHostResponse;
        if (clusterName == null) {
            return false;
        }
        try {
            ServiceComponentHostRequest componentRequest = new ServiceComponentHostRequest(clusterName, serviceName, componentName, hostName, null);
            Set<ServiceComponentHostResponse> hostComponents = managementController.getHostComponents(Collections.singleton(componentRequest));
            componentHostResponse = hostComponents.size() == 1 ? hostComponents.iterator().next() : null;
        }
        catch (OBDPException e) {
            LOG.debug("Error checking {} server host component state: ", (Object)componentName, (Object)e);
            return false;
        }
        return componentHostResponse != null && componentHostResponse.getLiveState().equals(State.STARTED.name());
    }

    public static boolean isHostLive(OBDPManagementController managementController, String clusterName, String hostName) {
        HostResponse hostResponse;
        if (clusterName == null) {
            return false;
        }
        try {
            HostRequest hostRequest = new HostRequest(hostName, clusterName);
            Set<HostResponse> hosts = HostResourceProvider.getHosts(managementController, hostRequest, null);
            hostResponse = hosts.size() == 1 ? hosts.iterator().next() : null;
        }
        catch (OBDPException e) {
            LOG.debug("Error while checking host live status: ", (Throwable)e);
            return false;
        }
        return hostResponse != null && !hostResponse.getHostState().equals((Object)HostState.HEARTBEAT_LOST);
    }
}

