/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.StaticallyInject;
import id.onyx.obdp.server.actionmanager.ActionManager;
import id.onyx.obdp.server.actionmanager.RequestFactory;
import id.onyx.obdp.server.actionmanager.Stage;
import id.onyx.obdp.server.actionmanager.StageFactory;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.controller.ActionExecutionContext;
import id.onyx.obdp.server.controller.OBDPActionExecutionHelper;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.internal.AbstractControllerResourceProvider;
import id.onyx.obdp.server.controller.internal.RequestResourceFilter;
import id.onyx.obdp.server.controller.internal.RequestStageContainer;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.orm.dao.HostVersionDAO;
import id.onyx.obdp.server.orm.dao.RepositoryVersionDAO;
import id.onyx.obdp.server.orm.entities.HostVersionEntity;
import id.onyx.obdp.server.orm.entities.RepoOsEntity;
import id.onyx.obdp.server.orm.entities.RepositoryVersionEntity;
import id.onyx.obdp.server.stack.upgrade.RepositoryVersionHelper;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.RepositoryVersionState;
import id.onyx.obdp.server.state.ServiceComponentHost;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.utils.StageUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StaticallyInject
public class HostStackVersionResourceProvider
extends AbstractControllerResourceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(HostStackVersionResourceProvider.class);
    protected static final String HOST_STACK_VERSION_ID_PROPERTY_ID = PropertyHelper.getPropertyId("HostStackVersions", "id");
    protected static final String HOST_STACK_VERSION_CLUSTER_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("HostStackVersions", "cluster_name");
    protected static final String HOST_STACK_VERSION_HOST_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("HostStackVersions", "host_name");
    protected static final String HOST_STACK_VERSION_STACK_PROPERTY_ID = PropertyHelper.getPropertyId("HostStackVersions", "stack");
    protected static final String HOST_STACK_VERSION_VERSION_PROPERTY_ID = PropertyHelper.getPropertyId("HostStackVersions", "version");
    protected static final String HOST_STACK_VERSION_STATE_PROPERTY_ID = PropertyHelper.getPropertyId("HostStackVersions", "state");
    protected static final String HOST_STACK_VERSION_REPOSITORIES_PROPERTY_ID = PropertyHelper.getPropertyId("HostStackVersions", "repositories");
    protected static final String HOST_STACK_VERSION_REPO_VERSION_PROPERTY_ID = PropertyHelper.getPropertyId("HostStackVersions", "repository_version");
    protected static final String HOST_STACK_VERSION_FORCE_INSTALL_ON_NON_MEMBER_HOST_PROPERTY_ID = PropertyHelper.getPropertyId("HostStackVersions", "force_non_member_install");
    protected static final String HOST_STACK_VERSION_COMPONENT_NAMES_PROPERTY_ID = PropertyHelper.getPropertyId("HostStackVersions", "components");
    protected static final String COMPONENT_NAME_PROPERTY_ID = "name";
    protected static final String INSTALL_PACKAGES_ACTION = "install_packages";
    protected static final String STACK_SELECT_ACTION = "stack_select_set_all";
    protected static final String INSTALL_PACKAGES_FULL_NAME = "Install Version";
    private static final Set<String> pkPropertyIds = Sets.newHashSet((Object[])new String[]{HOST_STACK_VERSION_CLUSTER_NAME_PROPERTY_ID, HOST_STACK_VERSION_HOST_NAME_PROPERTY_ID, HOST_STACK_VERSION_ID_PROPERTY_ID, HOST_STACK_VERSION_STACK_PROPERTY_ID, HOST_STACK_VERSION_VERSION_PROPERTY_ID, HOST_STACK_VERSION_REPO_VERSION_PROPERTY_ID});
    private static final Set<String> propertyIds = Sets.newHashSet((Object[])new String[]{HOST_STACK_VERSION_ID_PROPERTY_ID, HOST_STACK_VERSION_CLUSTER_NAME_PROPERTY_ID, HOST_STACK_VERSION_HOST_NAME_PROPERTY_ID, HOST_STACK_VERSION_STACK_PROPERTY_ID, HOST_STACK_VERSION_VERSION_PROPERTY_ID, HOST_STACK_VERSION_STATE_PROPERTY_ID, HOST_STACK_VERSION_REPOSITORIES_PROPERTY_ID, HOST_STACK_VERSION_REPO_VERSION_PROPERTY_ID, HOST_STACK_VERSION_FORCE_INSTALL_ON_NON_MEMBER_HOST_PROPERTY_ID, HOST_STACK_VERSION_COMPONENT_NAMES_PROPERTY_ID});
    private static final Map<Resource.Type, String> keyPropertyIds = new HashMap<Resource.Type, String>(){
        {
            this.put(Resource.Type.Cluster, HOST_STACK_VERSION_CLUSTER_NAME_PROPERTY_ID);
            this.put(Resource.Type.Host, HOST_STACK_VERSION_HOST_NAME_PROPERTY_ID);
            this.put(Resource.Type.HostStackVersion, HOST_STACK_VERSION_ID_PROPERTY_ID);
            this.put(Resource.Type.Stack, HOST_STACK_VERSION_STACK_PROPERTY_ID);
            this.put(Resource.Type.StackVersion, HOST_STACK_VERSION_VERSION_PROPERTY_ID);
            this.put(Resource.Type.RepositoryVersion, HOST_STACK_VERSION_REPO_VERSION_PROPERTY_ID);
        }
    };
    @Inject
    private static HostVersionDAO hostVersionDAO;
    @Inject
    private static RepositoryVersionDAO repositoryVersionDAO;
    @Inject
    private static StageFactory stageFactory;
    @Inject
    private static RequestFactory requestFactory;
    @Inject
    private static Provider<OBDPActionExecutionHelper> actionExecutionHelper;
    @Inject
    private static Configuration configuration;
    @Inject
    private static RepositoryVersionHelper repoVersionHelper;

    public HostStackVersionResourceProvider(OBDPManagementController managementController) {
        super(Resource.Type.HostStackVersion, propertyIds, keyPropertyIds, managementController);
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        HashSet<Resource> resources = new HashSet<Resource>();
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        Set<Map<String, Object>> propertyMaps = this.getPropertyMaps(predicate);
        for (Map<String, Object> propertyMap : propertyMaps) {
            List<HostVersionEntity> requestedEntities;
            String hostName = propertyMap.get(HOST_STACK_VERSION_HOST_NAME_PROPERTY_ID).toString();
            String clusterName = null;
            if (propertyMap.containsKey(HOST_STACK_VERSION_CLUSTER_NAME_PROPERTY_ID)) {
                clusterName = propertyMap.get(HOST_STACK_VERSION_CLUSTER_NAME_PROPERTY_ID).toString();
            }
            if (propertyMap.get(HOST_STACK_VERSION_ID_PROPERTY_ID) == null) {
                requestedEntities = clusterName == null ? hostVersionDAO.findByHost(hostName) : hostVersionDAO.findByClusterAndHost(clusterName, hostName);
            } else {
                Long id;
                try {
                    id = Long.parseLong(propertyMap.get(HOST_STACK_VERSION_ID_PROPERTY_ID).toString());
                }
                catch (Exception ex) {
                    throw new SystemException("Stack version should have numerical id");
                }
                HostVersionEntity entity = (HostVersionEntity)hostVersionDAO.findByPK(id);
                if (entity == null) {
                    throw new NoSuchResourceException("There is no stack version with id " + id);
                }
                requestedEntities = Collections.singletonList(entity);
            }
            if (requestedEntities == null) continue;
            this.addRequestedEntities(resources, requestedEntities, requestedIds, clusterName);
        }
        return resources;
    }

    public void addRequestedEntities(Set<Resource> resources, List<HostVersionEntity> requestedEntities, Set<String> requestedIds, String clusterName) {
        for (HostVersionEntity entity : requestedEntities) {
            StackId stackId = new StackId(entity.getRepositoryVersion().getStack());
            RepositoryVersionEntity repoVerEntity = repositoryVersionDAO.findByStackAndVersion(stackId, entity.getRepositoryVersion().getVersion());
            ResourceImpl resource = new ResourceImpl(Resource.Type.HostStackVersion);
            HostStackVersionResourceProvider.setResourceProperty(resource, HOST_STACK_VERSION_HOST_NAME_PROPERTY_ID, entity.getHostName(), requestedIds);
            HostStackVersionResourceProvider.setResourceProperty(resource, HOST_STACK_VERSION_ID_PROPERTY_ID, entity.getId(), requestedIds);
            HostStackVersionResourceProvider.setResourceProperty(resource, HOST_STACK_VERSION_STACK_PROPERTY_ID, stackId.getStackName(), requestedIds);
            HostStackVersionResourceProvider.setResourceProperty(resource, HOST_STACK_VERSION_VERSION_PROPERTY_ID, stackId.getStackVersion(), requestedIds);
            HostStackVersionResourceProvider.setResourceProperty(resource, HOST_STACK_VERSION_STATE_PROPERTY_ID, entity.getState().name(), requestedIds);
            if (clusterName != null) {
                HostStackVersionResourceProvider.setResourceProperty(resource, HOST_STACK_VERSION_CLUSTER_NAME_PROPERTY_ID, clusterName, requestedIds);
            }
            if (repoVerEntity != null) {
                Long repoVersionId = repoVerEntity.getId();
                HostStackVersionResourceProvider.setResourceProperty(resource, HOST_STACK_VERSION_REPO_VERSION_PROPERTY_ID, repoVersionId, requestedIds);
            }
            resources.add(resource);
        }
    }

    @Override
    public RequestStatus createResources(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        Iterator<Map<String, Object>> iterator = request.getProperties().iterator();
        if (request.getProperties().size() > 1) {
            throw new UnsupportedOperationException("Multiple requests cannot be executed at the same time.");
        }
        Map<String, Object> propertyMap = iterator.next();
        HashSet requiredProperties = Sets.newHashSet((Object[])new String[]{HOST_STACK_VERSION_HOST_NAME_PROPERTY_ID, HOST_STACK_VERSION_REPO_VERSION_PROPERTY_ID, HOST_STACK_VERSION_STACK_PROPERTY_ID, HOST_STACK_VERSION_VERSION_PROPERTY_ID});
        for (String requiredProperty : requiredProperties) {
            Validate.isTrue((boolean)propertyMap.containsKey(requiredProperty), (String)String.format("The required property %s is not defined", requiredProperty));
        }
        String clName = (String)propertyMap.get(HOST_STACK_VERSION_CLUSTER_NAME_PROPERTY_ID);
        String hostName = (String)propertyMap.get(HOST_STACK_VERSION_HOST_NAME_PROPERTY_ID);
        String desiredRepoVersion = (String)propertyMap.get(HOST_STACK_VERSION_REPO_VERSION_PROPERTY_ID);
        String stackName = (String)propertyMap.get(HOST_STACK_VERSION_STACK_PROPERTY_ID);
        String stackVersion = (String)propertyMap.get(HOST_STACK_VERSION_VERSION_PROPERTY_ID);
        boolean forceInstallOnNonMemberHost = false;
        Set componentNames = null;
        String forceInstallOnNonMemberHostString = (String)propertyMap.get(HOST_STACK_VERSION_FORCE_INSTALL_ON_NON_MEMBER_HOST_PROPERTY_ID);
        if (BooleanUtils.toBoolean((String)forceInstallOnNonMemberHostString)) {
            forceInstallOnNonMemberHost = true;
            componentNames = (Set)propertyMap.get(HOST_STACK_VERSION_COMPONENT_NAMES_PROPERTY_ID);
            if (componentNames == null) {
                throw new IllegalArgumentException("In case " + HOST_STACK_VERSION_FORCE_INSTALL_ON_NON_MEMBER_HOST_PROPERTY_ID + " is set to true, the list of components should be specified in request.");
            }
        }
        RequestStageContainer req = this.createInstallPackagesRequest(hostName, desiredRepoVersion, stackName, stackVersion, clName, forceInstallOnNonMemberHost, componentNames);
        return this.getRequestStatus(req.getRequestStatusResponse());
    }

    private RequestStageContainer createInstallPackagesRequest(String hostName, String desiredRepoVersion, String stackName, String stackVersion, String clName, boolean forceInstallOnNonMemberHost, Set<Map<String, String>> componentNames) throws NoSuchParentResourceException, SystemException {
        String clusterHostInfoJson;
        Cluster cluster;
        Set<Cluster> clusterSet;
        Host host;
        try {
            host = this.getManagementController().getClusters().getHost(hostName);
        }
        catch (OBDPException e) {
            throw new NoSuchParentResourceException(String.format("Can not find host %s", hostName), e);
        }
        OBDPManagementController managementController = this.getManagementController();
        OBDPMetaInfo ami = managementController.getAmbariMetaInfo();
        StackId stackId = new StackId(stackName, stackVersion);
        if (!ami.isSupportedStack(stackName, stackVersion)) {
            throw new NoSuchParentResourceException(String.format("Stack %s is not supported", stackId));
        }
        if (clName == null) {
            try {
                clusterSet = this.getManagementController().getClusters().getClustersForHost(hostName);
            }
            catch (OBDPException e) {
                throw new NoSuchParentResourceException(String.format("Host %s does not belong to any cluster", hostName), e);
            }
        }
        try {
            cluster = this.getManagementController().getClusters().getCluster(clName);
        }
        catch (OBDPException e) {
            throw new NoSuchParentResourceException(String.format("Cluster %s does not exist", clName), e);
        }
        clusterSet = Collections.singleton(cluster);
        if (clusterSet.isEmpty()) {
            throw new UnsupportedOperationException(String.format("Host %s belongs to 0 clusters with stack id %s. Performing %s action failed.", hostName, stackId, INSTALL_PACKAGES_FULL_NAME));
        }
        if (clusterSet.size() > 1) {
            throw new UnsupportedOperationException(String.format("Host %s belongs to %d clusters with stack id %s. Performing %s action on multiple clusters is not supported", hostName, clusterSet.size(), stackId, INSTALL_PACKAGES_FULL_NAME));
        }
        cluster = clusterSet.iterator().next();
        RepositoryVersionEntity repoVersionEnt = repositoryVersionDAO.findByStackAndVersion(stackId, desiredRepoVersion);
        if (repoVersionEnt == null) {
            throw new IllegalArgumentException(String.format("Repo version %s is not available for stack %s", desiredRepoVersion, stackId));
        }
        HostVersionEntity hostVersEntity = hostVersionDAO.findByClusterStackVersionAndHost(clName, stackId, desiredRepoVersion, hostName);
        if (!forceInstallOnNonMemberHost) {
            if (hostVersEntity == null) {
                throw new IllegalArgumentException(String.format("Repo version %s for stack %s is not available for host %s", desiredRepoVersion, stackId, hostName));
            }
            if (hostVersEntity.getState() != RepositoryVersionState.INSTALLED && hostVersEntity.getState() != RepositoryVersionState.INSTALL_FAILED && hostVersEntity.getState() != RepositoryVersionState.OUT_OF_SYNC) {
                throw new UnsupportedOperationException(String.format("Repo version %s for stack %s for host %s is in %s state. Can not transition to INSTALLING state", desiredRepoVersion, stackId, hostName, hostVersEntity.getState().toString()));
            }
        }
        String osFamily = host.getOsFamily();
        RepoOsEntity osEntity = null;
        for (RepoOsEntity repoOsEntity : repoVersionEnt.getRepoOsEntities()) {
            if (!osFamily.equals(repoOsEntity.getFamily())) continue;
            osEntity = repoOsEntity;
            break;
        }
        if (null == osEntity) {
            throw new SystemException(String.format("Operating System matching %s could not be found", osFamily));
        }
        if (CollectionUtils.isEmpty(osEntity.getRepoDefinitionEntities())) {
            throw new SystemException(String.format("Repositories for os type %s are not defined. Repo version=%s, stackId=%s", osFamily, desiredRepoVersion, stackId));
        }
        HashSet<String> servicesOnHost = new HashSet<String>();
        if (forceInstallOnNonMemberHost) {
            for (Map<String, String> map : componentNames) {
                String componentName = map.get(COMPONENT_NAME_PROPERTY_ID);
                if (StringUtils.isEmpty((String)componentName)) {
                    throw new IllegalArgumentException("Components list contains a component with no 'name' property");
                }
                String serviceName = null;
                try {
                    serviceName = ami.getComponentToService(stackName, stackVersion, componentName.trim().toUpperCase());
                    if (serviceName == null) {
                        throw new IllegalArgumentException("Service not found for component : " + componentName);
                    }
                    servicesOnHost.add(serviceName);
                }
                catch (OBDPException e) {
                    LOG.error("Service not found for component {}!", (Object)componentName, (Object)e);
                    throw new IllegalArgumentException("Service not found for component : " + componentName);
                }
            }
        } else {
            List<ServiceComponentHost> list = cluster.getServiceComponentHosts(host.getHostName());
            for (ServiceComponentHost component : list) {
                servicesOnHost.add(component.getServiceName());
            }
        }
        Map<String, String> map = repoVersionHelper.buildRoleParams(managementController, repoVersionEnt, osFamily, servicesOnHost);
        RequestResourceFilter requestResourceFilter = new RequestResourceFilter(null, null, Collections.singletonList(hostName));
        map.put("overrideConfigs", null);
        map.put("overrideStackName", null);
        ActionExecutionContext actionContext = new ActionExecutionContext(null, INSTALL_PACKAGES_ACTION, Collections.singletonList(requestResourceFilter), map);
        actionContext.setTimeout(Integer.valueOf(configuration.getDefaultAgentTaskTimeout(true)));
        actionContext.setStackId(repoVersionEnt.getStackId());
        repoVersionHelper.addCommandRepositoryToContext(actionContext, repoVersionEnt, osEntity);
        String caption = String.format("Install Version on host %s", hostName);
        RequestStageContainer req = this.createRequest(caption);
        HashMap<String, String> hostLevelParams = new HashMap<String, String>();
        hostLevelParams.put("jdk_location", this.getManagementController().getJdkResourceUrl());
        try {
            clusterHostInfoJson = StageUtils.getGson().toJson(StageUtils.getClusterHostInfo(cluster));
        }
        catch (OBDPException e) {
            throw new SystemException("Could not build cluster topology", e);
        }
        Stage stage = stageFactory.createNew(req.getId(), "/tmp/obdp", cluster.getClusterName(), cluster.getClusterId(), caption, "{}", StageUtils.getGson().toJson(hostLevelParams));
        long stageId = req.getLastStageId() + 1L;
        if (0L == stageId) {
            stageId = 1L;
        }
        stage.setStageId(stageId);
        req.addStages(Collections.singletonList(stage));
        try {
            ((OBDPActionExecutionHelper)actionExecutionHelper.get()).addExecutionCommandsToStage(actionContext, stage, null, !forceInstallOnNonMemberHost);
        }
        catch (OBDPException e) {
            throw new SystemException("Can not modify stage", e);
        }
        if (forceInstallOnNonMemberHost) {
            this.addSelectStackStage(desiredRepoVersion, forceInstallOnNonMemberHost, cluster, requestResourceFilter, caption, req, hostLevelParams, clusterHostInfoJson);
        }
        try {
            if (!forceInstallOnNonMemberHost) {
                hostVersEntity.setState(RepositoryVersionState.INSTALLING);
                hostVersionDAO.merge(hostVersEntity);
            }
            req.persist();
        }
        catch (OBDPException e) {
            throw new SystemException("Can not persist request", e);
        }
        return req;
    }

    private void addSelectStackStage(String desiredRepoVersion, boolean forceInstallOnNonMemberHost, Cluster cluster, RequestResourceFilter filter, String caption, RequestStageContainer req, Map<String, String> hostLevelParams, String clusterHostInfoJson) throws SystemException {
        HashMap<String, String> commandParams = new HashMap<String, String>();
        commandParams.put("version", desiredRepoVersion);
        Stage stage = stageFactory.createNew(req.getId(), "/tmp/obdp", cluster.getClusterName(), cluster.getClusterId(), caption, StageUtils.getGson().toJson(commandParams), StageUtils.getGson().toJson(hostLevelParams));
        long stageId = req.getLastStageId() + 1L;
        if (0L == stageId) {
            stageId = 1L;
        }
        stage.setStageId(stageId);
        req.addStages(Collections.singletonList(stage));
        ActionExecutionContext actionContext = new ActionExecutionContext(null, STACK_SELECT_ACTION, Collections.singletonList(filter), Collections.emptyMap());
        actionContext.setTimeout(Integer.valueOf(configuration.getDefaultAgentTaskTimeout(true)));
        try {
            ((OBDPActionExecutionHelper)actionExecutionHelper.get()).addExecutionCommandsToStage(actionContext, stage, null, !forceInstallOnNonMemberHost);
        }
        catch (OBDPException e) {
            throw new SystemException("Can not modify stage", e);
        }
    }

    private RequestStageContainer createRequest(String caption) {
        ActionManager actionManager = this.getManagementController().getActionManager();
        RequestStageContainer requestStages = new RequestStageContainer(actionManager.getNextRequestId(), null, requestFactory, actionManager);
        requestStages.setRequestContext(caption);
        return requestStages;
    }

    @Override
    public RequestStatus updateResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new SystemException("Method not supported");
    }

    @Override
    public RequestStatus deleteResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new SystemException("Method not supported");
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return pkPropertyIds;
    }
}

