/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.ClusterNotFoundException;
import id.onyx.obdp.server.DuplicateResourceException;
import id.onyx.obdp.server.HostNotFoundException;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.ObjectNotFoundException;
import id.onyx.obdp.server.ParentObjectNotFoundException;
import id.onyx.obdp.server.agent.RecoveryConfigHelper;
import id.onyx.obdp.server.agent.stomp.HostLevelParamsHolder;
import id.onyx.obdp.server.agent.stomp.TopologyHolder;
import id.onyx.obdp.server.agent.stomp.dto.HostLevelParamsCluster;
import id.onyx.obdp.server.agent.stomp.dto.TopologyCluster;
import id.onyx.obdp.server.agent.stomp.dto.TopologyHost;
import id.onyx.obdp.server.controller.ConfigurationRequest;
import id.onyx.obdp.server.controller.HostRequest;
import id.onyx.obdp.server.controller.HostResponse;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.RequestStatusResponse;
import id.onyx.obdp.server.controller.ServiceComponentHostRequest;
import id.onyx.obdp.server.controller.internal.AbstractControllerResourceProvider;
import id.onyx.obdp.server.controller.internal.DeleteStatusMetaData;
import id.onyx.obdp.server.controller.internal.HostComponentResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.internal.ScaleClusterRequest;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.events.HostLevelParamsUpdateEvent;
import id.onyx.obdp.server.events.TopologyUpdateEvent;
import id.onyx.obdp.server.events.UpdateEventType;
import id.onyx.obdp.server.security.authorization.AuthorizationException;
import id.onyx.obdp.server.security.authorization.AuthorizationHelper;
import id.onyx.obdp.server.security.authorization.ResourceType;
import id.onyx.obdp.server.security.authorization.RoleAuthorization;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.Config;
import id.onyx.obdp.server.state.DesiredConfig;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.MaintenanceState;
import id.onyx.obdp.server.state.ServiceComponentHost;
import id.onyx.obdp.server.state.stack.OsFamily;
import id.onyx.obdp.server.topology.ClusterTopology;
import id.onyx.obdp.server.topology.InvalidTopologyException;
import id.onyx.obdp.server.topology.InvalidTopologyTemplateException;
import id.onyx.obdp.server.topology.LogicalRequest;
import id.onyx.obdp.server.topology.TopologyManager;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostResourceProvider
extends AbstractControllerResourceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(HostResourceProvider.class);
    public static final String RESPONSE_KEY = "Hosts";
    public static final String ALL_PROPERTIES = "Hosts/*";
    public static final String CLUSTER_NAME_PROPERTY_ID = "cluster_name";
    public static final String CPU_COUNT_PROPERTY_ID = "cpu_count";
    public static final String DESIRED_CONFIGS_PROPERTY_ID = "desired_configs";
    public static final String DISK_INFO_PROPERTY_ID = "disk_info";
    public static final String HOST_HEALTH_REPORT_PROPERTY_ID = "host_health_report";
    public static final String HOST_NAME_PROPERTY_ID = "host_name";
    public static final String HOST_STATUS_PROPERTY_ID = "host_status";
    public static final String IP_PROPERTY_ID = "ip";
    public static final String LAST_AGENT_ENV_PROPERTY_ID = "last_agent_env";
    public static final String LAST_HEARTBEAT_TIME_PROPERTY_ID = "last_heartbeat_time";
    public static final String LAST_REGISTRATION_TIME_PROPERTY_ID = "last_registration_time";
    public static final String MAINTENANCE_STATE_PROPERTY_ID = "maintenance_state";
    public static final String OS_ARCH_PROPERTY_ID = "os_arch";
    public static final String OS_FAMILY_PROPERTY_ID = "os_family";
    public static final String OS_TYPE_PROPERTY_ID = "os_type";
    public static final String PHYSICAL_CPU_COUNT_PROPERTY_ID = "ph_cpu_count";
    public static final String PUBLIC_NAME_PROPERTY_ID = "public_host_name";
    public static final String RACK_INFO_PROPERTY_ID = "rack_info";
    public static final String RECOVERY_REPORT_PROPERTY_ID = "recovery_report";
    public static final String RECOVERY_SUMMARY_PROPERTY_ID = "recovery_summary";
    public static final String STATE_PROPERTY_ID = "host_state";
    public static final String TOTAL_MEM_PROPERTY_ID = "total_mem";
    public static final String ATTRIBUTES_PROPERTY_ID = "attributes";
    public static final String HOST_CLUSTER_NAME_PROPERTY_ID = "Hosts/cluster_name";
    public static final String HOST_CPU_COUNT_PROPERTY_ID = "Hosts/cpu_count";
    public static final String HOST_DESIRED_CONFIGS_PROPERTY_ID = "Hosts/desired_configs";
    public static final String HOST_DISK_INFO_PROPERTY_ID = "Hosts/disk_info";
    public static final String HOST_HOST_HEALTH_REPORT_PROPERTY_ID = "Hosts/host_health_report";
    public static final String HOST_HOST_STATUS_PROPERTY_ID = "Hosts/host_status";
    public static final String HOST_IP_PROPERTY_ID = "Hosts/ip";
    public static final String HOST_LAST_AGENT_ENV_PROPERTY_ID = "Hosts/last_agent_env";
    public static final String HOST_LAST_HEARTBEAT_TIME_PROPERTY_ID = "Hosts/last_heartbeat_time";
    public static final String HOST_LAST_REGISTRATION_TIME_PROPERTY_ID = "Hosts/last_registration_time";
    public static final String HOST_MAINTENANCE_STATE_PROPERTY_ID = "Hosts/maintenance_state";
    public static final String HOST_HOST_NAME_PROPERTY_ID = "Hosts/host_name";
    public static final String HOST_OS_ARCH_PROPERTY_ID = "Hosts/os_arch";
    public static final String HOST_OS_FAMILY_PROPERTY_ID = "Hosts/os_family";
    public static final String HOST_OS_TYPE_PROPERTY_ID = "Hosts/os_type";
    public static final String HOST_PHYSICAL_CPU_COUNT_PROPERTY_ID = "Hosts/ph_cpu_count";
    public static final String HOST_PUBLIC_NAME_PROPERTY_ID = "Hosts/public_host_name";
    public static final String HOST_RACK_INFO_PROPERTY_ID = "Hosts/rack_info";
    public static final String HOST_RECOVERY_REPORT_PROPERTY_ID = "Hosts/recovery_report";
    public static final String HOST_RECOVERY_SUMMARY_PROPERTY_ID = "Hosts/recovery_summary";
    public static final String HOST_STATE_PROPERTY_ID = "Hosts/host_state";
    public static final String HOST_TOTAL_MEM_PROPERTY_ID = "Hosts/total_mem";
    public static final String HOST_ATTRIBUTES_PROPERTY_ID = PropertyHelper.getPropertyId("Hosts", "attributes");
    public static final String BLUEPRINT_PROPERTY_ID = "blueprint";
    public static final String HOST_GROUP_PROPERTY_ID = "host_group";
    public static final String HOST_COUNT_PROPERTY_ID = "host_count";
    public static final String HOST_PREDICATE_PROPERTY_ID = "host_predicate";
    public static final Map<Resource.Type, String> keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.Host, (Object)"Hosts/host_name").put((Object)Resource.Type.Cluster, (Object)"Hosts/cluster_name").build();
    public static final Set<String> propertyIds = ImmutableSet.of((Object)"Hosts/cluster_name", (Object)"Hosts/cpu_count", (Object)"Hosts/desired_configs", (Object)"Hosts/disk_info", (Object)"Hosts/host_health_report", (Object)"Hosts/host_status", (Object[])new String[]{"Hosts/ip", "Hosts/last_agent_env", "Hosts/last_heartbeat_time", "Hosts/last_registration_time", "Hosts/maintenance_state", "Hosts/host_name", "Hosts/os_arch", "Hosts/os_family", "Hosts/os_type", "Hosts/ph_cpu_count", "Hosts/public_host_name", "Hosts/rack_info", "Hosts/recovery_report", "Hosts/recovery_summary", "Hosts/host_state", "Hosts/total_mem", HOST_ATTRIBUTES_PROPERTY_ID});
    @Inject
    private OsFamily osFamily;
    @Inject
    private static TopologyManager topologyManager;
    @Inject
    private TopologyHolder topologyHolder;
    @Inject
    private HostLevelParamsHolder hostLevelParamsHolder;
    @Inject
    private RecoveryConfigHelper recoveryConfigHelper;

    @AssistedInject
    HostResourceProvider(@Assisted OBDPManagementController managementController) {
        super(Resource.Type.Host, propertyIds, keyPropertyIds, managementController);
        EnumSet<RoleAuthorization> authorizationsAddDelete = EnumSet.of(RoleAuthorization.HOST_ADD_DELETE_HOSTS);
        this.setRequiredCreateAuthorizations(authorizationsAddDelete);
        this.setRequiredDeleteAuthorizations(authorizationsAddDelete);
        this.setRequiredGetAuthorizations(RoleAuthorization.AUTHORIZATIONS_VIEW_CLUSTER);
        this.setRequiredUpdateAuthorizations(RoleAuthorization.AUTHORIZATIONS_UPDATE_CLUSTER);
    }

    @Override
    protected RequestStatus createResourcesAuthorized(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        RequestStatusResponse createResponse = null;
        if (this.isHostGroupRequest(request)) {
            createResponse = this.submitHostRequests(request);
        } else {
            this.createResources(() -> {
                this.createHosts(request);
                return null;
            });
        }
        this.notifyCreate(Resource.Type.Host, request);
        return this.getRequestStatus(createResponse);
    }

    @Override
    protected Set<Resource> getResourcesAuthorized(Request request, Predicate predicate) throws SystemException, NoSuchResourceException, NoSuchParentResourceException {
        HashSet<HostRequest> requests = new HashSet<HostRequest>();
        if (predicate == null) {
            requests.add(this.getRequest(null));
        } else {
            for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
                requests.add(this.getRequest(propertyMap));
            }
        }
        Set responses = this.getResources(() -> this.getHosts(requests));
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        HashSet<Resource> resources = new HashSet<Resource>();
        for (HostResponse response : responses) {
            ResourceImpl resource = new ResourceImpl(Resource.Type.Host);
            if (response.getClusterName() != null && !response.getClusterName().isEmpty()) {
                HostResourceProvider.setResourceProperty(resource, HOST_CLUSTER_NAME_PROPERTY_ID, response.getClusterName(), requestedIds);
            }
            HostResourceProvider.setResourceProperty(resource, HOST_HOST_NAME_PROPERTY_ID, response.getHostname(), requestedIds);
            HostResourceProvider.setResourceProperty(resource, HOST_PUBLIC_NAME_PROPERTY_ID, response.getPublicHostName(), requestedIds);
            HostResourceProvider.setResourceProperty(resource, HOST_IP_PROPERTY_ID, response.getIpv4(), requestedIds);
            HostResourceProvider.setResourceProperty(resource, HOST_TOTAL_MEM_PROPERTY_ID, response.getTotalMemBytes(), requestedIds);
            HostResourceProvider.setResourceProperty(resource, HOST_CPU_COUNT_PROPERTY_ID, response.getCpuCount(), requestedIds);
            HostResourceProvider.setResourceProperty(resource, HOST_PHYSICAL_CPU_COUNT_PROPERTY_ID, response.getPhCpuCount(), requestedIds);
            HostResourceProvider.setResourceProperty(resource, HOST_OS_ARCH_PROPERTY_ID, response.getOsArch(), requestedIds);
            HostResourceProvider.setResourceProperty(resource, HOST_OS_TYPE_PROPERTY_ID, response.getOsType(), requestedIds);
            HostResourceProvider.setResourceProperty(resource, HOST_OS_FAMILY_PROPERTY_ID, response.getOsFamily(), requestedIds);
            HostResourceProvider.setResourceProperty(resource, HOST_RACK_INFO_PROPERTY_ID, response.getRackInfo(), requestedIds);
            HostResourceProvider.setResourceProperty(resource, HOST_LAST_HEARTBEAT_TIME_PROPERTY_ID, response.getLastHeartbeatTime(), requestedIds);
            HostResourceProvider.setResourceProperty(resource, HOST_LAST_AGENT_ENV_PROPERTY_ID, response.getLastAgentEnv(), requestedIds);
            HostResourceProvider.setResourceProperty(resource, HOST_LAST_REGISTRATION_TIME_PROPERTY_ID, response.getLastRegistrationTime(), requestedIds);
            HostResourceProvider.setResourceProperty(resource, HOST_HOST_STATUS_PROPERTY_ID, response.getStatus(), requestedIds);
            HostResourceProvider.setResourceProperty(resource, HOST_HOST_HEALTH_REPORT_PROPERTY_ID, response.getHealthReport(), requestedIds);
            HostResourceProvider.setResourceProperty(resource, HOST_RECOVERY_REPORT_PROPERTY_ID, response.getRecoveryReport(), requestedIds);
            HostResourceProvider.setResourceProperty(resource, HOST_RECOVERY_SUMMARY_PROPERTY_ID, response.getRecoverySummary(), requestedIds);
            HostResourceProvider.setResourceProperty(resource, HOST_DISK_INFO_PROPERTY_ID, response.getDisksInfo(), requestedIds);
            HostResourceProvider.setResourceProperty(resource, HOST_STATE_PROPERTY_ID, (Object)response.getHostState(), requestedIds);
            HostResourceProvider.setResourceProperty(resource, HOST_DESIRED_CONFIGS_PROPERTY_ID, response.getDesiredHostConfigs(), requestedIds);
            if (null != response.getMaintenanceState()) {
                HostResourceProvider.setResourceProperty(resource, HOST_MAINTENANCE_STATE_PROPERTY_ID, (Object)response.getMaintenanceState(), requestedIds);
            }
            resources.add(resource);
        }
        return resources;
    }

    @Override
    protected RequestStatus updateResourcesAuthorized(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        HashSet<HostRequest> requests = new HashSet<HostRequest>();
        for (Map<String, Object> propertyMap : this.getPropertyMaps(request.getProperties().iterator().next(), predicate)) {
            requests.add(this.getRequest(propertyMap));
        }
        this.modifyResources(() -> {
            this.updateHosts(requests);
            return null;
        });
        this.notifyUpdate(Resource.Type.Host, request, predicate);
        return this.getRequestStatus(null);
    }

    @Override
    protected RequestStatus deleteResourcesAuthorized(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        HashSet<HostRequest> requests = new HashSet<HostRequest>();
        for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
            requests.add(this.getRequest(propertyMap));
        }
        DeleteStatusMetaData deleteStatusMetaData = this.modifyResources(() -> this.deleteHosts(requests, request.isDryRunRequest()));
        if (!request.isDryRunRequest()) {
            this.notifyDelete(Resource.Type.Host, predicate);
        }
        return this.getRequestStatus(null, null, deleteStatusMetaData);
    }

    @Override
    public Set<String> checkPropertyIds(Set<String> propertyIds) {
        Set<String> baseUnsupported = super.checkPropertyIds(propertyIds);
        baseUnsupported.remove(BLUEPRINT_PROPERTY_ID);
        baseUnsupported.remove(HOST_GROUP_PROPERTY_ID);
        baseUnsupported.remove(HOST_NAME_PROPERTY_ID);
        baseUnsupported.remove(HOST_COUNT_PROPERTY_ID);
        baseUnsupported.remove(HOST_PREDICATE_PROPERTY_ID);
        baseUnsupported.remove(RACK_INFO_PROPERTY_ID);
        return this.checkConfigPropertyIds(baseUnsupported, RESPONSE_KEY);
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return new HashSet<String>(keyPropertyIds.values());
    }

    private boolean isHostGroupRequest(Request request) {
        boolean isHostGroupRequest = false;
        Set<Map<String, Object>> properties = request.getProperties();
        if (properties != null && !properties.isEmpty()) {
            String hgName = (String)properties.iterator().next().get(HOST_GROUP_PROPERTY_ID);
            isHostGroupRequest = hgName != null && !hgName.isEmpty();
        }
        return isHostGroupRequest;
    }

    private HostRequest getRequest(Map<String, Object> properties) {
        if (properties == null) {
            return new HostRequest(null, null);
        }
        HostRequest hostRequest = new HostRequest(HostResourceProvider.getHostNameFromProperties(properties), (String)properties.get(HOST_CLUSTER_NAME_PROPERTY_ID));
        hostRequest.setPublicHostName((String)properties.get(HOST_PUBLIC_NAME_PROPERTY_ID));
        String rackInfo = (String)(null != properties.get(HOST_RACK_INFO_PROPERTY_ID) ? properties.get(HOST_RACK_INFO_PROPERTY_ID) : properties.get(RACK_INFO_PROPERTY_ID));
        hostRequest.setRackInfo(rackInfo);
        hostRequest.setBlueprintName((String)properties.get(BLUEPRINT_PROPERTY_ID));
        hostRequest.setHostGroupName((String)properties.get(HOST_GROUP_PROPERTY_ID));
        Object o = properties.get(HOST_MAINTENANCE_STATE_PROPERTY_ID);
        if (null != o) {
            hostRequest.setMaintenanceState(o.toString());
        }
        List<ConfigurationRequest> cr = HostResourceProvider.getConfigurationRequests(RESPONSE_KEY, properties);
        hostRequest.setDesiredConfigs(cr);
        return hostRequest;
    }

    public synchronized void createHosts(Request request) throws OBDPException, AuthorizationException {
        Set<Map<String, Object>> propertySet = request.getProperties();
        if (propertySet == null || propertySet.isEmpty()) {
            LOG.warn("Received a create host request with no associated property sets");
            return;
        }
        OBDPManagementController controller = this.getManagementController();
        Clusters clusters = controller.getClusters();
        HashSet<String> duplicates = new HashSet<String>();
        HashSet<String> unknowns = new HashSet<String>();
        HashSet<String> allHosts = new HashSet<String>();
        HashSet<HostRequest> hostRequests = new HashSet<HostRequest>();
        for (Map<String, Object> propertyMap : propertySet) {
            HostRequest hostRequest = this.getRequest(propertyMap);
            hostRequests.add(hostRequest);
            if (propertyMap.containsKey(HOST_GROUP_PROPERTY_ID)) continue;
            this.createHostResource(clusters, duplicates, unknowns, allHosts, hostRequest);
        }
        if (!duplicates.isEmpty()) {
            throw new IllegalArgumentException("Invalid request contains duplicate hostnames, hostnames=" + String.join((CharSequence)",", duplicates));
        }
        if (!unknowns.isEmpty()) {
            throw new IllegalArgumentException("Attempted to add unknown hosts to a cluster.  These hosts have not been registered with the server: " + String.join((CharSequence)",", unknowns));
        }
        HashMap<String, Set<String>> hostClustersMap = new HashMap<String, Set<String>>();
        HashMap<String, Map<String, String>> hostAttributes = new HashMap<String, Map<String, String>>();
        HashSet<String> allClusterSet = new HashSet<String>();
        TreeMap<String, TopologyCluster> addedTopologies = new TreeMap<String, TopologyCluster>();
        ArrayList<HostLevelParamsUpdateEvent> hostLevelParamsUpdateEvents = new ArrayList<HostLevelParamsUpdateEvent>();
        for (HostRequest hostRequest : hostRequests) {
            if (hostRequest.getHostname() == null || hostRequest.getHostname().isEmpty() || hostRequest.getClusterName() == null || hostRequest.getClusterName().isEmpty()) continue;
            HashSet<String> clusterSet = new HashSet<String>();
            clusterSet.add(hostRequest.getClusterName());
            allClusterSet.add(hostRequest.getClusterName());
            hostClustersMap.put(hostRequest.getHostname(), clusterSet);
            Cluster cl = clusters.getCluster(hostRequest.getClusterName());
            String clusterId = Long.toString(cl.getClusterId());
            if (!addedTopologies.containsKey(clusterId)) {
                addedTopologies.put(clusterId, new TopologyCluster());
            }
            Host addedHost = clusters.getHost(hostRequest.getHostname());
            addedTopologies.get(clusterId).addTopologyHost(new TopologyHost(addedHost.getHostId(), addedHost.getHostName(), addedHost.getRackInfo(), addedHost.getIPv4()));
            HostLevelParamsUpdateEvent hostLevelParamsUpdateEvent = new HostLevelParamsUpdateEvent(addedHost.getHostId(), clusterId, new HostLevelParamsCluster(this.recoveryConfigHelper.getRecoveryConfig(cl.getClusterName(), addedHost.getHostName()), this.getManagementController().getBlueprintProvisioningStates(cl.getClusterId(), addedHost.getHostId())));
            hostLevelParamsUpdateEvents.add(hostLevelParamsUpdateEvent);
        }
        clusters.updateHostWithClusterAndAttributes(hostClustersMap, hostAttributes);
        this.updateHostRackInfoIfChanged(clusters, hostRequests);
        for (HostLevelParamsUpdateEvent hostLevelParamsUpdateEvent : hostLevelParamsUpdateEvents) {
            this.hostLevelParamsHolder.updateData(hostLevelParamsUpdateEvent);
        }
        TopologyUpdateEvent topologyUpdateEvent = new TopologyUpdateEvent(addedTopologies, UpdateEventType.UPDATE);
        this.topologyHolder.updateData(topologyUpdateEvent);
    }

    private void updateHostRackInfoIfChanged(Clusters clusters, Set<HostRequest> hostRequests) throws OBDPException, AuthorizationException {
        HashSet<String> rackChangeAffectedClusters = new HashSet<String>();
        for (HostRequest hostRequest : hostRequests) {
            Host host;
            Cluster cluster;
            String clusterName = hostRequest.getClusterName();
            if (!StringUtils.isNotBlank((String)clusterName) || !this.updateHostRackInfoIfChanged(cluster = clusters.getCluster(clusterName), host = clusters.getHost(hostRequest.getHostname()), hostRequest)) continue;
            rackChangeAffectedClusters.add(clusterName);
        }
        for (String clusterName : rackChangeAffectedClusters) {
            this.getManagementController().registerRackChange(clusterName);
        }
    }

    private boolean updateHostRackInfoIfChanged(Cluster cluster, Host host, HostRequest hostRequest) throws OBDPException, AuthorizationException {
        boolean rackChange;
        Long resourceId = cluster.getResourceId();
        String hostRackInfo = host.getRackInfo();
        String requestRackInfo = hostRequest.getRackInfo();
        boolean bl = rackChange = requestRackInfo != null && !requestRackInfo.equals(hostRackInfo);
        if (rackChange) {
            if (!AuthorizationHelper.isAuthorized(ResourceType.CLUSTER, resourceId, RoleAuthorization.HOST_ADD_DELETE_HOSTS)) {
                throw new AuthorizationException("The authenticated user is not authorized to update host rack information");
            }
            host.setRackInfo(requestRackInfo);
        }
        return rackChange;
    }

    private void createHostResource(Clusters clusters, Set<String> duplicates, Set<String> unknowns, Set<String> allHosts, HostRequest request) throws OBDPException {
        if (request.getHostname() == null || request.getHostname().isEmpty()) {
            throw new IllegalArgumentException("Invalid arguments, hostname cannot be null");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received a createHost request, hostname={}, request={}", (Object)request.getHostname(), (Object)request);
        }
        if (allHosts.contains(request.getHostname())) {
            duplicates.add(request.getHostname());
            return;
        }
        allHosts.add(request.getHostname());
        try {
            clusters.getHost(request.getHostname());
        }
        catch (HostNotFoundException e) {
            unknowns.add(request.getHostname());
            return;
        }
        if (request.getClusterName() != null) {
            try {
                clusters.getCluster(request.getClusterName());
            }
            catch (ClusterNotFoundException e) {
                throw new ParentObjectNotFoundException("Attempted to add a host to a cluster which doesn't exist:  clusterName=" + request.getClusterName());
            }
        }
    }

    public RequestStatusResponse install(String cluster, String hostname, Collection<String> skipInstallForComponents, Collection<String> dontSkipInstallForComponents, boolean skipFailure, boolean useClusterHostInfo) throws SystemException, NoSuchParentResourceException, UnsupportedPropertyException {
        return ((HostComponentResourceProvider)HostResourceProvider.getResourceProvider(Resource.Type.HostComponent)).install(cluster, hostname, skipInstallForComponents, dontSkipInstallForComponents, skipFailure, useClusterHostInfo);
    }

    public RequestStatusResponse start(String cluster, String hostname) throws SystemException, NoSuchParentResourceException, UnsupportedPropertyException {
        return ((HostComponentResourceProvider)HostResourceProvider.getResourceProvider(Resource.Type.HostComponent)).start(cluster, hostname);
    }

    protected Set<HostResponse> getHosts(Set<HostRequest> requests) throws OBDPException {
        HashSet<HostResponse> response = new HashSet<HostResponse>();
        OBDPManagementController controller = this.getManagementController();
        for (HostRequest request : requests) {
            try {
                response.addAll(HostResourceProvider.getHosts(controller, request, this.osFamily));
            }
            catch (HostNotFoundException e) {
                if (requests.size() != 1) continue;
                throw e;
            }
        }
        return response;
    }

    protected static Set<HostResponse> getHosts(OBDPManagementController controller, HostRequest request, OsFamily osFamily) throws OBDPException {
        List<Host> hosts;
        HashSet<HostResponse> response = new HashSet<HostResponse>();
        Cluster cluster = null;
        Clusters clusters = controller.getClusters();
        String clusterName = request.getClusterName();
        String hostName = request.getHostname();
        if (clusterName != null) {
            try {
                cluster = clusters.getCluster(clusterName);
            }
            catch (ObjectNotFoundException e) {
                throw new ParentObjectNotFoundException("Parent Cluster resource doesn't exist", e);
            }
        }
        if (hostName == null) {
            hosts = clusters.getHosts();
        } else {
            hosts = new ArrayList<Host>();
            try {
                hosts.add(clusters.getHost(request.getHostname()));
            }
            catch (HostNotFoundException e) {
                throw new HostNotFoundException(clusterName, hostName);
            }
        }
        Map<String, DesiredConfig> desiredConfigs = null;
        if (null != cluster) {
            desiredConfigs = cluster.getDesiredConfigs();
        }
        for (Host h : hosts) {
            HostResponse r;
            if (clusterName != null) {
                if (clusters.getClustersForHost(h.getHostName()).contains(cluster)) {
                    r = h.convertToResponse();
                    r.setClusterName(clusterName);
                    r.setDesiredHostConfigs(h.getDesiredHostConfigs(cluster, desiredConfigs));
                    r.setMaintenanceState(h.getMaintenanceState(cluster.getClusterId()));
                    if (osFamily != null) {
                        String hostOsFamily = osFamily.find(r.getOsType());
                        if (hostOsFamily == null) {
                            LOG.error("Can not find host OS family. For OS type = '{}' and host name = '{}'", (Object)r.getOsType(), (Object)r.getHostname());
                        }
                        r.setOsFamily(hostOsFamily);
                    }
                    response.add(r);
                    continue;
                }
                if (hostName == null) continue;
                throw new HostNotFoundException(clusterName, hostName);
            }
            r = h.convertToResponse();
            Set<Cluster> clustersForHost = clusters.getClustersForHost(h.getHostName());
            if (clustersForHost != null && clustersForHost.size() != 0) {
                Cluster clusterForHost = clustersForHost.iterator().next();
                r.setClusterName(clusterForHost.getClusterName());
                r.setDesiredHostConfigs(h.getDesiredHostConfigs(clusterForHost, null));
                r.setMaintenanceState(h.getMaintenanceState(clusterForHost.getClusterId()));
            }
            response.add(r);
        }
        return response;
    }

    protected synchronized void updateHosts(Set<HostRequest> requests) throws OBDPException, AuthorizationException {
        if (requests.isEmpty()) {
            LOG.warn("Received an empty requests set");
            return;
        }
        OBDPManagementController controller = this.getManagementController();
        Clusters clusters = controller.getClusters();
        for (HostRequest request : requests) {
            if (request.getHostname() != null && !request.getHostname().isEmpty()) continue;
            throw new IllegalArgumentException("Invalid arguments, hostname should be provided");
        }
        TreeMap<String, TopologyCluster> topologyUpdates = new TreeMap<String, TopologyCluster>();
        for (HostRequest request : requests) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Received an updateHost request, hostname={}, request={}", (Object)request.getHostname(), (Object)request);
            }
            Host host = clusters.getHost(request.getHostname());
            String clusterName = request.getClusterName();
            Cluster cluster = clusters.getCluster(clusterName);
            Long clusterId = cluster.getClusterId();
            Long resourceId = cluster.getResourceId();
            TopologyHost topologyHost = new TopologyHost(host.getHostId(), host.getHostName());
            try {
                clusters.mapAndPublishHostsToCluster(new HashSet<String>(Arrays.asList(request.getHostname())), clusterName);
            }
            catch (DuplicateResourceException duplicateResourceException) {
                // empty catch block
            }
            boolean rackChange = this.updateHostRackInfoIfChanged(cluster, host, request);
            if (rackChange) {
                topologyHost.setRackName(host.getRackInfo());
            }
            if (null != request.getPublicHostName()) {
                if (!AuthorizationHelper.isAuthorized(ResourceType.CLUSTER, resourceId, RoleAuthorization.HOST_ADD_DELETE_HOSTS)) {
                    throw new AuthorizationException("The authenticated user is not authorized to update host attributes");
                }
                host.setPublicHostName(request.getPublicHostName());
                topologyHost.setHostName(request.getPublicHostName());
            }
            if (null != clusterName && null != request.getMaintenanceState()) {
                MaintenanceState oldState;
                if (!AuthorizationHelper.isAuthorized(ResourceType.CLUSTER, resourceId, RoleAuthorization.HOST_TOGGLE_MAINTENANCE)) {
                    throw new AuthorizationException("The authenticated user is not authorized to update host maintenance state");
                }
                Object newState = MaintenanceState.valueOf(request.getMaintenanceState());
                if (!newState.equals((Object)(oldState = host.getMaintenanceState(clusterId)))) {
                    if (newState.equals((Object)MaintenanceState.IMPLIED_FROM_HOST) || newState.equals((Object)MaintenanceState.IMPLIED_FROM_SERVICE)) {
                        throw new IllegalArgumentException("Invalid arguments, can only set maintenance state to one of " + EnumSet.of(MaintenanceState.OFF, MaintenanceState.ON));
                    }
                    host.setMaintenanceState(clusterId, (MaintenanceState)((Object)newState));
                }
            }
            if (null != clusterName && null != request.getDesiredConfigs() && clusters.getHostsForCluster(clusterName).containsKey(host.getHostName())) {
                for (ConfigurationRequest cr : request.getDesiredConfigs()) {
                    Config baseConfig;
                    if (null != cr.getProperties() && cr.getProperties().size() > 0) {
                        LOG.info(MessageFormat.format("Applying configuration with tag ''{0}'' to host ''{1}'' in cluster ''{2}''", cr.getVersionTag(), request.getHostname(), clusterName));
                        cr.setClusterName(cluster.getClusterName());
                        controller.createConfiguration(cr);
                    }
                    if (null == (baseConfig = cluster.getConfig(cr.getType(), cr.getVersionTag()))) continue;
                    String authName = controller.getAuthName();
                    DesiredConfig oldConfig = host.getDesiredConfigs(clusterId).get(cr.getType());
                    if (!host.addDesiredConfig(clusterId, cr.isSelected(), authName, baseConfig)) continue;
                    Logger logger = LoggerFactory.getLogger((String)"configchange");
                    logger.info("(configchange) cluster '" + cluster.getClusterName() + "', host '" + host.getHostName() + "' changed by: '" + authName + "'; type='" + baseConfig.getType() + "' version='" + baseConfig.getVersion() + "'tag='" + baseConfig.getTag() + "'" + (String)(null == oldConfig ? "" : ", from='" + oldConfig.getTag() + "'"));
                }
            }
            if (StringUtils.isNotBlank((String)clusterName) && rackChange) {
                controller.registerRackChange(clusterName);
            }
            if (!topologyUpdates.containsKey(clusterId.toString())) {
                topologyUpdates.put(clusterId.toString(), new TopologyCluster());
            }
            ((TopologyCluster)topologyUpdates.get(clusterId.toString())).addTopologyHost(topologyHost);
            TopologyUpdateEvent topologyUpdateEvent = new TopologyUpdateEvent(topologyUpdates, UpdateEventType.UPDATE);
            this.topologyHolder.updateData(topologyUpdateEvent);
        }
    }

    @Transactional
    protected DeleteStatusMetaData deleteHosts(Set<HostRequest> requests, boolean dryRun) throws OBDPException {
        OBDPManagementController controller = this.getManagementController();
        Clusters clusters = controller.getClusters();
        DeleteStatusMetaData deleteStatusMetaData = new DeleteStatusMetaData();
        ArrayList<HostRequest> okToRemove = new ArrayList<HostRequest>();
        for (HostRequest hostRequest : requests) {
            String hostName = hostRequest.getHostname();
            if (null == hostName) continue;
            try {
                this.validateHostInDeleteFriendlyState(hostRequest, clusters);
                okToRemove.add(hostRequest);
            }
            catch (Exception ex) {
                deleteStatusMetaData.addException(hostName, ex);
            }
        }
        if (dryRun) {
            for (HostRequest request : okToRemove) {
                deleteStatusMetaData.addDeletedKey(request.getHostname());
            }
        } else {
            this.processDeleteHostRequests(okToRemove, clusters, deleteStatusMetaData);
        }
        if (!dryRun && deleteStatusMetaData.getDeletedKeys().size() + deleteStatusMetaData.getExceptionForKeys().size() == 1) {
            if (deleteStatusMetaData.getDeletedKeys().size() == 1) {
                return null;
            }
            Iterator<Object> iterator = deleteStatusMetaData.getExceptionForKeys().entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                Exception ex = (Exception)entry.getValue();
                if (ex instanceof OBDPException) {
                    throw (OBDPException)((Object)ex);
                }
                throw new OBDPException(ex.getMessage(), (Throwable)ex);
            }
        }
        return deleteStatusMetaData;
    }

    private void processDeleteHostRequests(List<HostRequest> requests, Clusters clusters, DeleteStatusMetaData deleteStatusMetaData) throws OBDPException {
        HashSet<String> hostsClusters = new HashSet<String>();
        HashSet<String> hostNames = new HashSet<String>();
        HashSet<Long> hostIds = new HashSet<Long>();
        TreeMap<String, TopologyCluster> topologyUpdates = new TreeMap<String, TopologyCluster>();
        for (HostRequest hostRequest : requests) {
            String hostname = hostRequest.getHostname();
            Long hostId = clusters.getHost(hostname).getHostId();
            hostNames.add(hostname);
            hostIds.add(hostId);
            if (hostRequest.getClusterName() != null) {
                hostsClusters.add(hostRequest.getClusterName());
            }
            LOG.info("Received Delete request for host {} from cluster {}.", (Object)hostname, (Object)hostRequest.getClusterName());
            HashSet<ServiceComponentHostRequest> schrs = new HashSet<ServiceComponentHostRequest>();
            for (Cluster cluster : clusters.getClustersForHost(hostname)) {
                List<ServiceComponentHost> list = cluster.getServiceComponentHosts(hostname);
                for (ServiceComponentHost sch : list) {
                    ServiceComponentHostRequest schr = new ServiceComponentHostRequest(cluster.getClusterName(), sch.getServiceName(), sch.getServiceComponentName(), sch.getHostName(), null);
                    schrs.add(schr);
                }
            }
            DeleteStatusMetaData componentDeleteStatus = null;
            if (schrs.size() > 0) {
                try {
                    componentDeleteStatus = this.getManagementController().deleteHostComponents(schrs);
                }
                catch (Exception ex) {
                    deleteStatusMetaData.addException(hostname, ex);
                }
            }
            if (componentDeleteStatus != null) {
                for (String string : componentDeleteStatus.getDeletedKeys()) {
                    deleteStatusMetaData.addDeletedKey(string);
                }
                for (String string : componentDeleteStatus.getExceptionForKeys().keySet()) {
                    deleteStatusMetaData.addException(string, componentDeleteStatus.getExceptionForKeys().get(string));
                }
            }
            if (hostRequest.getClusterName() != null) {
                hostsClusters.add(hostRequest.getClusterName());
            }
            try {
                HashSet<Cluster> hostClusters = new HashSet<Cluster>(clusters.getClustersForHost(hostname));
                clusters.deleteHost(hostname);
                for (Cluster cluster : hostClusters) {
                    String clusterId = Long.toString(cluster.getClusterId());
                    if (!topologyUpdates.containsKey(clusterId)) {
                        topologyUpdates.put(clusterId, new TopologyCluster());
                    }
                    topologyUpdates.get(clusterId).getTopologyHosts().add(new TopologyHost(hostId, hostname));
                }
                deleteStatusMetaData.addDeletedKey(hostname);
            }
            catch (Exception ex) {
                deleteStatusMetaData.addException(hostname, ex);
            }
            this.removeHostFromClusterTopology(clusters, hostRequest);
            for (LogicalRequest logicalRequest : topologyManager.getRequests(Collections.emptyList())) {
                logicalRequest.removeHostRequestByHostName(hostname);
            }
        }
        clusters.publishHostsDeletion(hostIds, hostNames);
        TopologyUpdateEvent topologyUpdateEvent = new TopologyUpdateEvent(topologyUpdates, UpdateEventType.DELETE);
        this.topologyHolder.updateData(topologyUpdateEvent);
    }

    private void validateHostInDeleteFriendlyState(HostRequest hostRequest, Clusters clusters) throws OBDPException {
        HashSet<String> clusterNamesForHost = new HashSet<String>();
        String hostName = hostRequest.getHostname();
        if (null != hostRequest.getClusterName()) {
            clusterNamesForHost.add(hostRequest.getClusterName());
        } else {
            Set<Cluster> clustersForHost = clusters.getClustersForHost(hostRequest.getHostname());
            if (null != clustersForHost) {
                for (Cluster c : clustersForHost) {
                    clusterNamesForHost.add(c.getClusterName());
                }
            }
        }
        for (String clusterName : clusterNamesForHost) {
            Cluster cluster = clusters.getCluster(clusterName);
            List<ServiceComponentHost> list = cluster.getServiceComponentHosts(hostName);
            if (list.isEmpty()) continue;
            ArrayList<String> componentsStarted = new ArrayList<String>();
            for (ServiceComponentHost sch : list) {
                if (sch.canBeRemoved()) continue;
                componentsStarted.add(sch.getServiceComponentName());
            }
            if (componentsStarted.isEmpty()) continue;
            StringBuilder reason = new StringBuilder("Cannot remove host ").append(hostName).append(" from ").append(hostRequest.getClusterName()).append(".  The following roles exist, and these components are not in the removable state: ");
            reason.append(StringUtils.join(componentsStarted, (String)", "));
            throw new OBDPException(reason.toString());
        }
    }

    private void removeHostFromClusterTopology(Clusters clusters, HostRequest hostRequest) throws OBDPException {
        if (hostRequest.getClusterName() == null) {
            for (Cluster c : clusters.getClusters().values()) {
                this.removeHostFromClusterTopology(c.getClusterId(), hostRequest.getHostname());
            }
        } else {
            long clusterId = clusters.getCluster(hostRequest.getClusterName()).getClusterId();
            this.removeHostFromClusterTopology(clusterId, hostRequest.getHostname());
        }
    }

    private void removeHostFromClusterTopology(long clusterId, String hostname) {
        ClusterTopology clusterTopology = topologyManager.getClusterTopology(clusterId);
        if (clusterTopology != null) {
            clusterTopology.removeHost(hostname);
        }
    }

    public static String getHostNameFromProperties(Map<String, Object> properties) {
        String hostname = (String)properties.get(HOST_HOST_NAME_PROPERTY_ID);
        return hostname != null ? hostname : (String)properties.get(HOST_NAME_PROPERTY_ID);
    }

    private RequestStatusResponse submitHostRequests(Request request) throws SystemException {
        ScaleClusterRequest requestRequest;
        try {
            requestRequest = new ScaleClusterRequest(request.getProperties());
        }
        catch (InvalidTopologyTemplateException e) {
            throw new IllegalArgumentException("Invalid Add Hosts Template: " + e, e);
        }
        try {
            return topologyManager.scaleHosts(requestRequest);
        }
        catch (InvalidTopologyException e) {
            throw new IllegalArgumentException("Topology validation failed: " + e, e);
        }
        catch (OBDPException e) {
            e.printStackTrace();
            throw new SystemException("Unable to add hosts", e);
        }
    }

    public static void setTopologyManager(TopologyManager topologyManager) {
        HostResourceProvider.topologyManager = topologyManager;
    }
}

