/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.KerberosHelper;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.BaseProvider;
import id.onyx.obdp.server.controller.internal.ReadOnlyResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.orm.dao.HostDAO;
import id.onyx.obdp.server.orm.dao.KerberosKeytabPrincipalDAO;
import id.onyx.obdp.server.orm.dao.KerberosPrincipalDAO;
import id.onyx.obdp.server.orm.entities.HostEntity;
import id.onyx.obdp.server.orm.entities.KerberosKeytabPrincipalEntity;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.kerberos.KerberosDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosIdentityDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosKeytabDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosPrincipalDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosPrincipalType;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class HostKerberosIdentityResourceProvider
extends ReadOnlyResourceProvider {
    protected static final String KERBEROS_IDENTITY_CLUSTER_NAME_PROPERTY_ID = "KerberosIdentity/cluster_name";
    protected static final String KERBEROS_IDENTITY_HOST_NAME_PROPERTY_ID = "KerberosIdentity/host_name";
    protected static final String KERBEROS_IDENTITY_DESCRIPTION_PROPERTY_ID = "KerberosIdentity/description";
    protected static final String KERBEROS_IDENTITY_PRINCIPAL_NAME_PROPERTY_ID = "KerberosIdentity/principal_name";
    protected static final String KERBEROS_IDENTITY_PRINCIPAL_TYPE_PROPERTY_ID = "KerberosIdentity/principal_type";
    protected static final String KERBEROS_IDENTITY_PRINCIPAL_LOCAL_USERNAME_PROPERTY_ID = "KerberosIdentity/principal_local_username";
    protected static final String KERBEROS_IDENTITY_KEYTAB_FILE_PATH_PROPERTY_ID = "KerberosIdentity/keytab_file_path";
    protected static final String KERBEROS_IDENTITY_KEYTAB_FILE_OWNER_PROPERTY_ID = "KerberosIdentity/keytab_file_owner";
    protected static final String KERBEROS_IDENTITY_KEYTAB_FILE_OWNER_ACCESS_PROPERTY_ID = "KerberosIdentity/keytab_file_owner_access";
    protected static final String KERBEROS_IDENTITY_KEYTAB_FILE_GROUP_PROPERTY_ID = "KerberosIdentity/keytab_file_group";
    protected static final String KERBEROS_IDENTITY_KEYTAB_FILE_GROUP_ACCESS_PROPERTY_ID = "KerberosIdentity/keytab_file_group_access";
    protected static final String KERBEROS_IDENTITY_KEYTAB_FILE_MODE_PROPERTY_ID = "KerberosIdentity/keytab_file_mode";
    protected static final String KERBEROS_IDENTITY_KEYTAB_FILE_INSTALLED_PROPERTY_ID = "KerberosIdentity/keytab_file_installed";
    protected static final Map<Resource.Type, String> PK_PROPERTY_MAP = Collections.unmodifiableMap(new HashMap<Resource.Type, String>(){
        {
            this.put(Resource.Type.Cluster, HostKerberosIdentityResourceProvider.KERBEROS_IDENTITY_CLUSTER_NAME_PROPERTY_ID);
            this.put(Resource.Type.Host, HostKerberosIdentityResourceProvider.KERBEROS_IDENTITY_HOST_NAME_PROPERTY_ID);
            this.put(Resource.Type.HostKerberosIdentity, HostKerberosIdentityResourceProvider.KERBEROS_IDENTITY_PRINCIPAL_NAME_PROPERTY_ID);
        }
    });
    protected static final Set<String> PK_PROPERTY_IDS = Collections.unmodifiableSet(new HashSet<String>(PK_PROPERTY_MAP.values()));
    protected static final Set<String> PROPERTY_IDS = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.add(HostKerberosIdentityResourceProvider.KERBEROS_IDENTITY_CLUSTER_NAME_PROPERTY_ID);
            this.add(HostKerberosIdentityResourceProvider.KERBEROS_IDENTITY_HOST_NAME_PROPERTY_ID);
            this.add(HostKerberosIdentityResourceProvider.KERBEROS_IDENTITY_DESCRIPTION_PROPERTY_ID);
            this.add(HostKerberosIdentityResourceProvider.KERBEROS_IDENTITY_PRINCIPAL_NAME_PROPERTY_ID);
            this.add(HostKerberosIdentityResourceProvider.KERBEROS_IDENTITY_PRINCIPAL_TYPE_PROPERTY_ID);
            this.add(HostKerberosIdentityResourceProvider.KERBEROS_IDENTITY_PRINCIPAL_LOCAL_USERNAME_PROPERTY_ID);
            this.add(HostKerberosIdentityResourceProvider.KERBEROS_IDENTITY_KEYTAB_FILE_PATH_PROPERTY_ID);
            this.add(HostKerberosIdentityResourceProvider.KERBEROS_IDENTITY_KEYTAB_FILE_OWNER_PROPERTY_ID);
            this.add(HostKerberosIdentityResourceProvider.KERBEROS_IDENTITY_KEYTAB_FILE_OWNER_ACCESS_PROPERTY_ID);
            this.add(HostKerberosIdentityResourceProvider.KERBEROS_IDENTITY_KEYTAB_FILE_GROUP_PROPERTY_ID);
            this.add(HostKerberosIdentityResourceProvider.KERBEROS_IDENTITY_KEYTAB_FILE_GROUP_ACCESS_PROPERTY_ID);
            this.add(HostKerberosIdentityResourceProvider.KERBEROS_IDENTITY_KEYTAB_FILE_MODE_PROPERTY_ID);
            this.add(HostKerberosIdentityResourceProvider.KERBEROS_IDENTITY_KEYTAB_FILE_INSTALLED_PROPERTY_ID);
        }
    });
    @Inject
    private KerberosHelper kerberosHelper;
    @Inject
    private KerberosPrincipalDAO kerberosPrincipalDAO;
    @Inject
    private HostDAO hostDAO;
    @Inject
    private KerberosKeytabPrincipalDAO kerberosKeytabPrincipalDAO;

    @AssistedInject
    HostKerberosIdentityResourceProvider(@Assisted OBDPManagementController managementController) {
        super(Resource.Type.HostKerberosIdentity, PROPERTY_IDS, PK_PROPERTY_MAP, managementController);
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        return this.getResources(new GetResourcesCommand(this.getPropertyMaps(predicate), this.getRequestPropertyIds(request, predicate)));
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return PK_PROPERTY_IDS;
    }

    private class GetResourcesCommand
    implements AbstractResourceProvider.Command<Set<Resource>> {
        private final Set<Map<String, Object>> propertyMaps;
        private final Set<String> requestPropertyIds;

        public GetResourcesCommand(Set<Map<String, Object>> propertyMaps, Set<String> requestPropertyIds) {
            this.propertyMaps = propertyMaps;
            this.requestPropertyIds = requestPropertyIds;
        }

        @Override
        public Set<Resource> invoke() throws OBDPException {
            HashSet<Resource> resources = new HashSet<Resource>();
            for (Map<String, Object> propertyMap : this.propertyMaps) {
                Clusters clusters;
                Cluster cluster;
                KerberosDescriptor kerberosDescriptor;
                String hostName;
                String clusterName = (String)propertyMap.get(HostKerberosIdentityResourceProvider.KERBEROS_IDENTITY_CLUSTER_NAME_PROPERTY_ID);
                Map<String, Collection<KerberosIdentityDescriptor>> hostDescriptors = HostKerberosIdentityResourceProvider.this.kerberosHelper.getActiveIdentities(clusterName, hostName = (String)propertyMap.get(HostKerberosIdentityResourceProvider.KERBEROS_IDENTITY_HOST_NAME_PROPERTY_ID), null, null, true, null, kerberosDescriptor = HostKerberosIdentityResourceProvider.this.kerberosHelper.getKerberosDescriptor(cluster = (clusters = HostKerberosIdentityResourceProvider.this.getManagementController().getClusters()).getCluster(clusterName), false), null);
                if (hostDescriptors == null) continue;
                for (Map.Entry<String, Collection<KerberosIdentityDescriptor>> entry : hostDescriptors.entrySet()) {
                    Collection<KerberosIdentityDescriptor> descriptors = entry.getValue();
                    if (descriptors == null) continue;
                    String currentHostName = entry.getKey();
                    HostEntity host = HostKerberosIdentityResourceProvider.this.hostDAO.findByName(currentHostName);
                    Long hostId = host == null ? null : host.getHostId();
                    for (KerberosIdentityDescriptor descriptor : descriptors) {
                        KerberosKeytabPrincipalEntity entity;
                        String principal;
                        KerberosPrincipalDescriptor principalDescriptor = descriptor.getPrincipalDescriptor();
                        if (principalDescriptor == null || (principal = principalDescriptor.getValue()) == null || principal.isEmpty()) continue;
                        ResourceImpl resource = new ResourceImpl(Resource.Type.HostKerberosIdentity);
                        KerberosPrincipalType principalType = principalDescriptor.getType();
                        if (principalType == null) {
                            principalType = KerberosPrincipalType.SERVICE;
                        }
                        BaseProvider.setResourceProperty(resource, HostKerberosIdentityResourceProvider.KERBEROS_IDENTITY_CLUSTER_NAME_PROPERTY_ID, clusterName, this.requestPropertyIds);
                        BaseProvider.setResourceProperty(resource, HostKerberosIdentityResourceProvider.KERBEROS_IDENTITY_HOST_NAME_PROPERTY_ID, currentHostName, this.requestPropertyIds);
                        BaseProvider.setResourceProperty(resource, HostKerberosIdentityResourceProvider.KERBEROS_IDENTITY_PRINCIPAL_NAME_PROPERTY_ID, principal, this.requestPropertyIds);
                        BaseProvider.setResourceProperty(resource, HostKerberosIdentityResourceProvider.KERBEROS_IDENTITY_PRINCIPAL_TYPE_PROPERTY_ID, (Object)principalType, this.requestPropertyIds);
                        BaseProvider.setResourceProperty(resource, HostKerberosIdentityResourceProvider.KERBEROS_IDENTITY_PRINCIPAL_LOCAL_USERNAME_PROPERTY_ID, principalDescriptor.getLocalUsername(), this.requestPropertyIds);
                        KerberosKeytabDescriptor keytabDescriptor = descriptor.getKeytabDescriptor();
                        String installedStatus = hostId != null && HostKerberosIdentityResourceProvider.this.kerberosPrincipalDAO.exists(principal) ? (keytabDescriptor != null ? ((entity = HostKerberosIdentityResourceProvider.this.kerberosKeytabPrincipalDAO.findByNaturalKey(hostId, keytabDescriptor.getFile(), principal)) != null && entity.isDistributed().booleanValue() ? "true" : "false") : "false") : "unknown";
                        BaseProvider.setResourceProperty(resource, HostKerberosIdentityResourceProvider.KERBEROS_IDENTITY_KEYTAB_FILE_INSTALLED_PROPERTY_ID, installedStatus, this.requestPropertyIds);
                        if (keytabDescriptor != null) {
                            String ownerAccess = keytabDescriptor.getOwnerAccess();
                            String groupAccess = keytabDescriptor.getGroupAccess();
                            int mode = 0;
                            if ("rw".equals(ownerAccess)) {
                                mode += 600;
                            } else if ("r".equals(ownerAccess)) {
                                mode += 400;
                            }
                            if ("rw".equals(groupAccess)) {
                                mode += 60;
                            } else if ("r".equals(groupAccess)) {
                                mode += 40;
                            }
                            BaseProvider.setResourceProperty(resource, HostKerberosIdentityResourceProvider.KERBEROS_IDENTITY_KEYTAB_FILE_PATH_PROPERTY_ID, keytabDescriptor.getFile(), this.requestPropertyIds);
                            BaseProvider.setResourceProperty(resource, HostKerberosIdentityResourceProvider.KERBEROS_IDENTITY_KEYTAB_FILE_OWNER_PROPERTY_ID, keytabDescriptor.getOwnerName(), this.requestPropertyIds);
                            BaseProvider.setResourceProperty(resource, HostKerberosIdentityResourceProvider.KERBEROS_IDENTITY_KEYTAB_FILE_OWNER_ACCESS_PROPERTY_ID, ownerAccess, this.requestPropertyIds);
                            BaseProvider.setResourceProperty(resource, HostKerberosIdentityResourceProvider.KERBEROS_IDENTITY_KEYTAB_FILE_GROUP_PROPERTY_ID, keytabDescriptor.getGroupName(), this.requestPropertyIds);
                            BaseProvider.setResourceProperty(resource, HostKerberosIdentityResourceProvider.KERBEROS_IDENTITY_KEYTAB_FILE_GROUP_ACCESS_PROPERTY_ID, groupAccess, this.requestPropertyIds);
                            BaseProvider.setResourceProperty(resource, HostKerberosIdentityResourceProvider.KERBEROS_IDENTITY_KEYTAB_FILE_MODE_PROPERTY_ID, new DecimalFormat("000").format(mode), this.requestPropertyIds);
                        }
                        BaseProvider.setResourceProperty(resource, HostKerberosIdentityResourceProvider.KERBEROS_IDENTITY_DESCRIPTION_PROPERTY_ID, descriptor.getName(), this.requestPropertyIds);
                        resources.add(resource);
                    }
                }
            }
            return resources;
        }
    }
}

