/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.MaintenanceStateHelper;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.RequestStatusResponse;
import id.onyx.obdp.server.controller.ServiceComponentHostRequest;
import id.onyx.obdp.server.controller.ServiceComponentHostResponse;
import id.onyx.obdp.server.controller.internal.AbstractControllerResourceProvider;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.DeleteStatusMetaData;
import id.onyx.obdp.server.controller.internal.RequestOperationLevel;
import id.onyx.obdp.server.controller.internal.RequestStageContainer;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.predicate.AndPredicate;
import id.onyx.obdp.server.controller.predicate.EqualsPredicate;
import id.onyx.obdp.server.controller.predicate.NotPredicate;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.orm.dao.HostVersionDAO;
import id.onyx.obdp.server.security.authorization.AuthorizationException;
import id.onyx.obdp.server.security.authorization.AuthorizationHelper;
import id.onyx.obdp.server.security.authorization.ResourceType;
import id.onyx.obdp.server.security.authorization.RoleAuthorization;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.MaintenanceState;
import id.onyx.obdp.server.state.ServiceComponent;
import id.onyx.obdp.server.state.ServiceComponentHost;
import id.onyx.obdp.server.state.ServiceComponentHostEvent;
import id.onyx.obdp.server.state.State;
import id.onyx.obdp.server.state.fsm.InvalidStateTransitionException;
import id.onyx.obdp.server.state.svccomphost.ServiceComponentHostDisableEvent;
import id.onyx.obdp.server.state.svccomphost.ServiceComponentHostRestoreEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostComponentResourceProvider
extends AbstractControllerResourceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(HostComponentResourceProvider.class);
    public static final String HOST_ROLES = "HostRoles";
    public static final String HOST = "host";
    public static final String SERVICE_COMPONENT_INFO = "ServiceComponentInfo";
    public static final String ROLE_ID_PROPERTY_ID = "role_id";
    public static final String CLUSTER_NAME_PROPERTY_ID = "cluster_name";
    public static final String SERVICE_NAME_PROPERTY_ID = "service_name";
    public static final String COMPONENT_NAME_PROPERTY_ID = "component_name";
    public static final String DISPLAY_NAME_PROPERTY_ID = "display_name";
    public static final String HOST_NAME_PROPERTY_ID = "host_name";
    public static final String PUBLIC_HOST_NAME_PROPERTY_ID = "public_host_name";
    public static final String STATE_PROPERTY_ID = "state";
    public static final String DESIRED_STATE_PROPERTY_ID = "desired_state";
    public static final String VERSION_PROPERTY_ID = "version";
    public static final String DESIRED_STACK_ID_PROPERTY_ID = "desired_stack_id";
    public static final String DESIRED_REPOSITORY_VERSION_PROPERTY_ID = "desired_repository_version";
    public static final String ACTUAL_CONFIGS_PROPERTY_ID = "actual_configs";
    public static final String STALE_CONFIGS_PROPERTY_ID = "stale_configs";
    public static final String RELOAD_CONFIGS_PROPERTY_ID = "reload_configs";
    public static final String DESIRED_ADMIN_STATE_PROPERTY_ID = "desired_admin_state";
    public static final String MAINTENANCE_STATE_PROPERTY_ID = "maintenance_state";
    public static final String UPGRADE_STATE_PROPERTY_ID = "upgrade_state";
    public static final String HOST_PROPERTY_ID = "host";
    public static final String HREF_PROPERTY_ID = "href";
    public static final String COMPONENT_PROPERTY_ID = "component";
    public static final String METRICS_PROPERTY_ID = "metrics";
    public static final String PROCESSES_PROPERTY_ID = "processes";
    public static final String ROLE_ID = PropertyHelper.getPropertyId("HostRoles", "role_id");
    public static final String CLUSTER_NAME = PropertyHelper.getPropertyId("HostRoles", "cluster_name");
    public static final String SERVICE_NAME = PropertyHelper.getPropertyId("HostRoles", "service_name");
    public static final String COMPONENT_NAME = PropertyHelper.getPropertyId("HostRoles", "component_name");
    public static final String DISPLAY_NAME = PropertyHelper.getPropertyId("HostRoles", "display_name");
    public static final String HOST_NAME = PropertyHelper.getPropertyId("HostRoles", "host_name");
    public static final String PUBLIC_HOST_NAME = PropertyHelper.getPropertyId("HostRoles", "public_host_name");
    public static final String STATE = PropertyHelper.getPropertyId("HostRoles", "state");
    public static final String DESIRED_STATE = PropertyHelper.getPropertyId("HostRoles", "desired_state");
    public static final String VERSION = PropertyHelper.getPropertyId("HostRoles", "version");
    public static final String DESIRED_STACK_ID = PropertyHelper.getPropertyId("HostRoles", "desired_stack_id");
    public static final String DESIRED_REPOSITORY_VERSION = PropertyHelper.getPropertyId("HostRoles", "desired_repository_version");
    public static final String ACTUAL_CONFIGS = PropertyHelper.getPropertyId("HostRoles", "actual_configs");
    public static final String STALE_CONFIGS = PropertyHelper.getPropertyId("HostRoles", "stale_configs");
    public static final String RELOAD_CONFIGS = PropertyHelper.getPropertyId("HostRoles", "reload_configs");
    public static final String DESIRED_ADMIN_STATE = PropertyHelper.getPropertyId("HostRoles", "desired_admin_state");
    public static final String MAINTENANCE_STATE = PropertyHelper.getPropertyId("HostRoles", "maintenance_state");
    public static final String UPGRADE_STATE = PropertyHelper.getPropertyId("HostRoles", "upgrade_state");
    private static final String QUERY_PARAMETERS_RUN_SMOKE_TEST_ID = "params/run_smoke_test";
    public static final Map<Resource.Type, String> keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.Cluster, (Object)CLUSTER_NAME).put((Object)Resource.Type.Host, (Object)HOST_NAME).put((Object)Resource.Type.HostComponent, (Object)COMPONENT_NAME).put((Object)Resource.Type.Component, (Object)COMPONENT_NAME).build();
    protected static final Set<String> propertyIds = ImmutableSet.of((Object)ROLE_ID, (Object)CLUSTER_NAME, (Object)SERVICE_NAME, (Object)COMPONENT_NAME, (Object)DISPLAY_NAME, (Object)HOST_NAME, (Object[])new String[]{PUBLIC_HOST_NAME, STATE, DESIRED_STATE, VERSION, DESIRED_STACK_ID, DESIRED_REPOSITORY_VERSION, ACTUAL_CONFIGS, STALE_CONFIGS, RELOAD_CONFIGS, DESIRED_ADMIN_STATE, MAINTENANCE_STATE, UPGRADE_STATE, "params/run_smoke_test"});
    public static final String SKIP_INSTALL_FOR_COMPONENTS = "skipInstallForComponents";
    public static final String DO_NOT_SKIP_INSTALL_FOR_COMPONENTS = "dontSkipInstallForComponents";
    public static final String ALL_COMPONENTS = "ALL";
    public static final String FOR_ALL_COMPONENTS = HostComponentResourceProvider.joinComponentList((Collection<String>)ImmutableSet.of((Object)"ALL"));
    public static final String FOR_NO_COMPONENTS = HostComponentResourceProvider.joinComponentList((Collection<String>)ImmutableSet.of());
    @Inject
    private MaintenanceStateHelper maintenanceStateHelper;
    @Inject
    private HostVersionDAO hostVersionDAO;

    @AssistedInject
    public HostComponentResourceProvider(@Assisted OBDPManagementController managementController) {
        super(Resource.Type.HostComponent, propertyIds, keyPropertyIds, managementController);
        this.setRequiredCreateAuthorizations(EnumSet.of(RoleAuthorization.SERVICE_ADD_DELETE_SERVICES, RoleAuthorization.HOST_ADD_DELETE_COMPONENTS));
        this.setRequiredDeleteAuthorizations(EnumSet.of(RoleAuthorization.SERVICE_ADD_DELETE_SERVICES, RoleAuthorization.HOST_ADD_DELETE_COMPONENTS));
    }

    @Override
    protected RequestStatus createResourcesAuthorized(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        final HashSet<ServiceComponentHostRequest> requests = new HashSet<ServiceComponentHostRequest>();
        for (Map<String, Object> propertyMap : request.getProperties()) {
            requests.add(this.changeRequest(propertyMap));
        }
        this.createResources(new AbstractResourceProvider.Command<Void>(){

            @Override
            public Void invoke() throws OBDPException, AuthorizationException {
                HostComponentResourceProvider.this.getManagementController().createHostComponents(requests);
                return null;
            }
        });
        this.notifyCreate(Resource.Type.HostComponent, request);
        return this.getRequestStatus(null);
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        HashSet<ServiceComponentHostRequest> requests = new HashSet<ServiceComponentHostRequest>();
        for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
            requests.add(this.getRequest(propertyMap));
        }
        return this.findResources(request, predicate, requests);
    }

    private Set<Resource> getResourcesForUpdate(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        HashSet<ServiceComponentHostRequest> requests = new HashSet<ServiceComponentHostRequest>();
        for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
            requests.add(this.getRequest(propertyMap));
        }
        return this.findResources(request, predicate, requests);
    }

    private Set<Resource> findResources(Request request, Predicate predicate, final Set<ServiceComponentHostRequest> requests) throws SystemException, NoSuchResourceException, NoSuchParentResourceException {
        HashSet<Resource> resources = new HashSet<Resource>();
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        requestedIds.add(HOST_NAME);
        Set<ServiceComponentHostResponse> responses = this.getResources(new AbstractResourceProvider.Command<Set<ServiceComponentHostResponse>>(){

            @Override
            public Set<ServiceComponentHostResponse> invoke() throws OBDPException {
                return HostComponentResourceProvider.this.getManagementController().getHostComponents(requests);
            }
        });
        for (ServiceComponentHostResponse response : responses) {
            ResourceImpl resource = new ResourceImpl(Resource.Type.HostComponent);
            HostComponentResourceProvider.setResourceProperty(resource, CLUSTER_NAME, response.getClusterName(), requestedIds);
            HostComponentResourceProvider.setResourceProperty(resource, SERVICE_NAME, response.getServiceName(), requestedIds);
            HostComponentResourceProvider.setResourceProperty(resource, COMPONENT_NAME, response.getComponentName(), requestedIds);
            HostComponentResourceProvider.setResourceProperty(resource, DISPLAY_NAME, response.getDisplayName(), requestedIds);
            HostComponentResourceProvider.setResourceProperty(resource, HOST_NAME, response.getHostname(), requestedIds);
            HostComponentResourceProvider.setResourceProperty(resource, PUBLIC_HOST_NAME, response.getPublicHostname(), requestedIds);
            HostComponentResourceProvider.setResourceProperty(resource, STATE, response.getLiveState(), requestedIds);
            HostComponentResourceProvider.setResourceProperty(resource, DESIRED_STATE, response.getDesiredState(), requestedIds);
            HostComponentResourceProvider.setResourceProperty(resource, VERSION, response.getVersion(), requestedIds);
            HostComponentResourceProvider.setResourceProperty(resource, DESIRED_STACK_ID, response.getDesiredStackVersion(), requestedIds);
            HostComponentResourceProvider.setResourceProperty(resource, ACTUAL_CONFIGS, response.getActualConfigs(), requestedIds);
            HostComponentResourceProvider.setResourceProperty(resource, STALE_CONFIGS, response.isStaleConfig(), requestedIds);
            HostComponentResourceProvider.setResourceProperty(resource, RELOAD_CONFIGS, response.isReloadConfig(), requestedIds);
            HostComponentResourceProvider.setResourceProperty(resource, UPGRADE_STATE, (Object)response.getUpgradeState(), requestedIds);
            HostComponentResourceProvider.setResourceProperty(resource, DESIRED_REPOSITORY_VERSION, response.getDesiredRepositoryVersion(), requestedIds);
            if (response.getAdminState() != null) {
                HostComponentResourceProvider.setResourceProperty(resource, DESIRED_ADMIN_STATE, response.getAdminState(), requestedIds);
            }
            if (null != response.getMaintenanceState()) {
                HostComponentResourceProvider.setResourceProperty(resource, MAINTENANCE_STATE, response.getMaintenanceState(), requestedIds);
            }
            resources.add(resource);
        }
        return resources;
    }

    @Override
    public RequestStatus updateResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        if (request.getProperties().isEmpty()) {
            throw new IllegalArgumentException("Received an update request with no properties");
        }
        RequestStageContainer requestStages = this.doUpdateResources(null, request, predicate, false, false, false);
        RequestStatusResponse response = null;
        if (requestStages != null) {
            try {
                requestStages.persist();
            }
            catch (OBDPException e) {
                throw new SystemException(e.getMessage(), e);
            }
            response = requestStages.getRequestStatusResponse();
            this.notifyUpdate(Resource.Type.HostComponent, request, predicate);
        }
        return this.getRequestStatus(response);
    }

    @Override
    protected RequestStatus deleteResourcesAuthorized(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        final HashSet<ServiceComponentHostRequest> requests = new HashSet<ServiceComponentHostRequest>();
        for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
            requests.add(this.changeRequest(propertyMap));
        }
        DeleteStatusMetaData deleteStatusMetaData = this.modifyResources(new AbstractResourceProvider.Command<DeleteStatusMetaData>(){

            @Override
            public DeleteStatusMetaData invoke() throws OBDPException, AuthorizationException {
                return HostComponentResourceProvider.this.getManagementController().deleteHostComponents(requests);
            }
        });
        this.notifyDelete(Resource.Type.HostComponent, predicate);
        return this.getRequestStatus(null, null, deleteStatusMetaData);
    }

    @Override
    public Set<String> checkPropertyIds(Set<String> propertyIds) {
        if ((propertyIds = super.checkPropertyIds(propertyIds)).isEmpty()) {
            return propertyIds;
        }
        HashSet<String> unsupportedProperties = new HashSet<String>();
        for (String propertyId : propertyIds) {
            String propertyCategory;
            if (propertyId.equals("config") || (propertyCategory = PropertyHelper.getPropertyCategory(propertyId)) != null && propertyCategory.equals("config")) continue;
            unsupportedProperties.add(propertyId);
        }
        return unsupportedProperties;
    }

    public RequestStatusResponse install(String cluster, String hostname, Collection<String> skipInstallForComponents, Collection<String> dontSkipInstallForComponents, boolean skipFailure, boolean useClusterHostInfo) throws SystemException, UnsupportedPropertyException, NoSuchParentResourceException {
        RequestStageContainer requestStages;
        HashMap<String, Object> installProperties = new HashMap<String, Object>();
        installProperties.put(DESIRED_STATE, "INSTALLED");
        HashMap<String, String> requestInfo = new HashMap<String, String>();
        requestInfo.put("context", String.format("Install components on host %s", hostname));
        requestInfo.put("phase", "INITIAL_INSTALL");
        requestInfo.putAll(RequestOperationLevel.propertiesFor(Resource.Type.HostComponent, cluster));
        HostComponentResourceProvider.addProvisionActionProperties(skipInstallForComponents, dontSkipInstallForComponents, requestInfo);
        Request installRequest = PropertyHelper.getUpdateRequest(installProperties, requestInfo);
        EqualsPredicate statePredicate = new EqualsPredicate(STATE, "INIT");
        EqualsPredicate clusterPredicate = new EqualsPredicate(CLUSTER_NAME, cluster);
        EqualsPredicate hostPredicate = new EqualsPredicate(HOST_NAME, hostname);
        AndPredicate hostAndStatePredicate = new AndPredicate(statePredicate, hostPredicate);
        AndPredicate installPredicate = new AndPredicate(hostAndStatePredicate, clusterPredicate);
        try {
            LOG.info("Installing all components on host: " + hostname);
            requestStages = this.doUpdateResources(null, installRequest, installPredicate, true, true, useClusterHostInfo);
            this.notifyUpdate(Resource.Type.HostComponent, installRequest, installPredicate);
            try {
                requestStages.persist();
            }
            catch (OBDPException e) {
                throw new SystemException(e.getMessage(), e);
            }
        }
        catch (NoSuchResourceException e) {
            throw new SystemException("An unexpected exception occurred while processing install hosts", e);
        }
        return requestStages.getRequestStatusResponse();
    }

    @VisibleForTesting
    static void addProvisionActionProperties(Collection<String> skipInstallForComponents, Collection<String> dontSkipInstallForComponents, Map<String, String> requestInfo) {
        requestInfo.put(SKIP_INSTALL_FOR_COMPONENTS, HostComponentResourceProvider.joinComponentList(skipInstallForComponents));
        requestInfo.put(DO_NOT_SKIP_INSTALL_FOR_COMPONENTS, HostComponentResourceProvider.joinComponentList(dontSkipInstallForComponents));
    }

    public static String joinComponentList(Collection<String> components) {
        return components != null ? ";" + String.join((CharSequence)";", components) + ";" : "";
    }

    public static boolean shouldSkipInstallTaskForComponent(String componentName, boolean isClientComponent, Map<String, String> requestProperties) {
        String skipInstallForComponents = requestProperties.get(SKIP_INSTALL_FOR_COMPONENTS);
        String searchString = HostComponentResourceProvider.joinComponentList((Collection<String>)ImmutableSet.of((Object)componentName));
        return !isClientComponent && "INITIAL_INSTALL".equals(requestProperties.get("phase")) && skipInstallForComponents != null && (skipInstallForComponents.contains(searchString) || skipInstallForComponents.equals(FOR_ALL_COMPONENTS) && !requestProperties.get(DO_NOT_SKIP_INSTALL_FOR_COMPONENTS).contains(searchString));
    }

    public RequestStatusResponse start(String cluster, String hostName) throws SystemException, UnsupportedPropertyException, NoSuchParentResourceException {
        return this.start(cluster, hostName, Collections.emptySet(), false, false);
    }

    public RequestStatusResponse start(String cluster, String hostName, Collection<String> installOnlyComponents, boolean skipFailure, boolean useClusterHostInfo) throws SystemException, UnsupportedPropertyException, NoSuchParentResourceException {
        RequestStageContainer requestStages;
        HashMap<String, String> requestInfo = new HashMap<String, String>();
        requestInfo.put("context", String.format("Start components on host %s", hostName));
        requestInfo.put("phase", "INITIAL_START");
        requestInfo.putAll(RequestOperationLevel.propertiesFor(Resource.Type.HostComponent, cluster));
        requestInfo.put("skip_failure", Boolean.toString(skipFailure));
        EqualsPredicate clusterPredicate = new EqualsPredicate(CLUSTER_NAME, cluster);
        EqualsPredicate hostPredicate = new EqualsPredicate(HOST_NAME, hostName);
        try {
            AndPredicate startPredicate;
            HashMap<String, Object> startProperties = new HashMap<String, Object>();
            startProperties.put(DESIRED_STATE, "STARTED");
            Request startRequest = PropertyHelper.getUpdateRequest(startProperties, requestInfo);
            EqualsPredicate installedStatePredicate = new EqualsPredicate(DESIRED_STATE, "INSTALLED");
            NotPredicate notClientPredicate = new NotPredicate(new ClientComponentPredicate());
            AndPredicate clusterAndClientPredicate = new AndPredicate(clusterPredicate, notClientPredicate);
            AndPredicate hostAndStatePredicate = new AndPredicate(installedStatePredicate, hostPredicate);
            if (installOnlyComponents.isEmpty()) {
                startPredicate = new AndPredicate(clusterAndClientPredicate, hostAndStatePredicate);
                LOG.info("Starting all non-client components on host: " + hostName);
            } else {
                ArrayList<NotPredicate> listOfComponentPredicates = new ArrayList<NotPredicate>();
                for (String installOnlyComponent : installOnlyComponents) {
                    EqualsPredicate componentNameEquals = new EqualsPredicate(COMPONENT_NAME, installOnlyComponent);
                    listOfComponentPredicates.add(new NotPredicate(componentNameEquals));
                }
                Predicate[] arrayOfInstallOnlyPredicates = new Predicate[listOfComponentPredicates.size()];
                AndPredicate installOnlyComponentsPredicate = new AndPredicate(listOfComponentPredicates.toArray(arrayOfInstallOnlyPredicates));
                startPredicate = new AndPredicate(clusterAndClientPredicate, hostAndStatePredicate, installOnlyComponentsPredicate);
                LOG.info("Starting all non-client components on host: " + hostName + ", except for the INSTALL_ONLY components specified: " + installOnlyComponents);
            }
            requestStages = this.doUpdateResources(null, startRequest, startPredicate, true, true, useClusterHostInfo);
            this.notifyUpdate(Resource.Type.HostComponent, startRequest, startPredicate);
            try {
                requestStages.persist();
            }
            catch (OBDPException e) {
                throw new SystemException(e.getMessage(), e);
            }
        }
        catch (NoSuchResourceException e) {
            throw new SystemException("An unexpected exception occurred while processing start hosts", e);
        }
        return requestStages.getRequestStatusResponse();
    }

    protected RequestStageContainer updateHostComponents(RequestStageContainer stages, Set<ServiceComponentHostRequest> requests, Map<String, String> requestProperties, boolean runSmokeTest, boolean useGeneratedConfigs, boolean useClusterHostInfo) throws OBDPException, AuthorizationException {
        Clusters clusters = this.getManagementController().getClusters();
        HashMap<String, Map<State, List<ServiceComponentHost>>> changedScHosts = new HashMap<String, Map<State, List<ServiceComponentHost>>>();
        ArrayList<ServiceComponentHost> ignoredScHosts = new ArrayList<ServiceComponentHost>();
        HashSet<String> clusterNames = new HashSet<String>();
        HashMap requestClusters = new HashMap();
        HashMap<ServiceComponentHost, State> directTransitionScHosts = new HashMap<ServiceComponentHost, State>();
        Resource.Type reqOpLvl = this.determineOperationLevel(requestProperties);
        String clusterName = requestProperties.get("operation_level/cluster_name");
        if (clusterName != null && !clusterName.isEmpty()) {
            clusterNames.add(clusterName);
        }
        for (ServiceComponentHostRequest request : requests) {
            MaintenanceState oldMaint;
            MaintenanceState newMaint;
            HashSet<String> componentHosts;
            HashMap serviceComponents;
            this.validateServiceComponentHostRequest(request);
            Cluster cluster = clusters.getCluster(request.getClusterName());
            if (runSmokeTest && !AuthorizationHelper.isAuthorized(ResourceType.CLUSTER, cluster.getResourceId(), RoleAuthorization.SERVICE_RUN_SERVICE_CHECK)) {
                throw new AuthorizationException("The authenticated user is not authorized to run service checks");
            }
            if (StringUtils.isEmpty((String)request.getServiceName())) {
                request.setServiceName(this.getManagementController().findServiceName(cluster, request.getComponentName()));
            }
            ServiceComponent sc = this.getServiceComponent(request.getClusterName(), request.getServiceName(), request.getComponentName());
            this.logRequestInfo("Received a updateHostComponent request", request);
            if ((clusterName == null || clusterName.isEmpty()) && request.getClusterName() != null && !request.getClusterName().isEmpty()) {
                clusterNames.add(request.getClusterName());
            }
            if (clusterNames.size() > 1) {
                throw new IllegalArgumentException("Updates to multiple clusters is not supported");
            }
            HashMap clusterServices = (HashMap)requestClusters.get(request.getClusterName());
            if (clusterServices == null) {
                clusterServices = new HashMap();
                requestClusters.put(request.getClusterName(), clusterServices);
            }
            if ((serviceComponents = (HashMap)clusterServices.get(request.getServiceName())) == null) {
                serviceComponents = new HashMap();
                clusterServices.put(request.getServiceName(), serviceComponents);
            }
            if ((componentHosts = (HashSet<String>)serviceComponents.get(request.getComponentName())) == null) {
                componentHosts = new HashSet<String>();
                serviceComponents.put(request.getComponentName(), componentHosts);
            }
            if (componentHosts.contains(request.getHostname())) {
                throw new IllegalArgumentException("Invalid request contains duplicate hostcomponents");
            }
            componentHosts.add(request.getHostname());
            ServiceComponentHost sch = sc.getServiceComponentHost(request.getHostname());
            State oldState = sch.getState();
            State newState = null;
            if (request.getDesiredState() != null && !(newState = State.valueOf(request.getDesiredState())).isValidDesiredState()) {
                throw new IllegalArgumentException("Invalid arguments, invalid desired state, desiredState=" + newState);
            }
            if (null != request.getMaintenanceState() && (newMaint = MaintenanceState.valueOf(request.getMaintenanceState())) != (oldMaint = this.maintenanceStateHelper.getEffectiveState(sch))) {
                if (sc.isClientComponent()) {
                    throw new IllegalArgumentException("Invalid arguments, cannot set maintenance state on a client component");
                }
                if (newMaint.equals((Object)MaintenanceState.IMPLIED_FROM_HOST) || newMaint.equals((Object)MaintenanceState.IMPLIED_FROM_SERVICE)) {
                    throw new IllegalArgumentException("Invalid arguments, can only set maintenance state to one of " + EnumSet.of(MaintenanceState.OFF, MaintenanceState.ON));
                }
                sch.setMaintenanceState(newMaint);
            }
            if (newState == null) {
                LOG.info(this.getServiceComponentRequestInfoLogMessage("Nothing to do for new updateServiceComponentHost", request, oldState, null));
                continue;
            }
            if (!AuthorizationHelper.isAuthorized(ResourceType.CLUSTER, cluster.getResourceId(), EnumSet.of(RoleAuthorization.SERVICE_START_STOP, RoleAuthorization.SERVICE_ADD_DELETE_SERVICES, RoleAuthorization.HOST_ADD_DELETE_COMPONENTS, RoleAuthorization.HOST_ADD_DELETE_HOSTS))) {
                throw new AuthorizationException("The authenticated user is not authorized to change the state of service components");
            }
            if (sc.isClientComponent() && newState == State.STARTED && !requestProperties.containsKey(sch.getServiceComponentName().toLowerCase())) {
                ignoredScHosts.add(sch);
                LOG.info(this.getServiceComponentRequestInfoLogMessage("Ignoring ServiceComponentHost as STARTED new desired state for client components is not valid", request, sch.getState(), newState));
                continue;
            }
            if (sc.isClientComponent() && !newState.isValidClientComponentState()) {
                throw new IllegalArgumentException("Invalid desired state for a client component");
            }
            State oldSchState = sch.getState();
            if (newState == oldSchState && !sc.isClientComponent() && !requestProperties.containsKey(sch.getServiceComponentName().toLowerCase())) {
                ignoredScHosts.add(sch);
                LOG.info(this.getServiceComponentRequestInfoLogMessage("Ignoring ServiceComponentHost as the current state matches the new desired state", request, oldState, newState));
                continue;
            }
            if (!this.maintenanceStateHelper.isOperationAllowed(reqOpLvl, sch)) {
                ignoredScHosts.add(sch);
                LOG.info(this.getServiceComponentRequestInfoLogMessage("Ignoring ServiceComponentHost as operation is not allowed", request, oldState, newState));
                continue;
            }
            if (!this.isValidStateTransition(stages, oldSchState, newState, sch)) {
                throw new OBDPException("Invalid state transition for host component, clusterName=" + cluster.getClusterName() + ", clusterId=" + cluster.getClusterId() + ", serviceName=" + sch.getServiceName() + ", componentName=" + sch.getServiceComponentName() + ", hostname=" + sch.getHostName() + ", currentState=" + oldSchState + ", newDesiredState=" + newState);
            }
            if (this.isDirectTransition(oldSchState, newState)) {
                LOG.info(this.getServiceComponentRequestInfoLogMessage("Handling direct transition update to host component", request, oldState, newState));
                directTransitionScHosts.put(sch, newState);
                continue;
            }
            if (!changedScHosts.containsKey(sc.getName())) {
                changedScHosts.put(sc.getName(), new EnumMap(State.class));
            }
            if (!((Map)changedScHosts.get(sc.getName())).containsKey((Object)newState)) {
                ((Map)changedScHosts.get(sc.getName())).put(newState, new ArrayList());
            }
            LOG.info(this.getServiceComponentRequestInfoLogMessage("Handling update to host component", request, oldState, newState));
            ((List)((Map)changedScHosts.get(sc.getName())).get((Object)newState)).add(sch);
        }
        this.doDirectTransitions(directTransitionScHosts);
        Cluster cluster = clusters.getCluster((String)clusterNames.iterator().next());
        return this.getManagementController().addStages(stages, cluster, requestProperties, null, null, null, changedScHosts, ignoredScHosts, runSmokeTest, false, useGeneratedConfigs, useClusterHostInfo);
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return new HashSet<String>(keyPropertyIds.values());
    }

    private ServiceComponentHostRequest getRequest(Map<String, Object> properties) {
        Object o;
        ServiceComponentHostRequest serviceComponentHostRequest = new ServiceComponentHostRequest((String)properties.get(CLUSTER_NAME), (String)properties.get(SERVICE_NAME), (String)properties.get(COMPONENT_NAME), (String)properties.get(HOST_NAME), (String)properties.get(DESIRED_STATE));
        serviceComponentHostRequest.setState((String)properties.get(STATE));
        if (properties.get(STALE_CONFIGS) != null) {
            serviceComponentHostRequest.setStaleConfig(properties.get(STALE_CONFIGS).toString().toLowerCase());
        }
        if (properties.get(DESIRED_ADMIN_STATE) != null) {
            serviceComponentHostRequest.setAdminState(properties.get(DESIRED_ADMIN_STATE).toString());
        }
        if (properties.get(PUBLIC_HOST_NAME) != null) {
            serviceComponentHostRequest.setPublicHostname(properties.get(PUBLIC_HOST_NAME).toString());
        }
        if (null != (o = properties.get(MAINTENANCE_STATE))) {
            serviceComponentHostRequest.setMaintenanceState(o.toString());
        }
        return serviceComponentHostRequest;
    }

    private ServiceComponentHostRequest changeRequest(Map<String, Object> properties) {
        Object o;
        ServiceComponentHostRequest serviceComponentHostRequest = new ServiceComponentHostRequest((String)properties.get(CLUSTER_NAME), (String)properties.get(SERVICE_NAME), (String)properties.get(COMPONENT_NAME), (String)properties.get(HOST_NAME), (String)properties.get(STATE));
        if (properties.get(DESIRED_STATE) != null) {
            serviceComponentHostRequest.setDesiredState((String)properties.get(DESIRED_STATE));
        }
        if (properties.get(STALE_CONFIGS) != null) {
            serviceComponentHostRequest.setStaleConfig(properties.get(STALE_CONFIGS).toString().toLowerCase());
        }
        if (properties.get(DESIRED_ADMIN_STATE) != null) {
            serviceComponentHostRequest.setAdminState(properties.get(DESIRED_ADMIN_STATE).toString());
        }
        if (null != (o = properties.get(MAINTENANCE_STATE))) {
            serviceComponentHostRequest.setMaintenanceState(o.toString());
        }
        return serviceComponentHostRequest;
    }

    public RequestStageContainer doUpdateResources(final RequestStageContainer stages, final Request request, Predicate predicate, boolean performQueryEvaluation, final boolean useGeneratedConfigs, final boolean useClusterHostInfo) throws UnsupportedPropertyException, SystemException, NoSuchResourceException, NoSuchParentResourceException {
        final HashSet<ServiceComponentHostRequest> requests = new HashSet<ServiceComponentHostRequest>();
        final boolean runSmokeTest = "true".equals(HostComponentResourceProvider.getQueryParameterValue(QUERY_PARAMETERS_RUN_SMOKE_TEST_ID, predicate));
        Set<String> queryIds = Collections.singleton(COMPONENT_NAME);
        Request queryRequest = PropertyHelper.getReadRequest(queryIds);
        Set<Resource> matchingResources = this.getResourcesForUpdate(queryRequest, predicate);
        for (Resource queryResource : matchingResources) {
            if (performQueryEvaluation && !predicate.evaluate(queryResource)) continue;
            HashMap<String, Object> updateRequestProperties = new HashMap<String, Object>();
            updateRequestProperties.putAll(PropertyHelper.getProperties(queryResource));
            if (request.getProperties() != null && request.getProperties().size() != 0) {
                updateRequestProperties.putAll(request.getProperties().iterator().next());
            }
            requests.add(this.changeRequest(updateRequestProperties));
        }
        if (requests.isEmpty()) {
            String msg = String.format("Skipping updating hosts: no matching requests for %s", predicate);
            LOG.info(msg);
            throw new NoSuchResourceException(msg);
        }
        RequestStageContainer requestStages = this.modifyResources(new AbstractResourceProvider.Command<RequestStageContainer>(){

            @Override
            public RequestStageContainer invoke() throws OBDPException {
                RequestStageContainer stageContainer = null;
                try {
                    stageContainer = HostComponentResourceProvider.this.updateHostComponents(stages, requests, request.getRequestInfoProperties(), runSmokeTest, useGeneratedConfigs, useClusterHostInfo);
                }
                catch (Exception e) {
                    LOG.info("Caught an exception while updating host components, will not try again: {}", (Object)e.getMessage(), (Object)e);
                    if (e instanceof IllegalArgumentException) {
                        throw (IllegalArgumentException)e;
                    }
                    throw new RuntimeException("Update Host request submission failed: " + e, e);
                }
                return stageContainer;
            }
        });
        this.notifyUpdate(Resource.Type.HostComponent, request, predicate);
        return requestStages;
    }

    private boolean isValidStateTransition(RequestStageContainer stages, State startState, State desiredState, ServiceComponentHost host) {
        return true;
    }

    public boolean isDirectTransition(State oldState, State newState) {
        switch (newState) {
            case INSTALLED: {
                if (oldState != State.DISABLED) break;
                return true;
            }
            case DISABLED: {
                if (oldState != State.INSTALLED && oldState != State.INSTALL_FAILED && oldState != State.UNKNOWN) break;
                return true;
            }
        }
        return false;
    }

    private ServiceComponent getServiceComponent(String clusterName, String serviceName, String componentName) throws OBDPException {
        Clusters clusters = this.getManagementController().getClusters();
        return clusters.getCluster(clusterName).getService(serviceName).getServiceComponent(componentName);
    }

    private void doDirectTransitions(Map<ServiceComponentHost, State> directTransitionScHosts) throws OBDPException {
        for (Map.Entry<ServiceComponentHost, State> entry : directTransitionScHosts.entrySet()) {
            ServiceComponentHost componentHost = entry.getKey();
            State newState = entry.getValue();
            long timestamp = System.currentTimeMillis();
            componentHost.setDesiredState(newState);
            ServiceComponentHostEvent event = switch (newState) {
                case State.DISABLED -> new ServiceComponentHostDisableEvent(componentHost.getServiceComponentName(), componentHost.getHostName(), timestamp);
                case State.INSTALLED -> new ServiceComponentHostRestoreEvent(componentHost.getServiceComponentName(), componentHost.getHostName(), timestamp);
                default -> throw new OBDPException("Direct transition from " + componentHost.getState() + " to " + newState + " not supported");
            };
            try {
                componentHost.handleEvent(event);
            }
            catch (InvalidStateTransitionException e) {
                throw new OBDPException("Internal error - not supported transition", (Throwable)e);
            }
        }
    }

    private void logRequestInfo(String msg, ServiceComponentHostRequest request) {
        LOG.info("{}, clusterName={}, serviceName={}, componentName={}, hostname={}, request={}", new Object[]{msg, request.getClusterName(), request.getServiceName(), request.getComponentName(), request.getHostname(), request});
    }

    private String getServiceComponentRequestInfoLogMessage(String msg, ServiceComponentHostRequest request, State oldState, State newDesiredState) {
        StringBuilder sb = new StringBuilder();
        sb.append(msg).append(", clusterName=").append(request.getClusterName()).append(", serviceName=").append(request.getServiceName()).append(", componentName=").append(request.getComponentName()).append(", hostname=").append(request.getHostname()).append(", currentState=").append(oldState == null ? "null" : oldState).append(", newDesiredState=").append(newDesiredState == null ? "null" : newDesiredState);
        return sb.toString();
    }

    private Resource.Type determineOperationLevel(Map<String, String> requestProperties) {
        Resource.Type reqOpLvl;
        if (requestProperties.containsKey("operation_level/level")) {
            reqOpLvl = new RequestOperationLevel(requestProperties).getLevel();
        } else {
            String message = "Can not determine request operation level. Operation level property should be specified for this request.";
            LOG.warn(message);
            reqOpLvl = Resource.Type.Cluster;
        }
        return reqOpLvl;
    }

    private void validateServiceComponentHostRequest(ServiceComponentHostRequest request) {
        if (request.getClusterName() == null || request.getClusterName().isEmpty() || request.getComponentName() == null || request.getComponentName().isEmpty() || request.getHostname() == null || request.getHostname().isEmpty()) {
            throw new IllegalArgumentException("Invalid arguments, cluster name, component name and host name should be provided");
        }
        if (request.getAdminState() != null) {
            throw new IllegalArgumentException("Property adminState cannot be modified through update. Use service specific DECOMMISSION action to decommision/recommission components.");
        }
    }

    private class ClientComponentPredicate
    implements Predicate {
        private ClientComponentPredicate() {
        }

        @Override
        public boolean evaluate(Resource resource) {
            boolean isClient = false;
            String componentName = (String)resource.getPropertyValue(COMPONENT_NAME);
            try {
                if (componentName != null && !componentName.isEmpty()) {
                    OBDPManagementController managementController = HostComponentResourceProvider.this.getManagementController();
                    String clusterName = (String)resource.getPropertyValue(CLUSTER_NAME);
                    String serviceName = (String)resource.getPropertyValue(SERVICE_NAME);
                    if (StringUtils.isEmpty((String)serviceName)) {
                        Cluster cluster = managementController.getClusters().getCluster(clusterName);
                        serviceName = managementController.findServiceName(cluster, componentName);
                    }
                    ServiceComponent sc = HostComponentResourceProvider.this.getServiceComponent((String)resource.getPropertyValue(CLUSTER_NAME), serviceName, componentName);
                    isClient = sc.isClientComponent();
                }
            }
            catch (OBDPException e) {
                throw new RuntimeException("An unexpected exception occurred while trying to determine if a component is a client", e);
            }
            return isClient;
        }
    }
}

