/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.HostComponentProcessResponse;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.ReadOnlyResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.ServiceComponentHost;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HostComponentProcessResourceProvider
extends ReadOnlyResourceProvider {
    public static final String HOST_COMPONENT_PROCESS = "HostComponentProcess";
    public static final String NAME_PROPERTY_ID = "name";
    public static final String STATUS_PROPERTY_ID = "status";
    public static final String CLUSTER_NAME_PROPERTY_ID = "cluster_name";
    public static final String HOST_NAME_PROPERTY_ID = "host_name";
    public static final String COMPONENT_NAME_PROPERTY_ID = "component_name";
    public static final String NAME = "HostComponentProcess/name";
    public static final String STATUS = "HostComponentProcess/status";
    public static final String CLUSTER_NAME = "HostComponentProcess/cluster_name";
    public static final String HOST_NAME = "HostComponentProcess/host_name";
    public static final String COMPONENT_NAME = "HostComponentProcess/component_name";
    private static final Map<Resource.Type, String> keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.Cluster, (Object)"HostComponentProcess/cluster_name").put((Object)Resource.Type.Host, (Object)"HostComponentProcess/host_name").put((Object)Resource.Type.Component, (Object)"HostComponentProcess/component_name").put((Object)Resource.Type.HostComponent, (Object)"HostComponentProcess/component_name").put((Object)Resource.Type.HostComponentProcess, (Object)"HostComponentProcess/name").build();
    private static final Set<String> propertyIds = Sets.newHashSet((Object[])new String[]{"HostComponentProcess/name", "HostComponentProcess/status", "HostComponentProcess/cluster_name", "HostComponentProcess/host_name", "HostComponentProcess/component_name"});

    HostComponentProcessResourceProvider(OBDPManagementController amc) {
        super(Resource.Type.HostComponentProcess, propertyIds, keyPropertyIds, amc);
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return new HashSet<String>(keyPropertyIds.values());
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        final Set<Map<String, Object>> requestMaps = this.getPropertyMaps(predicate);
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        Set<HostComponentProcessResponse> responses = this.getResources(new AbstractResourceProvider.Command<Set<HostComponentProcessResponse>>(){

            @Override
            public Set<HostComponentProcessResponse> invoke() throws OBDPException {
                return HostComponentProcessResourceProvider.this.getHostComponentProcesses(requestMaps);
            }
        });
        HashSet<Resource> resources = new HashSet<Resource>();
        for (HostComponentProcessResponse response : responses) {
            ResourceImpl r = new ResourceImpl(Resource.Type.HostComponentProcess);
            HostComponentProcessResourceProvider.setResourceProperty(r, CLUSTER_NAME, response.getCluster(), requestedIds);
            HostComponentProcessResourceProvider.setResourceProperty(r, HOST_NAME, response.getHost(), requestedIds);
            HostComponentProcessResourceProvider.setResourceProperty(r, COMPONENT_NAME, response.getComponent(), requestedIds);
            HostComponentProcessResourceProvider.setResourceProperty(r, NAME, response.getValueMap().get(NAME_PROPERTY_ID), requestedIds);
            HostComponentProcessResourceProvider.setResourceProperty(r, STATUS, response.getValueMap().get(STATUS_PROPERTY_ID), requestedIds);
            for (Map.Entry<String, String> entry : response.getValueMap().entrySet()) {
                if (entry.getKey().equals(NAME_PROPERTY_ID) || entry.getKey().equals(STATUS_PROPERTY_ID)) continue;
                HostComponentProcessResourceProvider.setResourceProperty(r, "HostComponentProcess/" + entry.getKey(), entry.getValue(), requestedIds);
            }
            resources.add(r);
        }
        return resources;
    }

    private Set<HostComponentProcessResponse> getHostComponentProcesses(Set<Map<String, Object>> requestMaps) throws OBDPException {
        HashSet<HostComponentProcessResponse> results = new HashSet<HostComponentProcessResponse>();
        Clusters clusters = this.getManagementController().getClusters();
        for (Map<String, Object> requestMap : requestMaps) {
            String cluster = (String)requestMap.get(CLUSTER_NAME);
            String component = (String)requestMap.get(COMPONENT_NAME);
            String host = (String)requestMap.get(HOST_NAME);
            Cluster c = clusters.getCluster(cluster);
            List<ServiceComponentHost> schs = c.getServiceComponentHosts(host);
            for (ServiceComponentHost sch : schs) {
                if (!sch.getServiceComponentName().equals(component)) continue;
                for (Map<String, String> proc : sch.getProcesses()) {
                    results.add(new HostComponentProcessResponse(cluster, sch.getHostName(), component, proc));
                }
            }
        }
        return results;
    }
}

