/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.GroupRequest;
import id.onyx.obdp.server.controller.GroupResponse;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.internal.AbstractControllerResourceProvider;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.security.authorization.RoleAuthorization;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupResourceProvider
extends AbstractControllerResourceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(GroupResourceProvider.class);
    public static final String GROUP_GROUPNAME_PROPERTY_ID = PropertyHelper.getPropertyId("Groups", "group_name");
    public static final String GROUP_LDAP_GROUP_PROPERTY_ID = PropertyHelper.getPropertyId("Groups", "ldap_group");
    public static final String GROUP_GROUPTYPE_PROPERTY_ID = PropertyHelper.getPropertyId("Groups", "group_type");
    private static final Map<Resource.Type, String> keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.Group, (Object)GROUP_GROUPNAME_PROPERTY_ID).build();
    private static final Set<String> propertyIds = Sets.newHashSet((Object[])new String[]{GROUP_GROUPNAME_PROPERTY_ID, GROUP_LDAP_GROUP_PROPERTY_ID, GROUP_GROUPTYPE_PROPERTY_ID});

    GroupResourceProvider(OBDPManagementController managementController) {
        super(Resource.Type.Group, propertyIds, keyPropertyIds, managementController);
        EnumSet<RoleAuthorization> manageUserAuthorizations = EnumSet.of(RoleAuthorization.OBDP_MANAGE_USERS);
        this.setRequiredCreateAuthorizations(manageUserAuthorizations);
        this.setRequiredGetAuthorizations(manageUserAuthorizations);
        this.setRequiredUpdateAuthorizations(manageUserAuthorizations);
        this.setRequiredDeleteAuthorizations(manageUserAuthorizations);
    }

    @Override
    protected RequestStatus createResourcesAuthorized(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        final HashSet<GroupRequest> requests = new HashSet<GroupRequest>();
        for (Map<String, Object> propertyMap : request.getProperties()) {
            requests.add(this.getRequest(propertyMap));
        }
        this.createResources(new AbstractResourceProvider.Command<Void>(){

            @Override
            public Void invoke() throws OBDPException {
                GroupResourceProvider.this.getManagementController().createGroups(requests);
                return null;
            }
        });
        return this.getRequestStatus(null);
    }

    @Override
    protected Set<Resource> getResourcesAuthorized(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        final HashSet<GroupRequest> requests = new HashSet<GroupRequest>();
        if (predicate == null) {
            requests.add(this.getRequest(null));
        } else {
            for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
                requests.add(this.getRequest(propertyMap));
            }
        }
        Set<GroupResponse> responses = this.getResources(new AbstractResourceProvider.Command<Set<GroupResponse>>(){

            @Override
            public Set<GroupResponse> invoke() throws OBDPException {
                return GroupResourceProvider.this.getManagementController().getGroups(requests);
            }
        });
        LOG.debug("Found group responses matching get group request, groupRequestSize={}, groupResponseSize={}", (Object)requests.size(), (Object)responses.size());
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        HashSet<Resource> resources = new HashSet<Resource>();
        for (GroupResponse groupResponse : responses) {
            ResourceImpl resource = new ResourceImpl(Resource.Type.Group);
            GroupResourceProvider.setResourceProperty(resource, GROUP_GROUPNAME_PROPERTY_ID, groupResponse.getGroupName(), requestedIds);
            GroupResourceProvider.setResourceProperty(resource, GROUP_LDAP_GROUP_PROPERTY_ID, groupResponse.isLdapGroup(), requestedIds);
            GroupResourceProvider.setResourceProperty(resource, GROUP_GROUPTYPE_PROPERTY_ID, (Object)groupResponse.getGroupType(), requestedIds);
            resources.add(resource);
        }
        return resources;
    }

    @Override
    protected RequestStatus updateResourcesAuthorized(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        final HashSet<GroupRequest> requests = new HashSet<GroupRequest>();
        for (Map<String, Object> propertyMap : this.getPropertyMaps(request.getProperties().iterator().next(), predicate)) {
            GroupRequest req = this.getRequest(propertyMap);
            requests.add(req);
        }
        this.modifyResources(new AbstractResourceProvider.Command<Void>(){

            @Override
            public Void invoke() throws OBDPException {
                GroupResourceProvider.this.getManagementController().updateGroups(requests);
                return null;
            }
        });
        return this.getRequestStatus(null);
    }

    @Override
    protected RequestStatus deleteResourcesAuthorized(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        final HashSet<GroupRequest> requests = new HashSet<GroupRequest>();
        for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
            GroupRequest req = this.getRequest(propertyMap);
            requests.add(req);
        }
        this.modifyResources(new AbstractResourceProvider.Command<Void>(){

            @Override
            public Void invoke() throws OBDPException {
                GroupResourceProvider.this.getManagementController().deleteGroups(requests);
                return null;
            }
        });
        return this.getRequestStatus(null);
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return new HashSet<String>(keyPropertyIds.values());
    }

    private GroupRequest getRequest(Map<String, Object> properties) {
        if (properties == null) {
            return new GroupRequest(null);
        }
        GroupRequest request = new GroupRequest((String)properties.get(GROUP_GROUPNAME_PROPERTY_ID));
        return request;
    }
}

