/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import id.onyx.obdp.server.StaticallyInject;
import id.onyx.obdp.server.controller.GroupPrivilegeResponse;
import id.onyx.obdp.server.controller.internal.ReadOnlyResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.orm.dao.ClusterDAO;
import id.onyx.obdp.server.orm.dao.GroupDAO;
import id.onyx.obdp.server.orm.dao.ViewInstanceDAO;
import id.onyx.obdp.server.orm.entities.ClusterEntity;
import id.onyx.obdp.server.orm.entities.GroupEntity;
import id.onyx.obdp.server.orm.entities.PrincipalTypeEntity;
import id.onyx.obdp.server.orm.entities.PrivilegeEntity;
import id.onyx.obdp.server.orm.entities.ViewEntity;
import id.onyx.obdp.server.orm.entities.ViewInstanceEntity;
import id.onyx.obdp.server.security.authorization.AuthorizationException;
import id.onyx.obdp.server.security.authorization.AuthorizationHelper;
import id.onyx.obdp.server.security.authorization.ResourceType;
import id.onyx.obdp.server.security.authorization.RoleAuthorization;
import id.onyx.obdp.server.security.authorization.Users;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@StaticallyInject
public class GroupPrivilegeResourceProvider
extends ReadOnlyResourceProvider {
    protected static final String GROUP_NAME_PROPERTY_ID = "group_name";
    protected static final String PRIVILEGE_ID = "PrivilegeInfo/privilege_id";
    protected static final String PERMISSION_NAME = "PrivilegeInfo/permission_name";
    protected static final String PERMISSION_LABEL = "PrivilegeInfo/permission_label";
    protected static final String PRINCIPAL_NAME = "PrivilegeInfo/principal_name";
    protected static final String PRINCIPAL_TYPE = "PrivilegeInfo/principal_type";
    protected static final String VIEW_NAME = "PrivilegeInfo/view_name";
    protected static final String VIEW_VERSION = "PrivilegeInfo/version";
    protected static final String INSTANCE_NAME = "PrivilegeInfo/instance_name";
    protected static final String CLUSTER_NAME = "PrivilegeInfo/cluster_name";
    protected static final String TYPE = "PrivilegeInfo/type";
    protected static final String GROUP_NAME = "PrivilegeInfo/group_name";
    @Inject
    private static ClusterDAO clusterDAO;
    @Inject
    private static GroupDAO groupDAO;
    @Inject
    private static ViewInstanceDAO viewInstanceDAO;
    @Inject
    private static Users users;
    private static final Set<String> propertyIds;
    private static final Set<String> pkPropertyIds;
    private static final Map<Resource.Type, String> keyPropertyIds;

    public static void init(ClusterDAO clusterDAO, GroupDAO groupDAO, ViewInstanceDAO viewInstanceDAO, Users users) {
        GroupPrivilegeResourceProvider.clusterDAO = clusterDAO;
        GroupPrivilegeResourceProvider.groupDAO = groupDAO;
        GroupPrivilegeResourceProvider.viewInstanceDAO = viewInstanceDAO;
        GroupPrivilegeResourceProvider.users = users;
    }

    public GroupPrivilegeResourceProvider() {
        super(Resource.Type.GroupPrivilege, propertyIds, keyPropertyIds, null);
        EnumSet<RoleAuthorization> requiredAuthorizations = EnumSet.of(RoleAuthorization.OBDP_ASSIGN_ROLES);
        this.setRequiredCreateAuthorizations(requiredAuthorizations);
        this.setRequiredDeleteAuthorizations(requiredAuthorizations);
        this.setRequiredGetAuthorizations(requiredAuthorizations);
        this.setRequiredUpdateAuthorizations(requiredAuthorizations);
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return pkPropertyIds;
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        HashSet<Resource> resources = new HashSet<Resource>();
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        if (!AuthorizationHelper.isAuthorized(ResourceType.OBDP, null, RoleAuthorization.OBDP_MANAGE_GROUPS)) {
            throw new AuthorizationException();
        }
        for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
            String groupName = (String)propertyMap.get(GROUP_NAME);
            if (groupName == null) continue;
            GroupEntity groupEntity = groupDAO.findGroupByName(groupName);
            if (groupEntity == null) {
                throw new SystemException("Group " + groupName + " was not found");
            }
            Collection<PrivilegeEntity> privileges = users.getGroupPrivileges(groupEntity);
            for (PrivilegeEntity privilegeEntity : privileges) {
                GroupPrivilegeResponse response = this.getResponse(privilegeEntity, groupName);
                resources.add(this.toResource(response, requestedIds));
            }
        }
        return resources;
    }

    protected GroupPrivilegeResponse getResponse(PrivilegeEntity privilegeEntity, String groupName) {
        String typeName;
        ResourceType resourceType;
        String permissionLabel = privilegeEntity.getPermission().getPermissionLabel();
        String permissionName = privilegeEntity.getPermission().getPermissionName();
        String principalTypeName = privilegeEntity.getPrincipal().getPrincipalType().getName();
        GroupPrivilegeResponse groupPrivilegeResponse = new GroupPrivilegeResponse(groupName, permissionLabel, permissionName, privilegeEntity.getId(), PrincipalTypeEntity.PrincipalType.valueOf(principalTypeName));
        if (principalTypeName.equals(PrincipalTypeEntity.GROUP_PRINCIPAL_TYPE_NAME)) {
            GroupEntity groupEntity = groupDAO.findGroupByPrincipal(privilegeEntity.getPrincipal());
            groupPrivilegeResponse.setPrincipalName(groupEntity.getGroupName());
        }
        if ((resourceType = ResourceType.translate(typeName = privilegeEntity.getResource().getResourceType().getName())) != null) {
            switch (resourceType) {
                case OBDP: {
                    break;
                }
                case CLUSTER: {
                    ClusterEntity clusterEntity = clusterDAO.findByResourceId(privilegeEntity.getResource().getId());
                    groupPrivilegeResponse.setClusterName(clusterEntity.getClusterName());
                    break;
                }
                case VIEW: {
                    ViewInstanceEntity viewInstanceEntity = viewInstanceDAO.findByResourceId(privilegeEntity.getResource().getId());
                    ViewEntity viewEntity = viewInstanceEntity.getViewEntity();
                    groupPrivilegeResponse.setViewName(viewEntity.getCommonName());
                    groupPrivilegeResponse.setVersion(viewEntity.getVersion());
                    groupPrivilegeResponse.setInstanceName(viewInstanceEntity.getName());
                }
            }
            groupPrivilegeResponse.setType(resourceType);
        }
        return groupPrivilegeResponse;
    }

    protected Resource toResource(GroupPrivilegeResponse response, Set<String> requestedIds) {
        ResourceImpl resource = new ResourceImpl(Resource.Type.GroupPrivilege);
        GroupPrivilegeResourceProvider.setResourceProperty(resource, GROUP_NAME, response.getGroupName(), requestedIds);
        GroupPrivilegeResourceProvider.setResourceProperty(resource, PRIVILEGE_ID, response.getPrivilegeId(), requestedIds);
        GroupPrivilegeResourceProvider.setResourceProperty(resource, PERMISSION_NAME, response.getPermissionName(), requestedIds);
        GroupPrivilegeResourceProvider.setResourceProperty(resource, PERMISSION_LABEL, response.getPermissionLabel(), requestedIds);
        GroupPrivilegeResourceProvider.setResourceProperty(resource, PRINCIPAL_TYPE, response.getPrincipalType().name(), requestedIds);
        if (response.getPrincipalName() != null) {
            GroupPrivilegeResourceProvider.setResourceProperty(resource, PRINCIPAL_NAME, response.getPrincipalName(), requestedIds);
        }
        if (response.getType() != null) {
            GroupPrivilegeResourceProvider.setResourceProperty(resource, TYPE, response.getType().name(), requestedIds);
            switch (response.getType()) {
                case CLUSTER: {
                    GroupPrivilegeResourceProvider.setResourceProperty(resource, CLUSTER_NAME, response.getClusterName(), requestedIds);
                    break;
                }
                case VIEW: {
                    GroupPrivilegeResourceProvider.setResourceProperty(resource, VIEW_NAME, response.getViewName(), requestedIds);
                    GroupPrivilegeResourceProvider.setResourceProperty(resource, VIEW_VERSION, response.getVersion(), requestedIds);
                    GroupPrivilegeResourceProvider.setResourceProperty(resource, INSTANCE_NAME, response.getInstanceName(), requestedIds);
                }
            }
        }
        return resource;
    }

    static {
        propertyIds = Sets.newHashSet((Object[])new String[]{PRIVILEGE_ID, PERMISSION_NAME, PERMISSION_LABEL, PRINCIPAL_NAME, PRINCIPAL_TYPE, VIEW_NAME, VIEW_VERSION, INSTANCE_NAME, CLUSTER_NAME, TYPE, GROUP_NAME});
        pkPropertyIds = ImmutableSet.builder().add((Object)PRIVILEGE_ID).build();
        keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.Group, (Object)GROUP_NAME).put((Object)Resource.Type.GroupPrivilege, (Object)PRIVILEGE_ID).build();
    }
}

