/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import id.onyx.obdp.server.controller.internal.AbstractDRResourceProvider;
import id.onyx.obdp.server.controller.internal.RequestStatusImpl;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.ivory.Feed;
import id.onyx.obdp.server.controller.ivory.IvoryService;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FeedResourceProvider
extends AbstractDRResourceProvider {
    protected static final String FEED_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("Feed", "name");
    protected static final String FEED_DESCRIPTION_PROPERTY_ID = PropertyHelper.getPropertyId("Feed", "description");
    protected static final String FEED_STATUS_PROPERTY_ID = PropertyHelper.getPropertyId("Feed", "status");
    protected static final String FEED_SCHEDULE_PROPERTY_ID = PropertyHelper.getPropertyId("Feed", "frequency");
    protected static final String FEED_SOURCE_CLUSTER_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("Feed/sourceCluster", "name");
    protected static final String FEED_SOURCE_CLUSTER_START_PROPERTY_ID = PropertyHelper.getPropertyId("Feed/sourceCluster/validity", "start");
    protected static final String FEED_SOURCE_CLUSTER_END_PROPERTY_ID = PropertyHelper.getPropertyId("Feed/sourceCluster/validity", "end");
    protected static final String FEED_SOURCE_CLUSTER_LIMIT_PROPERTY_ID = PropertyHelper.getPropertyId("Feed/sourceCluster/retention", "limit");
    protected static final String FEED_SOURCE_CLUSTER_ACTION_PROPERTY_ID = PropertyHelper.getPropertyId("Feed/sourceCluster/retention", "action");
    protected static final String FEED_TARGET_CLUSTER_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("Feed/targetCluster", "name");
    protected static final String FEED_TARGET_CLUSTER_START_PROPERTY_ID = PropertyHelper.getPropertyId("Feed/targetCluster/validity", "start");
    protected static final String FEED_TARGET_CLUSTER_END_PROPERTY_ID = PropertyHelper.getPropertyId("Feed/targetCluster/validity", "end");
    protected static final String FEED_TARGET_CLUSTER_LIMIT_PROPERTY_ID = PropertyHelper.getPropertyId("Feed/targetCluster/retention", "limit");
    protected static final String FEED_TARGET_CLUSTER_ACTION_PROPERTY_ID = PropertyHelper.getPropertyId("Feed/targetCluster/retention", "action");
    protected static final String FEED_PROPERTIES_PROPERTY_ID = PropertyHelper.getPropertyId("Feed", "properties");
    private static final Map<Resource.Type, String> keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.DRFeed, (Object)FEED_NAME_PROPERTY_ID).build();
    private static final Set<String> propertyIds = Sets.newHashSet((Object[])new String[]{FEED_NAME_PROPERTY_ID, FEED_DESCRIPTION_PROPERTY_ID, FEED_STATUS_PROPERTY_ID, FEED_SCHEDULE_PROPERTY_ID, FEED_SOURCE_CLUSTER_NAME_PROPERTY_ID, FEED_SOURCE_CLUSTER_START_PROPERTY_ID, FEED_SOURCE_CLUSTER_END_PROPERTY_ID, FEED_SOURCE_CLUSTER_LIMIT_PROPERTY_ID, FEED_SOURCE_CLUSTER_ACTION_PROPERTY_ID, FEED_TARGET_CLUSTER_NAME_PROPERTY_ID, FEED_TARGET_CLUSTER_START_PROPERTY_ID, FEED_TARGET_CLUSTER_END_PROPERTY_ID, FEED_TARGET_CLUSTER_LIMIT_PROPERTY_ID, FEED_TARGET_CLUSTER_ACTION_PROPERTY_ID, FEED_PROPERTIES_PROPERTY_ID});

    public FeedResourceProvider(IvoryService ivoryService) {
        super(propertyIds, keyPropertyIds, ivoryService);
    }

    @Override
    public RequestStatus createResources(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        IvoryService service = this.getService();
        Set<Map<String, Object>> propertiesSet = request.getProperties();
        for (Map<String, Object> propertyMap : propertiesSet) {
            service.submitFeed(FeedResourceProvider.getFeed((String)propertyMap.get(FEED_NAME_PROPERTY_ID), propertyMap));
        }
        return new RequestStatusImpl(null);
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        IvoryService service = this.getService();
        List<String> feedNames = service.getFeedNames();
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        HashSet<Resource> resources = new HashSet<Resource>();
        for (String feedName : feedNames) {
            Feed feed = service.getFeed(feedName);
            ResourceImpl resource = new ResourceImpl(Resource.Type.DRFeed);
            FeedResourceProvider.setResourceProperty(resource, FEED_NAME_PROPERTY_ID, feed.getName(), requestedIds);
            FeedResourceProvider.setResourceProperty(resource, FEED_DESCRIPTION_PROPERTY_ID, feed.getDescription(), requestedIds);
            FeedResourceProvider.setResourceProperty(resource, FEED_STATUS_PROPERTY_ID, feed.getStatus(), requestedIds);
            FeedResourceProvider.setResourceProperty(resource, FEED_SCHEDULE_PROPERTY_ID, feed.getSchedule(), requestedIds);
            FeedResourceProvider.setResourceProperty(resource, FEED_SOURCE_CLUSTER_NAME_PROPERTY_ID, feed.getSourceClusterName(), requestedIds);
            FeedResourceProvider.setResourceProperty(resource, FEED_SOURCE_CLUSTER_START_PROPERTY_ID, feed.getSourceClusterStart(), requestedIds);
            FeedResourceProvider.setResourceProperty(resource, FEED_SOURCE_CLUSTER_END_PROPERTY_ID, feed.getSourceClusterEnd(), requestedIds);
            FeedResourceProvider.setResourceProperty(resource, FEED_SOURCE_CLUSTER_LIMIT_PROPERTY_ID, feed.getSourceClusterLimit(), requestedIds);
            FeedResourceProvider.setResourceProperty(resource, FEED_SOURCE_CLUSTER_ACTION_PROPERTY_ID, feed.getSourceClusterAction(), requestedIds);
            FeedResourceProvider.setResourceProperty(resource, FEED_TARGET_CLUSTER_NAME_PROPERTY_ID, feed.getTargetClusterName(), requestedIds);
            FeedResourceProvider.setResourceProperty(resource, FEED_TARGET_CLUSTER_START_PROPERTY_ID, feed.getTargetClusterStart(), requestedIds);
            FeedResourceProvider.setResourceProperty(resource, FEED_TARGET_CLUSTER_END_PROPERTY_ID, feed.getTargetClusterEnd(), requestedIds);
            FeedResourceProvider.setResourceProperty(resource, FEED_TARGET_CLUSTER_LIMIT_PROPERTY_ID, feed.getTargetClusterLimit(), requestedIds);
            FeedResourceProvider.setResourceProperty(resource, FEED_TARGET_CLUSTER_ACTION_PROPERTY_ID, feed.getTargetClusterAction(), requestedIds);
            FeedResourceProvider.setResourceProperty(resource, FEED_PROPERTIES_PROPERTY_ID, feed.getProperties(), requestedIds);
            if (predicate != null && !predicate.evaluate(resource)) continue;
            resources.add(resource);
        }
        return resources;
    }

    @Override
    public RequestStatus updateResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        Iterator<Map<String, Object>> iterator = request.getProperties().iterator();
        if (iterator.hasNext()) {
            Map<String, Object> propertyMap = iterator.next();
            String desiredStatus = (String)propertyMap.get(FEED_STATUS_PROPERTY_ID);
            Set<Resource> resources = this.getResources(PropertyHelper.getReadRequest(new String[0]), predicate);
            for (Resource resource : resources) {
                IvoryService service = this.getService();
                if (desiredStatus != null) {
                    String status = (String)resource.getPropertyValue(FEED_STATUS_PROPERTY_ID);
                    String feedName = (String)resource.getPropertyValue(FEED_NAME_PROPERTY_ID);
                    if (desiredStatus.equals("SCHEDULED")) {
                        service.scheduleFeed(feedName);
                    } else if (desiredStatus.equals("SUSPENDED")) {
                        service.suspendFeed(feedName);
                    } else if (status.equals("SUSPENDED") && desiredStatus.equals("RUNNING")) {
                        service.resumeFeed(feedName);
                    }
                }
                service.updateFeed(FeedResourceProvider.getFeed((String)resource.getPropertyValue(FEED_NAME_PROPERTY_ID), FeedResourceProvider.getUpdateMap(resource, propertyMap)));
            }
        }
        return new RequestStatusImpl(null);
    }

    @Override
    public RequestStatus deleteResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        IvoryService service = this.getService();
        Set<Resource> resources = this.getResources(PropertyHelper.getReadRequest(new String[0]), predicate);
        for (Resource resource : resources) {
            service.deleteFeed((String)resource.getPropertyValue(FEED_NAME_PROPERTY_ID));
        }
        return new RequestStatusImpl(null);
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return new HashSet<String>(keyPropertyIds.values());
    }

    protected static Feed getFeed(String feedName, Map<String, Object> propertyMap) {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : propertyMap.entrySet()) {
            String property = entry.getKey();
            String category = PropertyHelper.getPropertyCategory(property);
            if (!category.equals(FEED_PROPERTIES_PROPERTY_ID)) continue;
            properties.put(PropertyHelper.getPropertyName(property), (String)entry.getValue());
        }
        return new Feed(feedName, (String)propertyMap.get(FEED_DESCRIPTION_PROPERTY_ID), (String)propertyMap.get(FEED_STATUS_PROPERTY_ID), (String)propertyMap.get(FEED_SCHEDULE_PROPERTY_ID), (String)propertyMap.get(FEED_SOURCE_CLUSTER_NAME_PROPERTY_ID), (String)propertyMap.get(FEED_SOURCE_CLUSTER_START_PROPERTY_ID), (String)propertyMap.get(FEED_SOURCE_CLUSTER_END_PROPERTY_ID), (String)propertyMap.get(FEED_SOURCE_CLUSTER_LIMIT_PROPERTY_ID), (String)propertyMap.get(FEED_SOURCE_CLUSTER_ACTION_PROPERTY_ID), (String)propertyMap.get(FEED_TARGET_CLUSTER_NAME_PROPERTY_ID), (String)propertyMap.get(FEED_TARGET_CLUSTER_START_PROPERTY_ID), (String)propertyMap.get(FEED_TARGET_CLUSTER_END_PROPERTY_ID), (String)propertyMap.get(FEED_TARGET_CLUSTER_LIMIT_PROPERTY_ID), (String)propertyMap.get(FEED_TARGET_CLUSTER_ACTION_PROPERTY_ID), properties);
    }

    protected static Map<String, Object> getUpdateMap(Resource resource, Map<String, Object> propertyMap) {
        HashMap<String, Object> updateMap = new HashMap<String, Object>();
        updateMap.put(FEED_NAME_PROPERTY_ID, resource.getPropertyValue(FEED_NAME_PROPERTY_ID));
        updateMap.put(FEED_DESCRIPTION_PROPERTY_ID, resource.getPropertyValue(FEED_DESCRIPTION_PROPERTY_ID));
        updateMap.put(FEED_SCHEDULE_PROPERTY_ID, resource.getPropertyValue(FEED_SCHEDULE_PROPERTY_ID));
        updateMap.put(FEED_STATUS_PROPERTY_ID, resource.getPropertyValue(FEED_STATUS_PROPERTY_ID));
        updateMap.put(FEED_SOURCE_CLUSTER_NAME_PROPERTY_ID, resource.getPropertyValue(FEED_SOURCE_CLUSTER_NAME_PROPERTY_ID));
        updateMap.put(FEED_SOURCE_CLUSTER_START_PROPERTY_ID, resource.getPropertyValue(FEED_SOURCE_CLUSTER_START_PROPERTY_ID));
        updateMap.put(FEED_SOURCE_CLUSTER_END_PROPERTY_ID, resource.getPropertyValue(FEED_SOURCE_CLUSTER_END_PROPERTY_ID));
        updateMap.put(FEED_SOURCE_CLUSTER_LIMIT_PROPERTY_ID, resource.getPropertyValue(FEED_SOURCE_CLUSTER_LIMIT_PROPERTY_ID));
        updateMap.put(FEED_SOURCE_CLUSTER_ACTION_PROPERTY_ID, resource.getPropertyValue(FEED_SOURCE_CLUSTER_ACTION_PROPERTY_ID));
        updateMap.put(FEED_TARGET_CLUSTER_NAME_PROPERTY_ID, resource.getPropertyValue(FEED_TARGET_CLUSTER_NAME_PROPERTY_ID));
        updateMap.put(FEED_TARGET_CLUSTER_START_PROPERTY_ID, resource.getPropertyValue(FEED_TARGET_CLUSTER_START_PROPERTY_ID));
        updateMap.put(FEED_TARGET_CLUSTER_END_PROPERTY_ID, resource.getPropertyValue(FEED_TARGET_CLUSTER_END_PROPERTY_ID));
        updateMap.put(FEED_TARGET_CLUSTER_LIMIT_PROPERTY_ID, resource.getPropertyValue(FEED_TARGET_CLUSTER_LIMIT_PROPERTY_ID));
        updateMap.put(FEED_TARGET_CLUSTER_ACTION_PROPERTY_ID, resource.getPropertyValue(FEED_TARGET_CLUSTER_ACTION_PROPERTY_ID));
        updateMap.put(FEED_PROPERTIES_PROPERTY_ID, resource.getPropertyValue(FEED_PROPERTIES_PROPERTY_ID));
        updateMap.putAll(propertyMap);
        return updateMap;
    }
}

