/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.StaticallyInject;
import id.onyx.obdp.server.controller.ExtensionVersionRequest;
import id.onyx.obdp.server.controller.ExtensionVersionResponse;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.ReadOnlyResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@StaticallyInject
public class ExtensionVersionResourceProvider
extends ReadOnlyResourceProvider {
    public static final String EXTENSION_VERSION_PROPERTY_ID = PropertyHelper.getPropertyId("Versions", "extension_version");
    public static final String EXTENSION_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("Versions", "extension_name");
    public static final String EXTENSION_VALID_PROPERTY_ID = PropertyHelper.getPropertyId("Versions", "valid");
    public static final String EXTENSION_ERROR_SET = PropertyHelper.getPropertyId("Versions", "extension-errors");
    public static final String EXTENSION_PARENT_PROPERTY_ID = PropertyHelper.getPropertyId("Versions", "parent_extension_version");
    private static final Map<Resource.Type, String> keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.Extension, (Object)EXTENSION_NAME_PROPERTY_ID).put((Object)Resource.Type.ExtensionVersion, (Object)EXTENSION_VERSION_PROPERTY_ID).build();
    private static final Set<String> propertyIds = Sets.newHashSet((Object[])new String[]{EXTENSION_VERSION_PROPERTY_ID, EXTENSION_NAME_PROPERTY_ID, EXTENSION_VALID_PROPERTY_ID, EXTENSION_ERROR_SET, EXTENSION_PARENT_PROPERTY_ID});

    protected ExtensionVersionResourceProvider(OBDPManagementController managementController) {
        super(Resource.Type.ExtensionVersion, propertyIds, keyPropertyIds, managementController);
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        final HashSet<ExtensionVersionRequest> requests = new HashSet<ExtensionVersionRequest>();
        if (predicate == null) {
            requests.add(this.getRequest(Collections.emptyMap()));
        } else {
            for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
                requests.add(this.getRequest(propertyMap));
            }
        }
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        Set<ExtensionVersionResponse> responses = this.getResources(new AbstractResourceProvider.Command<Set<ExtensionVersionResponse>>(){

            @Override
            public Set<ExtensionVersionResponse> invoke() throws OBDPException {
                return ExtensionVersionResourceProvider.this.getManagementController().getExtensionVersions(requests);
            }
        });
        HashSet<Resource> resources = new HashSet<Resource>();
        for (ExtensionVersionResponse response : responses) {
            ResourceImpl resource = new ResourceImpl(Resource.Type.ExtensionVersion);
            ExtensionVersionResourceProvider.setResourceProperty(resource, EXTENSION_NAME_PROPERTY_ID, response.getExtensionName(), requestedIds);
            ExtensionVersionResourceProvider.setResourceProperty(resource, EXTENSION_VERSION_PROPERTY_ID, response.getExtensionVersion(), requestedIds);
            ExtensionVersionResourceProvider.setResourceProperty(resource, EXTENSION_VALID_PROPERTY_ID, response.isValid(), requestedIds);
            ExtensionVersionResourceProvider.setResourceProperty(resource, EXTENSION_ERROR_SET, response.getErrors(), requestedIds);
            ExtensionVersionResourceProvider.setResourceProperty(resource, EXTENSION_PARENT_PROPERTY_ID, response.getParentVersion(), requestedIds);
            resources.add(resource);
        }
        return resources;
    }

    private ExtensionVersionRequest getRequest(Map<String, Object> properties) {
        return new ExtensionVersionRequest((String)properties.get(EXTENSION_NAME_PROPERTY_ID), (String)properties.get(EXTENSION_VERSION_PROPERTY_ID));
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return new HashSet<String>(keyPropertyIds.values());
    }
}

