/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.ExtensionRequest;
import id.onyx.obdp.server.controller.ExtensionResponse;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.RequestStatusResponse;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.ReadOnlyResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ExtensionResourceProvider
extends ReadOnlyResourceProvider {
    public static final String EXTENSION_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("Extensions", "extension_name");
    private static final Map<Resource.Type, String> keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.Extension, (Object)EXTENSION_NAME_PROPERTY_ID).build();
    private static final Set<String> propertyIds = Sets.newHashSet((Object[])new String[]{EXTENSION_NAME_PROPERTY_ID});

    protected ExtensionResourceProvider(OBDPManagementController managementController) {
        super(Resource.Type.Extension, propertyIds, keyPropertyIds, managementController);
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        final HashSet<ExtensionRequest> requests = new HashSet<ExtensionRequest>();
        if (predicate == null) {
            requests.add(this.getRequest(Collections.emptyMap()));
        } else {
            for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
                requests.add(this.getRequest(propertyMap));
            }
        }
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        Set<ExtensionResponse> responses = this.getResources(new AbstractResourceProvider.Command<Set<ExtensionResponse>>(){

            @Override
            public Set<ExtensionResponse> invoke() throws OBDPException {
                return ExtensionResourceProvider.this.getManagementController().getExtensions(requests);
            }
        });
        HashSet<Resource> resources = new HashSet<Resource>();
        for (ExtensionResponse response : responses) {
            ResourceImpl resource = new ResourceImpl(Resource.Type.Extension);
            ExtensionResourceProvider.setResourceProperty(resource, EXTENSION_NAME_PROPERTY_ID, response.getExtensionName(), requestedIds);
            resource.setProperty(EXTENSION_NAME_PROPERTY_ID, response.getExtensionName());
            resources.add(resource);
        }
        return resources;
    }

    @Override
    public RequestStatus updateResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        RequestStatusResponse response = this.modifyResources(new AbstractResourceProvider.Command<RequestStatusResponse>(){

            @Override
            public RequestStatusResponse invoke() throws OBDPException {
                return ExtensionResourceProvider.this.getManagementController().updateStacks();
            }
        });
        this.notifyUpdate(Resource.Type.Extension, request, predicate);
        return this.getRequestStatus(response);
    }

    private ExtensionRequest getRequest(Map<String, Object> properties) {
        return new ExtensionRequest((String)properties.get(EXTENSION_NAME_PROPERTY_ID));
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return new HashSet<String>(keyPropertyIds.values());
    }
}

