/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.StaticallyInject;
import id.onyx.obdp.server.controller.ExtensionLinkRequest;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.RequestStatusResponse;
import id.onyx.obdp.server.controller.internal.AbstractControllerResourceProvider;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.orm.dao.ExtensionLinkDAO;
import id.onyx.obdp.server.orm.entities.ExtensionLinkEntity;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@StaticallyInject
public class ExtensionLinkResourceProvider
extends AbstractControllerResourceProvider {
    public static final String LINK_ID_PROPERTY_ID = PropertyHelper.getPropertyId("ExtensionLink", "link_id");
    public static final String STACK_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("ExtensionLink", "stack_name");
    public static final String STACK_VERSION_PROPERTY_ID = PropertyHelper.getPropertyId("ExtensionLink", "stack_version");
    public static final String EXTENSION_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("ExtensionLink", "extension_name");
    public static final String EXTENSION_VERSION_PROPERTY_ID = PropertyHelper.getPropertyId("ExtensionLink", "extension_version");
    private static final Map<Resource.Type, String> keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.ExtensionLink, (Object)LINK_ID_PROPERTY_ID).put((Object)Resource.Type.Stack, (Object)STACK_NAME_PROPERTY_ID).put((Object)Resource.Type.StackVersion, (Object)STACK_VERSION_PROPERTY_ID).put((Object)Resource.Type.Extension, (Object)EXTENSION_NAME_PROPERTY_ID).put((Object)Resource.Type.ExtensionVersion, (Object)EXTENSION_VERSION_PROPERTY_ID).build();
    private static final Set<String> propertyIds = Sets.newHashSet((Object[])new String[]{LINK_ID_PROPERTY_ID, STACK_NAME_PROPERTY_ID, STACK_VERSION_PROPERTY_ID, EXTENSION_NAME_PROPERTY_ID, EXTENSION_VERSION_PROPERTY_ID});
    @Inject
    private static ExtensionLinkDAO dao;

    protected ExtensionLinkResourceProvider(OBDPManagementController managementController) {
        super(Resource.Type.ExtensionLink, propertyIds, keyPropertyIds, managementController);
    }

    @Override
    public RequestStatus createResources(Request request) throws SystemException, UnsupportedPropertyException, NoSuchParentResourceException, ResourceAlreadyExistsException {
        final HashSet<ExtensionLinkRequest> requests = new HashSet<ExtensionLinkRequest>();
        for (Map<String, Object> propertyMap : request.getProperties()) {
            requests.add(this.getRequest(propertyMap));
        }
        this.createResources(new AbstractResourceProvider.Command<Void>(){

            @Override
            public Void invoke() throws OBDPException {
                for (ExtensionLinkRequest extensionLinkRequest : requests) {
                    ExtensionLinkResourceProvider.this.getManagementController().createExtensionLink(extensionLinkRequest);
                }
                return null;
            }
        });
        if (requests.size() > 0) {
            try {
                this.getManagementController().updateStacks();
            }
            catch (OBDPException e) {
                throw new SystemException(e.getMessage(), e);
            }
            this.notifyCreate(Resource.Type.ExtensionLink, request);
        }
        return this.getRequestStatus(null);
    }

    @Override
    protected RequestStatus deleteResourcesAuthorized(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        final HashSet<ExtensionLinkRequest> requests = new HashSet<ExtensionLinkRequest>();
        if (predicate == null) {
            requests.add(this.getRequest(Collections.emptyMap()));
        } else {
            for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
                requests.add(this.getRequest(propertyMap));
            }
        }
        RequestStatusResponse response = this.modifyResources(new AbstractResourceProvider.Command<RequestStatusResponse>(){

            @Override
            public RequestStatusResponse invoke() throws OBDPException {
                for (ExtensionLinkRequest extensionLinkRequest : requests) {
                    ExtensionLinkResourceProvider.this.getManagementController().deleteExtensionLink(extensionLinkRequest);
                }
                return null;
            }
        });
        try {
            this.getManagementController().updateStacks();
        }
        catch (OBDPException e) {
            throw new SystemException(e.getMessage(), e);
        }
        this.notifyDelete(Resource.Type.ExtensionLink, predicate);
        return this.getRequestStatus(response);
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        HashSet<Resource> resources = new HashSet<Resource>();
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        HashSet<ExtensionLinkRequest> requests = new HashSet<ExtensionLinkRequest>();
        if (predicate == null) {
            requests.add(this.getRequest(Collections.emptyMap()));
        } else {
            for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
                requests.add(this.getRequest(propertyMap));
            }
        }
        HashSet<ExtensionLinkEntity> entities = new HashSet<ExtensionLinkEntity>();
        for (ExtensionLinkRequest extensionLinkRequest : requests) {
            this.verifyStackAndExtensionExist(extensionLinkRequest);
            entities.addAll(dao.find(extensionLinkRequest));
        }
        for (ExtensionLinkEntity entity : entities) {
            ResourceImpl resource = new ResourceImpl(Resource.Type.ExtensionLink);
            ExtensionLinkResourceProvider.setResourceProperty(resource, LINK_ID_PROPERTY_ID, entity.getLinkId(), requestedIds);
            ExtensionLinkResourceProvider.setResourceProperty(resource, STACK_NAME_PROPERTY_ID, entity.getStack().getStackName(), requestedIds);
            ExtensionLinkResourceProvider.setResourceProperty(resource, STACK_VERSION_PROPERTY_ID, entity.getStack().getStackVersion(), requestedIds);
            ExtensionLinkResourceProvider.setResourceProperty(resource, EXTENSION_NAME_PROPERTY_ID, entity.getExtension().getExtensionName(), requestedIds);
            ExtensionLinkResourceProvider.setResourceProperty(resource, EXTENSION_VERSION_PROPERTY_ID, entity.getExtension().getExtensionVersion(), requestedIds);
            resources.add(resource);
        }
        return resources;
    }

    @Override
    public RequestStatus updateResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        final HashSet<ExtensionLinkRequest> requests = new HashSet<ExtensionLinkRequest>();
        for (Map<String, Object> propertyMap : request.getProperties()) {
            requests.add(this.getRequest(propertyMap));
        }
        this.modifyResources(new AbstractResourceProvider.Command<RequestStatusResponse>(){

            @Override
            public RequestStatusResponse invoke() throws OBDPException {
                for (ExtensionLinkRequest extensionLinkRequest : requests) {
                    ExtensionLinkResourceProvider.this.getManagementController().updateExtensionLink(extensionLinkRequest);
                }
                return null;
            }
        });
        try {
            this.getManagementController().updateStacks();
        }
        catch (OBDPException e) {
            throw new SystemException(e.getMessage(), e);
        }
        this.notifyUpdate(Resource.Type.ExtensionLink, request, predicate);
        return this.getRequestStatus(null);
    }

    private void verifyStackAndExtensionExist(ExtensionLinkRequest request) throws NoSuchParentResourceException {
        try {
            if (request.getStackName() != null && request.getStackVersion() != null) {
                this.getManagementController().getAmbariMetaInfo().getStack(request.getStackName(), request.getStackVersion());
            }
            if (request.getExtensionName() != null && request.getExtensionVersion() != null) {
                this.getManagementController().getAmbariMetaInfo().getExtension(request.getExtensionName(), request.getExtensionVersion());
            }
        }
        catch (OBDPException ambariException) {
            throw new NoSuchParentResourceException(ambariException.getMessage());
        }
    }

    private ExtensionLinkRequest getRequest(Map<String, Object> properties) {
        return new ExtensionLinkRequest((String)properties.get(LINK_ID_PROPERTY_ID), (String)properties.get(STACK_NAME_PROPERTY_ID), (String)properties.get(STACK_VERSION_PROPERTY_ID), (String)properties.get(EXTENSION_NAME_PROPERTY_ID), (String)properties.get(EXTENSION_VERSION_PROPERTY_ID));
    }

    private ExtensionLinkRequest createExtensionLinkRequest(ExtensionLinkEntity entity) {
        if (entity == null) {
            return null;
        }
        return new ExtensionLinkRequest(String.valueOf(entity.getLinkId()), entity.getStack().getStackName(), entity.getStack().getStackVersion(), entity.getExtension().getExtensionName(), entity.getExtension().getExtensionVersion());
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return new HashSet<String>(keyPropertyIds.values());
    }
}

