/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.orm.entities.ExtensionEntity;
import id.onyx.obdp.server.state.AutoDeployInfo;
import id.onyx.obdp.server.state.ComponentInfo;
import id.onyx.obdp.server.state.DependencyInfo;
import id.onyx.obdp.server.topology.Cardinality;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class Extension {
    private String name;
    private String version;
    private Map<String, Collection<String>> serviceComponents = new HashMap<String, Collection<String>>();
    private Map<String, String> componentService = new HashMap<String, String>();
    private Map<String, Collection<DependencyInfo>> dependencies = new HashMap<String, Collection<DependencyInfo>>();
    private Map<DependencyInfo, String> dependencyConditionalServiceMap = new HashMap<DependencyInfo, String>();
    private Map<String, String> dbDependencyInfo = new HashMap<String, String>();
    private Map<String, String> cardinalityRequirements = new HashMap<String, String>();
    private Map<String, AutoDeployInfo> componentAutoDeployInfo = new HashMap<String, AutoDeployInfo>();
    private final OBDPManagementController controller;

    public Extension(ExtensionEntity extension, OBDPManagementController ambariManagementController) throws OBDPException {
        this(extension.getExtensionName(), extension.getExtensionVersion(), ambariManagementController);
    }

    public Extension(String name, String version, OBDPManagementController controller) throws OBDPException {
        this.name = name;
        this.version = version;
        this.controller = controller;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    Map<DependencyInfo, String> getDependencyConditionalServiceMap() {
        return this.dependencyConditionalServiceMap;
    }

    public Collection<String> getServices() {
        return this.serviceComponents.keySet();
    }

    public Collection<String> getComponents(String service) {
        return this.serviceComponents.get(service);
    }

    public Map<String, Collection<String>> getComponents() {
        HashMap<String, Collection<String>> serviceComponents = new HashMap<String, Collection<String>>();
        for (String service : this.getServices()) {
            HashSet<String> components = new HashSet<String>();
            components.addAll(this.getComponents(service));
            serviceComponents.put(service, components);
        }
        return serviceComponents;
    }

    public ComponentInfo getComponentInfo(String component) {
        ComponentInfo componentInfo = null;
        String service = this.getServiceForComponent(component);
        if (service != null) {
            try {
                componentInfo = this.controller.getAmbariMetaInfo().getComponent(this.getName(), this.getVersion(), service, component);
            }
            catch (OBDPException oBDPException) {
                // empty catch block
            }
        }
        return componentInfo;
    }

    public String getServiceForComponent(String component) {
        return this.componentService.get(component);
    }

    public Collection<String> getServicesForComponents(Collection<String> components) {
        HashSet<String> services = new HashSet<String>();
        for (String component : components) {
            services.add(this.getServiceForComponent(component));
        }
        return services;
    }

    public Collection<DependencyInfo> getDependenciesForComponent(String component) {
        return this.dependencies.containsKey(component) ? this.dependencies.get(component) : Collections.emptySet();
    }

    public String getConditionalServiceForDependency(DependencyInfo dependency) {
        return this.dependencyConditionalServiceMap.get(dependency);
    }

    public String getExternalComponentConfig(String component) {
        return this.dbDependencyInfo.get(component);
    }

    public Cardinality getCardinality(String component) {
        return new Cardinality(this.cardinalityRequirements.get(component));
    }

    public AutoDeployInfo getAutoDeployInfo(String component) {
        return this.componentAutoDeployInfo.get(component);
    }
}

