/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.api.util.TreeNode;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.internal.Stack;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.state.DesiredConfig;
import id.onyx.obdp.server.state.HostConfig;
import id.onyx.obdp.server.topology.Blueprint;
import id.onyx.obdp.server.topology.BlueprintImpl;
import id.onyx.obdp.server.topology.Component;
import id.onyx.obdp.server.topology.Configuration;
import id.onyx.obdp.server.topology.HostGroup;
import id.onyx.obdp.server.topology.HostGroupImpl;
import id.onyx.obdp.server.topology.HostGroupInfo;
import id.onyx.obdp.server.topology.InvalidTopologyTemplateException;
import id.onyx.obdp.server.topology.TopologyRequest;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ExportBlueprintRequest
implements TopologyRequest {
    private final OBDPManagementController controller;
    private final String clusterName;
    private final Long clusterId;
    private Blueprint blueprint;
    private final Configuration configuration;
    private final Map<String, HostGroupInfo> hostGroupInfo = new HashMap<String, HostGroupInfo>();

    public ExportBlueprintRequest(TreeNode<Resource> clusterNode, OBDPManagementController controller) throws InvalidTopologyTemplateException {
        this.controller = controller;
        Resource clusterResource = clusterNode.getObject();
        Stack stack = this.parseStack(clusterResource);
        this.clusterName = String.valueOf(clusterResource.getPropertyValue("Clusters/cluster_name"));
        this.clusterId = Long.valueOf(String.valueOf(clusterResource.getPropertyValue("Clusters/cluster_id")));
        this.configuration = ExportBlueprintRequest.createConfiguration(clusterNode);
        Collection<ExportedHostGroup> exportedHostGroups = this.processHostGroups(clusterNode.getChild("hosts"));
        this.createHostGroupInfo(exportedHostGroups);
        this.createBlueprint(exportedHostGroups, stack);
    }

    public String getClusterName() {
        return this.clusterName;
    }

    @Override
    public Long getClusterId() {
        return this.clusterId;
    }

    @Override
    public TopologyRequest.Type getType() {
        return TopologyRequest.Type.EXPORT;
    }

    @Override
    public Blueprint getBlueprint() {
        return this.blueprint;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public Map<String, HostGroupInfo> getHostGroupInfo() {
        return this.hostGroupInfo;
    }

    @Override
    public String getDescription() {
        return String.format("Export Command For Cluster '%s'", this.clusterName);
    }

    private void createBlueprint(Collection<ExportedHostGroup> exportedHostGroups, Stack stack) {
        String bpName = "exported-blueprint";
        ArrayList<HostGroup> hostGroups = new ArrayList<HostGroup>();
        for (ExportedHostGroup exportedHostGroup : exportedHostGroups) {
            ArrayList<Component> componentList = new ArrayList<Component>();
            for (String component : exportedHostGroup.getComponents()) {
                componentList.add(new Component(component));
            }
            hostGroups.add(new HostGroupImpl(exportedHostGroup.getName(), bpName, stack, componentList, exportedHostGroup.getConfiguration(), String.valueOf(exportedHostGroup.getCardinality())));
        }
        this.blueprint = new BlueprintImpl(bpName, hostGroups, stack, this.configuration, null);
    }

    private void createHostGroupInfo(Collection<ExportedHostGroup> exportedHostGroups) {
        for (ExportedHostGroup exportedGroup : exportedHostGroups) {
            HostGroupInfo groupInfo = new HostGroupInfo(exportedGroup.getName());
            groupInfo.addHosts(exportedGroup.getHostInfo());
            groupInfo.setConfiguration(exportedGroup.getConfiguration());
            this.hostGroupInfo.put(groupInfo.getHostGroupName(), groupInfo);
        }
    }

    private Stack parseStack(Resource clusterResource) throws InvalidTopologyTemplateException {
        String[] stackTokens = String.valueOf(clusterResource.getPropertyValue("Clusters/version")).split("-");
        try {
            return new Stack(stackTokens[0], stackTokens[1], this.controller);
        }
        catch (OBDPException e) {
            throw new InvalidTopologyTemplateException(String.format("The specified stack doesn't exist: name=%s version=%s", stackTokens[0], stackTokens[1]));
        }
    }

    private static Configuration createConfiguration(TreeNode<Resource> clusterNode) {
        HashMap<String, Map<String, String>> properties = new HashMap<String, Map<String, String>>();
        HashMap<String, Map<String, Map<String, String>>> attributes = new HashMap<String, Map<String, Map<String, String>>>();
        Map<String, Object> desiredConfigMap = clusterNode.getObject().getPropertiesMap().get("Clusters/desired_configs");
        TreeNode<Resource> configNode = clusterNode.getChild("configurations");
        for (TreeNode<Resource> config : configNode.getChildren()) {
            ExportedConfiguration configuration = new ExportedConfiguration(config);
            DesiredConfig desiredConfig = (DesiredConfig)desiredConfigMap.get(configuration.getType());
            if (desiredConfig == null || !desiredConfig.getTag().equals(configuration.getTag())) continue;
            properties.put(configuration.getType(), configuration.getProperties());
            attributes.put(configuration.getType(), configuration.getPropertyAttributes());
        }
        Configuration configuration = new Configuration(properties, attributes);
        configuration.setParentConfiguration(new Configuration(Collections.emptyMap(), Collections.emptyMap()));
        return configuration;
    }

    private Collection<ExportedHostGroup> processHostGroups(TreeNode<Resource> hostNode) {
        HashMap<ExportedHostGroup, ExportedHostGroup> mapHostGroups = new HashMap<ExportedHostGroup, ExportedHostGroup>();
        int count = 1;
        for (TreeNode<Resource> host : hostNode.getChildren()) {
            ExportedHostGroup group = new ExportedHostGroup(host);
            String hostName = (String)host.getObject().getPropertyValue(PropertyHelper.getPropertyId("Hosts", "host_name"));
            if (mapHostGroups.containsKey(group)) {
                ExportedHostGroup hostGroup = (ExportedHostGroup)mapHostGroups.get(group);
                hostGroup.incrementCardinality();
                hostGroup.addHost(hostName);
                continue;
            }
            mapHostGroups.put(group, group);
            group.setName("host_group_" + count++);
            group.addHost(hostName);
        }
        return mapHostGroups.values();
    }

    public class ExportedHostGroup {
        private String name;
        private final Set<String> components = new HashSet<String>();
        private final Collection<ExportedConfiguration> configurations = new HashSet<ExportedConfiguration>();
        private int m_cardinality = 1;
        private final Collection<String> hosts = new HashSet<String>();

        public ExportedHostGroup(TreeNode<Resource> host) {
            TreeNode<Resource> components = host.getChild("host_components");
            for (TreeNode<Resource> component : components.getChildren()) {
                this.getComponents().add((String)component.getObject().getPropertyValue("HostRoles/component_name"));
            }
            this.addAmbariComponentIfLocalhost((String)host.getObject().getPropertyValue(PropertyHelper.getPropertyId("Hosts", "host_name")));
            this.processGroupConfiguration(host);
        }

        public Configuration getConfiguration() {
            HashMap<String, Map<String, String>> configProperties = new HashMap<String, Map<String, String>>();
            HashMap<String, Map<String, Map<String, String>>> configAttributes = new HashMap<String, Map<String, Map<String, String>>>();
            for (ExportedConfiguration config : this.configurations) {
                configProperties.put(config.getType(), config.getProperties());
                configAttributes.put(config.getType(), config.getPropertyAttributes());
            }
            return new Configuration(configProperties, configAttributes);
        }

        private void processGroupConfiguration(TreeNode<Resource> host) {
            Map<String, Object> desiredConfigMap = host.getObject().getPropertiesMap().get("Hosts/desired_configs");
            if (desiredConfigMap != null) {
                block0: for (Map.Entry<String, Object> entry : desiredConfigMap.entrySet()) {
                    String type = entry.getKey();
                    HostConfig hostConfig = (HostConfig)entry.getValue();
                    Map<Long, String> overrides = hostConfig.getConfigGroupOverrides();
                    if (overrides == null || overrides.isEmpty()) continue;
                    Long version = Collections.max(overrides.keySet());
                    String tag = overrides.get(version);
                    TreeNode<Resource> clusterNode = host.getParent().getParent();
                    TreeNode<Resource> configNode = clusterNode.getChild("configurations");
                    for (TreeNode<Resource> config : configNode.getChildren()) {
                        ExportedConfiguration configuration = new ExportedConfiguration(config);
                        if (!type.equals(configuration.getType()) || !tag.equals(configuration.getTag())) continue;
                        this.getConfigurations().add(configuration);
                        continue block0;
                    }
                }
            }
        }

        public String getName() {
            return this.name;
        }

        public Set<String> getComponents() {
            return this.components;
        }

        public Collection<String> getHostInfo() {
            return this.hosts;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void addHost(String host) {
            this.hosts.add(host);
        }

        public Collection<ExportedConfiguration> getConfigurations() {
            return this.configurations;
        }

        public int getCardinality() {
            return this.m_cardinality;
        }

        public void incrementCardinality() {
            ++this.m_cardinality;
        }

        private void addAmbariComponentIfLocalhost(String hostname) {
            try {
                InetAddress hostAddress = InetAddress.getByName(hostname);
                try {
                    if (hostAddress.equals(InetAddress.getLocalHost())) {
                        this.getComponents().add("OBDP_SERVER");
                    }
                }
                catch (UnknownHostException e) {
                    throw new RuntimeException("Unable to obtain local host name", e);
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExportedHostGroup hostGroup = (ExportedHostGroup)o;
            return this.components.equals(hostGroup.components) && this.configurations.equals(hostGroup.configurations);
        }

        public int hashCode() {
            int result = this.components.hashCode();
            result = 31 * result + this.configurations.hashCode();
            return result;
        }
    }

    private static class ExportedConfiguration {
        private String type;
        private String tag;
        private Map<String, String> properties = new HashMap<String, String>();
        private Map<String, Map<String, String>> propertyAttributes = new HashMap<String, Map<String, String>>();

        public ExportedConfiguration(TreeNode<Resource> configNode) {
            Resource configResource = configNode.getObject();
            this.type = (String)configResource.getPropertyValue("type");
            this.tag = (String)configResource.getPropertyValue("tag");
            Map<String, Map<String, Object>> propertiesMap = configNode.getObject().getPropertiesMap();
            if (propertiesMap.containsKey("properties")) {
                this.properties = propertiesMap.get("properties");
            }
            if (propertiesMap.containsKey("properties_attributes")) {
                this.propertyAttributes = propertiesMap.get("properties_attributes");
            }
        }

        public String getType() {
            return this.type;
        }

        public String getTag() {
            return this.tag;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public Map<String, Map<String, String>> getPropertyAttributes() {
            return this.propertyAttributes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExportedConfiguration that = (ExportedConfiguration)o;
            return this.tag.equals(that.tag) && this.type.equals(that.type) && this.properties.equals(that.properties) && this.propertyAttributes.equals(that.propertyAttributes);
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + this.tag.hashCode();
            result = 31 * result + this.properties.hashCode();
            result = 31 * result + this.propertyAttributes.hashCode();
            return result;
        }
    }
}

