/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import id.onyx.obdp.server.controller.internal.AbstractControllerResourceProvider;
import id.onyx.obdp.server.controller.internal.AbstractProviderModule;
import id.onyx.obdp.server.controller.internal.AlertDefinitionResourceProvider;
import id.onyx.obdp.server.controller.internal.AlertGroupResourceProvider;
import id.onyx.obdp.server.controller.internal.AlertHistoryResourceProvider;
import id.onyx.obdp.server.controller.internal.AlertNoticeResourceProvider;
import id.onyx.obdp.server.controller.internal.AlertResourceProvider;
import id.onyx.obdp.server.controller.internal.ArtifactResourceProvider;
import id.onyx.obdp.server.controller.internal.ClusterPrivilegeResourceProvider;
import id.onyx.obdp.server.controller.internal.GroupPrivilegeResourceProvider;
import id.onyx.obdp.server.controller.internal.HostStackVersionResourceProvider;
import id.onyx.obdp.server.controller.internal.JobResourceProvider;
import id.onyx.obdp.server.controller.internal.LdapSyncEventResourceProvider;
import id.onyx.obdp.server.controller.internal.MpackResourceProvider;
import id.onyx.obdp.server.controller.internal.OBDPPrivilegeResourceProvider;
import id.onyx.obdp.server.controller.internal.OperatingSystemResourceProvider;
import id.onyx.obdp.server.controller.internal.PermissionResourceProvider;
import id.onyx.obdp.server.controller.internal.PreUpgradeCheckResourceProvider;
import id.onyx.obdp.server.controller.internal.RemoteClusterResourceProvider;
import id.onyx.obdp.server.controller.internal.RepositoryResourceProvider;
import id.onyx.obdp.server.controller.internal.SettingResourceProvider;
import id.onyx.obdp.server.controller.internal.StackDependencyResourceProvider;
import id.onyx.obdp.server.controller.internal.StageResourceProvider;
import id.onyx.obdp.server.controller.internal.TaskAttemptResourceProvider;
import id.onyx.obdp.server.controller.internal.UpgradeGroupResourceProvider;
import id.onyx.obdp.server.controller.internal.UpgradeItemResourceProvider;
import id.onyx.obdp.server.controller.internal.UpgradeSummaryResourceProvider;
import id.onyx.obdp.server.controller.internal.UserPrivilegeResourceProvider;
import id.onyx.obdp.server.controller.internal.ViewPermissionResourceProvider;
import id.onyx.obdp.server.controller.internal.ViewPrivilegeResourceProvider;
import id.onyx.obdp.server.controller.internal.ViewResourceProvider;
import id.onyx.obdp.server.controller.internal.ViewURLResourceProvider;
import id.onyx.obdp.server.controller.internal.ViewVersionResourceProvider;
import id.onyx.obdp.server.controller.internal.WorkflowResourceProvider;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProviderModule
extends AbstractProviderModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultProviderModule.class);

    @Override
    protected ResourceProvider createResourceProvider(Resource.Type type) {
        LOGGER.debug("Creating resource provider for the type: {}", (Object)type);
        switch (type.getInternalType()) {
            case Workflow: {
                return new WorkflowResourceProvider();
            }
            case Job: {
                return new JobResourceProvider();
            }
            case TaskAttempt: {
                return new TaskAttemptResourceProvider();
            }
            case View: {
                return new ViewResourceProvider();
            }
            case ViewVersion: {
                return new ViewVersionResourceProvider();
            }
            case ViewURL: {
                return new ViewURLResourceProvider();
            }
            case StackServiceComponentDependency: {
                return new StackDependencyResourceProvider();
            }
            case Permission: {
                return new PermissionResourceProvider();
            }
            case AmbariPrivilege: {
                return new OBDPPrivilegeResourceProvider();
            }
            case ViewPrivilege: {
                return new ViewPrivilegeResourceProvider();
            }
            case ViewPermission: {
                return new ViewPermissionResourceProvider();
            }
            case ClusterPrivilege: {
                return new ClusterPrivilegeResourceProvider();
            }
            case LdapSyncEvent: {
                return new LdapSyncEventResourceProvider(this.managementController);
            }
            case UserPrivilege: {
                return new UserPrivilegeResourceProvider();
            }
            case GroupPrivilege: {
                return new GroupPrivilegeResourceProvider();
            }
            case Alert: {
                return new AlertResourceProvider(this.managementController);
            }
            case Mpack: {
                return new MpackResourceProvider(this.managementController);
            }
            case AlertDefinition: {
                return new AlertDefinitionResourceProvider(this.managementController);
            }
            case AlertHistory: {
                return new AlertHistoryResourceProvider(this.managementController);
            }
            case AlertGroup: {
                return new AlertGroupResourceProvider(this.managementController);
            }
            case AlertNotice: {
                return new AlertNoticeResourceProvider(this.managementController);
            }
            case UpgradeGroup: {
                return new UpgradeGroupResourceProvider(this.managementController);
            }
            case UpgradeItem: {
                return new UpgradeItemResourceProvider(this.managementController);
            }
            case UpgradeSummary: {
                return new UpgradeSummaryResourceProvider(this.managementController);
            }
            case PreUpgradeCheck: {
                return new PreUpgradeCheckResourceProvider(this.managementController);
            }
            case HostStackVersion: {
                return new HostStackVersionResourceProvider(this.managementController);
            }
            case Stage: {
                return new StageResourceProvider(this.managementController);
            }
            case OperatingSystem: {
                return new OperatingSystemResourceProvider(this.managementController);
            }
            case Repository: {
                return new RepositoryResourceProvider(this.managementController);
            }
            case Setting: {
                return new SettingResourceProvider();
            }
            case Artifact: {
                return new ArtifactResourceProvider(this.managementController);
            }
            case RemoteCluster: {
                return new RemoteClusterResourceProvider();
            }
        }
        LOGGER.debug("Delegating creation of resource provider for: {} to the AbstractControllerResourceProvider", (Object)type.getInternalType());
        return AbstractControllerResourceProvider.getResourceProvider(type, this.managementController);
    }
}

