/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import id.onyx.obdp.server.DuplicateResourceException;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.StaticallyInject;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.internal.AbstractControllerResourceProvider;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.security.authorization.RoleAuthorization;
import id.onyx.obdp.server.security.credential.Credential;
import id.onyx.obdp.server.security.credential.PrincipalKeyCredential;
import id.onyx.obdp.server.security.encryption.CredentialStoreService;
import id.onyx.obdp.server.security.encryption.CredentialStoreType;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StaticallyInject
public class CredentialResourceProvider
extends AbstractControllerResourceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(CredentialResourceProvider.class);
    public static final String CREDENTIAL_CLUSTER_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("Credential", "cluster_name");
    public static final String CREDENTIAL_ALIAS_PROPERTY_ID = PropertyHelper.getPropertyId("Credential", "alias");
    public static final String CREDENTIAL_PRINCIPAL_PROPERTY_ID = PropertyHelper.getPropertyId("Credential", "principal");
    public static final String CREDENTIAL_KEY_PROPERTY_ID = PropertyHelper.getPropertyId("Credential", "key");
    public static final String CREDENTIAL_TYPE_PROPERTY_ID = PropertyHelper.getPropertyId("Credential", "type");
    private static final Set<String> PK_PROPERTY_IDS;
    private static final Set<String> PROPERTY_IDS;
    private static final Map<Resource.Type, String> KEY_PROPERTY_IDS;
    @Inject
    private CredentialStoreService credentialStoreService;

    @AssistedInject
    public CredentialResourceProvider(@Assisted OBDPManagementController managementController) {
        super(Resource.Type.Credential, PROPERTY_IDS, KEY_PROPERTY_IDS, managementController);
        EnumSet<RoleAuthorization> authorizations = EnumSet.of(RoleAuthorization.CLUSTER_MANAGE_CREDENTIALS, RoleAuthorization.CLUSTER_TOGGLE_KERBEROS);
        this.setRequiredCreateAuthorizations(authorizations);
        this.setRequiredGetAuthorizations(authorizations);
        this.setRequiredUpdateAuthorizations(authorizations);
        this.setRequiredDeleteAuthorizations(authorizations);
    }

    @Override
    protected RequestStatus createResourcesAuthorized(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        for (Map<String, Object> properties : request.getProperties()) {
            this.createResources(new CreateResourcesCommand(properties));
        }
        this.notifyCreate(Resource.Type.Credential, request);
        return this.getRequestStatus(null);
    }

    @Override
    protected Set<Resource> getResourcesAuthorized(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        HashSet<Resource> resources = new HashSet<Resource>();
        boolean sendNotFoundErrorIfEmpty = false;
        for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
            String clusterName = (String)propertyMap.get(CREDENTIAL_CLUSTER_NAME_PROPERTY_ID);
            if (null == clusterName || clusterName.isEmpty()) {
                throw new IllegalArgumentException("Invalid argument, cluster name is required");
            }
            String alias = (String)propertyMap.get(CREDENTIAL_ALIAS_PROPERTY_ID);
            if (!StringUtils.isEmpty((String)alias)) {
                try {
                    if (this.credentialStoreService.containsCredential(clusterName, alias)) {
                        resources.add(this.toResource(clusterName, alias, this.credentialStoreService.getCredentialStoreType(clusterName, alias), requestedIds));
                        continue;
                    }
                    sendNotFoundErrorIfEmpty = true;
                    continue;
                }
                catch (OBDPException e) {
                    throw new SystemException(e.getLocalizedMessage(), e);
                }
            }
            try {
                Map<String, CredentialStoreType> results = this.credentialStoreService.listCredentials(clusterName);
                if (results == null) continue;
                for (Map.Entry<String, CredentialStoreType> entry : results.entrySet()) {
                    resources.add(this.toResource(clusterName, entry.getKey(), entry.getValue(), requestedIds));
                }
            }
            catch (OBDPException e) {
                throw new SystemException(e.getLocalizedMessage(), e);
            }
        }
        if (sendNotFoundErrorIfEmpty && resources.isEmpty()) {
            throw new NoSuchResourceException("The requested resource doesn't exist: Credential not found, " + predicate);
        }
        return resources;
    }

    @Override
    protected RequestStatus updateResourcesAuthorized(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        for (Map<String, Object> requestPropMap : request.getProperties()) {
            for (Map<String, Object> propertyMap : this.getPropertyMaps(requestPropMap, predicate)) {
                if (this.modifyResources(new ModifyResourcesCommand(propertyMap)) != null) continue;
                throw new NoSuchResourceException("The requested resource doesn't exist: Credential not found, " + this.getAlias(propertyMap));
            }
        }
        this.notifyUpdate(Resource.Type.Credential, request, predicate);
        return this.getRequestStatus(null);
    }

    @Override
    protected RequestStatus deleteResourcesAuthorized(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        Set<Map<String, Object>> propertyMaps = this.getPropertyMaps(predicate);
        for (Map<String, Object> properties : propertyMaps) {
            this.modifyResources(new DeleteResourcesCommand(properties));
        }
        this.notifyDelete(Resource.Type.Credential, predicate);
        return this.getRequestStatus(null);
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return PK_PROPERTY_IDS;
    }

    private Credential createCredential(Map<String, Object> properties) throws IllegalArgumentException {
        String key;
        if (properties.get(CREDENTIAL_PRINCIPAL_PROPERTY_ID) == null) {
            throw new IllegalArgumentException("Property " + CREDENTIAL_PRINCIPAL_PROPERTY_ID + " must be provided");
        }
        String principal = String.valueOf(properties.get(CREDENTIAL_PRINCIPAL_PROPERTY_ID));
        if (properties.get(CREDENTIAL_KEY_PROPERTY_ID) == null) {
            LOG.warn("The credential is being added without a key");
            key = null;
        } else {
            key = String.valueOf(properties.get(CREDENTIAL_KEY_PROPERTY_ID));
        }
        return new PrincipalKeyCredential(principal, key);
    }

    private CredentialStoreType getCredentialStoreType(Map<String, Object> properties) throws IllegalArgumentException {
        Object propertyValue = properties.get(CREDENTIAL_TYPE_PROPERTY_ID);
        if (propertyValue == null) {
            throw new IllegalArgumentException("Property " + CREDENTIAL_TYPE_PROPERTY_ID + " must be provided");
        }
        if (propertyValue instanceof String) {
            try {
                return CredentialStoreType.valueOf(((String)propertyValue).toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Property " + CREDENTIAL_TYPE_PROPERTY_ID + " must be either 'persisted' or 'temporary'", e);
            }
        }
        throw new IllegalArgumentException("Property " + CREDENTIAL_TYPE_PROPERTY_ID + " must be a String");
    }

    private String getClusterName(Map<String, Object> properties) throws IllegalArgumentException {
        if (properties.get(CREDENTIAL_CLUSTER_NAME_PROPERTY_ID) == null) {
            throw new IllegalArgumentException("Property " + CREDENTIAL_CLUSTER_NAME_PROPERTY_ID + " must be provided");
        }
        return String.valueOf(properties.get(CREDENTIAL_CLUSTER_NAME_PROPERTY_ID));
    }

    private String getAlias(Map<String, Object> properties) throws IllegalArgumentException {
        if (properties.get(CREDENTIAL_ALIAS_PROPERTY_ID) == null) {
            throw new IllegalArgumentException("Property " + CREDENTIAL_ALIAS_PROPERTY_ID + " must be provided");
        }
        return String.valueOf(properties.get(CREDENTIAL_ALIAS_PROPERTY_ID));
    }

    private void validateForCreateOrModify(CredentialStoreType credentialStoreType) throws IllegalArgumentException {
        if (!this.credentialStoreService.isInitialized(credentialStoreType)) {
            if (CredentialStoreType.PERSISTED == credentialStoreType) {
                throw new IllegalArgumentException("Credentials cannot be stored in Ambari's persistent secure credential store since secure persistent storage has not yet be configured.  Use obdp-server setup-security to enable this feature.");
            }
            if (CredentialStoreType.TEMPORARY == credentialStoreType) {
                throw new IllegalArgumentException("Credentials cannot be stored in Ambari's temporary secure credential store since secure temporary storage has not yet be configured.");
            }
        }
    }

    private Resource toResource(String clusterName, String alias, CredentialStoreType credentialStoreType, Set<String> requestedIds) {
        ResourceImpl resource = new ResourceImpl(Resource.Type.Credential);
        CredentialResourceProvider.setResourceProperty(resource, CREDENTIAL_CLUSTER_NAME_PROPERTY_ID, clusterName, requestedIds);
        CredentialResourceProvider.setResourceProperty(resource, CREDENTIAL_ALIAS_PROPERTY_ID, alias, requestedIds);
        CredentialResourceProvider.setResourceProperty(resource, CREDENTIAL_TYPE_PROPERTY_ID, credentialStoreType.name().toLowerCase(), requestedIds);
        return resource;
    }

    static {
        HashSet<String> set = new HashSet<String>();
        set.add(CREDENTIAL_CLUSTER_NAME_PROPERTY_ID);
        set.add(CREDENTIAL_ALIAS_PROPERTY_ID);
        PK_PROPERTY_IDS = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(CREDENTIAL_CLUSTER_NAME_PROPERTY_ID);
        set.add(CREDENTIAL_ALIAS_PROPERTY_ID);
        set.add(CREDENTIAL_PRINCIPAL_PROPERTY_ID);
        set.add(CREDENTIAL_KEY_PROPERTY_ID);
        set.add(CREDENTIAL_TYPE_PROPERTY_ID);
        PROPERTY_IDS = Collections.unmodifiableSet(set);
        HashMap<Resource.Type, String> map = new HashMap<Resource.Type, String>();
        map.put(Resource.Type.Cluster, CREDENTIAL_CLUSTER_NAME_PROPERTY_ID);
        map.put(Resource.Type.Credential, CREDENTIAL_ALIAS_PROPERTY_ID);
        KEY_PROPERTY_IDS = Collections.unmodifiableMap(map);
    }

    private class CreateResourcesCommand
    implements AbstractResourceProvider.Command<String> {
        private final Map<String, Object> properties;

        public CreateResourcesCommand(Map<String, Object> properties) {
            this.properties = properties;
        }

        @Override
        public String invoke() throws OBDPException {
            CredentialStoreType credentialStoreType = CredentialResourceProvider.this.getCredentialStoreType(this.properties);
            CredentialResourceProvider.this.validateForCreateOrModify(credentialStoreType);
            String clusterName = CredentialResourceProvider.this.getClusterName(this.properties);
            String alias = CredentialResourceProvider.this.getAlias(this.properties);
            if (CredentialResourceProvider.this.credentialStoreService.containsCredential(clusterName, alias)) {
                throw new DuplicateResourceException("A credential with the alias of " + alias + " already exists");
            }
            CredentialResourceProvider.this.credentialStoreService.setCredential(clusterName, alias, CredentialResourceProvider.this.createCredential(this.properties), credentialStoreType);
            return alias;
        }
    }

    private class ModifyResourcesCommand
    implements AbstractResourceProvider.Command<String> {
        private final Map<String, Object> properties;

        public ModifyResourcesCommand(Map<String, Object> properties) {
            this.properties = properties;
        }

        @Override
        public String invoke() throws OBDPException {
            String clusterName = CredentialResourceProvider.this.getClusterName(this.properties);
            String alias = CredentialResourceProvider.this.getAlias(this.properties);
            CredentialStoreType credentialStoreType = this.properties.containsKey(CREDENTIAL_TYPE_PROPERTY_ID) ? CredentialResourceProvider.this.getCredentialStoreType(this.properties) : CredentialResourceProvider.this.credentialStoreService.getCredentialStoreType(clusterName, alias);
            CredentialResourceProvider.this.validateForCreateOrModify(credentialStoreType);
            Credential credential = CredentialResourceProvider.this.credentialStoreService.getCredential(clusterName, alias);
            if (credential instanceof PrincipalKeyCredential) {
                PrincipalKeyCredential principalKeyCredential = (PrincipalKeyCredential)credential;
                HashMap<String, Object> credentialProperties = new HashMap<String, Object>();
                CredentialResourceProvider.this.credentialStoreService.removeCredential(clusterName, alias);
                if (this.properties.containsKey(CREDENTIAL_PRINCIPAL_PROPERTY_ID)) {
                    credentialProperties.put(CREDENTIAL_PRINCIPAL_PROPERTY_ID, this.properties.get(CREDENTIAL_PRINCIPAL_PROPERTY_ID));
                } else {
                    credentialProperties.put(CREDENTIAL_PRINCIPAL_PROPERTY_ID, principalKeyCredential.getPrincipal());
                }
                if (this.properties.containsKey(CREDENTIAL_KEY_PROPERTY_ID)) {
                    credentialProperties.put(CREDENTIAL_KEY_PROPERTY_ID, this.properties.get(CREDENTIAL_KEY_PROPERTY_ID));
                } else {
                    char[] credentialKey = principalKeyCredential.getKey();
                    if (credentialKey != null) {
                        credentialProperties.put(CREDENTIAL_KEY_PROPERTY_ID, String.valueOf(credentialKey));
                    }
                }
                CredentialResourceProvider.this.credentialStoreService.setCredential(clusterName, alias, CredentialResourceProvider.this.createCredential(credentialProperties), credentialStoreType);
                return alias;
            }
            return null;
        }
    }

    private class DeleteResourcesCommand
    implements AbstractResourceProvider.Command<String> {
        private final Map<String, Object> properties;

        public DeleteResourcesCommand(Map<String, Object> properties) {
            this.properties = properties;
        }

        @Override
        public String invoke() throws OBDPException {
            String clusterName = CredentialResourceProvider.this.getClusterName(this.properties);
            String alias = CredentialResourceProvider.this.getAlias(this.properties);
            CredentialResourceProvider.this.credentialStoreService.removeCredential(clusterName, alias);
            return alias;
        }
    }
}

