/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.ConfigurationRequest;
import id.onyx.obdp.server.controller.ConfigurationResponse;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.internal.AbstractControllerResourceProvider;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.security.authorization.AuthorizationException;
import id.onyx.obdp.server.security.authorization.RoleAuthorization;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class ConfigurationResourceProvider
extends AbstractControllerResourceProvider {
    private static final Pattern PROPERTIES_ATTRIBUTES_PATTERN = Pattern.compile("^properties_attributes/[a-zA-Z][a-zA-Z._-]*$");
    public static final String CONFIG = "Config";
    public static final String CLUSTER_NAME_PROPERTY_ID = "cluster_name";
    public static final String STACK_ID_PROPERTY_ID = "stack_id";
    public static final String TYPE_PROPERTY_ID = "type";
    public static final String TAG_PROPERTY_ID = "tag";
    public static final String VERSION_PROPERTY_ID = "version";
    public static final String PROPERTIES_PROPERTY_ID = "properties";
    public static final String PROPERTIES_ATTRIBUTES_PROPERTY_ID = "properties_attributes";
    public static final String CLUSTER_NAME = "Config/cluster_name";
    public static final String STACK_ID = "Config/stack_id";
    public static final String TYPE = PropertyHelper.getPropertyId(null, "type");
    public static final String TAG = PropertyHelper.getPropertyId(null, "tag");
    public static final String VERSION = PropertyHelper.getPropertyId(null, "version");
    private static final Set<String> PROPERTY_IDS = new HashSet<String>();
    private static final Map<Resource.Type, String> KEY_PROPERTY_IDS = new HashMap<Resource.Type, String>();
    private static final Set<String> pkPropertyIds;

    ConfigurationResourceProvider(OBDPManagementController managementController) {
        super(Resource.Type.Configuration, PROPERTY_IDS, KEY_PROPERTY_IDS, managementController);
        this.setRequiredGetAuthorizations(EnumSet.of(RoleAuthorization.CLUSTER_VIEW_CONFIGS));
    }

    @Override
    public RequestStatus createResources(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        for (Map<String, Object> map : request.getProperties()) {
            String cluster = (String)map.get(CLUSTER_NAME);
            String type = (String)map.get(TYPE);
            String tag = (String)map.get(TAG);
            HashMap<String, String> configMap = new HashMap<String, String>();
            HashMap<String, HashMap<String, String>> configAttributesMap = null;
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String attributeName;
                HashMap<String, String> attributesMap;
                String propertyCategory = PropertyHelper.getPropertyCategory(entry.getKey());
                if (propertyCategory != null && propertyCategory.equals(PROPERTIES_PROPERTY_ID) && null != entry.getValue()) {
                    configMap.put(PropertyHelper.getPropertyName(entry.getKey()), entry.getValue().toString());
                }
                if (propertyCategory == null || !PROPERTIES_ATTRIBUTES_PATTERN.matcher(propertyCategory).matches() || null == entry.getValue()) continue;
                if (null == configAttributesMap) {
                    configAttributesMap = new HashMap<String, HashMap<String, String>>();
                }
                if ((attributesMap = (HashMap<String, String>)configAttributesMap.get(attributeName = propertyCategory.substring(propertyCategory.lastIndexOf(47) + 1))) == null) {
                    attributesMap = new HashMap<String, String>();
                    configAttributesMap.put(attributeName, attributesMap);
                }
                attributesMap.put(PropertyHelper.getPropertyName(entry.getKey()), entry.getValue().toString());
            }
            final ConfigurationRequest configRequest = new ConfigurationRequest(cluster, type, tag, configMap, configAttributesMap);
            this.createResources(new AbstractResourceProvider.Command<Void>(){

                @Override
                public Void invoke() throws OBDPException, AuthorizationException {
                    ConfigurationResourceProvider.this.getManagementController().createConfiguration(configRequest);
                    return null;
                }
            });
        }
        return this.getRequestStatus(null);
    }

    @Override
    public Set<Resource> getResourcesAuthorized(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        final HashSet<ConfigurationRequest> requests = new HashSet<ConfigurationRequest>();
        for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
            requests.add(this.getRequest(request, propertyMap));
        }
        Set<ConfigurationResponse> responses = this.getResources(new AbstractResourceProvider.Command<Set<ConfigurationResponse>>(){

            @Override
            public Set<ConfigurationResponse> invoke() throws OBDPException {
                return ConfigurationResourceProvider.this.getManagementController().getConfigurations(requests);
            }
        });
        HashSet<Resource> resources = new HashSet<Resource>();
        for (ConfigurationResponse response : responses) {
            String id;
            String stackId = response.getStackId().getStackId();
            ResourceImpl resource = new ResourceImpl(Resource.Type.Configuration);
            resource.setProperty(CLUSTER_NAME, response.getClusterName());
            resource.setProperty(STACK_ID, stackId);
            resource.setProperty(TYPE, response.getType());
            resource.setProperty(TAG, response.getVersionTag());
            resource.setProperty(VERSION, response.getVersion());
            if (null != response.getConfigs() && response.getConfigs().size() > 0) {
                Map<String, String> configs = response.getConfigs();
                for (Map.Entry<String, String> entry : configs.entrySet()) {
                    id = PropertyHelper.getPropertyId(PROPERTIES_PROPERTY_ID, entry.getKey());
                    resource.setProperty(id, entry.getValue());
                }
            }
            if (null != response.getConfigAttributes() && response.getConfigAttributes().size() > 0) {
                Map<String, Map<String, String>> configAttributes = response.getConfigAttributes();
                for (Map.Entry<String, Object> entry : configAttributes.entrySet()) {
                    id = PropertyHelper.getPropertyId(PROPERTIES_ATTRIBUTES_PROPERTY_ID, entry.getKey());
                    resource.setProperty(id, entry.getValue());
                }
            }
            resources.add(resource);
        }
        return resources;
    }

    @Override
    public RequestStatus updateResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new UnsupportedOperationException("Cannot update a Configuration resource.");
    }

    @Override
    public RequestStatus deleteResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new UnsupportedOperationException("Cannot delete a Configuration resource.");
    }

    @Override
    public Set<String> checkPropertyIds(Set<String> propertyIds) {
        if ((propertyIds = super.checkPropertyIds(propertyIds)).isEmpty()) {
            return propertyIds;
        }
        HashSet<String> unsupportedProperties = new HashSet<String>();
        for (String propertyId : propertyIds) {
            String propertyCategory;
            if (propertyId.equals(TAG_PROPERTY_ID) || propertyId.equals(TYPE_PROPERTY_ID) || propertyId.equals("/tag") || propertyId.equals("/type") || propertyId.equals(PROPERTIES_PROPERTY_ID) || propertyId.equals(PROPERTIES_ATTRIBUTES_PROPERTY_ID) || (propertyCategory = PropertyHelper.getPropertyCategory(propertyId)) != null && (propertyCategory.equals(PROPERTIES_PROPERTY_ID) || PROPERTIES_ATTRIBUTES_PATTERN.matcher(propertyCategory).matches())) continue;
            unsupportedProperties.add(propertyId);
        }
        return unsupportedProperties;
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return pkPropertyIds;
    }

    private ConfigurationRequest getRequest(Request request, Map<String, Object> properties) {
        String type = (String)properties.get(TYPE);
        String tag = (String)properties.get(TAG);
        ConfigurationRequest configRequest = new ConfigurationRequest((String)properties.get(CLUSTER_NAME), type, tag, new HashMap<String, String>(), new HashMap<String, Map<String, String>>());
        Set<String> requestedIds = request.getPropertyIds();
        if (requestedIds.contains(PROPERTIES_PROPERTY_ID) || requestedIds.contains("*")) {
            configRequest.setIncludeProperties(true);
        }
        return configRequest;
    }

    static {
        PROPERTY_IDS.add(CLUSTER_NAME);
        PROPERTY_IDS.add(STACK_ID);
        PROPERTY_IDS.add(TYPE);
        PROPERTY_IDS.add(TAG);
        PROPERTY_IDS.add(VERSION);
        KEY_PROPERTY_IDS.put(Resource.Type.Configuration, TYPE);
        KEY_PROPERTY_IDS.put(Resource.Type.Cluster, CLUSTER_NAME);
        pkPropertyIds = new HashSet<String>(Arrays.asList(CLUSTER_NAME, TYPE));
    }
}

