/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import id.onyx.obdp.server.ClusterNotFoundException;
import id.onyx.obdp.server.ConfigGroupNotFoundException;
import id.onyx.obdp.server.DuplicateResourceException;
import id.onyx.obdp.server.HostNotFoundException;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.ParentObjectNotFoundException;
import id.onyx.obdp.server.StaticallyInject;
import id.onyx.obdp.server.controller.ConfigGroupRequest;
import id.onyx.obdp.server.controller.ConfigGroupResponse;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.internal.AbstractControllerResourceProvider;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.ConfigurationResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.ResourcePredicateEvaluator;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.orm.dao.HostDAO;
import id.onyx.obdp.server.orm.entities.HostEntity;
import id.onyx.obdp.server.security.authorization.AuthorizationException;
import id.onyx.obdp.server.security.authorization.AuthorizationHelper;
import id.onyx.obdp.server.security.authorization.ResourceType;
import id.onyx.obdp.server.security.authorization.RoleAuthorization;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.Config;
import id.onyx.obdp.server.state.ConfigFactory;
import id.onyx.obdp.server.state.ConfigHelper;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.configgroup.ConfigGroup;
import id.onyx.obdp.server.state.configgroup.ConfigGroupFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StaticallyInject
public class ConfigGroupResourceProvider
extends AbstractControllerResourceProvider
implements ResourcePredicateEvaluator {
    private static final Logger configLogger = LoggerFactory.getLogger((String)"configchange");
    private static final Logger LOG = LoggerFactory.getLogger(ConfigGroupResourceProvider.class);
    public static final String CONFIG_GROUP = "ConfigGroup";
    public static final String CLUSTER_NAME_PROPERTY_ID = "cluster_name";
    public static final String ID_PROPERTY_ID = "id";
    public static final String GROUP_NAME_PROPERTY_ID = "group_name";
    public static final String TAG_PROPERTY_ID = "tag";
    public static final String SERVICE_NAME_PROPERTY_ID = "service_name";
    public static final String DESCRIPTION_PROPERTY_ID = "description";
    public static final String SERVICE_CONFIG_VERSION_NOTE_PROPERTY_ID = "service_config_version_note";
    public static final String HOST_NAME_PROPERTY_ID = "host_name";
    public static final String HOSTS_HOSTNAME_PROPERTY_ID = "hosts/host_name";
    public static final String HOSTS_PROPERTY_ID = "hosts";
    public static final String DESIRED_CONFIGS_PROPERTY_ID = "desired_configs";
    public static final String VERSION_TAGS_PROPERTY_ID = "version_tags";
    public static final String CLUSTER_NAME = PropertyHelper.getPropertyId("ConfigGroup", "cluster_name");
    public static final String ID = PropertyHelper.getPropertyId("ConfigGroup", "id");
    public static final String GROUP_NAME = PropertyHelper.getPropertyId("ConfigGroup", "group_name");
    public static final String TAG = PropertyHelper.getPropertyId("ConfigGroup", "tag");
    public static final String SERVICE_NAME = PropertyHelper.getPropertyId("ConfigGroup", "service_name");
    public static final String DESCRIPTION = PropertyHelper.getPropertyId("ConfigGroup", "description");
    public static final String SERVICE_CONFIG_VERSION_NOTE = PropertyHelper.getPropertyId("ConfigGroup", "service_config_version_note");
    public static final String HOST_NAME = PropertyHelper.getPropertyId(null, "host_name");
    public static final String HOSTS_HOST_NAME = PropertyHelper.getPropertyId("ConfigGroup", "hosts/host_name");
    public static final String HOSTS = PropertyHelper.getPropertyId("ConfigGroup", "hosts");
    public static final String DESIRED_CONFIGS = PropertyHelper.getPropertyId("ConfigGroup", "desired_configs");
    public static final String VERSION_TAGS = PropertyHelper.getPropertyId("ConfigGroup", "version_tags");
    private static final Map<Resource.Type, String> keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.Cluster, (Object)CLUSTER_NAME).put((Object)Resource.Type.ConfigGroup, (Object)ID).build();
    private static final Set<String> propertyIds = Sets.newHashSet((Object[])new String[]{CLUSTER_NAME, ID, GROUP_NAME, TAG, SERVICE_NAME, DESCRIPTION, SERVICE_CONFIG_VERSION_NOTE, HOST_NAME, HOSTS_HOST_NAME, HOSTS, DESIRED_CONFIGS, VERSION_TAGS});
    @Inject
    private static HostDAO hostDAO;
    @Inject
    private static ConfigFactory configFactory;
    @Inject
    private static Provider<ConfigHelper> m_configHelper;

    protected ConfigGroupResourceProvider(OBDPManagementController managementController) {
        super(Resource.Type.ConfigGroup, propertyIds, keyPropertyIds, managementController);
        EnumSet<RoleAuthorization> manageGroupsAuthSet = EnumSet.of(RoleAuthorization.SERVICE_MANAGE_CONFIG_GROUPS, RoleAuthorization.CLUSTER_MANAGE_CONFIG_GROUPS);
        this.setRequiredCreateAuthorizations(manageGroupsAuthSet);
        this.setRequiredDeleteAuthorizations(manageGroupsAuthSet);
        this.setRequiredUpdateAuthorizations(manageGroupsAuthSet);
        this.setRequiredGetAuthorizations(EnumSet.of(RoleAuthorization.CLUSTER_VIEW_CONFIGS, RoleAuthorization.CLUSTER_MANAGE_CONFIG_GROUPS, RoleAuthorization.SERVICE_VIEW_CONFIGS, RoleAuthorization.SERVICE_MANAGE_CONFIG_GROUPS, RoleAuthorization.SERVICE_COMPARE_CONFIGS));
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return new HashSet<String>(keyPropertyIds.values());
    }

    @Override
    public RequestStatus createResourcesAuthorized(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        HashSet<ConfigGroupRequest> requests = new HashSet<ConfigGroupRequest>();
        for (Map<String, Object> propertyMap : request.getProperties()) {
            requests.add(this.getConfigGroupRequest(propertyMap));
        }
        RequestStatus status = this.createResources(requests);
        this.notifyCreate(Resource.Type.ConfigGroup, request);
        return status;
    }

    @Override
    public Set<Resource> getResourcesAuthorized(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        final HashSet<ConfigGroupRequest> requests = new HashSet<ConfigGroupRequest>();
        for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
            requests.add(this.getConfigGroupRequest(propertyMap));
        }
        Set<ConfigGroupResponse> responses = this.getResources(new AbstractResourceProvider.Command<Set<ConfigGroupResponse>>(){

            @Override
            public Set<ConfigGroupResponse> invoke() throws OBDPException {
                return ConfigGroupResourceProvider.this.getConfigGroups(requests);
            }
        });
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        HashSet<Resource> resources = new HashSet<Resource>();
        if (requestedIds.contains(HOSTS_HOST_NAME)) {
            requestedIds.add(HOSTS);
        }
        for (ConfigGroupResponse response : responses) {
            ResourceImpl resource = new ResourceImpl(Resource.Type.ConfigGroup);
            ConfigGroupResourceProvider.setResourceProperty(resource, ID, response.getId(), requestedIds);
            ConfigGroupResourceProvider.setResourceProperty(resource, CLUSTER_NAME, response.getClusterName(), requestedIds);
            ConfigGroupResourceProvider.setResourceProperty(resource, GROUP_NAME, response.getGroupName(), requestedIds);
            ConfigGroupResourceProvider.setResourceProperty(resource, TAG, response.getTag(), requestedIds);
            ConfigGroupResourceProvider.setResourceProperty(resource, DESCRIPTION, response.getDescription(), requestedIds);
            ConfigGroupResourceProvider.setResourceProperty(resource, HOSTS, response.getHosts(), requestedIds);
            ConfigGroupResourceProvider.setResourceProperty(resource, DESIRED_CONFIGS, response.getConfigurations(), requestedIds);
            resources.add(resource);
        }
        return resources;
    }

    @Override
    public RequestStatus updateResourcesAuthorized(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        HashSet<ConfigGroupRequest> requests = new HashSet<ConfigGroupRequest>();
        Iterator<Map<String, Object>> iterator = request.getProperties().iterator();
        if (iterator.hasNext()) {
            for (Map<String, Object> propertyMap : this.getPropertyMaps(iterator.next(), predicate)) {
                requests.add(this.getConfigGroupRequest(propertyMap));
            }
        }
        this.updateResources(requests);
        HashSet<Resource> associatedResources = new HashSet<Resource>();
        for (ConfigGroupRequest configGroupRequest : requests) {
            ConfigGroupResponse configGroupResponse = this.getManagementController().getConfigGroupUpdateResults(configGroupRequest);
            ResourceImpl resource = new ResourceImpl(Resource.Type.ConfigGroup);
            resource.setProperty(ID, configGroupResponse.getId());
            resource.setProperty(CLUSTER_NAME, configGroupResponse.getClusterName());
            resource.setProperty(GROUP_NAME, configGroupResponse.getGroupName());
            resource.setProperty(TAG, configGroupResponse.getTag());
            resource.setProperty(VERSION_TAGS, configGroupResponse.getVersionTags());
            associatedResources.add(resource);
        }
        this.notifyUpdate(Resource.Type.ConfigGroup, request, predicate);
        return this.getRequestStatus(null, associatedResources);
    }

    @Override
    public RequestStatus deleteResourcesAuthorized(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
            final ConfigGroupRequest configGroupRequest = this.getConfigGroupRequest(propertyMap);
            this.modifyResources(new AbstractResourceProvider.Command<Void>(){

                @Override
                public Void invoke() throws OBDPException, AuthorizationException {
                    ConfigGroupResourceProvider.this.deleteConfigGroup(configGroupRequest);
                    return null;
                }
            });
        }
        this.notifyDelete(Resource.Type.ConfigGroup, predicate);
        return this.getRequestStatus(null);
    }

    @Override
    public Set<String> checkPropertyIds(Set<String> propertyIds) {
        Set<String> unsupportedPropertyIds = super.checkPropertyIds(propertyIds);
        Iterator<String> iterator = unsupportedPropertyIds.iterator();
        while (iterator.hasNext()) {
            String next = iterator.next();
            if (!(next = PropertyHelper.getPropertyName(next)).equals(SERVICE_CONFIG_VERSION_NOTE_PROPERTY_ID) && !next.equals("/service_config_version_note")) continue;
            iterator.remove();
        }
        return unsupportedPropertyIds;
    }

    public RequestStatus createResources(final Set<ConfigGroupRequest> requests) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        Set<ConfigGroupResponse> responses = this.createResources(new AbstractResourceProvider.Command<Set<ConfigGroupResponse>>(){

            @Override
            public Set<ConfigGroupResponse> invoke() throws OBDPException, AuthorizationException {
                return ConfigGroupResourceProvider.this.createConfigGroups(requests);
            }
        });
        HashSet<Resource> associatedResources = new HashSet<Resource>();
        for (ConfigGroupResponse response : responses) {
            ResourceImpl resource = new ResourceImpl(Resource.Type.ConfigGroup);
            resource.setProperty(ID, response.getId());
            associatedResources.add(resource);
        }
        return this.getRequestStatus(null, associatedResources);
    }

    public RequestStatus updateResources(final Set<ConfigGroupRequest> requests) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        this.modifyResources(new AbstractResourceProvider.Command<Void>(){

            @Override
            public Void invoke() throws OBDPException, AuthorizationException {
                ConfigGroupResourceProvider.this.updateConfigGroups(requests);
                return null;
            }
        });
        return this.getRequestStatus(null);
    }

    private synchronized Set<ConfigGroupResponse> getConfigGroups(Set<ConfigGroupRequest> requests) throws OBDPException {
        HashSet<ConfigGroupResponse> responses = new HashSet<ConfigGroupResponse>();
        if (requests != null) {
            for (ConfigGroupRequest request : requests) {
                LOG.debug("Received a Config group request with, clusterName = {}, groupId = {}, groupName = {}, tag = {}", new Object[]{request.getClusterName(), request.getId(), request.getGroupName(), request.getTag()});
                if (request.getClusterName() == null) {
                    LOG.warn("Cluster name is a required field.");
                    continue;
                }
                Cluster cluster = this.getManagementController().getClusters().getCluster(request.getClusterName());
                Map<Long, ConfigGroup> configGroupMap = cluster.getConfigGroups();
                if (request.getId() != null) {
                    ConfigGroup configGroup = configGroupMap.get(request.getId());
                    if (configGroup != null) {
                        responses.add(configGroup.convertToResponse());
                        continue;
                    }
                    throw new ConfigGroupNotFoundException(cluster.getClusterName(), request.getId().toString());
                }
                if (request.getGroupName() != null) {
                    for (ConfigGroup configGroup : configGroupMap.values()) {
                        if (!configGroup.getName().equals(request.getGroupName())) continue;
                        responses.add(configGroup.convertToResponse());
                    }
                    continue;
                }
                if (request.getTag() != null && request.getHosts().isEmpty()) {
                    for (ConfigGroup configGroup : configGroupMap.values()) {
                        if (!configGroup.getTag().equals(request.getTag())) continue;
                        responses.add(configGroup.convertToResponse());
                    }
                    continue;
                }
                if (!request.getHosts().isEmpty() && request.getTag() == null) {
                    for (String hostname : request.getHosts()) {
                        Map<Long, ConfigGroup> groupMap = cluster.getConfigGroupsByHostname(hostname);
                        if (groupMap.isEmpty()) continue;
                        for (ConfigGroup configGroup : groupMap.values()) {
                            responses.add(configGroup.convertToResponse());
                        }
                    }
                    continue;
                }
                if (request.getTag() != null && !request.getHosts().isEmpty()) {
                    for (ConfigGroup configGroup : configGroupMap.values()) {
                        if (!configGroup.getTag().equals(request.getTag())) continue;
                        ArrayList<Long> groupHostIds = new ArrayList<Long>(configGroup.getHosts().keySet());
                        HashSet<String> groupHostNames = new HashSet<String>(hostDAO.getHostNamesByHostIds(groupHostIds));
                        groupHostNames.retainAll(request.getHosts());
                        if (groupHostNames.isEmpty()) continue;
                        responses.add(configGroup.convertToResponse());
                    }
                    continue;
                }
                for (ConfigGroup configGroup : configGroupMap.values()) {
                    responses.add(configGroup.convertToResponse());
                }
            }
        }
        return responses;
    }

    private void verifyConfigs(Map<String, Config> configs, String clusterName) throws OBDPException {
        if (configs == null) {
            return;
        }
        Clusters clusters = this.getManagementController().getClusters();
        for (String key : configs.keySet()) {
            if (clusters.getCluster(clusterName).isConfigTypeExists(key)) continue;
            throw new OBDPException("Trying to add not existent config type to config group: configType = " + key + " cluster = " + clusterName);
        }
    }

    private void verifyHostList(Cluster cluster, Map<Long, Host> hosts, ConfigGroupRequest request) throws OBDPException {
        Map<Long, ConfigGroup> configGroupMap = cluster.getConfigGroups();
        if (configGroupMap != null) {
            for (ConfigGroup configGroup : configGroupMap.values()) {
                if (!configGroup.getTag().equals(request.getTag()) || configGroup.getId().equals(request.getId())) continue;
                for (Host host : hosts.values()) {
                    if (!configGroup.getHosts().containsKey(host.getHostId())) continue;
                    throw new DuplicateResourceException("Host is already associated with a config group, clusterName = " + configGroup.getClusterName() + ", configGroupName = " + configGroup.getName() + ", tag = " + configGroup.getTag() + ", hostname = " + host.getHostName());
                }
            }
        }
    }

    private synchronized void deleteConfigGroup(ConfigGroupRequest request) throws OBDPException, AuthorizationException {
        Cluster cluster;
        if (request.getId() == null) {
            throw new OBDPException("Config group id is a required field.");
        }
        Clusters clusters = this.getManagementController().getClusters();
        try {
            cluster = clusters.getCluster(request.getClusterName());
        }
        catch (ClusterNotFoundException e) {
            throw new ParentObjectNotFoundException("Attempted to delete a config group from a cluster which doesn't exist", e);
        }
        ConfigGroup configGroup = cluster.getConfigGroups().get(request.getId());
        if (configGroup == null) {
            throw new ConfigGroupNotFoundException(cluster.getClusterName(), request.getId().toString());
        }
        if (StringUtils.isEmpty((String)configGroup.getServiceName()) ? !AuthorizationHelper.isAuthorized(ResourceType.CLUSTER, cluster.getResourceId(), RoleAuthorization.CLUSTER_MANAGE_CONFIG_GROUPS) : !AuthorizationHelper.isAuthorized(ResourceType.CLUSTER, cluster.getResourceId(), RoleAuthorization.SERVICE_MANAGE_CONFIG_GROUPS)) {
            throw new AuthorizationException("The authenticated user is not authorized to delete config groups");
        }
        configLogger.info("(configchange) Deleting configuration group. cluster: '{}', changed by: '{}', config group: '{}', config group id: '{}'", new Object[]{cluster.getClusterName(), this.getManagementController().getAuthName(), configGroup.getName(), request.getId()});
        cluster.deleteConfigGroup(request.getId());
    }

    private void validateRequest(ConfigGroupRequest request) {
        if (request.getClusterName() == null || request.getClusterName().isEmpty() || request.getGroupName() == null || request.getGroupName().isEmpty() || request.getTag() == null || request.getTag().isEmpty()) {
            LOG.debug("Received a config group request with cluster name = {}, group name = {}, tag = {}", new Object[]{request.getClusterName(), request.getGroupName(), request.getTag()});
            throw new IllegalArgumentException("Cluster name, group name and tag need to be provided.");
        }
    }

    /*
     * WARNING - void declaration
     */
    private synchronized Set<ConfigGroupResponse> createConfigGroups(Set<ConfigGroupRequest> requests) throws OBDPException, AuthorizationException {
        if (requests.isEmpty()) {
            LOG.warn("Received an empty requests set");
            return null;
        }
        HashSet<ConfigGroupResponse> configGroupResponses = new HashSet<ConfigGroupResponse>();
        Clusters clusters = this.getManagementController().getClusters();
        ConfigGroupFactory configGroupFactory = this.getManagementController().getConfigGroupFactory();
        HashSet<String> updatedClusters = new HashSet<String>();
        for (ConfigGroupRequest request : requests) {
            void var11_12;
            Cluster cluster;
            try {
                cluster = clusters.getCluster(request.getClusterName());
            }
            catch (ClusterNotFoundException e) {
                throw new ParentObjectNotFoundException("Attempted to add a config group to a cluster which doesn't exist", e);
            }
            this.validateRequest(request);
            Map<Long, ConfigGroup> configGroupMap = cluster.getConfigGroups();
            if (configGroupMap != null) {
                for (ConfigGroup configGroup : configGroupMap.values()) {
                    if (!configGroup.getName().equals(request.getGroupName()) || !configGroup.getTag().equals(request.getTag())) continue;
                    throw new DuplicateResourceException("Config group already exists with the same name and tag, clusterName = " + request.getClusterName() + ", groupName = " + request.getGroupName() + ", tag = " + request.getTag());
                }
            }
            HashMap<Long, Host> hosts = new HashMap<Long, Host>();
            if (request.getHosts() != null && !request.getHosts().isEmpty()) {
                for (String hostname : request.getHosts()) {
                    Host host = clusters.getHost(hostname);
                    HostEntity hostEntity = hostDAO.findByName(hostname);
                    if (host == null || hostEntity == null) {
                        throw new HostNotFoundException(hostname);
                    }
                    hosts.put(hostEntity.getHostId(), host);
                }
            }
            this.verifyHostList(cluster, hosts, request);
            String string = request.getServiceName();
            if (string == null && !MapUtils.isEmpty(request.getConfigs())) {
                try {
                    String string2 = cluster.getServiceForConfigTypes(request.getConfigs().keySet());
                }
                catch (IllegalArgumentException hostname) {
                    // empty catch block
                }
            }
            if (StringUtils.isEmpty((String)var11_12) ? !AuthorizationHelper.isAuthorized(ResourceType.CLUSTER, cluster.getResourceId(), RoleAuthorization.CLUSTER_MANAGE_CONFIG_GROUPS) : !AuthorizationHelper.isAuthorized(ResourceType.CLUSTER, cluster.getResourceId(), RoleAuthorization.SERVICE_MANAGE_CONFIG_GROUPS)) {
                throw new AuthorizationException("The authenticated user is not authorized to create config groups");
            }
            configLogger.info("(configchange) Creating new configuration group. cluster: '{}', changed by: '{}', config group: '{}', tag: '{}'", new Object[]{cluster.getClusterName(), this.getManagementController().getAuthName(), request.getGroupName(), request.getTag()});
            this.verifyConfigs(request.getConfigs(), cluster.getClusterName());
            ConfigGroup configGroup = configGroupFactory.createNew(cluster, (String)var11_12, request.getGroupName(), request.getTag(), request.getDescription(), request.getConfigs(), hosts);
            cluster.addConfigGroup(configGroup);
            if (var11_12 != null) {
                cluster.createServiceConfigVersion((String)var11_12, this.getManagementController().getAuthName(), request.getServiceConfigVersionNote(), configGroup);
            } else {
                LOG.warn("Could not determine service name for config group {}, service config version not created", (Object)configGroup.getId());
            }
            ConfigGroupResponse response = new ConfigGroupResponse(configGroup.getId(), configGroup.getClusterName(), configGroup.getName(), configGroup.getTag(), configGroup.getDescription(), null, null);
            configGroupResponses.add(response);
            updatedClusters.add(cluster.getClusterName());
        }
        ((ConfigHelper)m_configHelper.get()).updateAgentConfigs(updatedClusters);
        return configGroupResponses;
    }

    private synchronized void updateConfigGroups(Set<ConfigGroupRequest> requests) throws OBDPException, AuthorizationException {
        if (requests.isEmpty()) {
            LOG.warn("Received an empty requests set");
            return;
        }
        Clusters clusters = this.getManagementController().getClusters();
        HashSet<String> updatedClusters = new HashSet<String>();
        for (ConfigGroupRequest request : requests) {
            Cluster cluster;
            try {
                cluster = clusters.getCluster(request.getClusterName());
            }
            catch (ClusterNotFoundException e) {
                throw new ParentObjectNotFoundException("Attempted to add a config group to a cluster which doesn't exist", e);
            }
            if (request.getId() == null) {
                throw new OBDPException("Config group Id is a required parameter.");
            }
            this.validateRequest(request);
            ConfigGroup configGroup = cluster.getConfigGroups().get(request.getId());
            if (configGroup == null) {
                throw new OBDPException("Config group not found, clusterName = " + request.getClusterName() + ", groupId = " + request.getId());
            }
            String serviceName = configGroup.getServiceName();
            String requestServiceName = cluster.getServiceForConfigTypes(request.getConfigs().keySet());
            if (StringUtils.isEmpty((String)serviceName) && StringUtils.isEmpty((String)requestServiceName) ? !AuthorizationHelper.isAuthorized(ResourceType.CLUSTER, cluster.getResourceId(), RoleAuthorization.CLUSTER_MANAGE_CONFIG_GROUPS) : !AuthorizationHelper.isAuthorized(ResourceType.CLUSTER, cluster.getResourceId(), RoleAuthorization.SERVICE_MANAGE_CONFIG_GROUPS)) {
                throw new AuthorizationException("The authenticated user is not authorized to update config groups");
            }
            if (serviceName != null && requestServiceName != null && !StringUtils.equals((String)serviceName, (String)requestServiceName)) {
                throw new IllegalArgumentException("Config group " + configGroup.getId() + " is mapped to service " + serviceName + ", but request contain configs from service " + requestServiceName);
            }
            if (serviceName == null && requestServiceName != null) {
                configGroup.setServiceName(requestServiceName);
                serviceName = requestServiceName;
            }
            int numHosts = null != configGroup.getHosts() ? configGroup.getHosts().size() : 0;
            configLogger.info("(configchange) Updating configuration group host membership or config value. cluster: '{}', changed by: '{}', service_name: '{}', config group: '{}', tag: '{}', num hosts in config group: '{}', note: '{}'", new Object[]{cluster.getClusterName(), this.getManagementController().getAuthName(), serviceName, request.getGroupName(), request.getTag(), numHosts, request.getServiceConfigVersionNote()});
            if (!request.getConfigs().isEmpty()) {
                ArrayList<String> affectedConfigTypeList = new ArrayList<String>(request.getConfigs().keySet());
                Collections.sort(affectedConfigTypeList);
                String affectedConfigTypesString = "(" + StringUtils.join(affectedConfigTypeList, (String)", ") + ")";
                configLogger.info("(configchange)    Affected configs: {}", (Object)affectedConfigTypesString);
                for (Config config : request.getConfigs().values()) {
                    ArrayList<String> sortedConfigKeys = new ArrayList<String>(config.getProperties().keySet());
                    Collections.sort(sortedConfigKeys);
                    String sortedConfigKeysString = StringUtils.join(sortedConfigKeys, (String)", ");
                    configLogger.info("(configchange)    Config type '{}' was  modified with the following keys, {}", (Object)config.getType(), (Object)sortedConfigKeysString);
                }
            }
            HashMap<Long, Host> hosts = new HashMap<Long, Host>();
            if (request.getHosts() != null && !request.getHosts().isEmpty()) {
                for (String hostname : request.getHosts()) {
                    Host host = clusters.getHost(hostname);
                    HostEntity hostEntity = hostDAO.findById(host.getHostId());
                    if (hostEntity == null) {
                        throw new HostNotFoundException(hostname);
                    }
                    hosts.put(hostEntity.getHostId(), host);
                }
            }
            this.verifyHostList(cluster, hosts, request);
            configGroup.setHosts(hosts);
            this.verifyConfigs(request.getConfigs(), request.getClusterName());
            configGroup.setConfigurations(request.getConfigs());
            configGroup.setName(request.getGroupName());
            configGroup.setDescription(request.getDescription());
            configGroup.setTag(request.getTag());
            if (serviceName != null) {
                cluster.createServiceConfigVersion(serviceName, this.getManagementController().getAuthName(), request.getServiceConfigVersionNote(), configGroup);
                ConfigGroupResponse configGroupResponse = new ConfigGroupResponse(configGroup.getId(), cluster.getClusterName(), configGroup.getName(), request.getTag(), "", new HashSet<Map<String, Object>>(), new HashSet<Map<String, Object>>());
                HashSet<Map<String, Object>> versionTags = new HashSet<Map<String, Object>>();
                HashMap<String, String> tagsMap = new HashMap<String, String>();
                for (Config config : configGroup.getConfigurations().values()) {
                    tagsMap.put(config.getType(), config.getTag());
                }
                versionTags.add(tagsMap);
                configGroupResponse.setVersionTags(versionTags);
                this.getManagementController().saveConfigGroupUpdate(request, configGroupResponse);
                updatedClusters.add(cluster.getClusterName());
                continue;
            }
            LOG.warn("Could not determine service name for config group {}, service config version not created", (Object)configGroup.getId());
        }
        ((ConfigHelper)m_configHelper.get()).updateAgentConfigs(updatedClusters);
    }

    ConfigGroupRequest getConfigGroupRequest(Map<String, Object> properties) {
        Object configObj;
        Object groupIdObj = properties.get(ID);
        Long groupId = null;
        if (groupIdObj != null) {
            groupId = groupIdObj instanceof Long ? (Long)groupIdObj : Long.parseLong((String)groupIdObj);
        }
        ConfigGroupRequest request = new ConfigGroupRequest(groupId, (String)properties.get(CLUSTER_NAME), (String)properties.get(GROUP_NAME), (String)properties.get(TAG), (String)properties.get(SERVICE_NAME), (String)properties.get(DESCRIPTION), null, null);
        request.setServiceConfigVersionNote((String)properties.get(SERVICE_CONFIG_VERSION_NOTE));
        HashMap<String, Config> configurations = new HashMap<String, Config>();
        HashSet<String> hosts = new HashSet<String>();
        String hostnameKey = HOST_NAME;
        Object hostObj = properties.get(HOSTS);
        if (hostObj == null) {
            hostnameKey = HOSTS_HOST_NAME;
            hostObj = properties.get(HOSTS_HOST_NAME);
        }
        if (hostObj != null) {
            if (hostObj instanceof HashSet) {
                try {
                    Set hostsSet = (Set)hostObj;
                    for (Map hostMap : hostsSet) {
                        if (!hostMap.containsKey(hostnameKey)) continue;
                        String hostname = (String)hostMap.get(hostnameKey);
                        hosts.add(hostname);
                    }
                }
                catch (Exception e) {
                    LOG.warn("Host json in unparseable format. " + hostObj, (Throwable)e);
                }
            } else if (hostObj instanceof String) {
                hosts.add((String)hostObj);
            }
        }
        if ((configObj = properties.get(DESIRED_CONFIGS)) != null && configObj instanceof HashSet) {
            try {
                Set configSet = (Set)configObj;
                for (Map configMap : configSet) {
                    String type = (String)configMap.get(ConfigurationResourceProvider.TYPE);
                    String tag = (String)configMap.get(ConfigurationResourceProvider.TAG);
                    HashMap<String, String> configProperties = new HashMap<String, String>();
                    HashMap<String, Map<String, String>> configAttributes = new HashMap<String, Map<String, String>>();
                    for (Map.Entry entry : configMap.entrySet()) {
                        String propertyCategory = PropertyHelper.getPropertyCategory((String)entry.getKey());
                        if (propertyCategory == null || entry.getValue() == null) continue;
                        if ("properties".equals(propertyCategory)) {
                            configProperties.put(PropertyHelper.getPropertyName((String)entry.getKey()), entry.getValue().toString());
                            continue;
                        }
                        if (!"properties_attributes".equals(PropertyHelper.getPropertyCategory(propertyCategory))) continue;
                        String attributeName = PropertyHelper.getPropertyName(propertyCategory);
                        if (!configAttributes.containsKey(attributeName)) {
                            configAttributes.put(attributeName, new HashMap());
                        }
                        Map attributeValues = (Map)configAttributes.get(attributeName);
                        attributeValues.put(PropertyHelper.getPropertyName((String)entry.getKey()), entry.getValue().toString());
                    }
                    Config config = configFactory.createReadOnly(type, tag, configProperties, configAttributes);
                    configurations.put(config.getType(), config);
                }
            }
            catch (Exception e) {
                LOG.warn("Config json in unparseable format. " + configObj, (Throwable)e);
            }
        }
        request.setConfigs(configurations);
        request.setHosts(hosts);
        return request;
    }

    @Override
    public boolean evaluate(Predicate predicate, Resource resource) {
        return true;
    }
}

